/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.bouncycastle.gpg.keybox.Blob;
import org.bouncycastle.gpg.keybox.BlobType;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.gpg.keybox.FirstBlob;
import org.bouncycastle.gpg.keybox.KeyBlob;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.openpgp.operator.KeyFingerPrintCalculator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KeyBox {
    private final FirstBlob firstBlob;
    private final List<KeyBlob> keyBlobs;

    public KeyBox(InputStream input, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        this(KeyBoxByteBuffer.wrap(input), keyFingerPrintCalculator, blobVerifier);
    }

    public KeyBox(byte[] encoding, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        this(KeyBoxByteBuffer.wrap(encoding), keyFingerPrintCalculator, blobVerifier);
    }

    private KeyBox(KeyBoxByteBuffer buffer, KeyFingerPrintCalculator keyFingerPrintCalculator, BlobVerifier blobVerifier) throws IOException {
        Blob blob = Blob.getInstance(buffer, keyFingerPrintCalculator, blobVerifier);
        if (blob == null) {
            throw new IOException("No first blob, is the source zero length?");
        }
        if (!(blob instanceof FirstBlob)) {
            throw new IOException("First blob is not KeyBox 'First Blob'.");
        }
        FirstBlob firstBlob = (FirstBlob)blob;
        ArrayList<KeyBlob> keyBoxEntries = new ArrayList<KeyBlob>();
        Blob materialBlob = Blob.getInstance(buffer, keyFingerPrintCalculator, blobVerifier);
        while (materialBlob != null) {
            if (materialBlob.getType() == BlobType.FIRST_BLOB) {
                throw new IOException("Unexpected second 'FirstBlob', there should only be one FirstBlob at the start of the file.");
            }
            keyBoxEntries.add((KeyBlob)materialBlob);
            materialBlob = Blob.getInstance(buffer, keyFingerPrintCalculator, blobVerifier);
        }
        this.firstBlob = firstBlob;
        this.keyBlobs = Collections.unmodifiableList(keyBoxEntries);
    }

    public FirstBlob getFirstBlob() {
        return this.firstBlob;
    }

    public List<KeyBlob> getKeyBlobs() {
        return this.keyBlobs;
    }
}

