/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.IOException;
import org.bouncycastle.gpg.keybox.KeyBoxByteBuffer;
import org.bouncycastle.util.Arrays;

public class KeyInformation {
    private final byte[] fingerprint;
    private final long offsetToKeyID;
    private final int keyFlags;
    private final byte[] filler;
    private final byte[] keyID;

    KeyInformation(byte[] fingerprint, long offsetToKeyID, int keyFlags, byte[] filler, byte[] keyID) {
        this.fingerprint = Arrays.clone((byte[])fingerprint);
        this.offsetToKeyID = offsetToKeyID;
        this.keyFlags = keyFlags;
        this.filler = Arrays.clone((byte[])filler);
        this.keyID = Arrays.clone((byte[])keyID);
    }

    static KeyInformation getInstance(Object src, int expectedSize, int base) throws IOException {
        if (src instanceof KeyInformation) {
            return (KeyInformation)src;
        }
        KeyBoxByteBuffer buffer = KeyBoxByteBuffer.wrap(src);
        int start = buffer.position();
        byte[] fingerPrint = new byte[20];
        buffer.bN(fingerPrint);
        long offsetToKeyID = buffer.u32();
        byte[] keyID = null;
        if (offsetToKeyID > 0L) {
            keyID = buffer.rangeOf((int)((long)base + offsetToKeyID), (int)((long)base + offsetToKeyID + 8L));
        }
        int keyFlags = buffer.u16();
        buffer.u16();
        byte[] filler = new byte[expectedSize - (buffer.position() - start)];
        buffer.bN(filler);
        return new KeyInformation(fingerPrint, offsetToKeyID, keyFlags, filler, keyID);
    }

    public byte[] getFingerprint() {
        return Arrays.clone((byte[])this.fingerprint);
    }

    public int getKeyFlags() {
        return this.keyFlags;
    }

    public byte[] getFiller() {
        return Arrays.clone((byte[])this.filler);
    }

    public byte[] getKeyID() {
        return Arrays.clone((byte[])this.keyID);
    }
}

