/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.ingest.common;

import java.util.Map;
import java.util.regex.Pattern;
import org.elasticsearch.ingest.ConfigurationUtils;
import org.elasticsearch.ingest.common.AbstractStringProcessor;

public final class GsubProcessor
extends AbstractStringProcessor<String> {
    public static final String TYPE = "gsub";
    private final Pattern pattern;
    private final String replacement;

    GsubProcessor(String tag, String field, Pattern pattern, String replacement, boolean ignoreMissing, String targetField) {
        super(tag, field, ignoreMissing, targetField);
        this.pattern = pattern;
        this.replacement = replacement;
    }

    Pattern getPattern() {
        return this.pattern;
    }

    String getReplacement() {
        return this.replacement;
    }

    @Override
    protected String process(String value) {
        return this.pattern.matcher(value).replaceAll(this.replacement);
    }

    public String getType() {
        return TYPE;
    }

    public static final class Factory
    extends AbstractStringProcessor.Factory {
        public Factory() {
            super(GsubProcessor.TYPE);
        }

        protected GsubProcessor newProcessor(String processorTag, Map<String, Object> config, String field, boolean ignoreMissing, String targetField) {
            Pattern searchPattern;
            String pattern = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"pattern");
            String replacement = ConfigurationUtils.readStringProperty((String)GsubProcessor.TYPE, (String)processorTag, config, (String)"replacement");
            try {
                searchPattern = Pattern.compile(pattern);
            }
            catch (Exception e) {
                throw ConfigurationUtils.newConfigurationException((String)GsubProcessor.TYPE, (String)processorTag, (String)"pattern", (String)("Invalid regex pattern. " + e.getMessage()));
            }
            return new GsubProcessor(processorTag, field, searchPattern, replacement, ignoreMissing, targetField);
        }
    }
}

