/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.AnalyzerCaster;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;

public final class EConditional
extends AExpression {
    private AExpression condition;
    private AExpression left;
    private AExpression right;

    public EConditional(Location location, AExpression condition, AExpression left, AExpression right) {
        super(location);
        this.condition = Objects.requireNonNull(condition);
        this.left = Objects.requireNonNull(left);
        this.right = Objects.requireNonNull(right);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        this.condition.storeSettings(settings);
        this.left.storeSettings(settings);
        this.right.storeSettings(settings);
    }

    @Override
    void extractVariables(Set<String> variables) {
        this.condition.extractVariables(variables);
        this.left.extractVariables(variables);
        this.right.extractVariables(variables);
    }

    @Override
    void analyze(Locals locals) {
        this.condition.expected = Boolean.TYPE;
        this.condition.analyze(locals);
        this.condition = this.condition.cast(locals);
        if (this.condition.constant != null) {
            throw this.createError(new IllegalArgumentException("Extraneous conditional statement."));
        }
        this.left.expected = this.expected;
        this.left.explicit = this.explicit;
        this.left.internal = this.internal;
        this.right.expected = this.expected;
        this.right.explicit = this.explicit;
        this.right.internal = this.internal;
        this.actual = this.expected;
        this.left.analyze(locals);
        this.right.analyze(locals);
        if (this.expected == null) {
            Class<?> promote = AnalyzerCaster.promoteConditional(this.left.actual, this.right.actual, this.left.constant, this.right.constant);
            this.left.expected = promote;
            this.right.expected = promote;
            this.actual = promote;
        }
        this.left = this.left.cast(locals);
        this.right = this.right.cast(locals);
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        Label fals = new Label();
        Label end = new Label();
        this.condition.write(writer, globals);
        writer.ifZCmp(153, fals);
        this.left.write(writer, globals);
        writer.goTo(end);
        writer.mark(fals);
        this.right.write(writer, globals);
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.condition, this.left, this.right);
    }
}

