/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.objectweb.asm.Label;

public class PSubNullSafeCallInvoke
extends AExpression {
    private AExpression guarded;

    public PSubNullSafeCallInvoke(Location location, AExpression guarded) {
        super(location);
        this.guarded = Objects.requireNonNull(guarded);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void extractVariables(Set<String> variables) {
        throw this.createError(new IllegalStateException("illegal tree structure"));
    }

    @Override
    void analyze(Locals locals) {
        this.guarded.analyze(locals);
        this.actual = this.guarded.actual;
        if (this.actual.isPrimitive()) {
            throw new IllegalArgumentException("Result of null safe operator must be nullable");
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        Label end = new Label();
        writer.dup();
        writer.ifNull(end);
        this.guarded.write(writer, globals);
        writer.mark(end);
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.guarded);
    }
}

