/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.http.netty4;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.buffer.ByteBufAllocator;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.RecvByteBufAllocator;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioChannelOption;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.codec.ByteToMessageDecoder;
import io.netty.handler.codec.http.HttpContentCompressor;
import io.netty.handler.codec.http.HttpContentDecompressor;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.HttpRequestDecoder;
import io.netty.handler.codec.http.HttpResponseEncoder;
import io.netty.handler.timeout.ReadTimeoutException;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.util.AttributeKey;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.net.SocketOption;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeUnit;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.core.internal.io.IOUtils;
import org.elasticsearch.core.internal.net.NetUtils;
import org.elasticsearch.http.AbstractHttpServerTransport;
import org.elasticsearch.http.HttpChannel;
import org.elasticsearch.http.HttpHandlingSettings;
import org.elasticsearch.http.HttpReadTimeoutException;
import org.elasticsearch.http.HttpServerChannel;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.http.HttpTransportSettings;
import org.elasticsearch.http.netty4.Netty4HttpChannel;
import org.elasticsearch.http.netty4.Netty4HttpPipeliningHandler;
import org.elasticsearch.http.netty4.Netty4HttpRequestHandler;
import org.elasticsearch.http.netty4.Netty4HttpServerChannel;
import org.elasticsearch.http.netty4.cors.Netty4CorsHandler;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.CopyBytesServerSocketChannel;
import org.elasticsearch.transport.netty4.Netty4Utils;

public class Netty4HttpServerTransport
extends AbstractHttpServerTransport {
    private static final Logger logger = LogManager.getLogger(Netty4HttpServerTransport.class);
    private static final ByteSizeValue MTU = new ByteSizeValue(Long.parseLong(System.getProperty("es.net.mtu", "1500")));
    private static final String SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = "http.netty.max_composite_buffer_components";
    public static Setting<Integer> SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS = new Setting("http.netty.max_composite_buffer_components", s -> {
        ByteSizeValue maxContentLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CONTENT_LENGTH.get(s);
        long maxBufferComponentsEstimate = Math.round((double)(maxContentLength.getBytes() / MTU.getBytes()));
        long maxBufferComponents = Math.max(2L, Math.min(maxBufferComponentsEstimate, Integer.MAX_VALUE));
        return String.valueOf(maxBufferComponents);
    }, s -> Setting.parseInt((String)s, (int)2, (int)Integer.MAX_VALUE, (String)SETTING_KEY_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<Integer> SETTING_HTTP_WORKER_COUNT = new Setting("http.netty.worker_count", s -> Integer.toString(EsExecutors.numberOfProcessors((Settings)s) * 2), s -> Setting.parseInt((String)s, (int)1, (String)"http.netty.worker_count"), new Setting.Property[]{Setting.Property.NodeScope});
    public static final Setting<ByteSizeValue> SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE = Setting.byteSizeSetting((String)"http.netty.receive_predictor_size", (ByteSizeValue)new ByteSizeValue(64L, ByteSizeUnit.KB), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope});
    private final ByteSizeValue maxInitialLineLength;
    private final ByteSizeValue maxHeaderSize;
    private final ByteSizeValue maxChunkSize;
    private final int workerCount;
    private final int pipeliningMaxEvents;
    private final RecvByteBufAllocator recvByteBufAllocator;
    private final int readTimeoutMillis;
    private final int maxCompositeBufferComponents;
    private volatile ServerBootstrap serverBootstrap;
    static final AttributeKey<Netty4HttpChannel> HTTP_CHANNEL_KEY = AttributeKey.newInstance((String)"es-http-channel");
    static final AttributeKey<Netty4HttpServerChannel> HTTP_SERVER_CHANNEL_KEY = AttributeKey.newInstance((String)"es-http-server-channel");

    public Netty4HttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, NamedXContentRegistry xContentRegistry, HttpServerTransport.Dispatcher dispatcher) {
        super(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher);
        Netty4Utils.setAvailableProcessors((Integer)EsExecutors.NODE_PROCESSORS_SETTING.get(settings));
        this.maxChunkSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_CHUNK_SIZE.get(settings);
        this.maxHeaderSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_HEADER_SIZE.get(settings);
        this.maxInitialLineLength = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_MAX_INITIAL_LINE_LENGTH.get(settings);
        this.pipeliningMaxEvents = (Integer)HttpTransportSettings.SETTING_PIPELINING_MAX_EVENTS.get(settings);
        this.maxCompositeBufferComponents = (Integer)SETTING_HTTP_NETTY_MAX_COMPOSITE_BUFFER_COMPONENTS.get(settings);
        this.workerCount = (Integer)SETTING_HTTP_WORKER_COUNT.get(settings);
        this.readTimeoutMillis = Math.toIntExact(((TimeValue)HttpTransportSettings.SETTING_HTTP_READ_TIMEOUT.get(settings)).getMillis());
        ByteSizeValue receivePredictor = (ByteSizeValue)SETTING_HTTP_NETTY_RECEIVE_PREDICTOR_SIZE.get(settings);
        this.recvByteBufAllocator = new FixedRecvByteBufAllocator(receivePredictor.bytesAsInt());
        logger.debug("using max_chunk_size[{}], max_header_size[{}], max_initial_line_length[{}], max_content_length[{}], receive_predictor[{}], max_composite_buffer_components[{}], pipelining_max_events[{}]", (Object)this.maxChunkSize, (Object)this.maxHeaderSize, (Object)this.maxInitialLineLength, (Object)this.maxContentLength, (Object)receivePredictor, (Object)this.maxCompositeBufferComponents, (Object)this.pipeliningMaxEvents);
    }

    public Settings settings() {
        return this.settings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doStart() {
        boolean success = false;
        try {
            ByteSizeValue tcpReceiveBufferSize;
            ByteSizeValue tcpSendBufferSize;
            this.serverBootstrap = new ServerBootstrap();
            this.serverBootstrap.group((EventLoopGroup)new NioEventLoopGroup(this.workerCount, EsExecutors.daemonThreadFactory((Settings)this.settings, (String)"http_server_worker")));
            if (ByteBufAllocator.DEFAULT.isDirectBufferPooled()) {
                this.serverBootstrap.channel(NioServerSocketChannel.class);
            } else {
                this.serverBootstrap.channel(CopyBytesServerSocketChannel.class);
            }
            this.serverBootstrap.childHandler(this.configureServerChannelHandler());
            this.serverBootstrap.handler((ChannelHandler)new ServerChannelExceptionHandler(this));
            this.serverBootstrap.childOption(ChannelOption.TCP_NODELAY, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_NO_DELAY.get(this.settings)));
            this.serverBootstrap.childOption(ChannelOption.SO_KEEPALIVE, (Object)((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)));
            if (((Boolean)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_ALIVE.get(this.settings)).booleanValue() && (IOUtils.LINUX || IOUtils.MAC_OS_X)) {
                SocketOption keepCountOption;
                SocketOption keepIntervalOption;
                SocketOption keepIdleOption;
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings) >= 0 && (keepIdleOption = NetUtils.getTcpKeepIdleSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIdleOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_IDLE.get(this.settings)));
                }
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings) >= 0 && (keepIntervalOption = NetUtils.getTcpKeepIntervalSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepIntervalOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_INTERVAL.get(this.settings)));
                }
                if ((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings) >= 0 && (keepCountOption = NetUtils.getTcpKeepCountSocketOptionOrNull()) != null) {
                    this.serverBootstrap.childOption(NioChannelOption.of((SocketOption)keepCountOption), (Object)((Integer)HttpTransportSettings.SETTING_HTTP_TCP_KEEP_COUNT.get(this.settings)));
                }
            }
            if ((tcpSendBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_SEND_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_SNDBUF, (Object)Math.toIntExact(tcpSendBufferSize.getBytes()));
            }
            if ((tcpReceiveBufferSize = (ByteSizeValue)HttpTransportSettings.SETTING_HTTP_TCP_RECEIVE_BUFFER_SIZE.get(this.settings)).getBytes() > 0L) {
                this.serverBootstrap.childOption(ChannelOption.SO_RCVBUF, (Object)Math.toIntExact(tcpReceiveBufferSize.getBytes()));
            }
            this.serverBootstrap.option(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            this.serverBootstrap.childOption(ChannelOption.RCVBUF_ALLOCATOR, (Object)this.recvByteBufAllocator);
            boolean reuseAddress = (Boolean)HttpTransportSettings.SETTING_HTTP_TCP_REUSE_ADDRESS.get(this.settings);
            this.serverBootstrap.option(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.serverBootstrap.childOption(ChannelOption.SO_REUSEADDR, (Object)reuseAddress);
            this.bindServer();
            success = true;
        }
        finally {
            if (!success) {
                this.doStop();
            }
        }
    }

    protected HttpServerChannel bind(InetSocketAddress socketAddress) throws Exception {
        ChannelFuture future = this.serverBootstrap.bind((SocketAddress)socketAddress).sync();
        Channel channel = future.channel();
        Netty4HttpServerChannel httpServerChannel = new Netty4HttpServerChannel(channel);
        channel.attr(HTTP_SERVER_CHANNEL_KEY).set((Object)httpServerChannel);
        return httpServerChannel;
    }

    protected void stopInternal() {
        if (this.serverBootstrap != null) {
            this.serverBootstrap.config().group().shutdownGracefully(0L, 5L, TimeUnit.SECONDS).awaitUninterruptibly();
            this.serverBootstrap = null;
        }
    }

    public void onException(HttpChannel channel, Exception cause) {
        if (cause instanceof ReadTimeoutException) {
            super.onException(channel, (Exception)new HttpReadTimeoutException((long)this.readTimeoutMillis, cause));
        } else {
            super.onException(channel, cause);
        }
    }

    public ChannelHandler configureServerChannelHandler() {
        return new HttpChannelHandler(this, this.handlingSettings);
    }

    @ChannelHandler.Sharable
    private static class ServerChannelExceptionHandler
    extends ChannelInboundHandlerAdapter {
        private final Netty4HttpServerTransport transport;

        private ServerChannelExceptionHandler(Netty4HttpServerTransport transport) {
            this.transport = transport;
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            Netty4HttpServerChannel httpServerChannel = (Netty4HttpServerChannel)ctx.channel().attr(HTTP_SERVER_CHANNEL_KEY).get();
            if (cause instanceof Error) {
                this.transport.onServerException(httpServerChannel, new Exception(cause));
            } else {
                this.transport.onServerException(httpServerChannel, (Exception)cause);
            }
        }
    }

    protected static class HttpChannelHandler
    extends ChannelInitializer<Channel> {
        private final Netty4HttpServerTransport transport;
        private final Netty4HttpRequestHandler requestHandler;
        private final HttpHandlingSettings handlingSettings;

        protected HttpChannelHandler(Netty4HttpServerTransport transport, HttpHandlingSettings handlingSettings) {
            this.transport = transport;
            this.handlingSettings = handlingSettings;
            this.requestHandler = new Netty4HttpRequestHandler(transport);
        }

        protected void initChannel(Channel ch) throws Exception {
            Netty4HttpChannel nettyHttpChannel = new Netty4HttpChannel(ch);
            ch.attr(HTTP_CHANNEL_KEY).set((Object)nettyHttpChannel);
            ch.pipeline().addLast("read_timeout", (ChannelHandler)new ReadTimeoutHandler((long)this.transport.readTimeoutMillis, TimeUnit.MILLISECONDS));
            HttpRequestDecoder decoder = new HttpRequestDecoder(this.handlingSettings.getMaxInitialLineLength(), this.handlingSettings.getMaxHeaderSize(), this.handlingSettings.getMaxChunkSize());
            decoder.setCumulator(ByteToMessageDecoder.COMPOSITE_CUMULATOR);
            ch.pipeline().addLast("decoder", (ChannelHandler)decoder);
            ch.pipeline().addLast("decoder_compress", (ChannelHandler)new HttpContentDecompressor());
            ch.pipeline().addLast("encoder", (ChannelHandler)new HttpResponseEncoder());
            HttpObjectAggregator aggregator = new HttpObjectAggregator(this.handlingSettings.getMaxContentLength());
            aggregator.setMaxCumulationBufferComponents(this.transport.maxCompositeBufferComponents);
            ch.pipeline().addLast("aggregator", (ChannelHandler)aggregator);
            if (this.handlingSettings.isCompression()) {
                ch.pipeline().addLast("encoder_compress", (ChannelHandler)new HttpContentCompressor(this.handlingSettings.getCompressionLevel()));
            }
            if (this.handlingSettings.isCorsEnabled()) {
                ch.pipeline().addLast("cors", (ChannelHandler)new Netty4CorsHandler(this.transport.corsConfig));
            }
            ch.pipeline().addLast("pipelining", (ChannelHandler)new Netty4HttpPipeliningHandler(logger, this.transport.pipeliningMaxEvents));
            ch.pipeline().addLast("handler", (ChannelHandler)this.requestHandler);
            this.transport.serverAcceptedChannel(nettyHttpChannel);
        }

        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
            ExceptionsHelper.maybeDieOnAnotherThread((Throwable)cause);
            super.exceptionCaught(ctx, cause);
        }
    }
}

