/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jcajce.provider;

import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.InvalidParameterSpecException;
import java.security.spec.KeySpec;
import java.util.HashMap;
import java.util.Map;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import javax.crypto.spec.DHPrivateKeySpec;
import javax.crypto.spec.DHPublicKeySpec;
import org.bouncycastle.asn1.pkcs.DHParameter;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PrivateKeyInfo;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.DomainParameters;
import org.bouncycastle.asn1.x9.ValidationParams;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.AgreementFactory;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.Parameters;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPrivateKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricDHPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricKeyPair;
import org.bouncycastle.crypto.asymmetric.DHDomainParameters;
import org.bouncycastle.crypto.asymmetric.DHValidationParameters;
import org.bouncycastle.crypto.fips.FipsDH;
import org.bouncycastle.crypto.fips.FipsKDF;
import org.bouncycastle.crypto.fips.FipsUnapprovedOperationError;
import org.bouncycastle.jcajce.provider.AsymmetricAlgorithmProvider;
import org.bouncycastle.jcajce.provider.BaseAgreement;
import org.bouncycastle.jcajce.provider.BaseKeyFactory;
import org.bouncycastle.jcajce.provider.BouncyCastleFipsProvider;
import org.bouncycastle.jcajce.provider.DHAlgorithmParameterGeneratorSpi;
import org.bouncycastle.jcajce.provider.DHAlgorithmParametersSpi;
import org.bouncycastle.jcajce.provider.EngineCreator;
import org.bouncycastle.jcajce.provider.ParametersCreator;
import org.bouncycastle.jcajce.provider.PrivateKeyConverter;
import org.bouncycastle.jcajce.provider.ProvDHPrivateKey;
import org.bouncycastle.jcajce.provider.ProvDHPublicKey;
import org.bouncycastle.jcajce.provider.ProvIOException;
import org.bouncycastle.jcajce.provider.PublicKeyConverter;
import org.bouncycastle.jcajce.provider.Utils;
import org.bouncycastle.jcajce.spec.DHDomainParameterSpec;
import org.bouncycastle.jcajce.spec.MQVParameterSpec;
import org.bouncycastle.jcajce.spec.UserKeyingMaterialSpec;

class ProvDH
extends AsymmetricAlgorithmProvider {
    private static final Map<String, String> generalDhAttributes = new HashMap<String, String>();
    static final PublicKeyConverter<AsymmetricDHPublicKey> publicKeyConverter;
    static final PrivateKeyConverter<AsymmetricDHPrivateKey> privateKeyConverter;
    private static final String PREFIX = "org.bouncycastle.jcajce.provider.asymmetric.dh.";
    private static final AgreementFactory fipsDHFactory;
    private static final AgreementFactory fipsMQVFactory;
    private static final ParametersCreator mqvParametersCreator;
    private static final ParametersCreator parametersCreator;

    ProvDH() {
    }

    public void configure(final BouncyCastleFipsProvider bouncyCastleFipsProvider) {
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyPairGenerator.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyPairGeneratorSpi", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyPairGeneratorSpi(bouncyCastleFipsProvider);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.DIFFIEHELLMAN", "DH");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyPairGenerator.MQV", "DH");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyAgreement.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(new FipsDH.DHAgreementFactory(), publicKeyConverter, privateKeyConverter, parametersCreator);
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyAgreement.DIFFIEHELLMAN", "DH");
        bouncyCastleFipsProvider.addAlgorithmImplementation("KeyFactory.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyFactorySpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new KeyFactorySpi();
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.DIFFIEHELLMAN", "DH");
        bouncyCastleFipsProvider.addAlias("Alg.Alias.KeyFactory.MQV", "DH");
        KeyFactorySpi keyFactorySpi = new KeyFactorySpi();
        this.registerOid(bouncyCastleFipsProvider, X9ObjectIdentifiers.dhpublicnumber, "DH", keyFactorySpi);
        this.registerOid(bouncyCastleFipsProvider, PKCSObjectIdentifiers.dhKeyAgreement, "DH", keyFactorySpi);
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.AlgorithmParametersSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new AlgorithmParametersSpi();
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.AlgorithmParameters.DIFFIEHELLMAN", "DH");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.DH", "org.bouncycastle.jcajce.provider.asymmetric.dh.AlgorithmParameterGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new DHAlgorithmParameterGeneratorSpi(bouncyCastleFipsProvider, "DH");
            }
        });
        bouncyCastleFipsProvider.addAlias("Alg.Alias.AlgorithmParameterGenerator.DIFFIEHELLMAN", "DH");
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameters.MQV", "org.bouncycastle.jcajce.provider.asymmetric.dh.MQVAlgorithmParametersSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new MQVAlgorithmParametersSpi();
            }
        });
        bouncyCastleFipsProvider.addAlgorithmImplementation("AlgorithmParameterGenerator.MQV", "org.bouncycastle.jcajce.provider.asymmetric.dh.MQVAlgorithmParameterGeneratorSpi", new EngineCreator(){

            public Object createInstance(Object object) {
                return new DHAlgorithmParameterGeneratorSpi(bouncyCastleFipsProvider, "MQV");
            }
        });
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addX963DHAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addX963MQVAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addConcatDHAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA1", FipsKDF.AgreementKDFPRF.SHA1);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA224", FipsKDF.AgreementKDFPRF.SHA224);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA256", FipsKDF.AgreementKDFPRF.SHA256);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA384", FipsKDF.AgreementKDFPRF.SHA384);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512", FipsKDF.AgreementKDFPRF.SHA512);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(224)", FipsKDF.AgreementKDFPRF.SHA512_224);
        this.addConcatMQVAlgorithm(bouncyCastleFipsProvider, "SHA512(256)", FipsKDF.AgreementKDFPRF.SHA512_256);
    }

    private void addX963DHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF) {
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "DHWITH" + string + "KDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DH" + string + "KDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addX963MQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF) {
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "MQVWITH" + string + "KDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQV" + string + "KDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator, FipsKDF.X963.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addConcatDHAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF) {
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "DHWITH" + string + "CKDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$DH" + string + "CKDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsDHFactory, publicKeyConverter, privateKeyConverter, parametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    private void addConcatMQVAlgorithm(BouncyCastleFipsProvider bouncyCastleFipsProvider, String string, final FipsKDF.AgreementKDFPRF agreementKDFPRF) {
        this.addKeyAgreementAlgorithm(bouncyCastleFipsProvider, "MQVWITH" + string + "CKDF", "org.bouncycastle.jcajce.provider.asymmetric.dh.KeyAgreementSpi$MQV" + string + "CKDF", generalDhAttributes, new EngineCreator(){

            public Object createInstance(Object object) {
                return new BaseAgreement(fipsMQVFactory, publicKeyConverter, privateKeyConverter, mqvParametersCreator, FipsKDF.CONCATENATION.withPRF(agreementKDFPRF));
            }
        });
    }

    static {
        generalDhAttributes.put("SupportedKeyClasses", "javax.crypto.interfaces.DHPublicKey|javax.crypto.interfaces.DHPrivateKey");
        generalDhAttributes.put("SupportedKeyFormats", "PKCS#8|X.509");
        publicKeyConverter = new PublicKeyConverter<AsymmetricDHPublicKey>(){

            @Override
            public AsymmetricDHPublicKey convertKey(Algorithm algorithm, PublicKey publicKey) throws InvalidKeyException {
                if (publicKey instanceof DHPublicKey) {
                    if (publicKey instanceof ProvDHPublicKey) {
                        return ((ProvDHPublicKey)publicKey).getBaseKey();
                    }
                    return new ProvDHPublicKey(algorithm, (DHPublicKey)publicKey).getBaseKey();
                }
                try {
                    return new AsymmetricDHPublicKey(algorithm, SubjectPublicKeyInfo.getInstance(Utils.getKeyEncoding(publicKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify DH public key: " + exception.getMessage(), exception);
                }
            }
        };
        privateKeyConverter = new PrivateKeyConverter<AsymmetricDHPrivateKey>(){

            @Override
            public AsymmetricDHPrivateKey convertKey(Algorithm algorithm, PrivateKey privateKey) throws InvalidKeyException {
                if (privateKey instanceof DHPrivateKey) {
                    if (privateKey instanceof ProvDHPrivateKey) {
                        return ((ProvDHPrivateKey)privateKey).getBaseKey();
                    }
                    return new ProvDHPrivateKey(algorithm, (DHPrivateKey)privateKey).getBaseKey();
                }
                try {
                    return new AsymmetricDHPrivateKey(algorithm, PrivateKeyInfo.getInstance(Utils.getKeyEncoding(privateKey)));
                }
                catch (Exception exception) {
                    throw new InvalidKeyException("Cannot identify DH private key: " + exception.getMessage(), exception);
                }
            }
        };
        fipsDHFactory = new FipsDH.DHAgreementFactory();
        fipsMQVFactory = new FipsDH.MQVAgreementFactory();
        mqvParametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                try {
                    if (!(algorithmParameterSpec instanceof MQVParameterSpec)) {
                        throw new InvalidAlgorithmParameterException("MQV can only take an MQVParameterSpec");
                    }
                    MQVParameterSpec mQVParameterSpec = (MQVParameterSpec)algorithmParameterSpec;
                    if (mQVParameterSpec.getEphemeralPublicKey() != null) {
                        return FipsDH.MQV.using(publicKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPublicKey()), privateKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPrivateKey()), publicKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mQVParameterSpec.getOtherPartyEphemeralKey()));
                    }
                    return FipsDH.MQV.using(privateKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mQVParameterSpec.getEphemeralPrivateKey()), publicKeyConverter.convertKey(FipsDH.MQV.getAlgorithm(), mQVParameterSpec.getOtherPartyEphemeralKey()));
                }
                catch (InvalidKeyException invalidKeyException) {
                    throw new InvalidAlgorithmParameterException("Unable to convert keys in MQVParameterSpec: " + invalidKeyException.getMessage(), invalidKeyException);
                }
            }
        };
        parametersCreator = new ParametersCreator(){

            public Parameters createParameters(boolean bl, AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
                if (algorithmParameterSpec != null && !(algorithmParameterSpec instanceof UserKeyingMaterialSpec)) {
                    throw new InvalidAlgorithmParameterException("DH can only take a UserKeyingMaterialSpec");
                }
                return FipsDH.DH;
            }
        };
    }

    static class AlgorithmParametersSpi
    extends DHAlgorithmParametersSpi {
        AlgorithmParametersSpi() {
            super("DH");
        }

        protected byte[] localGetEncoded() throws IOException {
            DHParameter dHParameter = new DHParameter(this.currentSpec.getP(), this.currentSpec.getG(), this.currentSpec.getL());
            return dHParameter.toASN1Primitive().getEncoded("DER");
        }

        protected void localInit(byte[] byArray) throws IOException {
            DHParameter dHParameter = DHParameter.getInstance(byArray);
            this.currentSpec = dHParameter.getL() == null ? new DHDomainParameterSpec(dHParameter.getP(), null, dHParameter.getG()) : new DHDomainParameterSpec(dHParameter.getP(), null, dHParameter.getG(), dHParameter.getL().intValue());
        }

        protected String engineToString() {
            return "DH Parameters";
        }
    }

    static class KeyFactorySpi
    extends BaseKeyFactory {
        protected PrivateKey engineGeneratePrivate(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPrivateKeySpec) {
                return new ProvDHPrivateKey((Algorithm)FipsDH.ALGORITHM, (DHPrivateKeySpec)keySpec);
            }
            return super.engineGeneratePrivate(keySpec);
        }

        protected PublicKey engineGeneratePublic(KeySpec keySpec) throws InvalidKeySpecException {
            if (keySpec instanceof DHPublicKeySpec) {
                try {
                    return new ProvDHPublicKey((Algorithm)FipsDH.ALGORITHM, (DHPublicKeySpec)keySpec);
                }
                catch (Exception exception) {
                    throw new InvalidKeySpecException("invalid KeySpec: " + exception.getMessage(), exception);
                }
            }
            return super.engineGeneratePublic(keySpec);
        }

        protected KeySpec engineGetKeySpec(Key key, Class clazz) throws InvalidKeySpecException {
            if (clazz == null) {
                throw new InvalidKeySpecException("null spec is invalid");
            }
            if (clazz.isAssignableFrom(DHPrivateKeySpec.class) && key instanceof DHPrivateKey) {
                DHPrivateKey dHPrivateKey = (DHPrivateKey)key;
                return new DHPrivateKeySpec(dHPrivateKey.getX(), dHPrivateKey.getParams().getP(), dHPrivateKey.getParams().getG());
            }
            if (clazz.isAssignableFrom(DHPublicKeySpec.class) && key instanceof DHPublicKey) {
                DHPublicKey dHPublicKey = (DHPublicKey)key;
                return new DHPublicKeySpec(dHPublicKey.getY(), dHPublicKey.getParams().getP(), dHPublicKey.getParams().getG());
            }
            return super.engineGetKeySpec(key, clazz);
        }

        protected Key engineTranslateKey(Key key) throws InvalidKeyException {
            if (key instanceof PublicKey) {
                return new ProvDHPublicKey(publicKeyConverter.convertKey(FipsDH.ALGORITHM, (PublicKey)key));
            }
            if (key instanceof PrivateKey) {
                return new ProvDHPrivateKey(privateKeyConverter.convertKey(FipsDH.ALGORITHM, (PrivateKey)key));
            }
            if (key != null) {
                throw new InvalidKeyException("Key type unrecognized: " + key.getClass().getName());
            }
            throw new InvalidKeyException("Key is null");
        }

        public PrivateKey generatePrivate(PrivateKeyInfo privateKeyInfo) throws IOException {
            return new ProvDHPrivateKey(new AsymmetricDHPrivateKey((Algorithm)FipsDH.ALGORITHM, privateKeyInfo));
        }

        public PublicKey generatePublic(SubjectPublicKeyInfo subjectPublicKeyInfo) throws IOException {
            return new ProvDHPublicKey(new AsymmetricDHPublicKey((Algorithm)FipsDH.ALGORITHM, subjectPublicKeyInfo));
        }
    }

    static class KeyPairGeneratorSpi
    extends KeyPairGenerator {
        private final BouncyCastleFipsProvider fipsProvider;
        private FipsDH.KeyGenParameters param;
        private FipsDH.KeyPairGenerator engine;
        private int strength = 2048;
        private SecureRandom random = null;
        private boolean initialised = false;

        public KeyPairGeneratorSpi(BouncyCastleFipsProvider bouncyCastleFipsProvider) {
            super("DH");
            this.fipsProvider = bouncyCastleFipsProvider;
            this.random = bouncyCastleFipsProvider.getDefaultSecureRandom();
        }

        public void initialize(int n) {
            this.initialize(n, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(int n, SecureRandom secureRandom) {
            this.strength = n;
            this.random = secureRandom;
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidAlgorithmParameterException {
            this.initialize(algorithmParameterSpec, this.fipsProvider.getDefaultSecureRandom());
        }

        public void initialize(AlgorithmParameterSpec algorithmParameterSpec, SecureRandom secureRandom) throws InvalidAlgorithmParameterException {
            if (!(algorithmParameterSpec instanceof DHParameterSpec)) {
                throw new InvalidAlgorithmParameterException("AlgorithmParameterSpec not recognized: " + algorithmParameterSpec.getClass().getName());
            }
            DHParameterSpec dHParameterSpec = (DHParameterSpec)algorithmParameterSpec;
            this.param = dHParameterSpec instanceof DHDomainParameterSpec ? new FipsDH.KeyGenParameters(new DHDomainParameters(dHParameterSpec.getP(), ((DHDomainParameterSpec)dHParameterSpec).getQ(), dHParameterSpec.getG(), dHParameterSpec.getL())) : new FipsDH.KeyGenParameters(new DHDomainParameters(dHParameterSpec.getP(), null, dHParameterSpec.getG(), dHParameterSpec.getL()));
            try {
                this.engine = new FipsDH.KeyPairGenerator(this.param, secureRandom);
            }
            catch (FipsUnapprovedOperationError fipsUnapprovedOperationError) {
                throw new InvalidAlgorithmParameterException(fipsUnapprovedOperationError.getMessage(), (Throwable)((Object)fipsUnapprovedOperationError));
            }
            this.initialised = true;
        }

        public KeyPair generateKeyPair() {
            Object object;
            Object object2;
            if (!this.initialised) {
                object2 = (DHDomainParameters)CryptoServicesRegistrar.getSizedProperty(CryptoServicesRegistrar.Property.DH_DEFAULT_PARAMS, this.strength);
                if (object2 != null) {
                    this.param = new FipsDH.KeyGenParameters((DHDomainParameters)object2);
                } else {
                    object = new FipsDH.DomainParametersGenerator(new FipsDH.DomainGenParameters(this.strength), this.random);
                    this.param = new FipsDH.KeyGenParameters(((FipsDH.DomainParametersGenerator)object).generateDomainParameters());
                }
                this.engine = new FipsDH.KeyPairGenerator(this.param, this.random);
                this.initialised = true;
            }
            object2 = this.engine.generateKeyPair();
            object = ((AsymmetricKeyPair)object2).getPublicKey();
            AsymmetricDHPrivateKey asymmetricDHPrivateKey = (AsymmetricDHPrivateKey)((AsymmetricKeyPair)object2).getPrivateKey();
            return new KeyPair(new ProvDHPublicKey((AsymmetricDHPublicKey)object), new ProvDHPrivateKey(asymmetricDHPrivateKey));
        }
    }

    static class MQVAlgorithmParametersSpi
    extends DHAlgorithmParametersSpi {
        MQVAlgorithmParametersSpi() {
            super("MQV");
        }

        protected byte[] localGetEncoded() throws IOException {
            DomainParameters domainParameters;
            DHDomainParameterSpec dHDomainParameterSpec = this.currentSpec;
            DHValidationParameters dHValidationParameters = dHDomainParameterSpec.getValidationParameters();
            try {
                domainParameters = dHValidationParameters != null ? new DomainParameters(this.currentSpec.getP(), this.currentSpec.getG(), dHDomainParameterSpec.getQ(), dHDomainParameterSpec.getJ(), new ValidationParams(dHValidationParameters.getSeed(), dHValidationParameters.getCounter())) : new DomainParameters(this.currentSpec.getP(), this.currentSpec.getG(), dHDomainParameterSpec.getQ(), dHDomainParameterSpec.getJ(), null);
            }
            catch (Exception exception) {
                throw new ProvIOException("Exception creating parameters: " + exception.getMessage(), exception);
            }
            return domainParameters.toASN1Primitive().getEncoded("DER");
        }

        protected void engineInit(AlgorithmParameterSpec algorithmParameterSpec) throws InvalidParameterSpecException {
            if (!(algorithmParameterSpec instanceof DHDomainParameterSpec)) {
                throw new InvalidParameterSpecException("DHDomainParameterSpec required to initialise a MQV/X9 AlgorithmParameters");
            }
            this.currentSpec = (DHDomainParameterSpec)algorithmParameterSpec;
        }

        protected void localInit(byte[] byArray) throws IOException {
            DomainParameters domainParameters = DomainParameters.getInstance(byArray);
            this.currentSpec = domainParameters.getValidationParams() != null ? new DHDomainParameterSpec(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), 0, new DHValidationParameters(domainParameters.getValidationParams().getSeed(), domainParameters.getValidationParams().getPgenCounter().intValue())) : new DHDomainParameterSpec(domainParameters.getP(), domainParameters.getQ(), domainParameters.getG(), domainParameters.getJ(), 0, null);
        }

        protected String engineToString() {
            return "MQV/X9 DH Parameters";
        }
    }
}

