/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.snapshots;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public final class SnapshotId
implements Comparable<SnapshotId>,
Writeable,
ToXContentObject {
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private final String name;
    private final String uuid;
    private final int hashCode;

    public SnapshotId(String name, String uuid) {
        this.name = Objects.requireNonNull(name);
        this.uuid = Objects.requireNonNull(uuid);
        this.hashCode = this.computeHashCode();
    }

    public SnapshotId(StreamInput in) throws IOException {
        this.name = in.readString();
        this.uuid = in.readString();
        this.hashCode = this.computeHashCode();
    }

    public String getName() {
        return this.name;
    }

    public String getUUID() {
        return this.uuid;
    }

    public String toString() {
        return this.name + "/" + this.uuid;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SnapshotId that = (SnapshotId)o;
        return this.name.equals(that.name) && this.uuid.equals(that.uuid);
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public int compareTo(SnapshotId other) {
        return this.name.compareTo(other.name);
    }

    private int computeHashCode() {
        return Objects.hash(this.name, this.uuid);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeString(this.name);
        out.writeString(this.uuid);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(NAME, this.name);
        builder.field(UUID, this.uuid);
        builder.endObject();
        return builder;
    }
}

