/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import net.sf.freecol.common.model.Building;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.FeatureContainer;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.RandomUtils;

public class SimpleCombatModel
extends CombatModel {
    private static final Logger logger = Logger.getLogger(SimpleCombatModel.class.getName());
    public static final int MAXIMUM_BOMBARD_POWER = 48;
    public static final int STRONG_DEFENCE_THRESHOLD = 150;
    public static final Modifier UNKNOWN_DEFENCE_MODIFIER = new Modifier("bogus", Float.MIN_VALUE, Modifier.ModifierType.ADDITIVE);

    @Override
    public CombatModel.CombatOdds calculateCombatOdds(FreeColGameObject attacker, FreeColGameObject defender) {
        return this.calculateCombatOdds(attacker, defender, null);
    }

    private CombatModel.CombatOdds calculateCombatOdds(FreeColGameObject attacker, FreeColGameObject defender, LogBuilder lb) {
        if (attacker == null || defender == null) {
            if (lb != null) {
                lb.add(" odds=unknowable");
            }
            return new CombatModel.CombatOdds(-1.0);
        }
        if (lb != null) {
            lb.add(" attacker=", attacker, " ");
        }
        double attackPower = this.getOffencePower(attacker, defender, lb);
        if (lb != null) {
            lb.add(" defender=", defender, " ");
        }
        double defencePower = this.getDefencePower(attacker, defender, lb);
        if (attackPower == 0.0 && defencePower == 0.0) {
            if (lb != null) {
                lb.add(" odds=unknown");
            }
            return new CombatModel.CombatOdds(-1.0);
        }
        double victory = attackPower / (attackPower + defencePower);
        if (lb != null) {
            lb.add(" odds=", victory);
        }
        return new CombatModel.CombatOdds(victory);
    }

    @Override
    public double getOffencePower(FreeColGameObject attacker, FreeColGameObject defender) {
        return this.getOffencePower(attacker, defender, null);
    }

    private void logModifiers(LogBuilder lb, Set<Modifier> modSet) {
        lb.addCollection(" ", modSet.stream().sorted().collect(Collectors.toList()));
    }

    private double getOffencePower(FreeColGameObject attacker, FreeColGameObject defender, LogBuilder lb) {
        double result = 0.0;
        if (attacker == null) {
            throw new IllegalStateException("Null attacker");
        }
        if (this.combatIsAttackMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsSettlementAttack(attacker, defender)) {
            Set<Modifier> mods = this.getOffensiveModifiers(attacker, defender);
            Turn turn = attacker.getGame().getTurn();
            result = FeatureContainer.applyModifiers(0.0f, turn, mods);
            if (lb != null) {
                this.logModifiers(lb, mods);
                lb.add(" = ", result);
            }
        } else if (this.combatIsBombard(attacker, defender)) {
            Settlement attackerSettlement = (Settlement)attacker;
            if (attackerSettlement.hasAbility("model.ability.bombardShips")) {
                result += attackerSettlement.getTile().getUnitList().stream().filter(u -> u.hasAbility("model.ability.bombard")).mapToDouble(u -> u.getType().getOffence()).sum();
            }
            if (result > 48.0) {
                result = 48.0;
            }
            if (lb != null) {
                lb.add(" bombard=", result);
            }
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        return result;
    }

    @Override
    public double getDefencePower(FreeColGameObject attacker, FreeColGameObject defender) {
        return this.getDefencePower(attacker, defender, null);
    }

    public double getDefencePower(FreeColGameObject attacker, FreeColGameObject defender, LogBuilder lb) {
        double result;
        if (this.combatIsDefenceMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsSettlementAttack(attacker, defender) || this.combatIsBombard(attacker, defender)) {
            Set<Modifier> mods = this.getDefensiveModifiers(attacker, defender);
            Turn turn = defender.getGame().getTurn();
            result = FeatureContainer.applyModifiers(0.0f, turn, mods);
            if (lb != null) {
                this.logModifiers(lb, mods);
                lb.add(" = ", result);
            }
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        return result;
    }

    @Override
    public Set<Modifier> getOffensiveModifiers(FreeColGameObject attacker, FreeColGameObject defender) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (attacker == null) {
            throw new IllegalStateException("Null attacker");
        }
        if (this.combatIsAttackMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsSettlementAttack(attacker, defender)) {
            Unit attackerUnit = (Unit)attacker;
            Turn turn = attackerUnit.getGame().getTurn();
            result.add(new Modifier("model.modifier.offence", attackerUnit.getType().getBaseOffence(), Modifier.ModifierType.ADDITIVE, Specification.BASE_OFFENCE_SOURCE, 10));
            result.addAll(attackerUnit.getCombatModifiers("model.modifier.offence", attackerUnit.getType(), turn));
            if (defender instanceof Ownable) {
                Player owner = ((Ownable)((Object)defender)).getOwner();
                result.addAll(attackerUnit.getModifiers("model.modifier.offenceAgainst", owner.getNationType()));
            }
            if (attackerUnit.isNaval()) {
                this.addNavalOffensiveModifiers(attackerUnit, result);
            } else {
                this.addLandOffensiveModifiers(attackerUnit, defender, result);
            }
        } else if (!this.combatIsBombard(attacker, defender)) {
            throw new IllegalArgumentException("Bogus combat");
        }
        for (Modifier r : result) {
            if (r.getModifierIndex() != 0) continue;
            r.setModifierIndex(50);
        }
        return result;
    }

    private void addNavalOffensiveModifiers(Unit attacker, Set<Modifier> result) {
        Specification spec = attacker.getSpecification();
        result.addAll(spec.getModifiers("model.modifier.attackBonus"));
        int goodsCount = attacker.getGoodsSpaceTaken();
        if (goodsCount > 0) {
            for (Modifier m : spec.getModifiers("model.modifier.cargoPenalty")) {
                Modifier c = new Modifier(m);
                c.setValue(c.getValue() * (float)goodsCount);
                result.add(c);
            }
        }
    }

    private void addPopularSupportBonus(Colony colony, Unit attacker, Set<Modifier> result) {
        int bonus = colony.getSoL();
        if (bonus >= 0) {
            if (attacker.getOwner().isREF()) {
                bonus = 100 - bonus;
            }
            if (bonus > 0) {
                result.add(new Modifier("model.modifier.popularSupport", bonus, Modifier.ModifierType.PERCENTAGE, colony, 50));
            }
        }
    }

    private void addLandOffensiveModifiers(Unit attacker, FreeColGameObject defender, Set<Modifier> result) {
        Specification spec = attacker.getSpecification();
        result.addAll(spec.getModifiers("model.modifier.attackBonus"));
        switch (attacker.getMovesLeft()) {
            case 1: {
                result.addAll(spec.getModifiers("model.modifier.bigMovementPenalty"));
                break;
            }
            case 2: {
                result.addAll(spec.getModifiers("model.modifier.smallMovementPenalty"));
                break;
            }
        }
        if (this.combatIsAmphibious(attacker, defender)) {
            result.addAll(spec.getModifiers("model.modifier.amphibiousAttack"));
        }
        if (!this.combatIsAttackMeasurement(attacker, defender)) {
            if (this.combatIsSettlementAttack(attacker, defender)) {
                result.addAll(attacker.getModifiers("model.modifier.bombardBonus"));
                if (this.combatIsWarOfIndependence(attacker, defender)) {
                    this.addPopularSupportBonus((Colony)defender, attacker, result);
                }
            } else if (this.combatIsAttack(attacker, defender)) {
                Unit defenderUnit = (Unit)defender;
                Tile tile = defenderUnit.getTile();
                if (tile != null) {
                    if (tile.hasSettlement()) {
                        result.addAll(attacker.getModifiers("model.modifier.bombardBonus"));
                        if (this.combatIsWarOfIndependence(attacker, defender)) {
                            this.addPopularSupportBonus((Colony)tile.getSettlement(), attacker, result);
                        }
                    } else if (this.isAmbush(attacker, defender)) {
                        for (Modifier m : tile.getDefenceModifiers()) {
                            Modifier mod = new Modifier("model.modifier.offence", m);
                            mod.setSource(Specification.AMBUSH_BONUS_SOURCE);
                            result.add(mod);
                        }
                    }
                }
                if (attacker.hasAbility("model.ability.bombard") && attacker.getLocation() instanceof Tile && attacker.getSettlement() == null && attacker.getState() != Unit.UnitState.FORTIFIED && defenderUnit.getSettlement() == null) {
                    result.addAll(spec.getModifiers("model.modifier.artilleryInTheOpen"));
                }
            } else {
                throw new IllegalStateException("Bogus combat");
            }
        }
    }

    @Override
    public Set<Modifier> getDefensiveModifiers(FreeColGameObject attacker, FreeColGameObject defender) {
        HashSet<Modifier> result = new HashSet<Modifier>();
        if (this.combatIsDefenceMeasurement(attacker, defender) || this.combatIsAttack(attacker, defender) || this.combatIsBombard(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            Turn turn = defenderUnit.getGame().getTurn();
            result.add(new Modifier("model.modifier.defence", defenderUnit.getType().getBaseDefence(), Modifier.ModifierType.ADDITIVE, Specification.BASE_DEFENCE_SOURCE, 10));
            result.addAll(defenderUnit.getCombatModifiers("model.modifier.defence", defenderUnit.getType(), turn));
            if (defenderUnit.isNaval()) {
                this.addNavalDefensiveModifiers(defenderUnit, result);
            } else {
                this.addLandDefensiveModifiers(attacker, defenderUnit, result);
            }
        } else if (this.combatIsSettlementAttack(attacker, defender)) {
            Settlement settlement = (Settlement)defender;
            Tile tile = settlement.getTile();
            result.addAll(tile.getType().getDefenceModifiers());
            result.addAll(settlement.getDefenceModifiers());
            result.add(UNKNOWN_DEFENCE_MODIFIER);
        } else {
            throw new IllegalArgumentException("Bogus combat");
        }
        for (Modifier r : result) {
            if (r.getModifierIndex() != 0) continue;
            r.setModifierIndex(50);
        }
        return result;
    }

    private void addNavalDefensiveModifiers(Unit defender, Set<Modifier> result) {
        Specification spec = defender.getSpecification();
        int goodsCount = defender.getVisibleGoodsCount();
        if (goodsCount > 0) {
            for (Modifier m : spec.getModifiers("model.modifier.cargoPenalty")) {
                Modifier c = new Modifier(m);
                c.setValue(c.getValue() * (float)goodsCount);
                result.add(c);
            }
        }
    }

    private boolean hasStrongDefenceModifier(FreeColObject fco) {
        return CollectionUtils.any(fco.getDefenceModifiers(), m -> m.getType() == Modifier.ModifierType.PERCENTAGE && m.getValue() >= 150.0f);
    }

    private void addLandDefensiveModifiers(FreeColGameObject attacker, Unit defender, Set<Modifier> result) {
        Settlement settlement;
        Specification spec = defender.getSpecification();
        Tile tile = defender.getTile();
        Settlement settlement2 = settlement = tile == null ? null : tile.getSettlement();
        if (tile != null) {
            boolean disableFortified = false;
            disableFortified |= this.hasStrongDefenceModifier(tile.getType());
            if (settlement == null) {
                result.addAll(tile.getType().getDefenceModifiers());
                if (defender.hasAbility("model.ability.bombard") && defender.getState() != Unit.UnitState.FORTIFIED) {
                    result.addAll(spec.getModifiers("model.modifier.artilleryInTheOpen"));
                }
            } else {
                Building stockade;
                Role autoRole;
                result.addAll(settlement.getDefenceModifiers());
                if (defender.hasAbility("model.ability.bombard") && attacker != null && ((Unit)attacker).getOwner().isIndian()) {
                    result.addAll(spec.getModifiers("model.modifier.artilleryAgainstRaid"));
                }
                if ((autoRole = defender.getAutomaticRole()) != null) {
                    result.addAll(autoRole.getDefenceModifiers());
                }
                if (settlement instanceof Colony && (stockade = ((Colony)settlement).getStockade()) != null) {
                    disableFortified |= this.hasStrongDefenceModifier(stockade.getType());
                }
            }
            if (defender.getState() == Unit.UnitState.FORTIFIED && !disableFortified) {
                result.addAll(spec.getModifiers("model.modifier.fortified"));
            }
        }
    }

    @Override
    public List<CombatModel.CombatResult> generateAttackResult(Random random, FreeColGameObject attacker, FreeColGameObject defender) {
        String action;
        LogBuilder lb = new LogBuilder(256);
        lb.add("Combat");
        ArrayList<CombatModel.CombatResult> crs = new ArrayList<CombatModel.CombatResult>();
        CombatModel.CombatOdds odds = this.calculateCombatOdds(attacker, defender, lb);
        double r = RandomUtils.randomDouble(logger, "AttackResult", random);
        lb.add(" random(1.0)=", r);
        boolean great = false;
        if (this.combatIsAttack(attacker, defender)) {
            Unit attackerUnit = (Unit)attacker;
            Unit defenderUnit = (Unit)defender;
            action = "Attack";
            if (r < odds.win || defenderUnit.isBeached()) {
                great = r < 0.1 * odds.win;
                crs.add(CombatModel.CombatResult.WIN);
                this.resolveAttack(attackerUnit, defenderUnit, great, r / (0.1 * odds.win), crs);
            } else if (r < 0.8 * odds.win + 0.2 && defenderUnit.hasAbility("model.ability.evadeAttack")) {
                crs.add(CombatModel.CombatResult.NO_RESULT);
                crs.add(CombatModel.CombatResult.EVADE_ATTACK);
            } else {
                great = r >= 0.1 * odds.win + 0.9;
                crs.add(CombatModel.CombatResult.LOSE);
                this.resolveAttack(defenderUnit, attackerUnit, great, (1.25 * r - 0.25 - odds.win) / (1.0 - odds.win), crs);
            }
        } else if (this.combatIsBombard(attacker, defender)) {
            Unit defenderUnit = (Unit)defender;
            if (!defenderUnit.isNaval()) {
                throw new IllegalStateException("Bombard of non-naval");
            }
            action = "Bombard";
            if (r <= odds.win) {
                crs.add(CombatModel.CombatResult.WIN);
                double offencePower = this.getOffencePower(attacker, defender);
                double defencePower = this.getDefencePower(attacker, defender);
                double diff = Math.max(3.0, defencePower * 2.0 - offencePower);
                boolean bl = great = r < odds.win / diff;
                if (great || defenderUnit.getRepairLocation() == null) {
                    crs.add(CombatModel.CombatResult.SINK_SHIP_BOMBARD);
                } else {
                    crs.add(CombatModel.CombatResult.DAMAGE_SHIP_BOMBARD);
                }
            } else {
                crs.add(CombatModel.CombatResult.NO_RESULT);
                crs.add(CombatModel.CombatResult.EVADE_BOMBARD);
            }
        } else {
            throw new IllegalStateException("Bogus combat");
        }
        lb.add(" great=", great, " ", action);
        for (CombatModel.CombatResult cr : crs) {
            lb.add(new Object[]{" ", cr});
        }
        lb.log(logger, Level.INFO);
        return crs;
    }

    private void resolveAttack(Unit winner, Unit loser, boolean great, double r, List<CombatModel.CombatResult> crs) {
        Player loserPlayer = loser.getOwner();
        Tile tile = loser.getTile();
        Player winnerPlayer = winner.getOwner();
        boolean attackerWon = crs.get(0) == CombatModel.CombatResult.WIN;
        boolean loserMustDie = loser.hasAbility("model.ability.disposeOnCombatLoss");
        if (loser.isNaval()) {
            if (winner.isNaval() && winner.canCaptureGoods() && !loser.getGoodsList().isEmpty()) {
                crs.add(CombatModel.CombatResult.LOOT_SHIP);
            }
            if (great || loserMustDie || loser.getRepairLocation() == null || loser.isBeached()) {
                crs.add(CombatModel.CombatResult.SINK_SHIP_ATTACK);
            } else {
                crs.add(CombatModel.CombatResult.DAMAGE_SHIP_ATTACK);
            }
        } else {
            Role autoRole;
            Role role = autoRole = attackerWon ? loser.getAutomaticRole() : null;
            if (autoRole != null) {
                crs.add(CombatModel.CombatResult.AUTOEQUIP_UNIT);
            }
            boolean done = false;
            Settlement settlement = tile.getSettlement();
            if (settlement instanceof Colony) {
                Colony colony = (Colony)settlement;
                if (!loser.isDefensiveUnit() && autoRole == null) {
                    CombatModel.CombatResult shipResult;
                    List<Unit> ships = colony.getTile().getNavalUnits();
                    CombatModel.CombatResult combatResult = ships.isEmpty() ? null : (shipResult = ships.get(0).getRepairLocation() == null ? CombatModel.CombatResult.SINK_COLONY_SHIPS : CombatModel.CombatResult.DAMAGE_COLONY_SHIPS);
                    if (winnerPlayer.isEuropean()) {
                        if (loserMustDie) {
                            crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                        }
                        if (shipResult != null) {
                            crs.add(shipResult);
                        }
                        crs.add(CombatModel.CombatResult.CAPTURE_COLONY);
                        done = true;
                    } else if (!great && colony.canBePillaged(winner)) {
                        crs.add(CombatModel.CombatResult.PILLAGE_COLONY);
                        done = true;
                    } else if (colony.getUnitCount() > 1 || loser.getLocation() == tile) {
                        loserMustDie = true;
                        done = false;
                    } else {
                        crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                        if (shipResult != null) {
                            crs.add(shipResult);
                        }
                        crs.add(CombatModel.CombatResult.DESTROY_COLONY);
                        done = true;
                    }
                }
            } else if (settlement instanceof IndianSettlement) {
                IndianSettlement is = (IndianSettlement)settlement;
                int lose = 0;
                if (loserMustDie) {
                    crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                    ++lose;
                    done = true;
                }
                if (attackerWon) {
                    if (r < (double)winner.getConvertProbability()) {
                        if (is.getUnitCount() + tile.getUnitCount() > lose && is.hasMissionary(winnerPlayer) && !this.combatIsAmphibious(winner, loser)) {
                            crs.add(CombatModel.CombatResult.CAPTURE_CONVERT);
                            ++lose;
                        }
                    } else if (r >= 1.0 - (double)winner.getBurnProbability() && CollectionUtils.any(loserPlayer.getIndianSettlements(), s -> s.hasMissionary(winnerPlayer))) {
                        crs.add(CombatModel.CombatResult.BURN_MISSIONS);
                    }
                }
                if (settlement.getUnitCount() + tile.getUnitCount() <= lose) {
                    crs.add(CombatModel.CombatResult.DESTROY_SETTLEMENT);
                    done = true;
                }
            }
            if (!done) {
                Role loserRole = loser.getRole();
                if (autoRole != null) {
                    crs.add(winner.canCaptureEquipment(autoRole) != null ? CombatModel.CombatResult.CAPTURE_AUTOEQUIP : CombatModel.CombatResult.LOSE_AUTOEQUIP);
                    if (loserMustDie) {
                        crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                    } else if (loser.hasAbility("model.ability.demoteOnAllEquipLost")) {
                        crs.add(CombatModel.CombatResult.DEMOTE_UNIT);
                    }
                } else if (loserMustDie) {
                    crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                } else if (loserRole.isOffensive()) {
                    crs.add(winner.canCaptureEquipment(loserRole) != null ? CombatModel.CombatResult.CAPTURE_EQUIP : CombatModel.CombatResult.LOSE_EQUIP);
                    if (loserMustDie || loser.losingEquipmentKillsUnit()) {
                        crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                    } else if (loser.losingEquipmentDemotesUnit()) {
                        crs.add(CombatModel.CombatResult.DEMOTE_UNIT);
                    }
                } else if (loser.hasAbility("model.ability.canBeCaptured") && winner.hasAbility("model.ability.captureUnits") && !this.combatIsAmphibious(winner, loser)) {
                    crs.add(CombatModel.CombatResult.CAPTURE_UNIT);
                } else if (loser.getTypeChange(UnitTypeChange.ChangeType.DEMOTION, loserPlayer) != null) {
                    crs.add(CombatModel.CombatResult.DEMOTE_UNIT);
                } else {
                    crs.add(CombatModel.CombatResult.SLAUGHTER_UNIT);
                }
            }
        }
        UnitTypeChange promotion = winner.getType().getUnitTypeChange(UnitTypeChange.ChangeType.PROMOTION, winnerPlayer);
        if (promotion != null && (winner.hasAbility("model.ability.automaticPromotion") || great && 100.0 * (r - Math.floor(r)) <= (double)promotion.getProbability(UnitTypeChange.ChangeType.PROMOTION))) {
            crs.add(CombatModel.CombatResult.PROMOTE_UNIT);
        }
    }

    private boolean isAmbush(FreeColGameObject attacker, FreeColGameObject defender) {
        if (attacker instanceof Unit && defender instanceof Unit) {
            Unit attackerUnit = (Unit)attacker;
            Unit defenderUnit = (Unit)defender;
            return !(attackerUnit.getSettlement() != null || !attackerUnit.hasTile() || defenderUnit.getSettlement() != null || defenderUnit.getState() == Unit.UnitState.FORTIFIED || !defenderUnit.hasTile() || !attackerUnit.hasAbility("model.ability.ambushBonus") && !defenderUnit.hasAbility("model.ability.ambushPenalty") || !attackerUnit.getTile().hasAbility("model.ability.ambushTerrain") && !defenderUnit.getTile().hasAbility("model.ability.ambushTerrain"));
        }
        return false;
    }
}

