/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.compiler;

import org.jruby.compiler.Compilable;
import org.jruby.compiler.JITCompiler;
import org.jruby.ir.IRScope;
import org.jruby.ir.interpreter.InterpreterContext;

class FullBuildTask
implements Runnable {
    private final JITCompiler jitCompiler;
    private final Compilable<InterpreterContext> method;

    FullBuildTask(JITCompiler jitCompiler, Compilable<InterpreterContext> method2) {
        this.jitCompiler = jitCompiler;
        this.method = method2;
    }

    @Override
    public void run() {
        block4: {
            try {
                IRScope hardScope = this.method.getIRScope().getNearestTopLocalVariableScope();
                if (hardScope != this.method.getIRScope()) {
                    hardScope.prepareFullBuild();
                }
                this.method.completeBuild(this.method.getIRScope().prepareFullBuild());
                if (this.jitCompiler.config.isJitLogging()) {
                    JITCompiler.log(this.method, this.method.getName(), "done building", new Object[0]);
                }
            }
            catch (Throwable t) {
                if (!this.jitCompiler.config.isJitLogging()) break block4;
                JITCompiler.log(this.method, this.method.getName(), "could not build; passes run: " + this.method.getIRScope().getExecutedPasses(), t);
                if (!this.jitCompiler.config.isJitLoggingVerbose()) break block4;
                t.printStackTrace();
            }
        }
    }
}

