"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const ConsoleLogger_1 = require("./ConsoleLogger");
class LogService {
    constructor() {
    }
    /**
     * Sets a new logger for the Log Service
     * @param {ILogger} logger the new logger
     */
    static setLogger(logger) {
        LogService.logger = logger;
    }
    /**
     * Logs to the DEBUG channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static debug(module, ...messageOrObject) {
        LogService.logger.debug(module, ...messageOrObject);
    }
    /**
     * Logs to the ERROR channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static error(module, ...messageOrObject) {
        LogService.logger.error(module, ...messageOrObject);
    }
    /**
     * Logs to the INFO channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static info(module, ...messageOrObject) {
        LogService.logger.info(module, ...messageOrObject);
    }
    /**
     * Logs to the WARN channel
     * @param {string} module The module being logged
     * @param {*[]} messageOrObject The data to log
     */
    static warn(module, ...messageOrObject) {
        LogService.logger.warn(module, ...messageOrObject);
    }
}
LogService.logger = new ConsoleLogger_1.ConsoleLogger();
exports.LogService = LogService;
