sl Module
     __________________________________________________________

   Table of Contents

   1. Admin Guide

        1.1. Overview
        1.2. Dependencies

              1.2.1. OpenSIPS Modules
              1.2.2. External Libraries or Applications

        1.3. Exported Parameters

              1.3.1. enable_stats (integer)

        1.4. Exported Functions

              1.4.1. sl_send_reply(code, reason)
              1.4.2. sl_reply_error()

        1.5. Exported Statistics

              1.5.1. 1xx_replies
              1.5.2. 2xx_replies
              1.5.3. 3xx_replies
              1.5.4. 4xx_replies
              1.5.5. 5xx_replies
              1.5.6. 6xx_replies
              1.5.7. sent_replies
              1.5.8. sent_err_replies
              1.5.9. received_ACKs

   2. Contributors

        2.1. By Commit Statistics
        2.2. By Commit Activity

   3. Documentation

        3.1. Contributors

   List of Tables

   2.1. Top contributors by DevScore^(1), authored commits^(2) and
          lines added/removed^(3)

   2.2. Most recently active contributors^(1) to this module

   List of Examples

   1.1. enable_stats example
   1.2. sl_send_reply usage
   1.3. sl_reply_error usage

Chapter 1. Admin Guide

1.1. Overview

   The SL module allows OpenSIPS to act as a stateless UA server
   and generate replies to SIP requests without keeping state.
   That is beneficial in many scenarios, in which you wish not to
   burden server's memory and scale well.

   The SL module needs to filter ACKs sent after a local stateless
   reply to an INVITE was generated. To recognize such ACKs,
   OpenSIPS adds a special "signature" in to-tags. This signature
   is sought for in incoming ACKs, and if included, the ACKs are
   absorbed.

   To speed up the filtering process, the module uses a timeout
   mechanism. When a reply is sent, a timer is set. As time as the
   timeout didn't hit, the incoming ACK requests will be checked
   using TO tag value. Once the timer expires, all the ACK are let
   through - a long time passed till it sent a reply, so it does
   not expect any ACK that have to be blocked.

   The ACK filtering may fail in some rare cases. If you think
   these matter to you, better use stateful processing (tm module)
   for INVITE processing. Particularly, the problem happens when a
   UA sends an INVITE which already has a to-tag in it (e.g., a
   re-INVITE) and OpenSIPS want to reply to it. Than, it will keep
   the current to-tag, which will be mirrored in ACK. OpenSIPS
   will not see its signature and forward the ACK downstream.
   Caused harm is not bad--just a useless ACK is forwarded.

1.2. Dependencies

1.2.1. OpenSIPS Modules

   The following modules must be loaded before this module:
     * No dependencies on other OpenSIPS modules.

1.2.2. External Libraries or Applications

   The following libraries or applications must be installed
   before running OpenSIPS with this module loaded:
     * None.

1.3. Exported Parameters

1.3.1. enable_stats (integer)

   If the module should generate and export statistics to the core
   manager. A zero value means disabled.

   SL module provides statistics about how many replies were sent
   ( splitted per code classes) and how many local ACKs were
   filtered out.

   Default value is 1 (enabled).

   Example 1.1. enable_stats example
modparam("sl", "enable_stats", 0)

1.4. Exported Functions

1.4.1.  sl_send_reply(code, reason)

   For the current request, a reply is sent back having the given
   code and text reason. The reply is sent stateless, totally
   independent of the Transaction module and with no
   retransmission for the INVITE's replies. 'code' and 'reason'
   can contain pseudo-variables that are replaced at runtime.

   Meaning of the parameters is as follows:
     * code (int) - Return code.
     * reason (string) - Reason phrase.

   This function can be used from REQUEST_ROUTE, ERROR_ROUTE.

   Example 1.2. sl_send_reply usage
...
sl_send_reply(404, "Not found");
...
sl_send_reply($err.rcode, $err.rreason);
...

1.4.2.  sl_reply_error()

   Sends back an error reply describing the nature of the last
   internal error. Usually this function should be used after a
   script function that returned an error code.

   This function can be used from REQUEST_ROUTE.

   Example 1.3. sl_reply_error usage
...
sl_reply_error();
...

1.5. Exported Statistics

1.5.1. 1xx_replies

   The number of 1xx_replies.

1.5.2. 2xx_replies

   The number of 2xx_replies.

1.5.3. 3xx_replies

   The number of 3xx_replies.

1.5.4. 4xx_replies

   The number of 4xx_replies.

1.5.5. 5xx_replies

   The number of 5xx_replies.

1.5.6. 6xx_replies

   The number of 6xx_replies.

1.5.7. sent_replies

   The number of sent_replies.

1.5.8. sent_err_replies

   The number of sent_err_replies.

1.5.9. received_ACKs

   The number of received_ACKs.

Chapter 2. Contributors

2.1. By Commit Statistics

   Table 2.1. Top contributors by DevScore^(1), authored
   commits^(2) and lines added/removed^(3)
     Name DevScore Commits Lines ++ Lines --
   1. Bogdan-Andrei Iancu (@bogdan-iancu) 72 52 852 695
   2. Jiri Kuthan (@jiriatipteldotorg) 43 32 665 232
   3. Daniel-Constantin Mierla (@miconda) 23 16 295 172
   4. Andrei Pelinescu-Onciul 16 14 50 50
   5. Liviu Chircu (@liviuchircu) 12 9 28 60
   6. Jan Janak (@janakj) 12 8 355 21
   7. Henning Westerholt (@henningw) 7 5 12 12
   8. Vlad Patrascu (@rvlad-patrascu) 7 4 30 83
   9. Razvan Crainea (@razvancrainea) 4 2 9 10
   10. Elena-Ramona Modroiu 3 2 65 0

   All remaining contributors: Jeffrey Magder, Andreas Heise,
   Konstantin Bokarius, Anca Vamanu, Ionut Ionita
   (@ionutrazvanionita), Peter Lemenkov (@lemenkov), Edson Gellert
   Schubert.

   (1) DevScore = author_commits + author_lines_added /
   (project_lines_added / project_commits) + author_lines_deleted
   / (project_lines_deleted / project_commits)

   (2) including any documentation-related commits, excluding
   merge commits. Regarding imported patches/code, we do our best
   to count the work on behalf of the proper owner, as per the
   "fix_authors" and "mod_renames" arrays in
   opensips/doc/build-contrib.sh. If you identify any
   patches/commits which do not get properly attributed to you,
   please submit a pull request which extends "fix_authors" and/or
   "mod_renames".

   (3) ignoring whitespace edits, renamed files and auto-generated
   files

2.2. By Commit Activity

   Table 2.2. Most recently active contributors^(1) to this module
                      Name                   Commit Activity
   1.  Vlad Patrascu (@rvlad-patrascu)     May 2017 - Apr 2019
   2.  Bogdan-Andrei Iancu (@bogdan-iancu) Feb 2002 - Apr 2019
   3.  Peter Lemenkov (@lemenkov)          Jun 2018 - Jun 2018
   4.  Liviu Chircu (@liviuchircu)         Mar 2014 - Jun 2018
   5.  Razvan Crainea (@razvancrainea)     Feb 2012 - Aug 2015
   6.  Ionut Ionita (@ionutrazvanionita)   Nov 2014 - Nov 2014
   7.  Anca Vamanu                         Nov 2010 - Nov 2010
   8.  Henning Westerholt (@henningw)      Aug 2007 - Jun 2008
   9.  Daniel-Constantin Mierla (@miconda) Apr 2006 - Mar 2008
   10. Konstantin Bokarius                 Mar 2008 - Mar 2008

   All remaining contributors: Edson Gellert Schubert, Andreas
   Heise, Elena-Ramona Modroiu, Jeffrey Magder, Jiri Kuthan
   (@jiriatipteldotorg), Jan Janak (@janakj), Andrei
   Pelinescu-Onciul.

   (1) including any documentation-related commits, excluding
   merge commits

Chapter 3. Documentation

3.1. Contributors

   Last edited by: Vlad Patrascu (@rvlad-patrascu), Peter Lemenkov
   (@lemenkov), Liviu Chircu (@liviuchircu), Bogdan-Andrei Iancu
   (@bogdan-iancu), Razvan Crainea (@razvancrainea), Henning
   Westerholt (@henningw), Daniel-Constantin Mierla (@miconda),
   Konstantin Bokarius, Edson Gellert Schubert, Elena-Ramona
   Modroiu, Jan Janak (@janakj).

   Documentation Copyrights:

   Copyright © 2003 FhG FOKUS
