/*
 * Decompiled with CFR 0.152.
 */
package com.swoval.files;

import com.swoval.files.CachedDirectory;
import com.swoval.files.FileCacheDirectoryTree;
import com.swoval.files.FileTreeDataViews;
import com.swoval.files.PathWatcher;
import com.swoval.files.PathWatchers;
import com.swoval.files.SymlinkWatcher;
import com.swoval.functional.Filters;
import java.io.IOException;
import java.nio.file.Path;

class FileCachePathWatcher<T>
implements AutoCloseable {
    private final SymlinkWatcher symlinkWatcher;
    private final PathWatcher<PathWatchers.Event> pathWatcher;
    private final FileCacheDirectoryTree<T> tree;

    FileCachePathWatcher(FileCacheDirectoryTree<T> fileCacheDirectoryTree, PathWatcher<PathWatchers.Event> pathWatcher) {
        this.symlinkWatcher = fileCacheDirectoryTree.symlinkWatcher;
        this.pathWatcher = pathWatcher;
        this.tree = fileCacheDirectoryTree;
    }

    boolean register(Path path, int n) throws IOException {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        CachedDirectory<T> cachedDirectory = this.tree.register(path2, n, this.pathWatcher);
        if (cachedDirectory != null && this.symlinkWatcher != null) {
            if (cachedDirectory.getEntry().getTypedPath().isSymbolicLink()) {
                this.symlinkWatcher.addSymlink(path2, n);
            }
            for (FileTreeDataViews.Entry<T> entry : cachedDirectory.listEntries(cachedDirectory.getMaxDepth(), Filters.AllPass)) {
                if (!entry.getTypedPath().isSymbolicLink()) continue;
                int n2 = path2.relativize(entry.getTypedPath().getPath()).getNameCount();
                this.symlinkWatcher.addSymlink(entry.getTypedPath().getPath(), n == Integer.MAX_VALUE ? n : n - n2);
            }
        }
        return cachedDirectory != null;
    }

    void unregister(Path path) {
        Path path2 = path.isAbsolute() ? path : path.toAbsolutePath();
        this.tree.unregister(path2);
        this.pathWatcher.unregister(path2);
    }

    @Override
    public void close() {
        this.pathWatcher.close();
        if (this.symlinkWatcher != null) {
            this.symlinkWatcher.close();
        }
    }
}

