/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import java.io.IOException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import org.languagetool.JLanguageTool;
import org.languagetool.TestTools;
import org.languagetool.rules.PunctuationMarkAtParagraphEnd;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public class PunctuationMarkAtParagraphEndTest {
    @Test
    public void testRule() throws IOException {
        JLanguageTool lt = new JLanguageTool(TestTools.getDemoLanguage());
        this.setUpRule(lt);
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test headline").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence. This is a link: http://example.com").size());
        Assert.assertEquals((long)1L, (long)lt.check("This is a test sentence. It can be found at http://example.com/foobar").size());
        Assert.assertEquals((long)1L, (long)lt.check("This is a test sentence. And this is a second test sentence").size());
        Assert.assertEquals((long)1L, (long)lt.check("\"This is a test sentence. And this is a second test sentence").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence. And this is a second test sentence.").size());
        Assert.assertEquals((long)0L, (long)lt.check("B. v. \u2013 Beschluss vom").size());
        Assert.assertEquals((long)1L, (long)lt.check("This is a test sentence.\nAnd this is a second test sentence. Here is a quotation mark missing").size());
        Assert.assertEquals((long)0L, (long)lt.check("This is a test sentence.\nAnd this is a second test sentence. Here is a quotation mark missing.").size());
        List matches = lt.check("This is a sentence. Another one: https://languagetool.org/foo\n\nAnother sentence\n");
        Assert.assertEquals((long)1L, (long)matches.size());
        Assert.assertEquals((long)71L, (long)((RuleMatch)matches.get(0)).getFromPos());
        Assert.assertEquals((long)79L, (long)((RuleMatch)matches.get(0)).getToPos());
    }

    private void setUpRule(JLanguageTool lt) {
        for (Rule rule : lt.getAllRules()) {
            lt.disableRule(rule.getId());
        }
        PunctuationMarkAtParagraphEnd rule = new PunctuationMarkAtParagraphEnd(TestTools.getEnglishMessages(), TestTools.getDemoLanguage());
        lt.addRule((Rule)rule);
    }
}

