/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules.spelling.morfologik;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import morfologik.speller.Speller;
import morfologik.stemming.Dictionary;
import org.jetbrains.annotations.NotNull;
import org.languagetool.JLanguageTool;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.tools.StringTools;

public class MorfologikSpeller {
    private static final LoadingCache<String, Dictionary> dictCache = CacheBuilder.newBuilder().expireAfterWrite(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, Dictionary>(){

        public Dictionary load(@NotNull String fileInClassPath) throws IOException {
            ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
            if (dataBroker.resourceExists(fileInClassPath)) {
                return Dictionary.read((URL)dataBroker.getFromResourceDirAsUrl(fileInClassPath));
            }
            return Dictionary.read((Path)Paths.get(fileInClassPath, new String[0]));
        }
    });
    private final Dictionary dictionary;
    private final Speller speller;
    private final int maxEditDistance;

    public MorfologikSpeller(String fileInClassPath, int maxEditDistance) {
        this((Dictionary)dictCache.getUnchecked((Object)fileInClassPath), maxEditDistance);
    }

    public MorfologikSpeller(String fileInClassPath) throws IOException {
        this(fileInClassPath, 1);
    }

    MorfologikSpeller(Dictionary dictionary, int maxEditDistance) {
        if (maxEditDistance <= 0) {
            throw new RuntimeException("maxEditDistance must be > 0: " + maxEditDistance);
        }
        this.dictionary = dictionary;
        this.maxEditDistance = maxEditDistance;
        this.speller = new Speller(dictionary, maxEditDistance);
    }

    public boolean isMisspelled(String word) {
        return word.length() > 0 && !"LanguageTool".equals(word) && !"LanguageTooler".equals(word) && this.speller.isMisspelled(word);
    }

    public List<String> getSuggestions(String word) {
        ArrayList<String> suggestions = new ArrayList<String>();
        Speller speller = new Speller(this.dictionary, this.maxEditDistance);
        suggestions.addAll(speller.findReplacements(word));
        suggestions.addAll(speller.replaceRunOnWords(word));
        if (this.dictionary.metadata.isConvertingCase() && StringTools.startsWithUppercase(word)) {
            for (int i = 0; i < suggestions.size(); ++i) {
                int auxIndex;
                String uppercaseFirst = StringTools.uppercaseFirstChar((String)suggestions.get(i));
                if (uppercaseFirst.equals(word) || StringTools.isMixedCase((String)suggestions.get(i))) {
                    uppercaseFirst = (String)suggestions.get(i);
                }
                if ((auxIndex = suggestions.indexOf(uppercaseFirst)) > i) {
                    suggestions.remove(auxIndex);
                }
                if (auxIndex > -1 && auxIndex < i) {
                    suggestions.remove(i);
                    --i;
                    continue;
                }
                suggestions.set(i, uppercaseFirst);
            }
        }
        return suggestions;
    }

    public boolean convertsCase() {
        return this.speller.convertsCase();
    }

    public String toString() {
        return "dist=" + this.maxEditDistance;
    }

    public int getFrequency(String word) {
        String w = word;
        int freq = this.speller.getFrequency((CharSequence)w);
        if (freq == 0 && word != word.toLowerCase()) {
            w = word.toLowerCase();
            freq = this.speller.getFrequency((CharSequence)w);
        }
        return freq;
    }
}

