/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.resources;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.util.HashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import net.sf.freecol.common.resources.Resource;

public class ImageResource
extends Resource
implements Resource.Preloadable,
Resource.Cleanable {
    private static final Logger logger = Logger.getLogger(ImageResource.class.getName());
    private HashMap<Dimension, BufferedImage> scaledImages = new HashMap();
    private HashMap<Dimension, BufferedImage> grayscaleImages = new HashMap();
    private volatile BufferedImage image = null;
    private final Object loadingLock = new Object();

    public ImageResource(URI resourceLocator) {
        super(resourceLocator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void preload() {
        Object object = this.loadingLock;
        synchronized (object) {
            if (this.image == null) {
                try {
                    URL url = this.getResourceLocator().toURL();
                    this.image = ImageIO.read(url);
                    if (this.image == null) {
                        logger.log(Level.WARNING, "Failed to load image from: " + this.getResourceLocator());
                    }
                }
                catch (IOException e) {
                    logger.log(Level.WARNING, "Failed to load image from: " + this.getResourceLocator(), e);
                }
            }
        }
    }

    @Override
    public void clean() {
        this.scaledImages = new HashMap();
        this.grayscaleImages = new HashMap();
    }

    public BufferedImage getImage() {
        if (this.image == null) {
            logger.finest("Preload not ready for " + this.getResourceLocator());
            this.preload();
        }
        return this.image;
    }

    public BufferedImage getImage(float scale) {
        BufferedImage im = this.getImage();
        if (scale == 1.0f || im == null) {
            return im;
        }
        return this.getImage(new Dimension(Math.round((float)im.getWidth() * scale), Math.round((float)im.getHeight() * scale)));
    }

    public BufferedImage getImage(Dimension d) {
        Graphics2D g;
        BufferedImage im = this.getImage();
        if (im == null) {
            return null;
        }
        int wNew = d.width;
        int hNew = d.height;
        if (wNew < 0 && hNew < 0) {
            return im;
        }
        int w = im.getWidth();
        int h = im.getHeight();
        if (wNew < 0 || hNew >= 0 && wNew * h > w * hNew) {
            wNew = (2 * w * hNew + (h + 1)) / (2 * h);
        } else if (hNew < 0 || wNew * h < w * hNew) {
            hNew = (2 * h * wNew + (w + 1)) / (2 * w);
        }
        if (wNew == w && hNew == h) {
            return im;
        }
        BufferedImage cached = this.scaledImages.get(d);
        if (cached != null) {
            return cached;
        }
        while (wNew * 2 <= w && hNew * 2 <= h) {
            w = (w + 1) / 2;
            h = (h + 1) / 2;
            BufferedImage halved = new BufferedImage(w, h, 2);
            g = halved.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            g.drawImage(im, 0, 0, w, h, null);
            g.dispose();
            im = halved;
        }
        if (wNew != w || hNew != h) {
            BufferedImage scaled = new BufferedImage(wNew, hNew, 2);
            g = scaled.createGraphics();
            g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
            g.drawImage(im, 0, 0, wNew, hNew, null);
            g.dispose();
            im = scaled;
        }
        this.scaledImages.put(d, im);
        return im;
    }

    public BufferedImage getGrayscaleImage(Dimension d) {
        BufferedImage cached = this.grayscaleImages.get(d);
        if (cached != null) {
            return cached;
        }
        BufferedImage im = this.getImage(d);
        if (im == null) {
            return null;
        }
        int width = im.getWidth();
        int height = im.getHeight();
        BufferedImage srcImage = new BufferedImage(width, height, 2);
        Graphics2D g = srcImage.createGraphics();
        g.drawImage((Image)im, 0, 0, null);
        g.dispose();
        ColorConvertOp filter = new ColorConvertOp(ColorSpace.getInstance(1003), null);
        BufferedImage grayscaleImage = filter.filter(srcImage, null);
        this.grayscaleImages.put(d, grayscaleImage);
        return grayscaleImage;
    }

    public BufferedImage getGrayscaleImage(float scale) {
        BufferedImage im = this.getImage();
        if (im == null) {
            return null;
        }
        return this.getGrayscaleImage(new Dimension(Math.round((float)im.getWidth() * scale), Math.round((float)im.getHeight() * scale)));
    }

    public int getCount() {
        return this.grayscaleImages.size() + this.scaledImages.size();
    }
}

