/*
 * Decompiled with CFR 0.152.
 */
package plugins.map;

import freemind.modes.mindmapmode.MindMapController;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JDialog;
import javax.swing.Timer;
import org.openstreetmap.gui.jmapviewer.Coordinate;
import org.openstreetmap.gui.jmapviewer.JMapViewer;
import org.openstreetmap.gui.jmapviewer.TileController;
import org.openstreetmap.gui.jmapviewer.interfaces.TileCache;
import plugins.map.FreeMindMapController;
import plugins.map.MapDialog;

final class JCursorMapViewer
extends JMapViewer {
    boolean mShowCursor;
    boolean mUseCursor;
    Coordinate mCursorPosition;
    Stroke mStroke = new BasicStroke(2.0f);
    Stroke mRectangularStroke = new BasicStroke(1.0f, 2, 0, 10.0f, new float[]{10.0f, 10.0f}, 0.0f);
    private FreeMindMapController mFreeMindMapController;
    private final MapDialog mMapHook;
    private boolean mHideFoldedNodes = true;
    private Coordinate mRectangularStart;
    private Coordinate mRectangularEnd;
    private boolean mDrawRectangular = false;

    public JCursorMapViewer(MindMapController pMindMapController, JDialog pMapDialog, TileCache pTileCache, MapDialog pMapHook) {
        super(pTileCache, 4);
        this.mMapHook = pMapHook;
        this.mFreeMindMapController = new FreeMindMapController(this, pMindMapController, pMapDialog, pMapHook);
        AbstractAction updateCursorAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                JCursorMapViewer.this.mShowCursor = !JCursorMapViewer.this.mShowCursor;
                JCursorMapViewer.this.repaint();
            }
        };
        new Timer(1000, updateCursorAction).start();
        this.setFocusable(false);
    }

    public FreeMindMapController getFreeMindMapController() {
        return this.mFreeMindMapController;
    }

    public boolean isUseCursor() {
        return this.mUseCursor;
    }

    public void setUseCursor(boolean pUseCursor) {
        this.mUseCursor = pUseCursor;
        this.repaint();
    }

    public Coordinate getCursorPosition() {
        return this.mCursorPosition;
    }

    public void setCursorPosition(Coordinate pCursorPosition) {
        this.mCursorPosition = pCursorPosition;
        this.repaint();
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g instanceof Graphics2D) {
            Point position;
            Graphics2D g2d = (Graphics2D)g;
            Stroke oldStroke = g2d.getStroke();
            Color oldColor = g2d.getColor();
            if (this.mUseCursor && this.mShowCursor && (position = this.getMapPosition(this.mCursorPosition)) != null) {
                int size_h = 15;
                g2d.setStroke(this.mStroke);
                g2d.setColor(Color.RED);
                g2d.drawLine(position.x - size_h, position.y, position.x + size_h, position.y);
                g2d.drawLine(position.x, position.y - size_h, position.x, position.y + size_h);
            }
            if (this.mDrawRectangular) {
                g2d.setColor(Color.BLACK);
                g2d.setStroke(this.mRectangularStroke);
                Rectangle r = this.getRectangle(this.mRectangularStart, this.mRectangularEnd);
                if (r != null) {
                    g2d.drawRect(r.x, r.y, r.width, r.height);
                }
            }
            g2d.setColor(oldColor);
            g2d.setStroke(oldStroke);
        }
    }

    public Rectangle getRectangle(Coordinate rectangularStart, Coordinate rectangularEnd) {
        Point positionStart = this.getMapPosition(rectangularStart);
        Point positionEnd = this.getMapPosition(rectangularEnd);
        Rectangle r = null;
        if (positionStart != null && positionEnd != null) {
            int x = Math.min(positionStart.x, positionEnd.x);
            int y = Math.min(positionStart.y, positionEnd.y);
            int width = Math.abs(positionStart.x - positionEnd.x);
            int height = Math.abs(positionStart.y - positionEnd.y);
            r = new Rectangle(x, y, width, height);
        }
        return r;
    }

    public TileController getTileController() {
        return this.tileController;
    }

    protected void initializeZoomSlider() {
        super.initializeZoomSlider();
        this.zoomSlider.setFocusable(false);
        this.zoomInButton.setFocusable(false);
        this.zoomOutButton.setFocusable(false);
    }

    public void setHideFoldedNodes(boolean pHideFoldedNodes) {
        this.mHideFoldedNodes = pHideFoldedNodes;
        this.repaint();
    }

    public boolean isHideFoldedNodes() {
        return this.mHideFoldedNodes;
    }

    public void setRectangular(Coordinate pRectangularStart, Coordinate pRectangularEnd) {
        this.mRectangularStart = pRectangularStart;
        this.mRectangularEnd = pRectangularEnd;
    }

    public boolean isDrawRectangular() {
        return this.mDrawRectangular;
    }

    public void setDrawRectangular(boolean pDrawRectangular) {
        this.mDrawRectangular = pDrawRectangular;
    }
}

