/*
 * Decompiled with CFR 0.152.
 */
package freemind.modes;

import freemind.main.FreeMindMain;
import freemind.main.Tools;
import freemind.main.XMLElement;
import freemind.modes.ArrowLinkTarget;
import freemind.modes.LinkAdapter;
import freemind.modes.MindMapArrowLink;
import freemind.modes.MindMapLinkRegistry;
import freemind.modes.MindMapNode;
import java.awt.Point;

public abstract class ArrowLinkAdapter
extends LinkAdapter
implements MindMapArrowLink {
    protected Point startInclination;
    protected Point endInclination;
    protected String startArrow = "None";
    protected String endArrow = "Default";
    protected boolean showControlPointsFlag;

    public ArrowLinkAdapter(MindMapNode source, MindMapNode target, FreeMindMain frame) {
        super(source, target, frame);
    }

    @Override
    public Point getStartInclination() {
        if (this.startInclination == null) {
            return null;
        }
        return new Point(this.startInclination);
    }

    @Override
    public Point getEndInclination() {
        if (this.endInclination == null) {
            return null;
        }
        return new Point(this.endInclination);
    }

    @Override
    public String getStartArrow() {
        return this.startArrow;
    }

    @Override
    public String getEndArrow() {
        return this.endArrow;
    }

    @Override
    public void setStartInclination(Point startInclination) {
        this.startInclination = startInclination;
    }

    @Override
    public void setEndInclination(Point endInclination) {
        this.endInclination = endInclination;
    }

    public void setStartArrow(String startArrow) {
        if (startArrow == null || startArrow.toUpperCase().equals("NONE")) {
            this.startArrow = "None";
            return;
        }
        if (startArrow.toUpperCase().equals("DEFAULT")) {
            this.startArrow = "Default";
            return;
        }
        System.err.println("Cannot set the start arrow type to " + startArrow);
    }

    public void setEndArrow(String endArrow) {
        if (endArrow == null || endArrow.toUpperCase().equals("NONE")) {
            this.endArrow = "None";
            return;
        }
        if (endArrow.toUpperCase().equals("DEFAULT")) {
            this.endArrow = "Default";
            return;
        }
        System.err.println("Cannot set the end arrow type to " + endArrow);
    }

    @Override
    public Object clone() {
        ArrowLinkAdapter arrowLink = (ArrowLinkAdapter)super.clone();
        arrowLink.startInclination = this.startInclination == null ? null : new Point(this.startInclination.x, this.startInclination.y);
        arrowLink.endInclination = this.endInclination == null ? null : new Point(this.endInclination.x, this.endInclination.y);
        arrowLink.startArrow = this.startArrow == null ? null : new String(this.startArrow);
        arrowLink.endArrow = this.endArrow == null ? null : new String(this.endArrow);
        return arrowLink;
    }

    @Override
    public void showControlPoints(boolean bShowControlPointsFlag) {
        this.showControlPointsFlag = bShowControlPointsFlag;
    }

    @Override
    public boolean getShowControlPointsFlag() {
        return this.showControlPointsFlag;
    }

    @Override
    public XMLElement save() {
        XMLElement arrowLink = new XMLElement();
        arrowLink.setName("arrowlink");
        if (this.style != null) {
            arrowLink.setAttribute("STYLE", this.style);
        }
        if (this.getUniqueId() != null) {
            arrowLink.setAttribute("ID", this.getUniqueId());
        }
        if (this.color != null) {
            arrowLink.setAttribute("COLOR", Tools.colorToXml(this.color));
        }
        if (this.getDestinationLabel() != null) {
            arrowLink.setAttribute("DESTINATION", this.getDestinationLabel());
        }
        if (this.getReferenceText() != null) {
            arrowLink.setAttribute("REFERENCETEXT", this.getReferenceText());
        }
        if (this.getStartInclination() != null) {
            arrowLink.setAttribute("STARTINCLINATION", Tools.PointToXml(this.getStartInclination()));
        }
        if (this.getEndInclination() != null) {
            arrowLink.setAttribute("ENDINCLINATION", Tools.PointToXml(this.getEndInclination()));
        }
        if (this.getStartArrow() != null) {
            arrowLink.setAttribute("STARTARROW", this.getStartArrow());
        }
        if (this.getEndArrow() != null) {
            arrowLink.setAttribute("ENDARROW", this.getEndArrow());
        }
        return arrowLink;
    }

    public ArrowLinkTarget createArrowLinkTarget(MindMapLinkRegistry pRegistry) {
        ArrowLinkTarget linkTarget = new ArrowLinkTarget(this.source, this.target, this.frame);
        linkTarget.setSourceLabel(pRegistry.getLabel(this.source));
        this.copy(linkTarget);
        return linkTarget;
    }

    protected void copy(ArrowLinkAdapter linkTarget) {
        linkTarget.setUniqueId(this.getUniqueId());
        linkTarget.setColor(this.getColor());
        linkTarget.setDestinationLabel(this.getDestinationLabel());
        linkTarget.setEndArrow(this.getEndArrow());
        linkTarget.setEndInclination(this.getEndInclination());
        linkTarget.setReferenceText(this.getReferenceText());
        linkTarget.setStartArrow(this.getStartArrow());
        linkTarget.setStartInclination(this.getStartInclination());
        linkTarget.setStyle(this.getStyle());
        linkTarget.setTarget(this.getTarget());
        linkTarget.setWidth(this.getWidth());
        linkTarget.setSource(this.getSource());
    }
}

