/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.fingerprint.impl;

import java.util.List;
import org.gradle.api.NonNullApi;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.cache.StringInterner;
import org.gradle.api.internal.file.FileCollectionInternal;
import org.gradle.internal.fingerprint.CurrentFileCollectionFingerprint;
import org.gradle.internal.fingerprint.FileCollectionFingerprinter;
import org.gradle.internal.fingerprint.FingerprintingStrategy;
import org.gradle.internal.fingerprint.impl.DefaultCurrentFileCollectionFingerprint;
import org.gradle.internal.snapshot.FileSystemSnapshot;
import org.gradle.internal.snapshot.FileSystemSnapshotter;

@NonNullApi
public abstract class AbstractFileCollectionFingerprinter
implements FileCollectionFingerprinter {
    private final StringInterner stringInterner;
    private final FileSystemSnapshotter fileSystemSnapshotter;

    public AbstractFileCollectionFingerprinter(StringInterner stringInterner, FileSystemSnapshotter fileSystemSnapshotter) {
        this.stringInterner = stringInterner;
        this.fileSystemSnapshotter = fileSystemSnapshotter;
    }

    public CurrentFileCollectionFingerprint fingerprint(FileCollection input, FingerprintingStrategy strategy) {
        FileCollectionInternal fileCollection = (FileCollectionInternal)input;
        List<FileSystemSnapshot> roots = this.fileSystemSnapshotter.snapshot(fileCollection);
        return DefaultCurrentFileCollectionFingerprint.from(roots, strategy);
    }

    protected StringInterner getStringInterner() {
        return this.stringInterner;
    }
}

