/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.osgi.core;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.List;
import java.util.jar.Attributes;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.apache.ivy.osgi.core.BundleCapability;
import org.apache.ivy.osgi.core.BundleInfo;
import org.apache.ivy.osgi.core.BundleRequirement;
import org.apache.ivy.osgi.core.ExportPackage;
import org.apache.ivy.osgi.core.ManifestHeaderElement;
import org.apache.ivy.osgi.core.ManifestHeaderValue;
import org.apache.ivy.osgi.util.Version;
import org.apache.ivy.osgi.util.VersionRange;

public class ManifestParser {
    private static final String EXPORT_PACKAGE = "Export-Package";
    private static final String IMPORT_PACKAGE = "Import-Package";
    private static final String EXPORT_SERVICE = "Export-Service";
    private static final String IMPORT_SERVICE = "Import-Service";
    private static final String REQUIRE_BUNDLE = "Require-Bundle";
    private static final String BUNDLE_VERSION = "Bundle-Version";
    private static final String BUNDLE_NAME = "Bundle-Name";
    private static final String BUNDLE_DESCRIPTION = "Bundle-Description";
    private static final String BUNDLE_SYMBOLIC_NAME = "Bundle-SymbolicName";
    private static final String BUNDLE_MANIFEST_VERSION = "Bundle-ManifestVersion";
    private static final String BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT = "Bundle-RequiredExecutionEnvironment";
    private static final String BUNDLE_CLASSPATH = "Bundle-ClassPath";
    private static final String ECLIPSE_SOURCE_BUNDLE = "Eclipse-SourceBundle";
    private static final String ATTR_RESOLUTION = "resolution";
    private static final String ATTR_VERSION = "version";
    private static final String ATTR_BUNDLE_VERSION = "bundle-version";
    private static final String ATTR_USE = "use";

    public static BundleInfo parseJarManifest(InputStream jarStream) throws IOException, ParseException {
        JarInputStream jis = new JarInputStream(jarStream);
        Manifest manifest = jis.getManifest();
        if (manifest == null) {
            return null;
        }
        BundleInfo bundleInfo = ManifestParser.parseManifest(manifest);
        return bundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BundleInfo parseManifest(File manifestFile) throws IOException, ParseException {
        FileInputStream fis = new FileInputStream(manifestFile);
        try {
            BundleInfo parseManifest;
            BundleInfo bundleInfo = parseManifest = ManifestParser.parseManifest(fis);
            return bundleInfo;
        }
        finally {
            try {
                fis.close();
            }
            catch (IOException iOException) {}
        }
    }

    public static BundleInfo parseManifest(String manifest) throws IOException, ParseException {
        ByteArrayInputStream bais = new ByteArrayInputStream(manifest.getBytes("UTF-8"));
        BundleInfo parseManifest = ManifestParser.parseManifest(bais);
        bais.close();
        return parseManifest;
    }

    public static BundleInfo parseManifest(InputStream manifestStream) throws IOException, ParseException {
        BundleInfo parseManifest = ManifestParser.parseManifest(new Manifest(manifestStream));
        return parseManifest;
    }

    public static BundleInfo parseManifest(Manifest manifest) throws ParseException {
        String bundleClasspath;
        Version version;
        Attributes mainAttributes = manifest.getMainAttributes();
        String symbolicName = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_SYMBOLIC_NAME)).getSingleValue();
        if (symbolicName == null) {
            throw new ParseException("No Bundle-SymbolicName in the manifest", 0);
        }
        String description = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        if (description == null) {
            description = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_DESCRIPTION)).getSingleValue();
        }
        String vBundle = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_VERSION)).getSingleValue();
        try {
            version = ManifestParser.versionOf(vBundle);
        }
        catch (NumberFormatException e) {
            throw new ParseException("The Bundle-Version has an incorrect version: " + vBundle + " (" + e.getMessage() + ")", 0);
        }
        BundleInfo bundleInfo = new BundleInfo(symbolicName, version);
        bundleInfo.setDescription(description);
        List<String> environments = new ManifestHeaderValue(mainAttributes.getValue(BUNDLE_REQUIRED_EXECUTION_ENVIRONMENT)).getValues();
        bundleInfo.setExecutionEnvironments(environments);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, REQUIRE_BUNDLE, "bundle", ATTR_BUNDLE_VERSION);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, IMPORT_PACKAGE, "package", ATTR_VERSION);
        ManifestParser.parseRequirement(bundleInfo, mainAttributes, IMPORT_SERVICE, "service", ATTR_VERSION);
        ManifestHeaderValue exportElements = new ManifestHeaderValue(mainAttributes.getValue(EXPORT_PACKAGE));
        for (ManifestHeaderElement exportElement : exportElements.getElements()) {
            String vExport = exportElement.getAttributes().get(ATTR_VERSION);
            Version v = null;
            try {
                v = ManifestParser.versionOf(vExport);
            }
            catch (NumberFormatException e) {
                throw new ParseException("The Export-Package has an incorrect version: " + vExport + " (" + e.getMessage() + ")", 0);
            }
            for (String name : exportElement.getValues()) {
                ExportPackage export = new ExportPackage(name, v);
                String uses = exportElement.getDirectives().get(ATTR_USE);
                if (uses != null) {
                    String[] split = uses.trim().split(",");
                    for (int i = 0; i < split.length; ++i) {
                        export.addUse(split[i].trim());
                    }
                }
                bundleInfo.addCapability(export);
            }
        }
        ManifestParser.parseCapability(bundleInfo, mainAttributes, EXPORT_SERVICE, "service");
        String eclipseSourceBundle = mainAttributes.getValue(ECLIPSE_SOURCE_BUNDLE);
        if (eclipseSourceBundle != null) {
            bundleInfo.setSource(true);
            ManifestHeaderValue eclipseSourceBundleValue = new ManifestHeaderValue(eclipseSourceBundle);
            ManifestHeaderElement element = eclipseSourceBundleValue.getElements().iterator().next();
            String symbolicNameTarget = element.getValues().iterator().next();
            bundleInfo.setSymbolicNameTarget(symbolicNameTarget);
            String v = element.getAttributes().get(ATTR_VERSION);
            if (v != null) {
                bundleInfo.setVersionTarget(new Version(v));
            }
        }
        if ((bundleClasspath = mainAttributes.getValue(BUNDLE_CLASSPATH)) != null) {
            ManifestHeaderValue bundleClasspathValue = new ManifestHeaderValue(bundleClasspath);
            bundleInfo.setClasspath(bundleClasspathValue.getValues());
            bundleInfo.setHasInnerClasspath(true);
        }
        return bundleInfo;
    }

    private static void parseRequirement(BundleInfo bundleInfo, Attributes mainAttributes, String headerName, String type, String versionAttr) throws ParseException {
        ManifestHeaderValue elements = new ManifestHeaderValue(mainAttributes.getValue(headerName));
        for (ManifestHeaderElement element : elements.getElements()) {
            String resolution = element.getDirectives().get(ATTR_RESOLUTION);
            String attVersion = element.getAttributes().get(versionAttr);
            VersionRange version = null;
            try {
                version = ManifestParser.versionRangeOf(attVersion);
            }
            catch (ParseException e) {
                throw new ParseException("The " + headerName + " has an incorrect version: " + attVersion + " (" + e.getMessage() + ")", 0);
            }
            for (String name : element.getValues()) {
                bundleInfo.addRequirement(new BundleRequirement(type, name, version, resolution));
            }
        }
    }

    private static void parseCapability(BundleInfo bundleInfo, Attributes mainAttributes, String headerName, String type) throws ParseException {
        ManifestHeaderValue elements = new ManifestHeaderValue(mainAttributes.getValue(headerName));
        for (ManifestHeaderElement element : elements.getElements()) {
            String attVersion = element.getAttributes().get(ATTR_VERSION);
            Version version = null;
            try {
                version = ManifestParser.versionOf(attVersion);
            }
            catch (NumberFormatException e) {
                throw new ParseException("The " + headerName + " has an incorrect version: " + attVersion + " (" + e.getMessage() + ")", 0);
            }
            for (String name : element.getValues()) {
                BundleCapability export = new BundleCapability(type, name, version);
                bundleInfo.addCapability(export);
            }
        }
    }

    private static VersionRange versionRangeOf(String v) throws ParseException {
        if (v == null) {
            return null;
        }
        return new VersionRange(v);
    }

    private static Version versionOf(String v) throws ParseException {
        if (v == null) {
            return null;
        }
        return new Version(v);
    }

    public static String formatLines(String manifest) {
        StringBuffer buffer = new StringBuffer(manifest.length());
        String[] lines = manifest.split("\n");
        for (int i = 0; i < lines.length; ++i) {
            if (lines[i].length() <= 72) {
                buffer.append(lines[i]);
                buffer.append('\n');
                continue;
            }
            buffer.append(lines[i].substring(0, 72));
            buffer.append("\n ");
            int n = 72;
            while (n <= lines[i].length() - 1) {
                int end = n + 71;
                if (end > lines[i].length()) {
                    end = lines[i].length();
                }
                buffer.append(lines[i].substring(n, end));
                buffer.append('\n');
                if (end != lines[i].length()) {
                    buffer.append(' ');
                }
                n = end;
            }
        }
        return buffer.toString();
    }
}

