/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.Objects;
import java.util.ResourceBundle;
import java.util.regex.Pattern;
import org.jetbrains.annotations.Nullable;
import org.languagetool.GlobalConfig;
import org.languagetool.JLanguageTool;
import org.languagetool.LanguageMaintainedState;
import org.languagetool.Languages;
import org.languagetool.UserConfig;
import org.languagetool.chunking.Chunker;
import org.languagetool.databroker.ResourceDataBroker;
import org.languagetool.language.Contributor;
import org.languagetool.languagemodel.LanguageModel;
import org.languagetool.languagemodel.LuceneLanguageModel;
import org.languagetool.rules.Rule;
import org.languagetool.rules.neuralnetwork.Word2VecModel;
import org.languagetool.rules.patterns.AbstractPatternRule;
import org.languagetool.rules.patterns.PatternRuleLoader;
import org.languagetool.rules.patterns.Unifier;
import org.languagetool.rules.patterns.UnifierConfiguration;
import org.languagetool.synthesis.Synthesizer;
import org.languagetool.tagging.Tagger;
import org.languagetool.tagging.disambiguation.Disambiguator;
import org.languagetool.tagging.disambiguation.xx.DemoDisambiguator;
import org.languagetool.tagging.xx.DemoTagger;
import org.languagetool.tokenizers.SentenceTokenizer;
import org.languagetool.tokenizers.SimpleSentenceTokenizer;
import org.languagetool.tokenizers.Tokenizer;
import org.languagetool.tokenizers.WordTokenizer;

public abstract class Language {
    private static final Disambiguator DEMO_DISAMBIGUATOR = new DemoDisambiguator();
    private static final Tagger DEMO_TAGGER = new DemoTagger();
    private static final SentenceTokenizer SENTENCE_TOKENIZER = new SimpleSentenceTokenizer();
    private static final WordTokenizer WORD_TOKENIZER = new WordTokenizer();
    private final UnifierConfiguration unifierConfig = new UnifierConfiguration();
    private final UnifierConfiguration disambiguationUnifierConfig = new UnifierConfiguration();
    private final Pattern ignoredCharactersRegex = Pattern.compile("[\u00ad]");
    private List<AbstractPatternRule> patternRules;
    private boolean noLmWarningPrinted;

    public abstract String getShortCode();

    public abstract String getName();

    public abstract String[] getCountries();

    @Nullable
    public abstract Contributor[] getMaintainers();

    public abstract List<Rule> getRelevantRules(ResourceBundle var1, UserConfig var2, Language var3, List<Language> var4) throws IOException;

    public String getCommonWordsPath() {
        return this.getShortCode() + "/common_words.txt";
    }

    @Nullable
    public String getVariant() {
        return null;
    }

    public List<String> getDefaultEnabledRulesForVariant() {
        return Collections.emptyList();
    }

    public List<String> getDefaultDisabledRulesForVariant() {
        return Collections.emptyList();
    }

    @Nullable
    public LanguageModel getLanguageModel(File indexDir) throws IOException {
        return null;
    }

    protected LanguageModel initLanguageModel(File indexDir, LanguageModel languageModel) {
        if (languageModel == null) {
            File topIndexDir = new File(indexDir, this.getShortCode());
            if (topIndexDir.exists()) {
                languageModel = new LuceneLanguageModel(topIndexDir);
            } else if (!this.noLmWarningPrinted) {
                System.err.println("WARN: ngram index dir " + topIndexDir + " not found for " + this.getName());
                this.noLmWarningPrinted = true;
            }
        }
        return languageModel;
    }

    public List<Rule> getRelevantLanguageModelRules(ResourceBundle messages, LanguageModel languageModel) throws IOException {
        return Collections.emptyList();
    }

    public List<Rule> getRelevantLanguageModelCapableRules(ResourceBundle messages, @Nullable LanguageModel languageModel, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Collections.emptyList();
    }

    @Nullable
    public Word2VecModel getWord2VecModel(File indexDir) throws IOException {
        return null;
    }

    public List<Rule> getRelevantWord2VecModelRules(ResourceBundle messages, Word2VecModel word2vecModel) throws IOException {
        return Collections.emptyList();
    }

    public List<Rule> getRelevantNeuralNetworkModels(ResourceBundle messages, File modelDir) {
        return Collections.emptyList();
    }

    public List<Rule> getRelevantRulesGlobalConfig(ResourceBundle messages, GlobalConfig globalConfig, UserConfig userConfig, Language motherTongue, List<Language> altLanguages) throws IOException {
        return Collections.emptyList();
    }

    public Locale getLocale() {
        return new Locale(this.getShortCode());
    }

    public Locale getLocaleWithCountryAndVariant() {
        if (this.getCountries().length > 0) {
            if (this.getVariant() != null) {
                return new Locale(this.getShortCode(), this.getCountries()[0], this.getVariant());
            }
            return new Locale(this.getShortCode(), this.getCountries()[0]);
        }
        return this.getLocale();
    }

    public List<String> getRuleFileNames() {
        String fileName;
        ArrayList<String> ruleFiles = new ArrayList<String>();
        ResourceDataBroker dataBroker = JLanguageTool.getDataBroker();
        ruleFiles.add(dataBroker.getRulesDir() + "/" + this.getShortCode() + "/" + "grammar.xml");
        if (this.getShortCodeWithCountryAndVariant().length() > 2 && dataBroker.ruleFileExists(fileName = this.getShortCode() + "/" + this.getShortCodeWithCountryAndVariant() + "/" + "grammar.xml")) {
            ruleFiles.add(dataBroker.getRulesDir() + "/" + fileName);
        }
        return ruleFiles;
    }

    @Nullable
    public Language getDefaultLanguageVariant() {
        return null;
    }

    public Disambiguator getDisambiguator() {
        return DEMO_DISAMBIGUATOR;
    }

    public Tagger getTagger() {
        return DEMO_TAGGER;
    }

    public SentenceTokenizer getSentenceTokenizer() {
        return SENTENCE_TOKENIZER;
    }

    public Tokenizer getWordTokenizer() {
        return WORD_TOKENIZER;
    }

    @Nullable
    public Chunker getChunker() {
        return null;
    }

    @Nullable
    public Chunker getPostDisambiguationChunker() {
        return null;
    }

    @Nullable
    public Synthesizer getSynthesizer() {
        return null;
    }

    public Unifier getUnifier() {
        return this.unifierConfig.createUnifier();
    }

    public Unifier getDisambiguationUnifier() {
        return this.disambiguationUnifierConfig.createUnifier();
    }

    public UnifierConfiguration getUnifierConfiguration() {
        return this.unifierConfig;
    }

    public UnifierConfiguration getDisambiguationUnifierConfiguration() {
        return this.disambiguationUnifierConfig;
    }

    public final String getTranslatedName(ResourceBundle messages) {
        try {
            return messages.getString(this.getShortCodeWithCountryAndVariant());
        }
        catch (MissingResourceException e) {
            try {
                return messages.getString(this.getShortCode());
            }
            catch (MissingResourceException e1) {
                return this.getName();
            }
        }
    }

    public final String getShortCodeWithCountryAndVariant() {
        String name = this.getShortCode();
        if (this.getCountries().length == 1 && !name.contains("-x-")) {
            name = name + "-" + this.getCountries()[0];
            if (this.getVariant() != null) {
                name = name + "-" + this.getVariant();
            }
        }
        return name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized List<AbstractPatternRule> getPatternRules() throws IOException {
        if (this.patternRules == null) {
            ArrayList<AbstractPatternRule> rules = new ArrayList<AbstractPatternRule>();
            PatternRuleLoader ruleLoader = new PatternRuleLoader();
            for (String fileName : this.getRuleFileNames()) {
                InputStream is = null;
                try {
                    is = this.getClass().getResourceAsStream(fileName);
                    boolean ignore = false;
                    if (is == null) {
                        try {
                            is = new FileInputStream(fileName);
                        }
                        catch (FileNotFoundException e) {
                            if (fileName.contains("-test-")) {
                                ignore = true;
                            }
                            throw e;
                        }
                    }
                    if (ignore) continue;
                    rules.addAll(ruleLoader.getRules(is, fileName));
                    this.patternRules = Collections.unmodifiableList(rules);
                }
                finally {
                    if (is == null) continue;
                    is.close();
                }
            }
        }
        return this.patternRules;
    }

    public final String toString() {
        return this.getName();
    }

    public final boolean isVariant() {
        for (Language language : Languages.get()) {
            boolean skip = language.getShortCodeWithCountryAndVariant().equals(this.getShortCodeWithCountryAndVariant());
            if (skip || !language.getClass().isAssignableFrom(this.getClass())) continue;
            return true;
        }
        return false;
    }

    public final boolean hasVariant() {
        for (Language language : Languages.get()) {
            boolean skip = language.getShortCodeWithCountryAndVariant().equals(this.getShortCodeWithCountryAndVariant());
            if (skip || !this.getClass().isAssignableFrom(language.getClass())) continue;
            return true;
        }
        return false;
    }

    public boolean isExternal() {
        return false;
    }

    public boolean equalsConsiderVariantsIfSpecified(Language otherLanguage) {
        if (this.getShortCode().equals(otherLanguage.getShortCode())) {
            boolean thisHasCountry = this.hasCountry();
            boolean otherHasCountry = otherLanguage.hasCountry();
            return !thisHasCountry || !otherHasCountry || this.getShortCodeWithCountryAndVariant().equals(otherLanguage.getShortCodeWithCountryAndVariant());
        }
        return false;
    }

    private boolean hasCountry() {
        return this.getCountries().length == 1;
    }

    public Pattern getIgnoredCharactersRegex() {
        return this.ignoredCharactersRegex;
    }

    public LanguageMaintainedState getMaintainedState() {
        return LanguageMaintainedState.LookingForNewMaintainer;
    }

    public boolean isHiddenFromGui() {
        return this.hasVariant() && !this.isVariant() && !this.isTheDefaultVariant();
    }

    private boolean isTheDefaultVariant() {
        if (this.getDefaultLanguageVariant() != null) {
            return this.getClass().equals(this.getDefaultLanguageVariant().getClass());
        }
        return false;
    }

    public int getPriorityForId(String id) {
        return 0;
    }

    public boolean isSpellcheckOnlyLanguage() {
        return false;
    }

    public boolean hasNGramFalseFriendRule(Language motherTongue) {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Language other = (Language)o;
        return Objects.equals(this.getShortCodeWithCountryAndVariant(), other.getShortCodeWithCountryAndVariant());
    }

    public int hashCode() {
        return this.getShortCodeWithCountryAndVariant().hashCode();
    }
}

