/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.editor;

import java.util.Collections;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.swing.JComponent;
import javax.swing.event.ChangeListener;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.ui.editor.OWLObjectEditor;
import org.protege.editor.owl.ui.editor.OWLObjectEditorHandler;
import org.protege.editor.owl.ui.selector.OWLEntitySelectorPanel;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.OWLDataFactory;
import org.semanticweb.owlapi.model.OWLEntity;
import org.semanticweb.owlapi.model.OWLOntology;

public class IRIFromEntityEditor
implements OWLObjectEditor<IRI> {
    private OWLEntitySelectorPanel entitySelectorPanel;
    private OWLEditorKit eKit;
    private OWLObjectEditorHandler<IRI> handler;

    public IRIFromEntityEditor(OWLEditorKit owlEditorKit) {
        this.eKit = owlEditorKit;
        this.entitySelectorPanel = new OWLEntitySelectorPanel(owlEditorKit, false);
    }

    @Override
    public boolean canEdit(Object object) {
        boolean contained = false;
        if (object instanceof IRI) {
            for (OWLOntology ontology : this.eKit.getModelManager().getActiveOntologies()) {
                if (!ontology.containsEntityInSignature((IRI)object)) continue;
                contained = true;
                break;
            }
        }
        return contained;
    }

    public boolean isPreferred(Object object) {
        return false;
    }

    @Override
    public void setHandler(OWLObjectEditorHandler<IRI> iriEditorHandler) {
        this.handler = iriEditorHandler;
    }

    @Override
    public OWLObjectEditorHandler<IRI> getHandler() {
        return this.handler;
    }

    @Override
    @Nonnull
    public JComponent getEditorComponent() {
        return this.entitySelectorPanel;
    }

    @Override
    @Nullable
    public IRI getEditedObject() {
        OWLEntity entity = this.entitySelectorPanel.getSelectedObject();
        return entity != null ? entity.getIRI() : null;
    }

    @Override
    public Set<IRI> getEditedObjects() {
        IRI selObj = this.getEditedObject();
        if (selObj != null) {
            return Collections.singleton(selObj);
        }
        return Collections.emptySet();
    }

    @Override
    public boolean isMultiEditSupported() {
        return false;
    }

    @Override
    public void clear() {
        this.setEditedObject(null);
    }

    @Override
    public boolean setEditedObject(IRI object) {
        if (object != null) {
            OWLDataFactory df = this.eKit.getOWLModelManager().getOWLDataFactory();
            for (OWLOntology ont : this.eKit.getOWLModelManager().getActiveOntologies()) {
                if (ont.containsClassInSignature(object)) {
                    this.entitySelectorPanel.setSelection(Collections.singleton(df.getOWLClass(object)));
                } else if (ont.containsObjectPropertyInSignature(object)) {
                    this.entitySelectorPanel.setSelection(Collections.singleton(df.getOWLObjectProperty(object)));
                } else if (ont.containsDataPropertyInSignature(object)) {
                    this.entitySelectorPanel.setSelection(Collections.singleton(df.getOWLDataProperty(object)));
                } else if (ont.containsIndividualInSignature(object)) {
                    this.entitySelectorPanel.setSelection(Collections.singleton(df.getOWLNamedIndividual(object)));
                } else {
                    if (!ont.containsAnnotationPropertyInSignature(object)) continue;
                    this.entitySelectorPanel.setSelection(Collections.singleton(df.getOWLAnnotationProperty(object)));
                }
                break;
            }
        } else {
            this.entitySelectorPanel.setSelection((OWLEntity)null);
        }
        return true;
    }

    @Override
    @Nonnull
    public String getEditorTypeName() {
        return "Entity IRI";
    }

    public JComponent getComponent() {
        return this.entitySelectorPanel;
    }

    @Override
    public void dispose() {
        this.entitySelectorPanel.dispose();
    }

    public void addSelectionListener(ChangeListener listener) {
        this.entitySelectorPanel.addSelectionListener(listener);
    }

    public void removeSelectionListener(ChangeListener listener) {
        this.entitySelectorPanel.addSelectionListener(listener);
    }
}

