/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_lo extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_CN = "\u0e88\u0eb5\u0e99";
        final String metaValue_DE = "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99";
        final String metaValue_FR = "\u0e9d\u0ea3\u0eb1\u0ec8\u0e87";
        final String metaValue_JP = "\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99";
        final String metaValue_LA = "\u0ea5\u0eb2\u0ea7";
        final String metaValue_MN = "\u0ea1\u0ead\u0e87\u0ec2\u0e81\u0ec0\u0ea5\u0e8d";
        final String metaValue_TH = "\u0ec4\u0e97";
        final String metaValue_TK = "\u0ec2\u0e95\u0ec0\u0e81\u0ec0\u0ea5\u0ebb\u0eb2";
        final String metaValue_TV = "\u0e95\u0eb9\u0ea7\u0eb2\u0ea5\u0eb9";
        final String metaValue_VN = "\u0eab\u0ea7\u0ebd\u0e94\u0e99\u0eb2\u0ea1";
        final String metaValue_WS = "\u0e8a\u0eb2\u0ea1\u0ebb\u0ea7";
        final String metaValue_bo = "\u0e97\u0eb4\u0ec0\u0e9a\u0e97\u0eb1\u0e99";
        final String metaValue_el = "\u0e81\u0ea3\u0eb5\u0e81";
        final String metaValue_he = "\u0eae\u0eb5\u0e9a\u0ea3\u0eb4\u0ea7";
        final String metaValue_hy = "\u0ead\u0eb2\u0ec0\u0ea1\u0e99\u0ebd\u0e99";
        final String metaValue_ka = "\u0e88\u0ecd\u0e88\u0ebd\u0e99";
        final String metaValue_kn = "\u0e84\u0eb1\u0e99\u0e99\u0eb2\u0e94\u0eb2";
        final String metaValue_la = "\u0ea5\u0eb2\u0e95\u0eb4\u0e99";
        final String metaValue_my = "\u0ea1\u0ebd\u0e99\u0ea1\u0eb2";
        final String metaValue_si = "\u0eaa\u0eb4\u0e99\u0eab\u0eb2\u0ea5\u0eb2";
        final String metaValue_ta = "\u0e97\u0eb2\u0ea1\u0eb4\u0ea5";
        final String metaValue_tl = "\u0e95\u0eb2\u0e81\u0eb2\u0ea5\u0ead\u0e81";
        final String metaValue_cop = "\u0e84\u0ead\u0e9a\u0e95\u0eb4\u0e81";
        final String metaValue_men = "\u0ec0\u0ea1\u0e99\u0ec0\u0e94";
        final String metaValue_nqo = "\u0ec0\u0ead\u0eb1\u0e99\u0ec2\u0e81";
        final String metaValue_ssy = "\u0e8a\u0eb2\u0ec2\u0eae";
        final String metaValue_vai = "\u0ec4\u0ea7";
        final Object[][] data = new Object[][] {
            { "ksh", "\u0ec2\u0e84\u0ea5\u0ead\u0e81\u0e99\u0ebd\u0e99" },
            { "Ogam", "\u0ead\u0ead\u0e81\u0e84\u0ead\u0e99" },
            { "mwl", "\u0ea1\u0eb5\u0ea5\u0eb1\u0e99\u0e94\u0eb2" },
            { "Zsym", "\u0eaa\u0eb1\u0e99\u0e8d\u0eb2\u0ea5\u0eb1\u0e81" },
            { "cch", "\u0ead\u0eb2\u0e94\u0ec1\u0e8a\u0ea1" },
            { "mwr", "\u0ea1\u0eb2\u0ea7\u0eb2\u0ea3\u0eb4" },
            { "type.nu.lanatham", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e97\u0e97\u0eb3\u0e97\u0eb3" },
            { "Tagb", "\u0e95\u0eb1\u0e81\u0e9a\u0eb1\u0e99\u0ea7\u0eb2" },
            { "Zsye", "\u0ead\u0eb5\u0ec2\u0ea1\u0e88\u0eb4" },
            { "%%NJIVA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e88\u0eb5\u0ea7\u0eb2/\u0e99\u0eb5\u0ea7\u0eb2" },
            { "egy", "\u0ead\u0eb5\u0ea2\u0eb4\u0e9a\u0e9a\u0eb9\u0eae\u0eb2\u0e99" },
            { "raj", "\u0ea3\u0eb2\u0e88\u0eb1\u0eaa\u0e97\u0eb2\u0e99\u0eb4" },
            { "Phag", "\u0e9f\u0eb2\u0e81\u0eaa-\u0e9b\u0eb2" },
            { "tem", "\u0e97\u0eb5\u0ea1\u0ec0\u0e99" },
            { "teo", "\u0ec0\u0e95\u0ec2\u0e8a" },
            { "rap", "\u0ea3\u0eb2\u0e9b\u0eb2\u0e99\u0eb8\u0e8d" },
            { "ter", "\u0ec0\u0e95\u0ec0\u0ea5\u0ec2\u0e99" },
            { "AC", "\u0ec0\u0e81\u0eb2\u0eb0\u0ead\u0eb2\u0ec0\u0e8a\u0e99\u0e8a\u0eb1\u0e99" },
            { "rar", "\u0ea3\u0eb2\u0ec2\u0ea3\u0e97\u0ead\u0e99\u0e81\u0eb2\u0e99" },
            { "tet", "\u0ec0\u0e95\u0e95\u0eb9\u0ea1" },
            { "AD", "\u0ead\u0eb1\u0e99\u0e94\u0ecd\u0ea3\u0eb2" },
            { "AE", "\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0ea3\u0eb1\u0e9a\u0ec0\u0ead\u0ea1\u0eb4\u0ec0\u0ea3\u0e94" },
            { "nl_BE", "\u0e9f\u0ea5\u0eb5\u0ea1\u0eb4\u0e8a" },
            { "AF", "\u0ead\u0eb2\u0e9f\u0e81\u0eb2\u0e99\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "AG", "\u0ec1\u0ead\u0e99\u0e97\u0eb4\u0e81\u0ebb\u0ea7 \u0ec1\u0ea5\u0eb0 \u0e9a\u0eb2\u0e9a\u0eb9\u0e94\u0eb2" },
            { "type.ca.ethiopic", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d" },
            { "AI", "\u0ec1\u0ead\u0e99\u0e81\u0eb8\u0e8d\u0ea5\u0eb2" },
            { "AL", "\u0ec1\u0ead\u0ea7\u0ec0\u0e9a\u0ec0\u0e99\u0e8d" },
            { "AM", "\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d" },
            { "Teng", "\u0ec0\u0e97\u0e87\u0e81\u0ea7\u0eb2\u0eae" },
            { "AO", "\u0ec1\u0ead\u0e87\u0ec2\u0e81\u0ea5\u0eb2" },
            { "AQ", "\u0ec1\u0ead\u0e99\u0e95\u0eb2\u0e94\u0e95\u0eb4\u0e81\u0eb2" },
            { "AR", "\u0ead\u0eb2\u0ec0\u0e88\u0e99\u0e97\u0eb4\u0e99\u0eb2" },
            { "Prti", "\u0e9e\u0eb2\u0eae\u0ecc\u0ec0\u0e97\u0e8d\u0ead\u0eb4\u0e99\u0eaa\u0e84\u0eae\u0eb4\u0e9b\u0e8a\u0eb1\u0e99\u0ec1\u0e99\u0ea5" },
            { "AS", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb2 \u0e8a\u0eb2\u0ea1\u0ebb\u0ea7" },
            { "AT", "\u0ead\u0ead\u0eaa\u0ec0\u0e97\u0ea3\u0e8d" },
            { "AU", "\u0ead\u0ead\u0eaa\u0ec0\u0e95\u0ea3\u0ec0\u0ea5\u0e8d" },
            { "AW", "\u0ead\u0eb2\u0ea3\u0eb9\u0e9a\u0eb2" },
            { "en_US", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94 (\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb1\u0e99)" },
            { "AX", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0ead\u0ea5\u0eb1\u0e99" },
            { "mye", "\u0ea1\u0ecd\u0ea2\u0eb4\u0e99" },
            { "AZ", "\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb2\u0e99" },
            { "%%AREVELA", "\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "BA", "\u0e9a\u0ead\u0e94\u0eaa\u0eb0\u0ec0\u0e99\u0e8d \u0ec1\u0ea5\u0eb0 \u0ec1\u0eae\u0eaa\u0ec2\u0e81\u0ea7\u0eb5\u0e99\u0eb2" },
            { "BB", "\u0e9a\u0eb2\u0e9a\u0eb2\u0ec2\u0e94\u0eaa" },
            { "ceb", "\u0e8a\u0eb5\u0e9a\u0eb9\u0ec2\u0e99" },
            { "BD", "\u0e9a\u0eb1\u0e87\u0e81\u0eb0\u0ea5\u0eb2\u0ec0\u0e97\u0e94" },
            { "kum", "\u0e84\u0eb9\u0ea1\u0eb5\u0e81" },
            { "BE", "\u0ec0\u0e9a\u0ea7\u0ea2\u0ebd\u0ea1" },
            { "gmh", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0eaa\u0eb9\u0e87\u0e81\u0eb2\u0e87" },
            { "BF", "\u0ec0\u0e9a\u0eb5\u0e81\u0eb4\u0e99\u0eb2 \u0e9f\u0eb2\u0ec2\u0e8a" },
            { "BG", "\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ec0\u0ea3\u0e8d" },
            { "BH", "\u0e9a\u0eb2\u0ec0\u0ea3\u0e99" },
            { "BI", "\u0e9a\u0eb9\u0ea3\u0eb8\u0e99\u0e94\u0eb4" },
            { "BJ", "\u0ec0\u0e9a\u0e99\u0eb4\u0e99" },
            { "BL", "\u0ec0\u0e8a\u0e99 \u0e9a\u0eb2\u0ec0\u0e97\u0ec0\u0ea5\u0ea1\u0eb5" },
            { "BM", "\u0ec0\u0e9a\u0eb5\u0ea1\u0eb4\u0ea7\u0e94\u0eb2" },
            { "kut", "\u0e84\u0eb9\u0ec0\u0e97\u0ec4\u0e99" },
            { "myv", "\u0ec0\u0ead\u0eb5\u0e8d\u0eb2" },
            { "BN", "\u0e9a\u0ea3\u0eb9\u0ec4\u0e99" },
            { "BO", "\u0ec2\u0e9a\u0ea5\u0eb4\u0ec0\u0ea7\u0e8d" },
            { "BQ", "\u0e84\u0eb2\u0ea3\u0eb4\u0e9a\u0e9a\u0ebd\u0e99 \u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99" },
            { "BR", "\u0e9a\u0ea3\u0eb2\u0e8a\u0eb4\u0ea7" },
            { "BS", "\u0e9a\u0eb2\u0eae\u0eb2\u0ea1\u0eb2\u0eaa" },
            { "xog", "\u0ec2\u0e8a\u0e81\u0eb2" },
            { "BT", "\u0e9e\u0eb9\u0e96\u0eb2\u0e99" },
            { "BV", "\u0ec0\u0e81\u0eb2\u0eb0\u0e9a\u0eb9\u0ec0\u0ea7\u0e94" },
            { "BW", "\u0e9a\u0ead\u0e94\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2" },
            { "BY", "\u0ec0\u0e9a\u0ea5\u0eb2\u0ea3\u0eb8\u0eaa" },
            { "BZ", "\u0ec0\u0e9a\u0ea5\u0eb5\u0e8a" },
            { "Visp", "\u0e84\u0eb3\u0ec0\u0ea7\u0ebb\u0ec9\u0eb2\u0e97\u0eb5\u0ec8\u0ec0\u0e9a\u0eb5\u0ec8\u0e87\u0ec0\u0eab\u0eb1\u0e99\u0ec4\u0e94\u0ec9" },
            { "type.ca.persian", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec0\u0e9b\u0eb5\u0e8a\u0ebd\u0e99" },
            { "type.nu.hebr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0eae\u0eb4\u0e9a\u0ea3\u0eb4\u0ea7" },
            { "CA", "\u0ec1\u0e84\u0e99\u0eb2\u0e94\u0eb2" },
            { "CC", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0e81\u0ec2\u0e81\u0eaa" },
            { "mzn", "\u0ea1\u0eb2\u0ec1\u0e8a\u0e99\u0ec0\u0e94\u0eb5\u0ea5\u0eb1\u0e87" },
            { "CD", "\u0e84\u0ead\u0e87\u0ec2\u0e81 - \u0e84\u0eb4\u0e99\u0e8a\u0eb2\u0e8a\u0eb2" },
            { "CF", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "CG", "\u0e84\u0ead\u0e87\u0ec2\u0e81 - \u0e9a\u0ea3\u0eb2\u0e8a\u0eb2\u0ea7\u0eb4\u0ea7" },
            { "CH", "\u0eaa\u0eb0\u0ea7\u0eb4\u0e94\u0ec0\u0e8a\u0eb5\u0ec1\u0ea5\u0e99" },
            { "CI", "\u0ec2\u0e84\u0e95\u0eb5 \u0ea7\u0ebb\u0ea7" },
            { "CK", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0eb8\u0e81" },
            { "CL", "\u0e8a\u0eb4\u0ea5\u0eb5" },
            { "Kthi", "\u0e81\u0eb2\u0e8d\u0e95\u0eb4" },
            { "CM", "\u0e84\u0eb2\u0ec0\u0ea1\u0ea3\u0eb9\u0e99" },
            { "CN", metaValue_CN },
            { "CO", "\u0ec2\u0e84\u0ea5\u0ebb\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "CP", "\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0ea5\u0eb4\u0e9a\u0ec0\u0e9b\u0eb5\u0e95\u0eb1\u0e99" },
            { "CR", "\u0ec2\u0e84\u0eaa\u0e95\u0eb2 \u0ea3\u0eb4\u0e81\u0eb2" },
            { "CU", "\u0e84\u0eb4\u0ea7\u0e9a\u0eb2" },
            { "CV", "\u0ec0\u0e84\u0e9a \u0ec0\u0ea7\u0eb5\u0e94" },
            { "CW", "\u0e84\u0eb9\u0ea3\u0eb2\u0e8a\u0eb2\u0ea7" },
            { "CX", "\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0ea3\u0eb4\u0eaa\u0ea1\u0eb2\u0e94" },
            { "CY", "\u0ec4\u0e8a\u0e9b\u0ea3\u0eb1\u0eaa" },
            { "type.nu.bali", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e9a\u0eb2\u0ea5\u0eb5" },
            { "CZ", "\u0ec0\u0e8a\u0eb1\u0e81\u0ec0\u0e8a\u0e8d" },
            { "eka", "\u0ead\u0eb5\u0e81\u0eb2\u0e88\u0eb1\u0e81" },
            { "DE", metaValue_DE },
            { "goh", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0eaa\u0eb9\u0e87\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "ace", "\u0ec1\u0ead\u0eb1\u0e81\u0e8a\u0eb5\u0ec0\u0e99\u0eb1\u0eaa" },
            { "cgg", "\u0e8a\u0eb5\u0e81\u0eb2" },
            { "DG", "\u0e94\u0eb4\u0ec0\u0ead\u0ec2\u0e81 \u0e81\u0eb2\u0ec0\u0e8a\u0e8d" },
            { "type.nu.deva", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0e94\u0ea7\u0eb2\u0e99\u0eb2\u0e81\u0eb2\u0ea3\u0eb5" },
            { "DJ", "\u0e88\u0eb4\u0e9a\u0eb9\u0e95\u0eb4" },
            { "DK", "\u0ec0\u0e94\u0e99\u0ea1\u0eb2\u0e81" },
            { "ach", "\u0ead\u0eb2\u0ec2\u0e84\u0ea5\u0eb5" },
            { "gon", "\u0e81\u0ead\u0e99\u0e94\u0eb5" },
            { "Brai", "\u0ec0\u0e9a\u0ea3\u0ea7" },
            { "Brah", "\u0e9e\u0eae\u0eb2\u0eab\u0ea1\u0eb5" },
            { "DM", "\u0ec2\u0e94\u0ea1\u0eb5\u0e99\u0eb4\u0e84\u0eb2" },
            { "type.nu.armnlow", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ec0\u0ea1\u0e99\u0ebd\u0e99\u0e95\u0ebb\u0ea7\u0e9e\u0eb4\u0ea1\u0e99\u0ec9\u0ead\u0e8d" },
            { "DO", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94 \u0ec2\u0e94\u0ea1\u0eb4\u0e99\u0eb4\u0e81\u0eb1\u0e99" },
            { "gor", "\u0ec2\u0e81\u0ea3\u0ead\u0e99\u0e95\u0eb2\u0ec2\u0ea3" },
            { "got", "\u0e81\u0ead\u0e94\u0eae\u0eb4\u0e81" },
            { "Mtei", "\u0ec0\u0ea1\u0ec0\u0e97\u0ea1\u0eb2\u0ec0\u0e8d\u0e81" },
            { "zun", "\u0e8a\u0eb9\u0e99\u0eb5" },
            { "tig", "\u0ec4\u0e97\u0e81\u0ea3\u0eb5" },
            { "Takr", "\u0e97\u0eb2\u0e84\u0eae\u0eb5" },
            { "DZ", "\u0ead\u0eb1\u0ea5\u0e88\u0eb4\u0ec0\u0ea3\u0e8d" },
            { "pag", "\u0e9b\u0eb2\u0e99\u0e81\u0eb2\u0e8a\u0eb5\u0ea1\u0eb2\u0e99" },
            { "pal", "\u0e9e\u0eb2\u0ea5\u0eb2\u0ea7\u0eb5" },
            { "EA", "\u0ec0\u0e8a\u0ea7\u0e95\u0eb2 \u0ec1\u0ea5\u0eb0\u0ec0\u0ea1\u0ea5\u0eb4\u0e99\u0ea5\u0eb2" },
            { "chb", "\u0e8a\u0eb4\u0e9a\u0e8a\u0eb2" },
            { "pam", "\u0e9b\u0eb2\u0ea1\u0e9b\u0eb2\u0e99\u0e81\u0eb2" },
            { "EC", "\u0ec0\u0ead\u0e81\u0ea7\u0eb2\u0e94\u0ecd" },
            { "pap", "\u0e9b\u0eb2\u0ea1\u0ec0\u0e9b\u0e8d\u0ec0\u0ea1\u0eb1\u0e99\u0ec2\u0e97" },
            { "ada", "\u0ead\u0eb2\u0ec1\u0e94\u0e87\u0ea1\u0eb5" },
            { "EE", "\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0ec0\u0e99\u0e8d" },
            { "tiv", "\u0e95\u0eb5\u0ea7" },
            { "EG", "\u0ead\u0eb5\u0ea2\u0eb4\u0e9a" },
            { "EH", "\u0e8a\u0eb2\u0eae\u0eb2\u0ea3\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "chg", "\u0e8a\u0eb2\u0e81\u0eb2\u0ec4\u0e95" },
            { "pau", "\u0e9b\u0eb2\u0ea5\u0ebb\u0ea7\u0ead\u0eb2\u0e99" },
            { "chk", "\u0e8a\u0eb9\u0ec0\u0e81\u0e94" },
            { "chn", "\u0e8a\u0eb5\u0e99\u0eb8\u0e81\u0e88\u0eb2\u0e81\u0ead\u0e99" },
            { "chm", "\u0ea1\u0eb2\u0ea3\u0eb4" },
            { "chp", "\u0e8a\u0eb5\u0e9e\u0eb4\u0ea7\u0ea2\u0eb2\u0e99" },
            { "cho", "\u0e8a\u0ead\u0e81\u0e95\u0eb4\u0ea7" },
            { "chr", "\u0e8a\u0eb5\u0ec2\u0ea3\u0e81\u0eb5" },
            { "ER", "\u0ec0\u0ead\u0ea3\u0eb4\u0ec0\u0e97\u0ea3\u0e8d" },
            { "ES", "\u0eaa\u0eb0\u0ec0\u0e9b\u0e99" },
            { "ET", "\u0ead\u0eb5\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d" },
            { "EU", "\u0eaa\u0eb0\u0eab\u0eb0\u0e9e\u0eb2\u0e9a\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a" },
            { "elx", "\u0ead\u0eb5\u0ea5\u0eb2\u0ec4\u0ea1" },
            { "type.ca.gregorian", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec0\u0e81\u0ea3\u0ec2\u0e81\u0ea3\u0ebd\u0e99" },
            { "EZ", "\u0ec0\u0e82\u0e94\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a" },
            { "chy", "\u0e8a\u0eb5\u0ec0\u0ea2\u0e99\u0e99\u0eb5" },
            { "type.nu.gujr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0eb8\u0e88\u0eb2\u0ea3\u0eb2\u0e97\u0eb5" },
            { "Inds", "\u0ead\u0eb4\u0e99\u0e94\u0eb1\u0e94" },
            { "ady", "\u0ec0\u0ead\u0e94\u0eb5\u0eae\u0eb4" },
            { "FI", "\u0e9f\u0eb4\u0e99\u0ec1\u0ea5\u0e99" },
            { "FJ", "\u0e9f\u0eb4\u0e88\u0eb4" },
            { "FK", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e9f\u0ead\u0e81\u0ec1\u0ea5\u0e99" },
            { "FM", "\u0ec4\u0ea1\u0ec2\u0e84\u0ea3\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "FO", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec1\u0e9f\u0ec2\u0ea3" },
            { "Taml", metaValue_ta },
            { "FR", metaValue_FR },
            { "Kpel", "\u0ec0\u0e9b\u0ea5\u0ec0\u0ea5" },
            { "tkl", metaValue_TK },
            { "grb", "\u0e81\u0ea3\u0eb5\u0ec2\u0e9a" },
            { "root", "\u0ea5\u0eb9\u0e94" },
            { "type.ca.indian", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec1\u0eab\u0ec8\u0e87\u0e8a\u0eb2\u0e94\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d" },
            { "grc", "\u0ec1\u0ead\u0e99\u0e8a\u0ebd\u0e99\u0e81\u0ea3\u0eb5\u0e81" },
            { "GA", "\u0e81\u0eb2\u0e9a\u0ead\u0e99" },
            { "vot", "\u0ec2\u0ea7\u0e95\u0eb4\u0e81" },
            { "GB", "\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb2\u0e94\u0e8a\u0eb0\u0ead\u0eb0\u0e99\u0eb2\u0e88\u0eb1\u0e81" },
            { "pcm", "\u0ec4\u0e99\u0e88\u0eb5\u0ea3\u0ebd\u0e99\u0e9e\u0eb4\u0e94\u0e81\u0eb4\u0e99" },
            { "GD", "\u0ec0\u0e81\u0ea3\u0ec0\u0e99\u0e94\u0eb2" },
            { "GE", "\u0e88\u0ecd\u0ec0\u0e88\u0e8d" },
            { "GF", "\u0ec0\u0e9f\u0ea3\u0e99\u0e8a\u0ecc \u0e81\u0eb8\u0e8d\u0ead\u0eb2\u0e99\u0eb2" },
            { "GG", "\u0ec0\u0e81\u0eb5\u0e99\u0e8a\u0eb5" },
            { "GH", "\u0e81\u0eb2\u0e99\u0eb2" },
            { "Tale", "\u0ec4\u0e97\u0ec0\u0ea5" },
            { "GI", "\u0e88\u0eb4\u0e9a\u0e9a\u0ea3\u0ead\u0e99\u0e97\u0eb2" },
            { "afh", "\u0ec1\u0ead\u0e9f\u0eb5\u0eae\u0eb5\u0ea5\u0eb5" },
            { "GL", "\u0e81\u0ea3\u0eb5\u0e99\u0ec1\u0ea5\u0e99" },
            { "enm", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0e81\u0eb2\u0e87" },
            { "GM", "\u0eaa\u0eb2\u0e97\u0eb2\u0ea5\u0eb0\u0e99\u0eb0\u0ea5\u0eb1\u0e94\u0ec1\u0e81\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "GN", "\u0e81\u0eb4\u0e99\u0eb5" },
            { "GP", "\u0e81\u0ebb\u0ea7\u0e94\u0eb2\u0ea5\u0eb9\u0e9a" },
            { "GQ", "\u0ec0\u0ead\u0e84\u0ebb\u0ea7\u0ec2\u0e97\u0ea3\u0ebd\u0ea7 \u0e81\u0eb5\u0e99\u0eb5" },
            { "GR", "\u0e81\u0ea3\u0eb5\u0e8a" },
            { "GS", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0e88\u0ecd\u0ec0\u0e88\u0e8d\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9 \u0ec1\u0ea5\u0eb0 \u0ec1\u0e8a\u0e99\u0ea7\u0eb4\u0e94\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9" },
            { "GT", "\u0e81\u0ebb\u0ea7\u0ec0\u0e97\u0ea1\u0eb2\u0ea5\u0eb2" },
            { "GU", "\u0e81\u0ea7\u0eb2\u0ea1" },
            { "GW", "\u0e81\u0eb4\u0e99\u0eb5-\u0e9a\u0eb4\u0eaa\u0ec0\u0e8a\u0ebb\u0eb2" },
            { "tli", "\u0e97\u0ea5\u0eb5\u0e87\u0e81\u0eb4\u0e94" },
            { "tlh", "\u0e84\u0ea3\u0eb4\u0e87\u0e81\u0ead\u0e99" },
            { "Talu", "\u0ec4\u0e97\u0ea5\u0eb7\u0ec9\u0ec3\u0edd\u0ec8" },
            { "GY", "\u0e81\u0eb2\u0e8d\u0ea2\u0eb2\u0e99\u0eb2" },
            { "ckb", "\u0ec2\u0e8a\u0ea3\u0eb2\u0e99\u0eb4 \u0ec0\u0e84\u0eb5\u0e94\u0eb4\u0e8a" },
            { "zxx", "\u0e9a\u0ecd\u0ec8\u0ea1\u0eb5\u0ec0\u0e99\u0eb7\u0ec9\u0ead\u0eab\u0eb2\u0e9e\u0eb2\u0eaa\u0eb2" },
            { "Jurc", "\u0e88\u0eb9\u0eae\u0ec0\u0e8a\u0eb1\u0e99" },
            { "de_AT", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99 (\u0ec2\u0ead\u0eaa\u0e95\u0ea3\u0eb4\u0e94)" },
            { "Vaii", metaValue_vai },
            { "HK", "\u0eae\u0ebb\u0e87\u0e81\u0ebb\u0e87 \u0ec0\u0e82\u0e94\u0e9b\u0ebb\u0e81\u0e84\u0ead\u0e87\u0e9e\u0eb4\u0ec0\u0eaa\u0e94 \u0e88\u0eb5\u0e99" },
            { "HM", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec0\u0eae\u0eb5\u0e94 & \u0ec1\u0ea1\u0eb1\u0e81\u0ec2\u0e94\u0e99\u0ead\u0ea5" },
            { "HN", "\u0eae\u0ead\u0e99\u0e94\u0eb9\u0ea3\u0eb1\u0eaa" },
            { "HR", "\u0ec2\u0e84\u0ea3\u0ec0\u0ead\u0ec0\u0e97\u0e8d" },
            { "agq", "\u0ead\u0eb2\u0ec0\u0eae\u0eb1\u0ea1" },
            { "gsw", "\u0eaa\u0eb0\u0ea7\u0eb4\u0eaa \u0ec0\u0e88\u0eb5\u0ec1\u0ea1\u0e99" },
            { "HT", "\u0ec4\u0eae\u0e95\u0eb4" },
            { "HU", "\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0eb5" },
            { "tmh", "\u0e97\u0eb2\u0ea1\u0eb2\u0e81\u0ec0\u0e8a\u0e81" },
            { "IC", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e84\u0eb2\u0e99\u0eb2\u0ea3\u0eb5" },
            { "ID", "\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0ec0\u0e8a\u0e8d" },
            { "peo", "\u0ec0\u0e9b\u0eb5\u0ec0\u0e8a\u0e8d\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "type.nu.kali", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0eb2\u0ea2\u0eb2" },
            { "IE", "\u0ec4\u0ead\u0ec1\u0ea5\u0e99" },
            { "nap", "\u0e99\u0eb2\u0ec2\u0e9b\u0ea5\u0eb5" },
            { "%%NDYUKA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e94\u0eb4\u0ea7\u0e84\u0eb2" },
            { "naq", "\u0e99\u0eb2\u0ea1\u0eb2" },
            { "zza", "\u0e8a\u0eb2\u0e8a\u0eb2" },
            { "Tang", "\u0e95\u0eb1\u0e99\u0e81\u0eb1\u0e99" },
            { "IL", "\u0ead\u0eb4\u0eaa\u0ea3\u0eb2\u0ec0\u0ead\u0ea7" },
            { "Nbat", "\u0e99\u0eb2\u0e9a\u0eb2\u0e97\u0eb2\u0e97\u0ebd\u0e99" },
            { "IM", "\u0ec0\u0ead\u0ea7 \u0ead\u0ead\u0e9a \u0ec1\u0ea1\u0e99" },
            { "IN", "\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d" },
            { "IO", "\u0ec0\u0e82\u0e94\u0ec1\u0e94\u0e99\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ec3\u0e99\u0ea1\u0eb0\u0eab\u0eb2\u0eaa\u0eb0\u0ea1\u0eb8\u0e94\u0ead\u0eb4\u0e99\u0ec0\u0e94\u0e8d" },
            { "IQ", "\u0ead\u0eb5\u0ea3\u0eb1\u0e81" },
            { "IR", "\u0ead\u0eb5\u0ea3\u0eb2\u0e99" },
            { "IS", "\u0ec4\u0ead\u0eaa\u0ec1\u0ea5\u0e99" },
            { "IT", "\u0ead\u0eb4\u0e95\u0eb2\u0ea5\u0eb5" },
            { "Zmth", "\u0ec0\u0e84\u0eb7\u0ec8\u0ead\u0e87\u0edd\u0eb2\u0e8d\u0e97\u0eb2\u0e87\u0e84\u0eb0\u0e99\u0eb4\u0e94\u0eaa\u0eb2\u0e94" },
            { "type.nu.thai", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e97" },
            { "%%POSIX", "\u0e84\u0ead\u0ea1\u0e9e\u0eb4\u0ea7\u0ec0\u0e95\u0eb5" },
            { "type.nu.beng", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e9a\u0eb1\u0e87\u0e81\u0ea5\u0eb2" },
            { "JE", "\u0ec0\u0e88\u0eb5\u0e8a\u0eb5" },
            { "type.ca.islamic", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ead\u0eb4\u0eaa\u0eb0\u0ea5\u0eb2\u0ea1" },
            { "JM", "\u0e88\u0eb2\u0ec4\u0ea1\u0e84\u0eb2" },
            { "Beng", "\u0ec0\u0e9a\u0eb1\u0e87\u0e81\u0eb2" },
            { "JO", "\u0e88\u0ecd\u0ec1\u0e94\u0e99" },
            { "JP", metaValue_JP },
            { "%%1606NICT", "\u0e9b\u0eb2\u0e8d\u0e8d\u0eb8\u0e81\u0e81\u0eb2\u0e87\u0e9d\u0ea3\u0eb1\u0ec8\u0e87\u0ec0\u0e96\u0eb4\u0e87\u0e9b\u0eb5 \u0e84\u0eaa 1606" },
            { "ain", "\u0ec4\u0ead\u0e99\u0eb9" },
            { "Mend", metaValue_men },
            { "guz", "\u0e81\u0eb9\u0e8a\u0eb4" },
            { "tog", "\u0e99\u0eb2\u0e8d\u0ead\u0eb2\u0e8a\u0eb2\u0e95\u0ead\u0e87\u0e81\u0eb2" },
            { "type.nu.knda", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec1\u0e84\u0e99\u0e99\u0eb2\u0e94\u0eb2" },
            { "Kali", "\u0e84\u0e8d\u0eb2" },
            { "de_CH", "\u0eaa\u0eb0\u0ea7\u0eb4\u0eaa \u0ec4\u0eae \u0ec0\u0e88\u0eb5\u0ec1\u0ea1\u0e99" },
            { "type.ca.buddhist", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99 \u0e9e\u0eb8\u0e94\u0e97\u0eb0\u0eaa\u0eb1\u0e87\u0e81\u0eb2\u0e94" },
            { "KE", "\u0ec0\u0e84\u0e99\u0ea2\u0eb2" },
            { "419", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99 \u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2" },
            { "KG", "\u0e84\u0ebd\u0e81\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "KH", "\u0e81\u0eb3\u0e9b\u0eb9\u0ec0\u0e88\u0e8d" },
            { "KI", "\u0e84\u0eb4\u0ea3\u0eb4\u0e9a\u0eb2\u0e97\u0eb4" },
            { "KM", "\u0ec2\u0e84\u0ec2\u0ea1\u0ec2\u0ea3\u0eaa" },
            { "Knda", metaValue_kn },
            { "KN", "\u0ec0\u0e8a\u0e99 \u0e84\u0eb4\u0e94 \u0ec1\u0ea5\u0eb0 \u0ec0\u0e99\u0ea7\u0eb4\u0eaa" },
            { "Zinh", "\u0ead\u0eb4\u0e99\u0ec0\u0eae\u0eae\u0eb4\u0e94" },
            { "fr_CA", "\u0e9f\u0ea5\u0eb1\u0e87(\u0e81\u0eb2\u0e99\u0eb2\u0e94\u0eb2)" },
            { "KP", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec0\u0edc\u0eb7\u0ead" },
            { "KR", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5\u0ec3\u0e95\u0ec9" },
            { "Plrd", "\u0eaa\u0eb1\u0e94\u0e95\u0eb0\u0eaa\u0eb2\u0e94\u0e9e\u0ecd\u0eae\u0ea5\u0eb2" },
            { "fr_CH", "\u0e9d\u0ea3\u0eb1\u0ec8\u0e87 (\u0eaa\u0ea7\u0eb4\u0eaa)" },
            { "KW", "\u0e81\u0eb9\u0ec0\u0ea7\u0e94" },
            { "tpi", "\u0e97\u0ead\u0e81\u0e9e\u0eb5\u0e8a\u0eb4\u0e99" },
            { "KY", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0e84\u0ec1\u0ea1\u0e99" },
            { "KZ", "\u0e84\u0eb2\u0e8a\u0eb1\u0e81\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "Cyrl", "\u0e8a\u0eb5\u0ea3\u0eb4\u0ea7\u0ea5\u0eb4\u0e81" },
            { "LA", metaValue_LA },
            { "LB", "\u0ec0\u0ea5\u0e9a\u0eb2\u0e99\u0ead\u0e99" },
            { "LC", "\u0ec0\u0e8a\u0e99 \u0ea5\u0eb9\u0ec0\u0e8a\u0e8d" },
            { "phn", "\u0e9f\u0eb5\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "Cyrs", "\u0ec0\u0e8a\u0eae\u0eb1\u0e94\u0eaa\u0ea5\u0eb2 \u0ec2\u0ea7\u0e99\u0eb4\u0e81\u0e8a\u0eb5\u0eae\u0eb4\u0e81\u0ea5\u0eb4\u0e81\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "gwi", "\u0ea7\u0eb4\u0e94\u0ead\u0eb4\u0e99" },
            { "%%LUNA1918", "\u0ea5\u0eb9\u0e99\u0ec8\u0eb21918" },
            { "nds", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99 \u0e95\u0ead\u0e99\u0ec4\u0e95\u0ec9" },
            { "LI", "\u0ea5\u0eb4\u0e94\u0ec0\u0e97\u0e99\u0eaa\u0eb0\u0e95\u0eb2\u0e8d" },
            { "LK", "\u0eaa\u0eb5\u0ea5\u0eb1\u0e87\u0e81\u0eb2" },
            { "akk", "\u0ead\u0eb1\u0e81\u0e81\u0eb2\u0e94\u0ebd\u0ea1" },
            { "cop", metaValue_cop },
            { "LR", "\u0ea5\u0eb4\u0ec0\u0e9a\u0eb5\u0ec0\u0ea3\u0e8d" },
            { "LS", "\u0ec0\u0ea5\u0ec2\u0e8a\u0ec2\u0e97" },
            { "Phlv", "\u0e9b\u0eb0\u0eab\u0ea5\u0eb2\u0ea7\u0eb5\u0e9a\u0eb8\u0e81" },
            { "LT", "\u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0ec0\u0e99\u0e8d" },
            { "LU", "\u0ea5\u0eb8\u0e81\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0eb5\u0e81" },
            { "LV", "\u0ea5\u0eb1\u0e94\u0ec0\u0ea7\u0e8d" },
            { "Kana", "\u0e84\u0eb0\u0e95\u0eb0\u0e81\u0eb0\u0e99\u0eb0" },
            { "Sora", "\u0ec2\u0eaa\u0eae\u0eb2\u0eaa\u0ebb\u0ea1\u0ec0\u0e9b\u0eb1\u0e87" },
            { "LY", "\u0ea5\u0eb4\u0ec0\u0e9a\u0e8d" },
            { "lad", "\u0ea5\u0eb2\u0e94\u0eb5\u0ec2\u0e99" },
            { "vun", "\u0ea7\u0eb1\u0e99\u0ec2\u0e88" },
            { "%%LAUKIKA", "\u0ea5\u0ebb\u0ea7\u0e81\u0eb4\u0e81\u0eb2" },
            { "lah", "\u0ea5\u0eb2\u0e99\u0e94\u0eb2" },
            { "lag", "\u0ec1\u0ea5\u0e99\u0e81\u0eb4" },
            { "Thaa", "\u0e97\u0eb2\u0e99\u0eb2" },
            { "MA", "\u0ec2\u0ea1\u0ea3\u0eb1\u0ead\u0e81\u0ec2\u0e84" },
            { "MC", "\u0ec2\u0ea1\u0e99\u0eb2\u0ec2\u0e84" },
            { "MD", "\u0ec2\u0ea1\u0e99\u0ec2\u0e94\u0ea7\u0eb2" },
            { "Nshu", "\u0e99\u0eb8\u0e8a\u0eb8" },
            { "ME", "\u0ea1\u0ead\u0e99\u0ec0\u0e95\u0ec0\u0e99\u0ec2\u0e81\u0ea3" },
            { "MF", "\u0ec0\u0e8a\u0e99 \u0ea1\u0eb2\u0e97\u0eb4\u0e99" },
            { "lam", "\u0ec1\u0ea5\u0ea1\u0e9a\u0eb2" },
            { "MG", "\u0ea1\u0eb2\u0e94\u0eb2\u0e81\u0eb2\u0eaa\u0eb0\u0e81\u0eb2" },
            { "Thai", metaValue_TH },
            { "MH", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ea1\u0eb2\u0ec1\u0e8a\u0ea7" },
            { "ale", "\u0ead\u0eb2\u0ec0\u0ea5\u0eb5\u0e94" },
            { "type.nu.vaii", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec3\u0e99\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0ec4\u0ea7" },
            { "MK", "\u0ec1\u0ea1\u0e8a\u0eb4\u0ec2\u0e94\u0ec0\u0e99\u0e8d" },
            { "ML", "\u0ea1\u0eb2\u0ea5\u0eb5" },
            { "MM", "\u0ea1\u0ebd\u0e99\u0ea1\u0eb2 (\u0ec0\u0e9a\u0eb5\u0ea1\u0eb2)" },
            { "MN", metaValue_MN },
            { "new", "\u0e99\u0eb5\u0ea7\u0eb2\u0ea3\u0eb4" },
            { "MO", "\u0ea1\u0eb2\u0e81\u0eb2\u0ea7 \u0ec0\u0e82\u0e94\u0e9b\u0ebb\u0e81\u0e84\u0ead\u0e87\u0e9e\u0eb4\u0ec0\u0eaa\u0e94 \u0e88\u0eb5\u0e99" },
            { "MP", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ea1\u0eb2\u0ec0\u0ea3\u0e8d\u0e99\u0eb2\u0e95\u0ead\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "MQ", "\u0ea1\u0eb2\u0e95\u0eb4\u0e99\u0eb5\u0e81" },
            { "MR", "\u0ea1\u0ebb\u0ea7\u0ea3\u0eb4\u0ec0\u0e97\u0ec0\u0e99\u0e8d" },
            { "MS", "\u0ea1\u0ead\u0e99\u0ec0\u0e8a\u0eb5\u0ea3\u0eb2\u0e94" },
            { "MT", "\u0ea1\u0ead\u0e99\u0e97\u0eb2" },
            { "MU", "\u0ea1\u0ebb\u0ea7\u0ea3\u0eb4\u0e8a\u0ebd\u0eaa" },
            { "alt", "\u0ead\u0eb2\u0e99\u0ec4\u0e95\u0ec3\u0e95\u0ec9" },
            { "MV", "\u0ea1\u0eb1\u0e99\u0e94\u0eb4\u0e9f" },
            { "MW", "\u0ea1\u0eb2\u0ea5\u0eb2\u0ea7\u0eb5" },
            { "MX", "\u0ec0\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0ec2\u0e81" },
            { "type.ca.japanese", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "MY", "\u0ea1\u0eb2\u0ec0\u0ea5\u0ec0\u0e8a\u0e8d" },
            { "MZ", "\u0ec2\u0ea1\u0ec1\u0e8a\u0ea1\u0e9a\u0eb4\u0e81" },
            { "Phli", "\u0e9b\u0eb0\u0eab\u0ea5\u0eb2\u0ea7\u0eb5\u0ead\u0eb4\u0e99\u0eaa\u0e84\u0eb4\u0e9a\u0e8a\u0eb1\u0e99\u0ec1\u0e99\u0ea5" },
            { "NA", "\u0e99\u0eb2\u0ea1\u0eb5\u0ec0\u0e9a\u0e8d" },
            { "202", "\u0e8a\u0eb1\u0e9a \u0e8a\u0eb2\u0eae\u0eb2\u0ea3\u0eb2\u0e99 \u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2" },
            { "type.ca.hebrew", "\u0e9b\u0eb0\u200b\u0e95\u0eb4\u200b\u0e97\u0eb4\u0e99\u200b\u0eae\u0eb5\u0e9a\u200b\u0ea3\u0eb4\u0ea7" },
            { "type.co.dictionary", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0e9e\u0ebb\u0e94\u0e88\u0eb0\u0e99\u0eb2\u0e99\u0eb8\u0e81\u0ebb\u0ea1" },
            { "NC", "\u0e99\u0eb4\u0ea7 \u0e84\u0eb2\u0ec0\u0ea5\u0ec2\u0e94\u0ec0\u0e99\u0e8d" },
            { "%%WADEGILE", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec1\u0e9a\u0e9a\u0ec0\u0ea7\u0e94-\u0ec4\u0e88\u0ea5\u0ecc" },
            { "%%UCRCOR", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0eaa\u0eb0\u0e9a\u0eb1\u0e9a\u0e9b\u0eb1\u0e9a\u0e9b\u0eb8\u0e87\u0ec1\u0e9a\u0e9a\u0e84\u0ebb\u0e9a\u0ea7\u0ebb\u0e87\u0e88\u0ead\u0e99" },
            { "NE", "\u0e99\u0eb4\u0ec0\u0e88\u0eb5" },
            { "NF", "\u0ec0\u0e81\u0eb2\u0eb0\u0e99\u0ecd\u0ec2\u0e9f\u0e81" },
            { "NG", "\u0ec4\u0e99\u0e88\u0eb5\u0ec0\u0ea3\u0e8d" },
            { "trv", "\u0e95\u0eb2\u0ec2\u0ea5\u0ec2\u0e81" },
            { "Phlp", "\u0e9b\u0eb0\u0eab\u0ea5\u0eb2\u0ea7\u0eb5\u0e8a\u0ead\u0e94\u0ec0\u0e95\u0eae\u0ecc" },
            { "NI", "\u0e99\u0eb4\u0e81\u0e84\u0eb2\u0ea3\u0eb2\u0e81\u0ebb\u0ea7" },
            { "Hmng", "\u0e9b\u0eb2\u0ec0\u0eae\u0eb2\u0ec0\u0ea1\u0eb1\u0e87" },
            { "NL", "\u0ec0\u0e99\u0ec0\u0e97\u0eb5\u0ec1\u0ea5\u0e99" },
            { "NO", "\u0e99\u0ecd\u0ec0\u0ea7" },
            { "NP", "\u0ec0\u0e99\u0e9b\u0eb2\u0e99" },
            { "NR", "\u0e99\u0eb2\u0ead\u0eb9\u0ea3\u0eb9" },
            { "NU", "\u0e99\u0eb5\u0ead\u0eb9\u0ec0\u0ead" },
            { "Phnx", "\u0e9f\u0eb5\u0e99\u0eb4\u0ec0\u0e8a\u0e8d" },
            { "rof", "\u0ea3\u0ebb\u0ea1\u0ec2\u0e9a" },
            { "tsi", "\u0e8a\u0eb5\u0ea1\u0e8a\u0eb5\u0ec1\u0ead\u0e99" },
            { "NZ", "\u0e99\u0eb4\u0ea7\u0e8a\u0eb5\u0ec1\u0ea5\u0e99" },
            { "Merc", "\u0ec0\u0e84\u0ec0\u0ea5\u0eb5\u0e8a\u0eb5\u0ec0\u0ea1\u0ec2\u0eae\u0ead\u0eb4\u0e95\u0eb4\u0e81" },
            { "rom", "\u0ec2\u0ea3\u0ec0\u0ea1\u0e99\u0eb5" },
            { "Mero", "\u0ec0\u0ea1\u0ec2\u0eae\u0e95\u0eb4\u0e81" },
            { "crh", "\u0e84\u0ea3\u0eb5\u0ec0\u0ea1\u0e99\u0ec0\u0e95\u0eb5\u0e84\u0eb4\u0e8a" },
            { "ang", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "OM", "\u0ec2\u0ead\u0ea1\u0eb2\u0e99" },
            { "%%PETR1708", "\u0e9e\u0eb5\u0e97\u0ecc1708" },
            { "anp", "\u0ec1\u0ead\u0e99\u0e88\u0eb5\u0e81\u0eb2" },
            { "crs", "\u0ec0\u0e8a\u0ec0\u0e8a\u0ea7\u0eb2 \u0ec2\u0e84\u0ea3\u0e94 \u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "Xpeo", "\u0ec0\u0e9b\u0eae\u0ec0\u0e8a\u0e8d\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "PA", "\u0e9e\u0eb2\u0e99\u0eb2\u0ea1\u0eb2" },
            { "type.ca.islamic-civil", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ead\u0eb4\u0e94\u0eaa\u0eb0\u0ea5\u0eb2\u0ea1" },
            { "csb", "\u0e81\u0eb2\u0e8a\u0eb9\u0e9a\u0ebd\u0e99" },
            { "en_GB", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94 (\u0e9a\u0ea3\u0eb4\u0e94\u0e97\u0eb4\u0e8a)" },
            { "PE", "\u0ec0\u0e9b\u0ea3\u0eb9" },
            { "PF", "\u0ec0\u0e9f\u0ea3\u0e99\u0e8a\u0ecc \u0ec2\u0e9e\u0ea5\u0eb4\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "PG", "\u0e9b\u0eb2\u0e9b\u0ebb\u0ea7\u0e99\u0eb4\u0ea7\u0e81\u0eb5\u0e99\u0eb5" },
            { "PH", "\u0e9f\u0eb4\u0ea5\u0eb4\u0e9a\u0e9b\u0eb4\u0e99" },
            { "PK", "\u0e9b\u0eb2\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "PL", "\u0ec2\u0e9b\u0ec1\u0ea5\u0e99" },
            { "ewo", "\u0ead\u0eb5\u0ea7\u0ead\u0e99\u0e94\u0eb9" },
            { "PM", "\u0ec0\u0e8a\u0e99 \u0e9b\u0eb5\u0ec1\u0ead \u0ea1\u0eb4\u0ec0\u0e81\u0ea7\u0ea5\u0ead\u0e99" },
            { "PN", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0e9e\u0eb4\u0e94\u0ec1\u0e84\u0e99" },
            { "PR", "\u0ec0\u0e9e\u0eb7\u0ead\u0ec2\u0e95 \u0ea3\u0eb4\u0ec2\u0e81" },
            { "PS", "\u0e94\u0eb4\u0e99\u0ec1\u0e94\u0e99 \u0e9b\u0eb2\u0ec0\u0ea5\u0eaa\u0e95\u0eb4\u0e99\u0ebd\u0e99" },
            { "Bali", "\u0e9a\u0eb2\u0ea5\u0eb5" },
            { "PT", "\u0e9e\u0ead\u0ea5\u0e97\u0eb9\u0ec2\u0e81" },
            { "PW", "\u0e9b\u0eb2\u0ea5\u0eb2\u0ea7" },
            { "nia", "\u0e99\u0eb5\u0ec8\u0ead\u0eb1\u0e94" },
            { "type.nu.greklow", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0ea3\u0eb5\u0e81\u0e95\u0ebb\u0ea7\u0e9e\u0eb4\u0ea1\u0e99\u0ec9\u0ead\u0e8d" },
            { "PY", "\u0e9e\u0eb2\u0ea3\u0eb2\u0e81\u0ea7\u0e8d" },
            { "tum", "\u0e95\u0eb3\u0e9a\u0eb9\u0e81\u0eb2" },
            { "Hebr", metaValue_he },
            { "QA", "\u0e81\u0eb2\u0e95\u0eb2" },
            { "%%SCOTLAND", "\u0e9e\u0eb2\u0eaa\u0eb2\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99\u0eaa\u0eb0\u0e81\u0eb1\u0ead\u0e94" },
            { "niu", "\u0e99\u0eb5\u0ec8\u0ead\u0eb9" },
            { "QO", "\u0ec0\u0e82\u0e94\u0eab\u0ec8\u0eb2\u0e87\u0ec4\u0e81\u0ec2\u0ead\u0e8a\u0eb5\u0ec0\u0e99\u0e8d" },
            { "lez", "\u0ea5\u0eb5\u0e8a\u0ebd\u0e99" },
            { "%%FONUPA", "\u0eaa\u0eb1\u0e94\u0e97\u0eb0\u0eaa\u0eb2\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99 UPA" },
            { "tvl", metaValue_TV },
            { "Tavt", "\u0ec4\u0e97\u0eab\u0ea7\u0ebd\u0e94" },
            { "001", "\u0ec2\u0ea5\u0e81" },
            { "002", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2" },
            { "003", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0ec0\u0edc\u0eb7\u0ead" },
            { "RE", "\u0ec0\u0ea3\u0ead\u0eb9\u0e99\u0eb4\u0e8d\u0ebb\u0e87" },
            { "005", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0ec3\u0e95\u0ec9" },
            { "jbo", "\u0ec2\u0ea5\u0e9a\u0e9a\u0eb1\u0e99" },
            { "Rjng", "\u0ec0\u0eae\u0e88\u0eb1\u0e87" },
            { "009", "\u0ec2\u0ead\u0e8a\u0eb5\u0ead\u0eb2\u0e99\u0eb5" },
            { "%%SURSILV", "\u0e8a\u0eb9\u0ea3\u0ecc\u0e8a\u0eb5\u0ea5\u0ecc" },
            { "RO", "\u0ec2\u0ea3\u0ec1\u0ea1\u0ec0\u0e99\u0e8d" },
            { "RS", "\u0ec0\u0e8a\u0eb5\u0ec0\u0e9a\u0e8d" },
            { "Mroo", "\u0ec0\u0ea1\u0ec2\u0eae" },
            { "RU", "\u0ea3\u0eb1\u0e94\u0ec0\u0e8a\u0e8d" },
            { "RW", "\u0ea3\u0ea7\u0eb1\u0e99\u0e94\u0eb2" },
            { "type.nu.talu", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e95\u0ea5\u0eb7\u0ec9\u0ec3\u0edd\u0ec8" },
            { "Mani", "\u0ea1\u0eb2\u0e99\u0eb4\u0ec1\u0e8a\u0e99" },
            { "Ugar", "\u0e8d\u0eb9\u0e81\u0eb2\u0eae\u0eb4\u0e94" },
            { "Khar", "\u0e82\u0ecd\u0ec2\u0eae\u0e81\u0eaa\u0eb5" },
            { "SA", "\u0e8a\u0eb2\u0ead\u0eb8\u0e94\u0eb4 \u0ead\u0eb2\u0ea3\u0eb2\u0ec0\u0e9a\u0e8d" },
            { "pon", "\u0e9e\u0ead\u0e99\u0ec0\u0e9e" },
            { "Mand", "\u0ec1\u0ea1\u0e99\u0e94\u0ebd\u0e99" },
            { "SB", "\u0eab\u0ea1\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0ec2\u0e8a\u0ec2\u0ea5\u0ea1\u0ead\u0e99" },
            { "twq", "\u0e95\u0eb2\u0e8a\u0eb2\u0ea7\u0eb1\u0e81" },
            { "011", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "SC", "\u0ec0\u0e8a\u0ec0\u0e8a\u0ea7\u0ec0\u0ea5\u0eaa" },
            { "SD", "\u0e8a\u0eb9\u0e94\u0eb2\u0e99" },
            { "013", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "SE", "\u0eaa\u0eb0\u0ea7\u0eb5\u0ec0\u0e94\u0eb1\u0e99" },
            { "014", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "arc", "\u0ead\u0eb2\u0ea5\u0eb2\u0ea1\u0eb4\u0e81" },
            { "Loma", "\u0ec2\u0ea5\u0ea1\u0eb2" },
            { "015", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0ec0\u0edc\u0eb7\u0ead" },
            { "SG", "\u0eaa\u0eb4\u0e87\u0e81\u0eb0\u0ec2\u0e9b" },
            { "SH", "\u0ec0\u0e8a\u0e99 \u0ec0\u0eae\u0ec0\u0ea5\u0e99\u0eb2" },
            { "type.lb.strict", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99\u0ec1\u0e9a\u0e9a\u0ec0\u0e84\u0eb1\u0ec8\u0e87\u0e84\u0eb1\u0e94" },
            { "017", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e81\u0eb2\u0e87" },
            { "SI", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ec0\u0ea7\u0ec0\u0e99\u0e8d" },
            { "018", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e95\u0ead\u0e99\u0ec3\u0e95\u0ec9" },
            { "SJ", "\u0eaa\u0eb0\u0ea7\u0eb2\u0e9a\u0eb2 \u0ec1\u0ea5\u0eb0 \u0ec1\u0ea2\u0e99 \u0ea1\u0eb2\u0ec0\u0ea2\u0e99" },
            { "019", "\u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb2" },
            { "SK", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ea7\u0eb2\u0ec0\u0e81\u0e8d" },
            { "Bamu", "\u0e9a\u0eb2\u0ea1\u0eb9\u0ea1" },
            { "Wole", "\u0ec2\u0ead\u0ea5\u0eb5\u0ec0\u0ead" },
            { "SL", "\u0ec0\u0e8a\u0e8d\u0ea3\u0eb2 \u0ea5\u0eb5\u0ec2\u0ead\u0e99" },
            { "SM", "\u0ec1\u0e8a\u0e99 \u0ea1\u0eb2\u0ea3\u0eb4\u0ec2\u0e99" },
            { "SN", "\u0ec0\u0e8a\u0e99\u0eb5\u0ec2\u0e81\u0ea5" },
            { "SO", "\u0ec2\u0e8a\u0ea1\u0eb2\u0ec0\u0ea5\u0e8d" },
            { "arn", "\u0ea1\u0eb2\u0e9e\u0eb8\u0e94\u0e8a\u0eb5" },
            { "arp", "\u0ead\u0eb2\u0ea3\u0eb2\u0e9b\u0eb2\u0ec2\u0eae" },
            { "type.nu.taml", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0ea1\u0eb4\u0ea5\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "SR", "\u0e8a\u0eb9\u0ea3\u0eb4\u0e99\u0eb2\u0ea1" },
            { "SS", "\u0e8a\u0eb9\u0e94\u0eb2\u0e99\u0ec3\u0e95\u0ec9" },
            { "ST", "\u0ec0\u0e8a\u0ebb\u0eb2\u0e97\u0eb9\u0ec0\u0ea1 \u0ec1\u0ea5\u0eb0 \u0e9e\u0ea3\u0eb4\u0e99\u0e8a\u0eb4\u0e9a" },
            { "SV", "\u0ec0\u0ead\u0ea7 \u0e8a\u0ecd\u0ea7\u0eb2\u0e94\u0ecd" },
            { "SX", "\u0e8a\u0eb4\u0e99 \u0ea1\u0eb2\u0ec0\u0e97\u0eb1\u0e99" },
            { "SY", "\u0e8a\u0eb5\u0ec0\u0ea3\u0e8d" },
            { "yao", "\u0ec0\u0ea2\u0ebb\u0ec9\u0eb2" },
            { "SZ", "\u200b\u0ec0\u0ead\u200b\u0eaa\u0eb0\u200b\u0ea7\u0eb2\u200b\u0e95\u0eb4\u200b\u0e99\u0eb5" },
            { "arw", "\u0ead\u0eb2\u0ea3\u0eb2\u0ec1\u0ea7\u0e81" },
            { "yap", "\u0ea2\u0eb1\u0e9a" },
            { "TA", "\u0e97\u0ea3\u0eb4\u0eaa\u0e95\u0eb1\u0e99 \u0e94\u0eb2 \u0e81\u0eb1\u0e99\u0eae\u0eb2" },
            { "asa", "\u0ead\u0eb2\u0e8a\u0eb9" },
            { "type.ms.ussystem", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0e81\u0eb2\u0e99\u0ea7\u0eb1\u0e94\u0ec1\u0e97\u0e81\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94" },
            { "021", "\u0e9e\u0eb2\u0e81\u0ec0\u0edc\u0eb7\u0ead\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb5\u0e81\u0eb2" },
            { "TC", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0e97\u0eb5\u0e81 \u0ec1\u0ea5\u0eb0 \u0ec4\u0e84\u0ec2\u0e84\u0eaa" },
            { "yav", "\u0ec1\u0e8d\u0e87\u0ec0\u0e9a\u0e99" },
            { "TD", "\u0e8a\u0eb2\u0e94" },
            { "TF", "\u0ec0\u0e82\u0e94\u0ec1\u0e94\u0e99\u0e97\u0eb2\u0e87\u0ec3\u0e95\u0ec9\u0e82\u0ead\u0e9d\u0eae\u0eb1\u0ec8\u0e87" },
            { "TG", "\u0ec2\u0e95\u0ec2\u0e81" },
            { "TH", metaValue_TH },
            { "TJ", "\u0e97\u0eb2\u0e88\u0eb4\u0e81\u0eb4\u0e94\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "TK", metaValue_TK },
            { "029", "\u0e84\u0eb2\u0ea3\u0eb4\u0e9a\u0e9a\u0ebd\u0e99" },
            { "TL", "\u0e97\u0eb4\u0ea1\u0ecd-\u0ec0\u0ea5\u0eaa\u0ec0\u0e95" },
            { "ybb", "\u0ec1\u0ea2\u0ea1\u0e9a\u0eb2" },
            { "type.co.searchjl", "\u0e84\u0ebb\u0ec9\u0e99\u0eab\u0eb2\u0e95\u0eb2\u0ea1\u0e9e\u0eb0\u0e8d\u0eb1\u0e99\u0e8a\u0eb0\u0e99\u0eb0\u0e82\u0eb6\u0ec9\u0e99\u0e95\u0ebb\u0ec9\u0e99\u0e97\u0eb5\u0ec8\u0ec0\u0e9b\u0eb1\u0e99\u0eae\u0eb1\u0e87\u0e81\u0eb5\u0ea3" },
            { "TM", "\u0ec0\u0e97\u0eb5\u0e81\u0ec0\u0ea1\u0e99\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "%%BOONT", "\u0e9a\u0eb9\u0e99\u0e97\u0ea5\u0eb4\u0ec8\u0e87" },
            { "TN", "\u0e95\u0eb9\u0e99\u0eb4\u0ec0\u0e8a\u0e8d" },
            { "TO", "\u0e97\u0ead\u0e87\u0e81\u0eb2" },
            { "TR", "\u0ec0\u0e97\u0eb5\u0e84\u0eb5" },
            { "TT", "\u0e97\u0ea3\u0eb4\u0e99\u0eb4\u0ec1\u0e94\u0e94 \u0ec1\u0ea5\u0eb0 \u0ec2\u0e97\u0ec1\u0e9a\u0ec2\u0e81" },
            { "TV", metaValue_TV },
            { "TW", "\u0ec4\u0e95\u0ec9\u0eab\u0ea7\u0eb1\u0e99" },
            { "ast", "\u0ead\u0eb1\u0eaa\u0e95\u0eb9\u0eae\u0ebd\u0e99" },
            { "Orkh", "\u0ead\u0ead\u0e81\u0eaa\u0ea1\u0eb1\u0e99\u0e8d\u0eb2" },
            { "TZ", "\u0e97\u0eb2\u0e99\u0e8a\u0eb2\u0ec0\u0e99\u0e8d" },
            { "nmg", "\u0e81\u0ea7\u0eb2\u0e8a\u0eb5\u0ec2\u0ead" },
            { "Zzzz", "\u0ec1\u0e9a\u0e9a\u0e82\u0ebd\u0e99\u0e97\u0eb5\u0ec8\u0e9a\u0ecd\u0ec8\u0eae\u0eb9\u0ec9\u0e88\u0eb1\u0e81" },
            { "Sind", "\u0e94\u0eb8\u0e94\u0eb2\u0ea7\u0eb2\u0e94\u0eb5" },
            { "UA", "\u0ea2\u0eb9\u0ec0\u0e84\u0ea3\u0e99" },
            { "rup", "\u0ead\u0eb2\u0ec2\u0ea3\u0ea1\u0eb2\u0e99\u0ebd\u0e99" },
            { "030", "\u0ead\u0eb2\u0e8a\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "tyv", "\u0e95\u0eb9\u0ea7\u0eb5\u0e99\u0ebd\u0e99" },
            { "sw_CD", "\u0e84\u0ead\u0e87\u0ec2\u0e81 \u0e8a\u0ea7\u0eb2\u0eae\u0eb5\u0ea5\u0eb4" },
            { "034", "\u0ead\u0eb2\u0e8a\u0eb5\u0ec4\u0e95\u0ec9" },
            { "hai", "\u0ec4\u0eae\u0e94\u0eb2" },
            { "035", "\u0ead\u0eb2\u0e8a\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81\u0eaa\u0ec8\u0ebd\u0e87\u0ec4\u0e95\u0ec9" },
            { "UG", "\u0ead\u0eb9\u0e81\u0eb2\u0e99\u0e94\u0eb2" },
            { "type.co.pinyin", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0e81\u0eb2\u0e99\u0ead\u0ead\u0e81\u0eaa\u0ebd\u0e87\u0e9e\u0eb2\u0eaa\u0eb2\u0e88\u0eb5\u0e99" },
            { "039", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0ec3\u0e95\u0ec9" },
            { "Sinh", metaValue_si },
            { "UM", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0\u0eae\u0ead\u0e9a\u0e99\u0ead\u0e81\u0e82\u0ead\u0e87\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94\u0eaf" },
            { "UN", "\u0eaa\u0eb0\u0eab\u0eb0\u0e9b\u0eb0\u0e8a\u0eb2\u0e8a\u0eb2\u0e94" },
            { "US", "\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94" },
            { "haw", "\u0eae\u0eb2\u0ec4\u0ea7\u0ead\u0ebd\u0e99" },
            { "%%1959ACAD", "\u0ea7\u0eb4\u0e8a\u0eb2\u0e81\u0eb2\u0e99" },
            { "type.co.gb2312han", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0e88\u0eb5\u0e99\u0e9b\u0eb0\u0e8d\u0eb8\u0e81" },
            { "UY", "\u0ead\u0eb9\u0ea3\u0eb8\u0e81\u0ea7\u0e8d" },
            { "prg", "\u0e9b\u0ea3\u0eb1\u0eaa\u0e8a\u0ebd\u0e99" },
            { "UZ", "\u0ead\u0eb8\u0eaa\u0ec0\u0e9a\u0e81\u0eb4\u0eaa\u0eb0\u0e96\u0eb2\u0e99" },
            { "tzm", "\u0ead\u0eb1\u0e94\u0ea5\u0eb2\u0eaa \u0e97\u0eb2\u0ea1\u0eb2\u0e8a\u0eb5\u0e81 \u0e81\u0eb2\u0e87" },
            { "type.co.stroke", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0e81\u0eb2\u0e99\u0ea5\u0eb2\u0e81\u0ec0\u0eaa\u0eb1\u0ec9\u0e99" },
            { "nnh", "\u0e88\u0eb5\u0ec8\u0ea1\u0e9a\u0eb9\u0e99" },
            { "VA", "\u0e99\u0eb0\u0e84\u0ead\u0e99 \u0ea7\u0eb2\u0e95\u0eb4\u0e81\u0eb1\u0e99" },
            { "pro", "\u0ec2\u0e9b\u0ea7\u0ead\u0e87\u0e8a\u0eb2\u0e99\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "VC", "\u0ec0\u0e8a\u0e99 \u0ea7\u0eb4\u0e99\u0ec0\u0e8a\u0e99 \u0ec1\u0ea5\u0eb0 \u0ec0\u0e81\u0ea3\u0ec0\u0e99\u0e94\u0eb4\u0e99" },
            { "VE", "\u0ec0\u0ea7\u0ec0\u0e99\u0e8a\u0eb9\u0ec0\u0ead\u0ea5\u0eb2" },
            { "VG", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0ea7\u0eb5\u0e88\u0eb4\u0e99\u0e82\u0ead\u0e87\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94" },
            { "VI", "\u0edd\u0eb9\u0ec8\u0ec0\u0e81\u0eb2\u0eb0 \u0ec0\u0ea7\u0eb5\u0e88\u0eb4\u0e99 \u0e82\u0ead\u0e87\u0eaa\u0eb0\u0eab\u0eb0\u0ea5\u0eb1\u0e94" },
            { "VN", metaValue_VN },
            { "VU", "\u0ea7\u0eb2\u0e99\u0ebb\u0ea7\u0e95\u0eb9" },
            { "nog", "\u0e99\u0ecd\u0ec4\u0e81" },
            { "rwk", "\u0ead\u0eb2\u0ea3\u0ea7\u0eb2" },
            { "non", "\u0e99\u0ecd\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "053", "\u0ec2\u0ead\u0e94\u0eaa\u0eb0\u0e95\u0eb2\u0ea5\u0eb5" },
            { "%%AREVMDA", "\u0ead\u0eb2\u0ec0\u0ea1\u0ec0\u0e99\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "054", "\u0ec0\u0ea1\u0ea5\u0eb2\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "WF", "\u0ea7\u0eb2\u0ea5\u0ea5\u0eb4\u0eaa \u0ec1\u0ea5\u0eb0 \u0e9f\u0eb9\u0e95\u0eb9\u0e99\u0eb2" },
            { "type.co.traditional", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "057", "\u0ec0\u0e82\u0e94\u0ec4\u0ea1\u0ec2\u0e84\u0ea3\u0ec0\u0e99\u0e8a\u0ebd\u0e99" },
            { "jgo", "\u0e87\u0ead\u0ea1\u0e9a\u0eb2" },
            { "lkt", "\u0ea5\u0eb2\u0ec2\u0e81\u0e95\u0eb2" },
            { "%%HEPBURN", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec1\u0e9a\u0e9a\u0ec0\u0eae\u0e9a\u0ec0\u0e9a\u0eb4\u0e99" },
            { "wae", "\u0ea7\u0eb2\u0ec0\u0e8a\u0eb5" },
            { "WS", metaValue_WS },
            { "Bass", "\u0e9a\u0eb1\u0e94\u0e8a\u0eb2" },
            { "type.nu.mtei", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ea1\u0ec4\u0e95\u0ea1\u0eb2\u0ec0\u0ea2\u0e81" },
            { "wal", "\u0ea7\u0eb2\u0ea5\u0eb2\u0ec2\u0ea1" },
            { "was", "\u0ea7\u0eb2\u0ec2\u0e8a" },
            { "war", "\u0ea7\u0eb2\u0ec0\u0ea5" },
            { "awa", "\u0ead\u0eb2\u0ea7\u0eb2\u0eae\u0eb4" },
            { "061", "\u0ec2\u0e9e\u0ea5\u0eb5\u0e99\u0eb5\u0ec0\u0e8a\u0e8d" },
            { "XK", "\u0ec2\u0e84\u0ec2\u0e8a\u0ec2\u0ea7" },
            { "Gujr", "\u0e88\u0eb9\u0e88\u0eb2\u0ea3\u0eb2\u0e97\u0eb5" },
            { "Zxxx", "\u0e9a\u0ecd\u0ec8\u0ea1\u0eb5\u0e9e\u0eb2\u0eaa\u0eb2\u0e82\u0ebd\u0e99" },
            { "Olck", "\u0ec2\u0ead\u0e8a\u0eb4\u0e81\u0eb4" },
            { "wbp", "\u0ea7\u0eb2\u0ea3\u0e9e\u0eb4\u0ea3\u0eb4" },
            { "Batk", "\u0e9a\u0eb2\u0e95\u0eb1\u0e81" },
            { "Blis", "\u0e9a\u0ea5\u0eb4\u0e81\u0e8a\u0eb4\u0ea1\u0ec2\u0e9a\u0ea5\u0eaa" },
            { "YE", "\u0ec0\u0ea2\u0ec0\u0ea1\u0e99" },
            { "nqo", metaValue_nqo },
            { "type.co.standard", "\u0eae\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "fan", "\u0ec1\u0e9f\u0e87" },
            { "%%ROZAJ", "\u0ec0\u0ea3\u0e8a\u0ec8\u0ebd\u0e99" },
            { "%%SUTSILV", "\u0e8a\u0eb8\u0e95\u0ecc\u0e8a\u0eb5\u0ea5\u0ecc" },
            { "fat", "\u0ec1\u0e9f\u0e99\u0e95\u0eb5" },
            { "Sgnw", "\u0ec4\u0e8a\u0e99\u0ecc\u0ec4\u0eae\u0e95\u0eb5\u0ec9\u0e87" },
            { "YT", "\u0ea1\u0eb2\u0ea2\u0eb1\u0ead\u0e94" },
            { "type.nu.cham", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0ea3\u0eb2\u0ea1" },
            { "ZA", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0ec3\u0e95\u0ec9" },
            { "type.nu.sund", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0eb8\u0e99\u0e94\u0eb2" },
            { "type.lb.loose", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99\u0ec1\u0e9a\u0e9a\u0eab\u0ebc\u0ea7\u0ea1" },
            { "Deva", "\u0e94\u0eb5\u0ea7\u0eb2\u0e99\u0eb2\u0e81\u0eb2\u0ea3\u0eb5" },
            { "type.nu.geor", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0ecd\u0e88\u0ebd\u0e99" },
            { "Hira", "\u0ea3\u0eb4\u0ea3\u0eb0\u0e87\u0eb0\u0e99\u0eb0" },
            { "ZM", "\u0ec1\u0e8a\u0ea1\u0ec0\u0e9a\u0e8d" },
            { "%%PINYIN", "\u0e9e\u0eb4\u0e99\u0ea2\u0eb4\u0e99" },
            { "ZW", "\u0e8a\u0eb4\u0ea1\u0e9a\u0eb1\u0e9a\u0ec0\u0ea7" },
            { "ZZ", "\u0e82\u0ebb\u0e87\u0ec0\u0e82\u0e94\u0e97\u0eb5\u0ec8\u0e9a\u0ecd\u0ec8\u0eae\u0eb9\u0ec9\u0e88\u0eb1\u0e81" },
            { "Runr", "\u0eae\u0eb9\u0e99\u0eb4\u0e81" },
            { "type.ms.metric", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0ec0\u0ea1\u0e97\u0ea3\u0eb4\u0e81" },
            { "type.ca.iso8601", "\u0e9b\u0eb0\u200b\u0e95\u0eb4\u200b\u0e97\u0eb4\u0e99 ISO-8601" },
            { "lol", "\u0ec1\u0ea1\u0eb1\u0e87\u0ec2\u0e81\u0ec9" },
            { "nso", "\u0ec2\u0e8a\u0ec2\u0e97\u0ec0\u0edc\u0eb7\u0ead" },
            { "type.nu.telu", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0e95\u0ea5\u0eb9\u0e81\u0eb9" },
            { "loz", "\u0ec2\u0ea5\u0e8a\u0eb4" },
            { "Nkgb", "\u0e81\u0eb5\u0e9a\u0eb2-\u0e99\u0eb2\u0e8a\u0eb5" },
            { "jmc", "\u0ea1\u0eb2\u0ec1\u0e8a\u0ea1" },
            { "type.nu.hansfin", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0e87\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d\u0e82\u0ead\u0e87\u0e88\u0eb5\u0e99" },
            { "hil", "\u0eae\u0eb4\u0ea3\u0eb4\u0ec4\u0e81\u0e99\u0ead\u0e99" },
            { "type.nu.arabext", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81-\u0ead\u0eb4\u0e99\u0e94\u0eb4\u0e81\u0e95\u0ebb\u0ea7\u0ec0\u0e95\u0eb1\u0ea1" },
            { "nus", "\u0ec0\u0e99\u0eb5" },
            { "dak", "\u0e94\u0eb2\u0ec2\u0e81\u0e95\u0eb2" },
            { "type.nu.fullwide", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e84\u0ea7\u0eb2\u0ea1\u0e81\u0ea7\u0ec9\u0eb2\u0e87\u0ec0\u0e95\u0eb1\u0ea1" },
            { "hit", "\u0eae\u0eb4\u0e94\u0ec4\u0e95" },
            { "dar", "\u0e94\u0eb2\u0e81\u0ea7\u0eb2" },
            { "dav", "\u0ec4\u0e95\u0e95\u0eb2" },
            { "Maya", "\u0ea1\u0eb2\u0e8d\u0eb2\u0ec4\u0eae\u0ec2\u0eae\u0e81\u0ea5\u0eb4\u0e9a" },
            { "lrc", "\u0ea5\u0eb9\u0ea3\u0eb4 \u0e97\u0eb2\u0e87\u0e95\u0ead\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "Copt", metaValue_cop },
            { "nwc", "\u0ec0\u0e99\u0ea7\u0eb2\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "udm", "\u0ead\u0eb8\u0e94\u0ea1\u0eb1\u0e94" },
            { "Khmr", "\u0e82\u0eb0\u0ec1\u0ea1" },
            { "Limb", "\u0ea5\u0eb4\u0ea1\u0e9a\u0eb9" },
            { "sad", "\u0e8a\u0eb1\u0e99\u0e94\u0eb2\u0ea7" },
            { "type.nu.roman", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ea3\u0ea1\u0eb1\u0e99" },
            { "sah", "\u0e8a\u0eb2\u0e81\u0eb2" },
            { "sam", "\u0eaa\u0eb2\u0ea1\u0eb2\u0ea3\u0eb4\u0ec1\u0e95\u0e99-" },
            { "%%SCOUSE", "\u0eaa\u0eb0\u0ec0\u0e81\u0ebb\u0eb2\u0eaa\u0ecc" },
            { "saq", "\u0e8a\u0eb3\u0e9a\u0eb9\u0ea3\u0eb9" },
            { "sas", "\u0e8a\u0eb2\u0e8a\u0eb1\u0e81" },
            { "sat", "\u0e8a\u0eb2\u0e99\u0e97\u0eb2\u0ea5\u0eb4" },
            { "Tfng", "\u0e97\u0eb5\u0e9f\u0eb5\u0e99\u0eb2\u0e81" },
            { "jpr", "\u0e88\u0eb9\u0ec1\u0e94\u0ea7-\u0ec0\u0e9e\u0eb5\u0e8a\u0ebd\u0e99" },
            { "sba", "\u0e81\u0eb3\u0ec0\u0e9a" },
            { "Guru", "\u0e81\u0ebb\u0ea7\u0ea1\u0eb9\u0e84\u0eb5" },
            { "%%ALUKU", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ead\u0ea5\u0eb9\u0e84\u0eb8" },
            { "lua", "\u0ea5\u0eb9\u0e9a\u0eb2-\u0ea5\u0eb9\u0ea5\u0ebb\u0ea7" },
            { "%%BISCAYAN", "\u0e9a\u0eb4\u0eaa\u0e84\u0eb2\u0e8d\u0eb1\u0e99" },
            { "sbp", "\u0e8a\u0eb2\u0e99\u0e81\u0eb9" },
            { "lui", "\u0ea5\u0eb9\u0ec0\u0e8a\u0ec2\u0e99" },
            { "nyn", "\u0e99\u0eb2\u0e99\u0e84\u0ead\u0e99" },
            { "nym", "\u0e99\u0eb2\u0ea1\u0ea7\u0eb5\u0e8a\u0eb4" },
            { "lun", "\u0ea5\u0eb8\u0e99\u0e94\u0eb2" },
            { "nyo", "\u0ec2\u0e99\u0ec2\u0ea3" },
            { "luo", "\u0ea5\u0ebb\u0ea7" },
            { "fil", "\u0e9f\u0eb5\u0ea5\u0eb4\u0e9b\u0eb5\u0ec2\u0e99" },
            { "hmn", "\u0ea1\u0ead\u0e87" },
            { "del", "\u0ec0\u0e94\u0ea5\u0eb2\u0ea7\u0eb2" },
            { "lus", "\u0ea5\u0eb9\u0ec4\u0e8a" },
            { "bal", "\u0e9a\u0eb2\u0ea5\u0eb9\u0e8a\u0eb5" },
            { "den", "\u0e8a\u0eb5\u0ec0\u0ea5\u0eb1\u0e9a" },
            { "ban", "\u0e9a\u0eb2\u0ea5\u0eb5\u0ec0\u0e99\u0eb1\u0e94" },
            { "uga", "\u0ea2\u0eb9\u0e81\u0eb2\u0ea5\u0eb4\u0e81" },
            { "luy", "\u0ea5\u0eb9\u0ec4\u0e8d" },
            { "bas", "\u0e9a\u0eb2\u0e8a\u0eb2" },
            { "bax", "\u0e9a\u0eb2\u0ea1\u0eb8\u0e99" },
            { "jrb", "\u0e88\u0eb9\u0ec1\u0e94\u0ea7-\u0ead\u0eb2\u0ea5\u0eb2\u0e9a\u0eb4\u0e81" },
            { "es_ES", "\u0eaa\u0eb0\u0ec0\u0e9b\u0eb1\u0e99 \u0ea2\u0eb8\u0ec2\u0ea3\u0e9a" },
            { "nzi", "\u0e99\u0eb4\u0ea1\u0eb2" },
            { "sco", "\u0eaa\u0e81\u0ead\u0e94" },
            { "scn", "\u0e8a\u0eb5\u0e8a\u0eb4\u0ea5\u0eb5\u0e99" },
            { "aa", "\u0ead\u0eb0\u0e9f\u0eb2" },
            { "ab", "\u0ec1\u0ead\u0e9a\u0e84\u0eb2\u0e8a\u0ebd\u0e99" },
            { "ae", "\u0ead\u0eb2\u0ec0\u0ea7\u0eb1\u0eaa\u0ec1\u0e95\u0e99" },
            { "af", "\u0ead\u0eb2\u0e9f\u0ea3\u0eb4\u0e81\u0eb2\u0e99" },
            { "ak", "\u0ead\u0eb2\u0e81\u0eb2\u0e99" },
            { "bbj", "\u0ec2\u0e84\u0ea1\u0eb2\u0ea5\u0eb2" },
            { "am", "\u0ead\u0eb3\u0eae\u0eb2\u0ea3\u0eb4\u0e81" },
            { "an", "\u0ead\u0eb2\u0ea3\u0eb2\u0ec2\u0e81\u0ec0\u0e99\u0eb1\u0e94" },
            { "Arab", "\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81" },
            { "%%SOLBA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0eaa\u0eb0\u0ec2\u0e95\u0ea7\u0eb4\u0e8a\u0ecc\u0e8a\u0ec8\u0eb2/\u0ec2\u0e8a\u0ea5\u0ecc\u0e9a\u0eb5\u0e81\u0eb2" },
            { "Jpan", metaValue_JP },
            { "ar", "\u0ead\u0eb2\u0ea3\u0eb1\u0e9a" },
            { "Hrkt", "\u0e95\u0eb2\u0e95\u0eb2\u0ea5\u0eb2\u0e87\u0e9e\u0eb0\u0e8d\u0eb2\u0e87\u0e9e\u0eb2\u0eaa\u0eb2\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "as", "\u0ead\u0eb1\u0eaa\u0e8a\u0eb2\u0ea1\u0eb5\u0eaa" },
            { "Lina", "\u0ea5\u0eb5\u0ec0\u0e99\u0e8d" },
            { "av", "\u0ead\u0eb2\u0ea7\u0eb2\u0ea3\u0eb4\u0e81" },
            { "Linb", "\u0ea5\u0eb5\u0ec0\u0e99\u0e8d\u0ea3" },
            { "sdh", "\u0e9e\u0eb2\u0e81\u0ec4\u0e95\u0ec9 \u0e82\u0ead\u0e87 \u0e81\u0eb9\u0e94\u0eb4\u0e94" },
            { "ay", "\u0ead\u0eb2\u0e8d\u0ea1\u0eb2\u0ea5\u0eb2" },
            { "az", "\u0ead\u0eb2\u0ec0\u0e8a\u0eb5\u0ec4\u0e9a\u0e88\u0eb2\u0e99\u0eb4" },
            { "Khoj", "\u0e84\u0ecd\u0e88\u0e84\u0eb5" },
            { "%%OSOJS", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ec2\u0ead\u0e8a\u0ebd\u0e81\u0ec2\u0e84/\u0ec2\u0ead\u0ec2\u0e8a\u0e8d\u0eb2\u0ec0\u0e99" },
            { "ba", "\u0e9a\u0eb2\u0ea3\u0e81\u0eb5" },
            { "type.co.unihan", "\u0ea5\u0ebd\u0e87\u0ea5\u0eb3\u0e94\u0eb1\u0e9a\u0e95\u0eb2\u0ea1\u0e88\u0eb3\u0e99\u0ea7\u0e99\u0e82\u0eb5\u0e94" },
            { "be", "\u0ec0\u0e9a\u0ea5\u0eb2\u0ea3\u0eb1\u0eaa\u0e8a\u0ebd\u0e99" },
            { "bg", "\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0ebd\u0e99" },
            { "bi", "\u0e9a\u0eb4\u0eaa\u0ea5\u0eb0\u0ea1\u0eb2" },
            { "type.nu.java", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0ebb\u0ea7" },
            { "bm", "\u0e9a\u0eb2\u0ea1\u0e9a\u0eb2\u0ea3\u0eb2" },
            { "bn", "\u0ec0\u0e9a\u0eb1\u0e87\u0e81\u0eb2\u0ea5\u0eb5" },
            { "bo", metaValue_bo },
            { "dgr", "\u0ec2\u0e94\u0e81\u0ea3\u0eb4\u0e9a" },
            { "br", "\u0ec0\u0e9a\u0ea3\u0e95\u0eb1\u0e99" },
            { "bs", "\u0e9a\u0ead\u0eaa\u0e99\u0ebd\u0e99" },
            { "see", "\u0e8a\u0eb5\u0e99\u0eb5\u0e81\u0eb2" },
            { "Mymr", metaValue_my },
            { "type.nu.laoo", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea5\u0eb2\u0ea7" },
            { "seh", "\u0e8a\u0eb5\u0e99\u0eb2" },
            { "Nkoo", metaValue_nqo },
            { "sel", "\u0ec0\u0e8a\u0e99\u0e84\u0eb1\u0e9a" },
            { "ca", "\u0e84\u0eb2\u0e95\u0eb2\u0ea5\u0eb2\u0e99" },
            { "ses", "\u0ec2\u0e84\u0e8d\u0ea3\u0eb2\u0ec2\u0e9a\u0ec2\u0ea3 \u0ec0\u0e8a\u0e99\u0e99\u0eb4" },
            { "ce", "\u0e8a\u0eb5\u0ec0\u0e84\u0e99" },
            { "ch", "\u0e8a\u0eb2\u0ea1\u0ecd\u0ec2\u0ea3" },
            { "%%REVISED", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0eaa\u0eb0\u0e9a\u0eb1\u0e9a\u0e9b\u0eb1\u0e9a\u0e9b\u0eb8\u0e87" },
            { "co", "\u0e84\u0ecd\u0e8a\u0eb4\u0e81\u0eb2" },
            { "Orya", "\u0ec2\u0ead\u0ec0\u0e94\u0e8d" },
            { "cr", "\u0e84\u0eb5" },
            { "cs", "\u0ec0\u0e8a\u0e81" },
            { "cu", "\u0ec2\u0e9a\u0e94\u0eaa\u0ea5\u0eb2\u0ea7\u0eb4\u0e81" },
            { "cv", "\u0e8a\u0eb9\u0ea7\u0eb2\u0e8a" },
            { "cy", "\u0ec0\u0ea7\u0ea7" },
            { "type.nu.ethi", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0e9b\u0eb4\u0e81" },
            { "Yiii", "\u0e8d\u0eb5" },
            { "da", "\u0ec1\u0e94\u0e99\u0eb4\u0e8a" },
            { "pt_PT", "\u0e9b\u0ead\u0e81\u0e95\u0eb8\u0e8d\u0e81\u0eb4\u0eaa \u0ea2\u0eb8\u0ec2\u0ea3\u0e9a" },
            { "de", metaValue_DE },
            { "type.cf.standard", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "bej", "\u0e9a\u0eb5\u0ec0\u0e88" },
            { "din", "\u0e94\u0eb4\u0e99\u0e81\u0eb2" },
            { "Bugi", "\u0e9a\u0eb9\u0e81\u0eb4\u0eaa" },
            { "bem", "\u0ec0\u0e9a\u0eb1\u0ea1\u0e9a\u0eb2" },
            { "sga", "\u0ead\u0eb5\u0ea3\u0eb4\u0e8a\u0ec0\u0e81\u0ebb\u0ec8\u0eb2" },
            { "type.nu.mong", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea1\u0ec8\u0ead\u0e87\u0ec2\u0e81\u0ec0\u0ea5\u0e8d" },
            { "dv", "\u0e94\u0eb5\u0ea7\u0eb5\u0eae\u0eb5" },
            { "es_419", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99 \u0ead\u0eb2\u0ec0\u0ea1\u0ea3\u0eb4\u0e81\u0eb1\u0e99 \u0eaa\u0eb0\u0ec1\u0e9b\u0e99\u0e99\u0eb4\u0e8a" },
            { "dz", "\u0e94\u0eb5\u0e8a\u0ead\u0e87\u0e84\u0eb2" },
            { "bez", "\u0e9a\u0eb5\u0e99\u0eb2" },
            { "type.ca.chinese", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e88\u0eb5\u0e99" },
            { "Lisu", "\u0ec0\u0e9f\u0ea3\u0ec0\u0e8a\u0eae" },
            { "dje", "\u0e8a\u0eb2\u0ea1\u0eb2" },
            { "type.nu.grek", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0ea3\u0eb5\u0e81" },
            { "ee", "\u0ead\u0eb4\u0ea7\u0eb2" },
            { "bfd", "\u0e9a\u0eb2\u0e9f\u0eb1\u0e94" },
            { "type.lb.normal", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99\u0ec1\u0e9a\u0e9a\u0e9b\u0ebb\u0e81\u0e81\u0eb0\u0e95\u0eb4" },
            { "ro_MD", "\u0ec2\u0ea1\u0e94\u0eb2\u0ea7\u0ebd\u0e99" },
            { "el", metaValue_el },
            { "en", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94" },
            { "eo", "\u0ec0\u0ead\u0eaa\u0e9b\u0eb2\u0e8d" },
            { "type.co.big5han", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0e88\u0eb5\u0e99\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "es", "\u0eaa\u0eb0\u0ec1\u0e9b\u0e99\u0e99\u0eb4\u0e8a" },
            { "et", "\u0ec0\u0ead\u0eaa\u0ec2\u0e95\u0e99\u0ebd\u0e99" },
            { "Hanb", "\u0eae\u0eb1\u0e99" },
            { "eu", "\u0e9a\u0eb1\u0eaa\u0e81\u0eb5" },
            { "Buhd", "\u0e9a\u0eb9\u0eae\u0eb4\u0e94" },
            { "Hang", "\u0eae\u0eb1\u0e99\u0e81\u0eb9\u0e99" },
            { "Samr", "\u0e8a\u0eb2\u0ea1\u0eb2\u0ec0\u0ea5\u0e8d" },
            { "shi", "\u0e97\u0eb2\u0ec0\u0e8a\u0ea7\u0eab\u0eb4\u0e94" },
            { "hsb", "\u0e8a\u0ecd\u0e9a\u0ebd\u0e99 \u0e97\u0eb2\u0e87\u0e95\u0ead\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "Hani", "\u0eae\u0eb2\u0e99" },
            { "%%ULSTER", "\u0ead\u0eb1\u0ea5\u0eaa\u0eb0\u0ec0\u0e95\u0eb5" },
            { "shn", "\u0e8a\u0eb2\u0e99" },
            { "Hano", "\u0eae\u0eb2\u0e99\u0eb9\u0ec2\u0e99\u0ec2\u0ead" },
            { "fa", "\u0ec0\u0e9b\u0eb5\u0e8a\u0ebd\u0e99" },
            { "Hans", "\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d" },
            { "type.nu.latn", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "Hant", "\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "ff", "\u0e9f\u0eb9\u0ea5\u0eb2" },
            { "shu", "\u0ead\u0eb2\u0ea5\u0eb1\u0e9a-\u0e8a\u0eb2\u0e94" },
            { "fi", "\u0e9f\u0eb4\u0e99\u0e99\u0eb4\u0e8a" },
            { "fj", "\u0e9f\u0eb4\u0e88\u0ebd\u0e99" },
            { "fon", "\u0e9f\u0ead\u0e99" },
            { "bgn", "\u0e9a\u0eb2\u0ec2\u0ea5\u0e88\u0eb5 \u0e9e\u0eb2\u0e81\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "yue", "\u0e81\u0ea7\u0eb2\u0e87\u0e95\u0eb8\u0ec9\u0e87" },
            { "fo", "\u0e9f\u0eb2\u0ec2\u0ea3\u0eaa" },
            { "umb", "\u0ead\u0eb3\u0e9a\u0eb1\u0e99\u0e94\u0eb9" },
            { "fr", metaValue_FR },
            { "sid", "\u0e8a\u0eb4\u0e94\u0eb2\u0ec2\u0ea1" },
            { "fy", "\u0e9f\u0ea3\u0eb4\u0e8a\u0ebd\u0e99 \u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "ga", "\u0ec4\u0ead\u0ea3\u0eb4\u0eaa" },
            { "gd", "\u0eaa\u0eb0\u0e81\u0eb1\u0ead\u0e94\u0ec0\u0e81\u0ea5\u0eb4\u0e81" },
            { "gl", "\u0e81\u0eb2\u0ea5\u0eb4\u0e8a\u0ebd\u0e99" },
            { "gn", "\u0e81\u0ebb\u0ea7\u0ea3\u0eb2\u0e99\u0eb5" },
            { "bho", "\u0ec2\u0e9a\u0e9e\u0eb9\u0ea3\u0eb4" },
            { "und", "\u0e9a\u0ecd\u0ec8\u0eaa\u0eb2\u0ea1\u0eb2\u0e94\u0ea5\u0eb0\u0e9a\u0eb8\u0e9e\u0eb2\u0eaa\u0eb2" },
            { "type.ca.ethiopic-amete-alem", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e9b\u0eb5\u0ec2\u0ead\u0ec0\u0ead\u0e97\u0eb4\u0ec2\u0ead\u0ec0\u0e9b\u0e8d" },
            { "gu", "\u0e81\u0eb9\u0e88\u0eb2\u0ea3\u0eb2\u0e95\u0eb4" },
            { "gv", "\u0ec1\u0ea1\u0e87\u0e8a\u0ecc" },
            { "ha", "\u0ec0\u0eae\u0ebb\u0eb2\u0e8a\u0eb2" },
            { "he", metaValue_he },
            { "hi", "\u0eae\u0eb4\u0e99\u0e94\u0eb4" },
            { "hup", "\u0eae\u0eb9\u0e9b\u0eb2" },
            { "bik", "\u0e9a\u0eb5\u0e84\u0ead\u0e99" },
            { "bin", "\u0e9a\u0eb5\u0e99\u0eb5" },
            { "ho", "\u0eae\u0eb4\u0ea3\u0eb4\u0ec2\u0ea1\u0e95\u0eb9" },
            { "hr", "\u0ec2\u0e84\u0ea3\u0ec0\u0ead\u0e97\u0ebd\u0e99" },
            { "ht", "\u0ec4\u0eae\u0e95\u0ebd\u0e99" },
            { "hu", "\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0ea3\u0ebd\u0e99" },
            { "hy", metaValue_hy },
            { "hz", "\u0ec0\u0eae\u0eb4\u0eae\u0eb4\u0ec2\u0ea3" },
            { "%%FONIPA", "\u0eaa\u0eb1\u0e94\u0e97\u0eb0\u0eaa\u0eb2\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0eaa\u0eb2\u0e81\u0ebb\u0e99" },
            { "ia", "\u0ead\u0eb4\u0e99\u0ec0\u0e95\u0eb5\u0ea5\u0eb4\u0e87\u0ea5\u0ebb\u0ea7" },
            { "Jamo", "\u0e88\u0eb2\u0ec2\u0ea1" },
            { "id", "\u0ead\u0eb4\u0e99\u0ec2\u0e94\u0ec0\u0e99\u0e8a\u0ebd\u0e99" },
            { "type.nu.tibt", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb4\u0ec0\u0e9a\u0e94" },
            { "ie", "\u0ead\u0eb4\u0e99\u0ec0\u0e95\u0eb5\u0ea5\u0eb4\u0e87\u0e81\u0ea3\u0eb5" },
            { "ig", "\u0ead\u0eb4\u0e81\u0ec2\u0e9a" },
            { "ii", "\u0ec0\u0e8a\u0eaa\u0ea7\u0e8d\u0ea2\u0eb5" },
            { "frm", "\u0e9f\u0eae\u0eb1\u0ec8\u0e87\u0ec0\u0eaa\u0e94\u0e81\u0eb2\u0e87" },
            { "%%RUMGR", "\u0ea3\u0eb3\u0e81\u0ea3\u0ecc" },
            { "ik", "\u0ead\u0eb4\u0e99\u0e99\u0eb9\u0e9b\u0ebd\u0e81" },
            { "fro", "\u0e9f\u0eae\u0eb1\u0ec8\u0e87\u0ec0\u0eaa\u0e94\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "io", "\u0ead\u0eb5\u0ec2\u0e94" },
            { "frs", "\u0e9f\u0ea3\u0eb5\u0e8a\u0ebd\u0e99\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "frr", "\u0e9f\u0ea3\u0eb5\u0e8a\u0ebd\u0e99\u0ec0\u0edc\u0eb7\u0ead" },
            { "is", "\u0ec4\u0ead\u0eaa\u0ec1\u0ea5\u0e99\u0e94\u0eb4\u0e81" },
            { "it", "\u0ead\u0eb4\u0e95\u0eb2\u0ea5\u0ebd\u0e99" },
            { "iu", "\u0ead\u0eb4\u0e99\u0e99\u0eb8\u0e81\u0e95\u0eb4\u0e95\u0eb1\u0e94" },
            { "%%HOGNORSK", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e99\u0ecd\u0ea7\u0eb5\u0e88\u0ec8\u0ebd\u0e99\u0eaa\u0eb9\u0e87" },
            { "ja", metaValue_JP },
            { "Mlym", "\u0ea1\u0eb2\u0ec0\u0ea5\u0ea2\u0eb2\u0ea5\u0eb2\u0ea1" },
            { "Sarb", "\u0ead\u0eb2\u0ea5\u0eb0\u0ec0\u0e9a\u0e8d\u0ec3\u0e95\u0ec9\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Sara", "\u0e8a\u0eb2\u0eae\u0eb2\u0e95\u0eb4" },
            { "doi", "\u0e94\u0ead\u0e81\u0ea3\u0eb5" },
            { "type.nu.lepc", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ea5\u0e8a\u0eb2" },
            { "bkm", "\u0e81\u0ebb\u0ea1" },
            { "sma", "\u0e8a\u0eb2\u0ea1\u0eb4\u0ec3\u0e95\u0ec9" },
            { "jv", "\u0e88\u0eb2\u0ec1\u0ea7\u0e99\u0eb5\u0eaa" },
            { "Shaw", "\u0e8a\u0ead\u0ea7\u0ebd\u0e99" },
            { "%%BAUDDHA", "\u0e9e\u0eb0\u0e9e\u0eb8\u0e94\u0e97\u0eb0\u0ec0\u0e88\u0ebb\u0ec9\u0eb2" },
            { "mad", "\u0ea1\u0eb2\u0e94\u0eb9\u0ea5\u0eb2" },
            { "smj", "\u0ea5\u0eb8\u0e99\u0e8a\u0eb2\u0ea1\u0eb4" },
            { "mag", "\u0ea1\u0eb2\u0e81\u0eb2\u0eae\u0eb4" },
            { "maf", "\u0ea1\u0eb2\u0e9f\u0eb2" },
            { "mai", "\u0ec4\u0ea1\u0e97\u0eb5\u0ea5\u0eb4" },
            { "smn", "\u0ead\u0eb5\u0e99\u0eb2\u0ea3\u0eb4\u0e8a\u0eb2\u0ea1\u0eb4" },
            { "ka", metaValue_ka },
            { "bla", "\u0e8a\u0eb4\u0e81\u0e8a\u0eb4\u0e81\u0eb2" },
            { "mak", "\u0ea1\u0eb2\u0e81\u0eb2\u0e8a\u0eb2\u0ea3" },
            { "sms", "\u0eaa\u0e81\u0ead\u0e94\u0e8a\u0eb2\u0ea1\u0eb4" },
            { "man", "\u0ea1\u0eb1\u0e99\u0e94\u0eb4\u0e87\u0e81\u0eb2" },
            { "kg", "\u0e84\u0ead\u0e87\u0ec2\u0e81" },
            { "Goth", "\u0ec2\u0e81\u0eae\u0eb4\u0e81" },
            { "ki", "\u0e84\u0eb4\u0e84\u0eb9\u0ea2\u0eb8" },
            { "mas", "\u0ea1\u0eb2\u0ec4\u0e8a" },
            { "kj", "\u0e81\u0ea7\u0e99\u0e8d\u0eb2\u0ea1\u0eb2" },
            { "kk", "\u0e84\u0eb2\u0e8a\u0eb1\u0e81" },
            { "kl", "\u0e81\u0ea3\u0eb5\u0e99\u0ec1\u0ea5\u0e99\u0ea5\u0eb4\u0e94" },
            { "km", "\u0e82\u0eb0\u0ec0\u0edd\u0e99" },
            { "kn", metaValue_kn },
            { "ko", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ea5\u0eb5" },
            { "kr", "\u0e84\u0eb2\u0e99\u0eb8\u0ea5\u0eb4" },
            { "ks", "\u0e84\u0eb2\u0eaa\u0ec0\u0ea1\u0e8d\u0ea3\u0eb4" },
            { "Cirt", "\u0ec0\u0e8a\u0eb5\u0eae" },
            { "Lepc", "\u0ec0\u0ea5\u0e8a\u0eb2" },
            { "Avst", "\u0ead\u0eb0\u0ec0\u0ea7\u0eaa\u0e95\u0eb0" },
            { "ku", "\u0ec0\u0e84\u0eb5\u0e94\u0eb4\u0eaa" },
            { "kv", "\u0ec2\u0e84\u0ea1\u0eb4" },
            { "kw", "\u0e84\u0ecd\u0e99\u0eb4\u0e8a" },
            { "ky", "\u0ec0\u0e81\u0e8d\u0e81\u0eb5\u0eaa" },
            { "snk", "\u0ec2\u0e8a\u0e99\u0eb4\u0e99\u0e81\u0eb5" },
            { "la", metaValue_la },
            { "lb", "\u0ea5\u0eb1\u0e81\u0ec0\u0e8a\u0ea1\u0e9a\u0ea7\u0e81\u0e81\u0eb4\u0e8a" },
            { "type.nu.mlym", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea1\u0eb2\u0ec0\u0ea5\u0ead\u0eb2\u0ea5\u0eb3" },
            { "lg", "\u0ec1\u0e81\u0e99\u0e94\u0eb2" },
            { "Roro", "\u0eae\u0ead\u0e87\u0ec2\u0e81\u0eae\u0ead\u0e87\u0ec2\u0e81" },
            { "li", "\u0ea5\u0eb4\u0ea1\u0ec0\u0e9a\u0eb5\u0e81\u0eb5\u0e8a" },
            { "Tibt", metaValue_bo },
            { "ln", "\u0ea5\u0eb4\u0e87\u0e81\u0eb2\u0ea5\u0eb2" },
            { "fur", "\u0e9f\u0ea3\u0eb5\u0ea5\u0ebd\u0e99" },
            { "lo", metaValue_LA },
            { "type.ms.uksystem", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0e81\u0eb2\u0e99\u0ea7\u0eb1\u0e94\u0ec1\u0e97\u0e81\u0ec1\u0e9a\u0e9a\u0ead\u0eb4\u0ea1\u0ec0\u0e9e\u0eb5\u0ea3\u0ebd\u0ea7" },
            { "type.nu.lana", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec4\u0e97\u0e97\u0eb3\u0ec2\u0eae\u0ea5\u0eb2" },
            { "lt", "\u0ea5\u0eb4\u0e97\u0ebb\u0ea7\u0e99\u0ebd\u0e99" },
            { "lu", "\u0ea5\u0eb9\u0e9a\u0eb2-\u0e84\u0eb2\u0e95\u0eb1\u0e87\u0e81\u0eb2" },
            { "lv", "\u0ea5\u0eb1\u0e94\u0ea7\u0ebd\u0e99" },
            { "sog", "\u0e8a\u0ead\u0e81\u0e94\u0eb4\u0e99" },
            { "mg", "\u0ea1\u0eb2\u0ea5\u0eb2\u0e81\u0eb2\u0eaa\u0e8a\u0eb5" },
            { "mh", "\u0ea1\u0eb2\u0e8a\u0eb2\u0e99\u0ec0\u0ea5\u0eb1\u0e94" },
            { "type.co.ducet", "\u0eae\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ea5\u0eb3\u0e94\u0eb1\u0e9a\u0ea2\u0eb9\u0e99\u0eb4\u0ec2\u0e84\u0e94\u0ec0\u0ea5\u0eb5\u0ec8\u0ea1\u0e95\u0ebb\u0ec9\u0e99" },
            { "mi", "\u0ea1\u0eb2\u0ea7\u0ea3\u0eb4" },
            { "mk", "\u0ec1\u0ea1\u0e8a\u0eb4\u0ec2\u0e94\u0e99\u0ebd\u0e99" },
            { "ml", "\u0ea1\u0eb2\u0ec0\u0ea5\u0ead\u0eb2\u0ea5\u0eb3" },
            { "mn", metaValue_MN },
            { "mr", "\u0ea1\u0eb2\u0ea3\u0eb2\u0e97\u0eb5" },
            { "ms", "\u0ea1\u0eb2\u0ec0\u0ea5" },
            { "mt", "\u0ea1\u0ead\u0ea5\u0e97\u0eb5\u0eaa" },
            { "my", metaValue_my },
            { "Saur", "\u0ec2\u0eaa\u0eae\u0eb1\u0e94\u0e95\u0ea3\u0eb0" },
            { "Armn", metaValue_hy },
            { "mdf", "\u0ea1\u0ead\u0e81\u0e8a\u0eb2" },
            { "mde", "\u0ea1\u0eb2\u0e9a\u0eb2" },
            { "dsb", "\u0e8a\u0ecd\u0e9a\u0ebd\u0e99\u0e95\u0ecd\u0ec8\u0e81\u0ea7\u0ec8\u0eb2" },
            { "Armi", "\u0ead\u0eb4\u0ea1\u0e9e\u0eb5\u0eae\u0ebd\u0e99 \u0ead\u0eb2\u0ec0\u0ea1\u0ead\u0eb4\u0e81" },
            { "na", "\u0e99\u0eb2\u0ea2\u0eb9\u0ea5\u0eb9" },
            { "type.co.search", "\u0e81\u0eb2\u0e99\u0e8a\u0ead\u0e81\u0eab\u0eb2\u0e97\u0ebb\u0ec8\u0ea7\u0ec4\u0e9b" },
            { "nb", "\u0e99\u0ecd\u0ec0\u0ea7\u0e88\u0ebd\u0e99 \u0e9a\u0eb1\u0ead\u0e81\u0ea1\u0ead\u0ea5" },
            { "nd", "\u0ec0\u0ead\u0eb1\u0e99\u0ec0\u0e94\u0ec0\u0e9a\u0ec0\u0ea5\u0ec0\u0edc\u0eb7\u0ead" },
            { "ne", "\u0ec0\u0e99\u0e9b\u0eb2\u0ea5\u0eb5" },
            { "ng", "\u0ec0\u0ead\u0eb1\u0e99\u0e94\u0ead\u0e87\u0e81\u0eb2" },
            { "mdr", "\u0ea1\u0eb2\u0e99\u0e94\u0eb2\u0ea3" },
            { "nl", "\u0e94\u0eb1\u0e8a" },
            { "nn", "\u0e99\u0ecd\u0ec0\u0ea7\u0e88\u0ebd\u0e99 \u0e99\u0eb5\u0e99\u0ead\u0e81" },
            { "no", "\u0e99\u0ecd\u0ec0\u0ea7\u0e8d" },
            { "nr", "\u0e99\u0eb5\u0e9a\u0eb5\u0ea5\u0eb5\u0ec3\u0e95\u0ec9" },
            { "nv", "\u0e99\u0eb2\u0ea7\u0eb2\u0ec2\u0e88" },
            { "kaa", "\u0e81\u0eb2\u0ea3\u0eb2-\u0e81\u0eb2\u0e99\u0e9b\u0eb2\u0e81" },
            { "ny", "\u0e99\u0eb2\u0e99\u0e88\u0eb2" },
            { "kac", "\u0e81\u0eb2\u0e8a\u0eb4\u0e99" },
            { "kab", "\u0e81\u0eb2\u0ec4\u0e9a\u0ea5\u0ecc" },
            { "%%POLYTON", "\u0ec2\u0e9e\u0ea5\u0eb5\u0ec2\u0e97\u0e99\u0eb4\u0e81" },
            { "oc", "\u0ead\u0eb1\u0ead\u0e81\u0e8a\u0eb5\u0e95\u0eb2\u0e99" },
            { "kaj", "\u0e88\u0ea3\u0eb9" },
            { "kam", "\u0e81\u0eb2\u0ea1\u0e9a\u0eb2" },
            { "men", metaValue_men },
            { "oj", "\u0ec2\u0ead\u0e88\u0eb4\u0e9a\u0ea7\u0eb2" },
            { "mer", "\u0ec0\u0ea1\u0ea3\u0eb9" },
            { "type.nu.armn", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ec0\u0ea1\u0e99\u0ebd\u0e99" },
            { "om", "\u0ec2\u0ead\u0ec2\u0ea3\u0ec2\u0ea1" },
            { "kaw", "\u0e81\u0eb0\u0ea7\u0eb5" },
            { "or", "\u0ec2\u0ead\u0ea3\u0eb4\u0ea2\u0eb2" },
            { "os", "\u0ead\u0ead\u0e94\u0ec0\u0e8a\u0e95\u0eb4\u0e81" },
            { "%%ALALC97", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec0\u0e9b\u0eb1\u0e99\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec2\u0ea3\u0ea1\u0eb1\u0e99\u0e95\u0eb2\u0ea1\u0ec0\u0e81\u0e99\u0e82\u0ead\u0e87\u0eaa\u0eb0\u0ea1\u0eb2\u0e84\u0ebb\u0ea1\u0eab\u0ec9\u0ead\u0e87\u0eaa\u0eb0\u0edd\u0eb8\u0e94\u0ead\u0eb2\u0ec0\u0ea1\u0ea5\u0eb4\u0e81\u0eb2\u0ec1\u0ea5\u0eb0\u0eab\u0ec9\u0ead\u0e87\u0eaa\u0eb0\u0edd\u0eb8\u0e94\u0ea5\u0eb1\u0e94\u0e96\u0eb0\u0eaa\u0eb0\u0e9e\u0eb2 \u0eaa\u0eb0\u0e9a\u0eb1\u0e9a\u0e9e\u0eb4\u0ea1\u0e9b\u0eb5 1997" },
            { "kbd", "\u0e81\u0eb2\u0e9a\u0eb2\u0e94\u0ebd\u0e99" },
            { "mfe", "\u0ea1\u0ecd\u0ea3\u0eb4\u0eaa\u0ec0\u0ea2\u0e99" },
            { "srn", "\u0eaa\u0ea3\u0eb2\u0e99\u0e99\u0eb2\u0e99\u0e95\u0ead\u0e99\u0ec2\u0e81" },
            { "pa", "\u0e9b\u0eb1\u0e99\u0e88\u0eb2\u0e9a\u0eb5" },
            { "dua", "\u0e94\u0ebb\u0ea7\u0ea5\u0eb2" },
            { "srr", "\u0ec0\u0e8a\u0ec0\u0ea5\u0eb5" },
            { "%%LIPAW", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ea5\u0eb4\u0ec2\u0e9e\u0ea7\u0eb2\u0e8a\u0ecc\u0e82\u0ead\u0e87\u0ec0\u0ea3\u0e8a\u0ec8\u0ebd\u0e99" },
            { "kbl", "\u0e84\u0eb2\u0ec1\u0e99\u0ea1\u0e9a\u0eb9" },
            { "pi", "\u0e9b\u0eb2\u0ea5\u0eb5" },
            { "pl", "\u0ec2\u0e9b\u0ea5\u0eb4\u0e8a" },
            { "dum", "\u0e94\u0eb1\u0e81\u0e81\u0eb2\u0e87" },
            { "type.nu.saur", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0eaa\u0ebb\u0eb2\u0ea5\u0eb1\u0e94\u0e97\u0eb2" },
            { "type.ca.dangi", "\u0e9b\u0eb0\u200b\u0e95\u0eb4\u200b\u0e97\u0eb4\u0e99\u200b\u0e94\u0eb1\u0e87\u200b\u0e81\u0eb5" },
            { "%%VALLADER", "\u0ea7\u0eb1\u0ea5\u0ea5\u0eb2\u0ec0\u0e94\u0eb5" },
            { "ps", "\u0e9b\u0eb2\u0eaa\u0ec2\u0e95" },
            { "pt", "\u0e9b\u0ead\u0e81\u0e95\u0eb8\u0e8d\u0e81\u0eb4\u0eaa" },
            { "mga", "\u0ec4\u0ead\u0ea5\u0eb4\u0e94\u0e81\u0eb2\u0e87" },
            { "key.co", "\u0eae\u0ebd\u0e87\u0ea5\u0eb3\u0e94\u0eb1\u0e9a" },
            { "pt_BR", "\u0e9b\u0ead\u0e81\u0e95\u0eb8\u0e8d\u0e81\u0eb4\u0eaa \u0e9a\u0eb0\u0ec0\u0ea5\u0e8a\u0eb5\u0ec8\u0e99" },
            { "kcg", "\u0e95\u0eb5\u0e9a" },
            { "mgh", "\u0ea1\u0eb2\u0e84\u0eb9\u0ea7\u0eb2-\u0ea1\u0eb5\u0e94\u0ec2\u0e95" },
            { "key.cf", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99" },
            { "type.nu.nkoo", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec0\u0ead\u0eb1\u0e99\u0ec2\u0e81\u0ec9" },
            { "bra", "\u0e9a\u0ea3\u0eb2" },
            { "key.ca", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99" },
            { "%%JAUER", "\u0ec0\u0e8d\u0ebb\u0eb2\u0ec0\u0ead\u0eb5" },
            { "Laoo", metaValue_LA },
            { "%%SURMIRAN", "\u0e8a\u0eb9\u0ea3\u0ecc\u0ea1\u0eb4\u0ea5\u0eb2\u0e99" },
            { "mgo", "\u0ec0\u0ea1\u0e97\u0eb2" },
            { "type.hc.h23", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 24 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (0\u201323)" },
            { "type.hc.h24", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 24 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (1\u201324)" },
            { "ssy", metaValue_ssy },
            { "type.nu.mymr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea1\u0ebd\u0e99\u0ea1\u0eb2" },
            { "qu", "\u0e84\u0eb5\u0e8a\u0ebb\u0ea7" },
            { "zap", "\u0e8a\u0eb2\u0ec2\u0e9b\u0ec1\u0e95\u0e9a" },
            { "brx", "\u0ec2\u0e9a\u0e94\u0eb9" },
            { "Lana", "\u0ea5\u0ec9\u0eb2\u0e99\u0e99\u0eb2" },
            { "kde", "\u0ea1\u0eb2\u0e84\u0ead\u0e99\u0ec0\u0e94" },
            { "%%VAIDIKA", "\u0ec0\u0ea7\u0e94\u0eb4\u0e81\u0eb2" },
            { "Ethi", "\u0ead\u0eb5\u0e97\u0eb4\u0ec2\u0ead\u0e9b\u0eb4\u0e81" },
            { "%%JYUTPING", "\u0e81\u0eb2\u0e99\u0e96\u0ead\u0e94\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec1\u0e9a\u0e9a\u0e8d\u0eb9\u0e94\u0e9e\u0eb4\u0e87" },
            { "type.hc.h12", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 12 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (1\u201312)" },
            { "type.hc.h11", "\u0e95\u0eb2\u0ea1\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a 12 \u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87 (0\u201311)" },
            { "rm", "\u0ec2\u0ea3\u0ec1\u0ea1\u0e99\u0e8a\u0ecc" },
            { "rn", "\u0ea3\u0eb8\u0e99\u0e94\u0eb4" },
            { "key.cu", "\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99" },
            { "ro", "\u0ec2\u0ea3\u0ec1\u0ea1\u0e99\u0ebd\u0e99" },
            { "%%SAAHO", metaValue_ssy },
            { "type.nu.orya", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ead\u0e94\u0eb4\u0ead\u0eb2" },
            { "type.nu.hanidec", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0ebb\u0e94\u0eaa\u0eb0\u0e99\u0eb4\u0e8d\u0ebb\u0ea1\u0e88\u0eb5\u0e99" },
            { "ru", "\u0ea5\u0eb1\u0e94\u0ec0\u0e8a\u0e8d" },
            { "bss", "\u0ead\u0eb2\u0e84\u0eb8\u0e94" },
            { "rw", "\u0e84\u0eb4\u0e99\u0ea2\u0eb2\u0ea7\u0eb2\u0e99\u0e94\u0eb2" },
            { "zbl", "\u0eaa\u0eb1\u0e99\u0e8d\u0eb2\u0ea5\u0eb1\u0e81\u0e9a\u0ea5\u0eb5\u0e8a\u0eb4\u0ea1" },
            { "kea", "\u0e84\u0eb2\u0ec0\u0ea7\u0eb5\u0ec0\u0e94\u0e8d\u0e99\u0eb9" },
            { "mic", "\u0ea1\u0eb4\u0e81\u0ec1\u0ea1\u0e81" },
            { "suk", "\u0e8a\u0eb9\u0e84\u0eb9\u0ea1\u0ec9\u0eb2" },
            { "en_AU", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94 (\u0ec2\u0ead\u0e94\u0eaa\u0eb0\u0e95\u0eb2\u0ea5\u0eb5)" },
            { "Dupl", "\u0e8a\u0ebb\u0ea7\u0ec0\u0ea5\u0e94\u0eb1\u0e9a\u0ec2\u0ea5\u0e8d\u0eb1\u0e99" },
            { "sa", "\u0eaa\u0eb1\u0e99\u0eaa\u0eb0\u0e81\u0ea3\u0eb4\u0e94" },
            { "%%UCCOR", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0ec1\u0e9a\u0e9a\u0e84\u0ebb\u0e9a\u0ea7\u0ebb\u0e87\u0e88\u0ead\u0e99" },
            { "sc", "\u0eaa\u0eb2\u0e94\u0eb5\u0e99\u0ebd\u0e99" },
            { "sus", "\u0e8a\u0eb9\u0e8a\u0eb9" },
            { "sd", "\u0eaa\u0eb4\u0e99\u0e97\u0eb4" },
            { "se", "\u0e8a\u0eb2\u0ea1\u0eb4\u0ec0\u0edc\u0eb7\u0ead" },
            { "min", "\u0e97\u0eb5\u0ec1\u0e99\u0e87\u0e81\u0eb2\u0e9a\u0eb9" },
            { "sg", "\u0ec1\u0e8a\u0e87\u0ec2\u0e81" },
            { "sh", "\u0ec0\u0e8a\u0eb5\u0ec2\u0e9a-\u0ec2\u0e81\u0ec0\u0e8a\u0e8d" },
            { "si", metaValue_si },
            { "sux", "\u0e8a\u0eb9\u0ec0\u0ea1\u0eb5\u0ec0\u0ea5\u0e8d" },
            { "sk", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ec1\u0ea7\u0eb1\u0e81" },
            { "sl", "\u0eaa\u0eb0\u0ec2\u0ea5\u0ec0\u0ea7\u0e99\u0ebd\u0e99" },
            { "Gran", "\u0ec0\u0e84\u0e99\u0e97\u0eb2" },
            { "sm", metaValue_WS },
            { "sn", "\u0ec2\u0e8a\u0e99\u0eb2" },
            { "so", "\u0ec2\u0e8a\u0ea1\u0eb2\u0ea5\u0eb5" },
            { "type.nu.arab", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81-\u0ead\u0eb4\u0e99\u0e94\u0eb4\u0e81" },
            { "sq", "\u0ead\u0eb2\u0e99\u0e9a\u0eb2\u0e99\u0ebd\u0e99" },
            { "sr", "\u0ec0\u0e8a\u0eb5\u0e9a\u0ebd\u0e99" },
            { "ss", "\u0e8a\u0ea3\u0eb2\u0e95\u0eb4" },
            { "type.cf.account", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0eaa\u0eb0\u0e81\u0eb8\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0e81\u0eb2\u0e99\u0e9a\u0eb1\u0e99\u0e8a\u0eb5" },
            { "st", "\u0ec2\u0e8a\u0ec2\u0e97\u0ec3\u0e95\u0ec9" },
            { "Java", "\u0e88\u0eb2\u0ea7\u0eb2" },
            { "su", "\u0e8a\u0eb8\u0e99\u0ec1\u0e94\u0e99\u0e99\u0eb5\u0eaa" },
            { "%%NEDIS", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e99\u0eb2\u0e97\u0eb4\u0ec2\u0e8a\u0ec0\u0e99" },
            { "sv", "\u0eaa\u0eb0\u0ea7\u0eb5\u0e94\u0eb4\u0e8a" },
            { "sw", "\u0e8a\u0ea7\u0eb2\u0eae\u0eb5\u0ea5\u0eb4" },
            { "type.nu.hantfin", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0e87\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1\u0e82\u0ead\u0e87\u0e88\u0eb5\u0e99" },
            { "ibb", "\u0ec4\u0ead\u0ec4\u0e9a\u0ec4\u0e9a\u0ec2\u0ead" },
            { "iba", "\u0ec4\u0ead\u0e9a\u0eb2\u0e99" },
            { "ta", metaValue_ta },
            { "142", "\u0ead\u0eb2\u0e8a\u0eb5" },
            { "bua", "\u0e9a\u0eb9\u0ea3\u0ebd\u0e94" },
            { "143", "\u0ead\u0eb2\u0e8a\u0eb5\u0e81\u0eb2\u0e87" },
            { "te", "\u0ec0\u0e95\u0ea5\u0eb9\u0e81\u0eb9" },
            { "145", "\u0ead\u0eb2\u0e8a\u0eb5\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "tg", "\u0e97\u0eb2\u0e88\u0eb4\u0e81" },
            { "th", metaValue_TH },
            { "ti", "\u0e95\u0eb4\u0e81\u0ea3\u0eb4\u0e99\u0ea2\u0eb2" },
            { "bug", "\u0e9a\u0eb9\u0e88\u0eb5\u0ec0\u0e99\u0eb1\u0e94" },
            { "kfo", "\u0ec2\u0e84\u0ec2\u0ea5" },
            { "en_CA", "\u0ead\u0eb1\u0e87\u0e81\u0eb4\u0e94\u0ec1\u0e84\u0e99\u0eb2\u0e94\u0eb2" },
            { "tk", "\u0ec0\u0e97\u0eb5\u0e81\u0ec0\u0ea1\u0eb1\u0e99" },
            { "tl", metaValue_tl },
            { "tn", "\u0ec0\u0e95\u0eaa\u0eb0\u0ea7\u0eb2\u0e99\u0eb2" },
            { "to", "\u0e97\u0ead\u0e87\u0e81\u0eb2\u0e99" },
            { "bum", "\u0e9a\u0eb9\u0ea5\u0eb9" },
            { "dyo", "\u0ec2\u0e88\u0ea5\u0eb2-\u0e9f\u0ead\u0e99\u0ea2\u0eb5" },
            { "type.nu.jpan", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "tr", "\u0ec0\u0e97\u0eb5\u0e84\u0eb4\u0e8a" },
            { "ts", "\u0ec0\u0e95\u0e8a\u0ead\u0e87\u0e81\u0eb2" },
            { "swb", "\u0ec2\u0e84\u0ec2\u0e99\u0ea3\u0ebd\u0e99" },
            { "Cakm", "\u0e8a\u0eb2\u0e81\u0ea1\u0eb2" },
            { "tt", "\u0e97\u0eb2\u0e97\u0eb2" },
            { "dyu", "\u0e94\u0eb9\u0ea5\u0eb2" },
            { "tw", "\u0e97\u0ea7\u0eb5" },
            { "ty", "\u0e95\u0eb2\u0eae\u0eb5\u0e95\u0ebd\u0e99" },
            { "%%BISKE", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e8a\u0eb2\u0e99\u0e88\u0eb4\u0ec2\u0ead\u0ec2\u0e88/\u0e9a\u0eb4\u0ea5\u0eb2" },
            { "150", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a" },
            { "151", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "154", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0ec0\u0edc\u0eb7\u0ead" },
            { "dzg", "\u0e94\u0eb2\u0e8a\u0eb2\u0e81\u0eb2" },
            { "155", "\u0ea2\u0eb9\u0ec2\u0ea3\u0e9a\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "ug", "\u0ead\u0eb8\u0e8d\u0ec0\u0e84\u0eb5" },
            { "Ital", "\u0ead\u0eb5\u0e95\u0eb2\u0ea5\u0eb5\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "Kore", "\u0ec0\u0e81\u0ebb\u0eb2\u0eab\u0ebc\u0eb5" },
            { "Zyyy", "\u0eaa\u0eb2\u0ea1\u0eb1\u0e99" },
            { "uk", "\u0ea2\u0eb9\u0ec0\u0e84\u0ea3\u0e99\u0ebd\u0e99" },
            { "type.ca.coptic", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0e84\u0eb1\u0ead\u0e9a\u0e95\u0eb4\u0e81" },
            { "ur", "\u0ead\u0eb9\u0ea3\u0e94\u0eb9" },
            { "%%1994", "\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ec0\u0ea3\u0e8a\u0ec8\u0ebd\u0e99\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "xal", "\u0e81\u0eb2\u0e99\u0ea1\u0eb4\u0e81" },
            { "zen", "\u0ec0\u0e8a\u0e99\u0eb2\u0e81\u0eb2" },
            { "uz", "\u0ead\u0eb8\u0eaa\u0ec0\u0e9a\u0e81" },
            { "kha", "\u0e84\u0eb2\u0eaa\u0eb4" },
            { "%%1996", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0ead\u0ecd\u0ec2\u0e97\u0e81\u0ea3\u0eb2\u0e9f\u0eb5\u0e9b\u0eb51996" },
            { "nds_NL", "\u0e8a\u0eb2\u0e8a\u0ead\u0e99 \u0e95\u0ead\u0e99\u0ec4\u0e95" },
            { "Sylo", "\u0e8a\u0eb5\u0ec2\u0ea5\u0e95\u0eb4\u0e99\u0eb2\u0e81\u0ea3\u0eb5" },
            { "ve", "\u0ec0\u0ea7\u0e99\u0e94\u0eb2" },
            { "Wara", "\u0ea7\u0eb2\u0eae\u0eb1\u0e87\u0e81\u0eaa\u0eb4\u0e95\u0eb4" },
            { "type.ca.roc", "\u0e9b\u0eb0\u0e95\u0eb4\u0e97\u0eb4\u0e99\u0ec4\u0e95\u0ec9\u0eab\u0ea7\u0eb1\u0e99" },
            { "vi", metaValue_VN },
            { "kho", "\u0ec2\u0e84\u0e95\u0eb1\u0e99" },
            { "khq", "\u0e84\u0ead\u0e8d\u0ea3\u0eb2 \u0e8a\u0eb4\u0e99\u0eb5" },
            { "key.hc", "\u0eae\u0ead\u0e9a\u0ea7\u0ebd\u0e99\u0e8a\u0ebb\u0ec8\u0ea7\u0ec2\u0ea1\u0e87( 12 \u0eab\u0ebc\u0eb7 24)" },
            { "%%TARASK", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0e97\u0eb2\u0ea3\u0eb2\u0e8a\u0ecc\u0ec0\u0e84\u0e8d\u0ea7\u0eb4\u0e81\u0eb2" },
            { "vo", "\u0ec2\u0ea7\u0ea5\u0eb2\u0e9e\u0eb1\u0e81" },
            { "syc", "\u0e8a\u0eb5\u0ec0\u0ea5\u0e8d\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "quc", "K\u02bciche\u02bc" },
            { "gaa", "\u0e81\u0eb2" },
            { "wa", "\u0ea7\u0ecd\u0ea5\u0eb9\u0ea1" },
            { "gag", "\u0e81\u0eb2\u0e81\u0eb2\u0ead\u0eb8\u0e8a" },
            { "syr", "\u0e8a\u0eb5\u0ec0\u0ea5\u0e8d" },
            { "Grek", metaValue_el },
            { "Lydi", "\u0ea5\u0eb5\u0ec0\u0e94\u0e8d" },
            { "Xsux", "\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0eae\u0eb9\u0e9a\u0e9b\u0ea5\u0eb5\u0ec8\u0ea1\u0eaa\u0eb8\u0ec0\u0ea1\u0ec0\u0eae\u0e8d-\u0ead\u0eb1\u0e94\u0e84\u0eb2\u0ec0\u0e94\u0e8d" },
            { "wo", "\u0ea7\u0ecd\u0ea5\u0ead\u0e9a" },
            { "zgh", "\u0ec2\u0ea1\u0ea3\u0eb1\u0ead\u0e81\u0ec1\u0e84\u0e99 \u0e97\u0eb2\u0ea1\u0eb2\u0e8a\u0eb5\u0e81 \u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99" },
            { "ar_001", "\u0ead\u0eb2\u0ea3\u0eb2\u0e9a\u0eb4\u0e81\u0ea1\u0eb2\u0e94\u0e95\u0eb0\u0e96\u0eb2\u0e99\u0eaa\u0eb0\u0ec4\u0edd\u0ec3\u0edd\u0ec8" },
            { "Cans", "\u0eaa\u0eb1\u0e99\u0e8d\u0eb2\u0ea5\u0eb1\u0e81\u0e8a\u0ebb\u0e99\u0ec0\u0e9c\u0ebb\u0ec8\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0ec1\u0e84\u0e99\u0e99\u0eb2\u0e94\u0eb2" },
            { "%%FONXSAMP", "\u0e9f\u0ead\u0e99\u0ec1\u0e8a\u0ea1" },
            { "gay", "\u0e81\u0eb2\u0ec2\u0ea2" },
            { "Mong", "\u0ea1\u0ebb\u0e87\u0ec2\u0e81\u0e99" },
            { "mnc", "\u0ec1\u0ea1\u0e99\u0e88\u0eb9" },
            { "Latf", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99-\u0e9f\u0eae\u0eb1\u0ec8\u0e87\u0ec0\u0e95\u0ea3" },
            { "Hluw", "\u0ead\u0eb1\u0e81\u0ea5\u0eae\u0eb0\u0ead\u0eb2\u0e99\u0eb2\u0ec2\u0e95\u0ec0\u0ea5\u0e8d" },
            { "gba", "\u0e9a\u0eb2\u0e8d\u0eb2" },
            { "mni", "\u0ea1\u0eb2\u0e99\u0eb5\u0e9e\u0eb9\u0ea3\u0eb4" },
            { "Latn", metaValue_la },
            { "Latg", "\u0ea5\u0eb2\u0e95\u0eb4\u0e99-\u0ec1\u0e81\u0ea5\u0eb4\u0e81" },
            { "type.nu.hans", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d" },
            { "type.nu.hant", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "xh", "\u0ec2\u0eae\u0e8a\u0eb2" },
            { "type.nu.romanlow", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ea3\u0ea1\u0eb1\u0e99\u0e95\u0ebb\u0ea7\u0e9e\u0eb4\u0ea1\u0e99\u0ec9\u0ead\u0e8d" },
            { "byn", "\u0e9a\u0ea5\u0eb4\u0e99" },
            { "%%PAMAKA", "\u0e9e\u0eb2\u0eaa\u0eb2\u0e9e\u0eb7\u0ec9\u0e99\u0ec0\u0ea1\u0eb7\u0ead\u0e87\u0e9e\u0eb2\u0ea1\u0eb2\u0e84\u0eb2" },
            { "Lyci", "\u0ec4\u0ea5\u0ec0\u0e8a\u0e8d" },
            { "osa", "\u0ec2\u0ead\u0ec1\u0e8a\u0e81" },
            { "byv", "\u0ec0\u0ea1\u0e94\u0eb9\u0ea1\u0e9a\u0eb2" },
            { "Moon", "\u0ea1\u0eb9\u0e99" },
            { "moh", "\u0ec2\u0ea1\u0eab\u0eb2" },
            { "kkj", "\u0e84\u0eb2\u0ec2\u0e81" },
            { "%%1694ACAD", "\u0e95\u0ead\u0e99\u0e95\u0ebb\u0ec9\u0e99\u0e8d\u0eb8\u0e81\u0ec3\u0edd\u0ec8\u0e9d\u0ea3\u0eb1\u0ec8\u0e87" },
            { "yi", "\u0ea2\u0eb4\u0ea7" },
            { "mos", "\u0ea1\u0ead\u0eaa\u0e8a\u0eb5" },
            { "Syrc", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d" },
            { "Dsrt", "\u0ec0\u0e94\u0ec0\u0e8a\u0ec0\u0eae" },
            { "yo", "\u0ec2\u0ea2\u0ea3\u0eb9\u0e9a\u0eb2" },
            { "es_MX", "\u0ec0\u0ea1\u0eb1\u0e81\u0e8a\u0eb4\u0e81\u0eb1\u0e99 \u0eaa\u0eb0\u0ec1\u0e9b\u0e99\u0e99\u0eb4\u0e8a" },
            { "Syrj", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0e95\u0ebb\u0e81" },
            { "ota", "\u0e95\u0eb9\u0e81\u0eb5\u0ead\u0ead\u0e94\u0ec2\u0e95\u0ea1\u0eb1\u0e99" },
            { "Syre", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d\u0ec0\u0ead\u0eaa\u0e97\u0eae\u0eb2\u0e99\u0e88\u0eb5\u0ec2\u0ea5" },
            { "vai", metaValue_vai },
            { "za", "\u0e8a\u0ea7\u0eb2\u0e87" },
            { "Cari", "\u0e84\u0eb2\u0ec0\u0eae\u0e8d" },
            { "kln", "\u0e84\u0eb2\u0ec0\u0ea5\u0eb1\u0e99\u0e88\u0eb4\u0e99" },
            { "zh", metaValue_CN },
            { "Afak", "\u0ead\u0eb1\u0e9a\u0e9f\u0eb2\u0e81\u0eb2" },
            { "Bopo", "\u0e88\u0eb9\u0ec9\u0ead\u0eb4\u0e99" },
            { "Perm", "\u0ec0\u0e9e\u0eb5\u0ea1\u0eb5\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "key.lb", "\u0eae\u0eb9\u0e9a\u0ec1\u0e9a\u0e9a\u0ec0\u0eaa\u0eb1\u0ec9\u0e99\u0e82\u0eb1\u0ec9\u0e99" },
            { "zu", "\u0e8a\u0eb9\u0ea5\u0eb9" },
            { "type.co.phonebook", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0eaa\u0eb0\u0edd\u0eb8\u0e94\u0ec2\u0e97\u0ea5\u0eb0\u0eaa\u0eb1\u0e9a" },
            { "%%MONOTON", "\u0ec2\u0ea1\u0ec2\u0e99\u0ec2\u0e97\u0e99\u0eb4\u0e81" },
            { "Geor", metaValue_ka },
            { "Shrd", "\u0e8a\u0eb2\u0eae\u0eb2\u0e94\u0eb2" },
            { "kmb", "\u0e84\u0eb4\u0ea1\u0e9a\u0eb1\u0e99\u0e94\u0eb9" },
            { "type.nu.jpanfin", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0e87\u0e81\u0eb2\u0e99\u0ec0\u0e87\u0eb4\u0e99\u0e82\u0ead\u0e87\u0e8d\u0eb5\u0ec8\u0e9b\u0eb8\u0ec8\u0e99" },
            { "Cham", "\u0e88\u0eb2\u0ea1" },
            { "gez", "\u0e81\u0eb5" },
            { "Syrn", "\u0e8a\u0eb5\u0ec0\u0eae\u0e8d\u0e95\u0eb2\u0ec0\u0ea7\u0eb1\u0e99\u0ead\u0ead\u0e81" },
            { "type.nu.mymrshan", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e8a\u0eb2\u0e99\u0e9e\u0eb0\u0ea1\u0ec9\u0eb2" },
            { "Narb", "\u0ead\u0eb2\u0eae\u0eb0\u0ec0\u0e9a\u0e8d\u0ec0\u0edc\u0eb7\u0ead\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "type.nu.olck", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ec2\u0ead\u0ea5\u0e88\u0eb4\u0e81\u0eb4" },
            { "type.co.reformed", "\u0ea5\u0ebd\u0e87\u0e95\u0eb2\u0ea1\u0ea5\u0eb3\u0e94\u0eb1\u0e9a\u0eaa\u0eb8\u0e94\u0e97\u0ec9\u0eb2\u0e8d" },
            { "Tglg", metaValue_tl },
            { "Egyd", "\u0e94\u0eb5\u0ec2\u0ea1\u0e95\u0eb4\u0e81\u0ead\u0eb5\u0e8d\u0eb4\u0e9a" },
            { "Egyh", "\u0ec0\u0eae\u0e8d\u0eae\u0eb2\u0e95\u0eb4\u0e81\u0ead\u0eb5\u0e8d\u0eb4\u0e9a" },
            { "%%ITIHASA", "\u0ead\u0eb4\u0e95\u0eb4\u0eab\u0eb2\u0eaa\u0eb0" },
            { "Palm", "\u0e9e\u0eb2\u0ea5\u0ec4\u0ea1\u0eae\u0eb4\u0e99" },
            { "ebu", "\u0ec0\u0ead\u0eb1\u0ea1\u0e9a\u0eb9" },
            { "Egyp", "\u0ec0\u0eae\u0e8d\u0ec2\u0eae\u0e81\u0ea5\u0eb4\u0e9f\u0ead\u0eb5\u0e8d\u0eb4\u0e9a" },
            { "Geok", "\u0e84\u0ead\u0e94\u0e8a\u0eb9\u0eae\u0eb5\u0e88\u0ecd\u0ec0\u0e88\u0e8d" },
            { "zh_Hans", "\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0eae\u0ebd\u0e9a\u0e87\u0ec8\u0eb2\u0e8d" },
            { "koi", "\u0ec2\u0e84\u0ea1\u0eb5-\u0ec0\u0e9e\u0eb5\u0ea1\u0ea2\u0eb1\u0e81" },
            { "Hung", "\u0eae\u0eb1\u0e87\u0e81\u0eb2\u0eae\u0eb5\u0ec2\u0e9a\u0eae\u0eb2\u0e99" },
            { "kok", "\u0e81\u0ead\u0e99\u0e81\u0eb2\u0e99\u0eb5" },
            { "%%1901", "\u0ec0\u0ea2\u0e8d\u0ea5\u0eb0\u0ea1\u0eb1\u0e99\u0ead\u0ecd\u0ec2\u0e97\u0e81\u0ea3\u0eb2\u0e9f\u0eb5\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "kos", "\u0e84\u0eb9\u0eaa\u0ec4\u0ea5" },
            { "type.nu.limb", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0ea5\u0eb4\u0ea1\u0e9a\u0eb9" },
            { "zh_Hant", "\u0e88\u0eb5\u0e99\u0ec1\u0e9a\u0e9a\u0e94\u0eb1\u0ec9\u0e87\u0ec0\u0e94\u0eb5\u0ea1" },
            { "Sund", "\u0e8a\u0eb8\u0e99\u0e94\u0eb2" },
            { "kpe", "\u0e81\u0eb2\u0ec1\u0e9b\u0ea3" },
            { "type.nu.khmr", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e82\u0eb0\u0ec1\u0ea1" },
            { "Tirh", "\u0ec0\u0e97\u0eae\u0eb8\u0e97\u0eb2" },
            { "ilo", "\u0ec4\u0ead\u0ec2\u0ea5\u0ec2\u0e81" },
            { "%%VALENCIA", "\u0ea7\u0eb2\u0ec0\u0ea5\u0eb1\u0e99\u0ec0\u0e8a\u0e8d" },
            { "Cprt", "\u0ec4\u0e8a\u0ec0\u0e9b\u0e8d" },
            { "%%BAKU1926", "\u0e95\u0ebb\u0ea7\u0ead\u0eb1\u0e81\u0eaa\u0ead\u0e99\u0ea5\u0eb2\u0e95\u0eb4\u0e99\u0ec0\u0e97\u0eb5\u0e81\u0eb4\u0e81\u0ec1\u0e9a\u0e9a\u0e84\u0ebb\u0e9a\u0ea7\u0ebb\u0e87\u0e88\u0ead\u0e99" },
            { "mua", "\u0ea1\u0eb1\u0e99\u0e94\u0eb1\u0e87" },
            { "type.nu.guru", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e81\u0ebb\u0ea7\u0ea1\u0eb9\u0e84\u0eb4" },
            { "mul", "\u0eab\u0ea5\u0eb2\u0e8d\u0e9e\u0eb2\u0eaa\u0eb2" },
            { "%%PUTER", "\u0e9e\u0eb4\u0ea7\u0ec0\u0e95\u0eb5" },
            { "cad", "\u0ec1\u0e84\u0e94\u0ec2\u0e94" },
            { "key.ms", "\u0ea5\u0eb0\u0e9a\u0ebb\u0e9a\u0e81\u0eb2\u0e99\u0ea7\u0eb1\u0e94\u0ec1\u0e97\u0e81" },
            { "mus", "\u0e84\u0ea3\u0eb4\u0e81" },
            { "Glag", "\u0e81\u0ea5\u0eb2\u0ec2\u0e81\u0ea5\u0eb4\u0e95\u0eb4\u0e81" },
            { "gil", "\u0e81\u0eb4\u0e99\u0ec0\u0e9a\u0eb5\u0ec0\u0e97\u0eb1\u0e94" },
            { "%%KKCOR", "\u0ead\u0eb1\u0e81\u0e82\u0eb0\u0ea5\u0eb0\u0ea7\u0eb4\u0e97\u0eb5\u0eaa\u0eb2\u0ea1\u0eb1\u0e99" },
            { "Cher", "\u0ec0\u0e8a\u0ec2\u0eae\u0e81\u0eb5" },
            { "car", "\u0e84\u0eb2\u0ea3\u0eb4\u0e9a" },
            { "cay", "\u0e84\u0eb2\u0ea2\u0eb9\u0e81\u0eb2" },
            { "type.nu.tamldec", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81\u0e97\u0eb2\u0ea1\u0eb4\u0ea7" },
            { "krc", "\u0e81\u0eb2\u0ea3\u0eb2\u0ec4\u0e8a-\u0e9a\u0eb2\u0e99\u0e81\u0eb2" },
            { "inh", "\u0ead\u0eb4\u0e99\u0e81\u0eb1\u0e8a" },
            { "krl", "\u0e81\u0eb2\u0ec0\u0ea3\u0ea5\u0ebd\u0e99" },
            { "efi", "\u0ead\u0eb5\u0e9f\u0eb4\u0e81" },
            { "key.nu", "\u0e95\u0ebb\u0ea7\u0ec0\u0ea5\u0e81" },
            { "kru", "\u0e81\u0eb9\u0ea3\u0eb9\u0e81" },
            { "ksb", "\u0e8a\u0eb3\u0e9a\u0eb2\u0ea5\u0ec9\u0eb2" },
            { "Telu", "\u0ec0\u0e97\u0ea5\u0eb9\u0e81\u0eb9" },
            { "ksf", "\u0e9a\u0eb2\u0ec0\u0e9f\u0e8d" },
        };
        return data;
    }
}
