/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.lookup.PainlessLookupUtility;
import org.elasticsearch.painless.lookup.PainlessMethod;
import org.elasticsearch.painless.lookup.def;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.AStatement;
import org.elasticsearch.painless.node.ILambda;
import org.elasticsearch.painless.node.SFunction;
import org.objectweb.asm.Type;

public final class ELambda
extends AExpression
implements ILambda {
    private final List<String> paramTypeStrs;
    private final List<String> paramNameStrs;
    private final List<AStatement> statements;
    private CompilerSettings settings;
    private final Set<String> extractedVariables;
    private SFunction desugared;
    private List<Locals.Variable> captures;
    private FunctionRef ref;
    private String defPointer;

    public ELambda(Location location, List<String> paramTypes, List<String> paramNames, List<AStatement> statements) {
        super(location);
        this.paramTypeStrs = Collections.unmodifiableList(paramTypes);
        this.paramNameStrs = Collections.unmodifiableList(paramNames);
        this.statements = Collections.unmodifiableList(statements);
        this.extractedVariables = new HashSet<String>();
    }

    @Override
    void storeSettings(CompilerSettings settings) {
        for (AStatement statement : this.statements) {
            statement.storeSettings(settings);
        }
        this.settings = settings;
    }

    @Override
    void extractVariables(Set<String> variables) {
        for (AStatement statement : this.statements) {
            statement.extractVariables(this.extractedVariables);
        }
        variables.addAll(this.extractedVariables);
    }

    @Override
    void analyze(Locals locals) {
        ArrayList<String> actualParamTypeStrs;
        Class returnType;
        PainlessMethod interfaceMethod;
        if (this.expected == null) {
            interfaceMethod = null;
            returnType = def.class;
            actualParamTypeStrs = new ArrayList<String>(this.paramTypeStrs.size());
            for (String type : this.paramTypeStrs) {
                if (type == null) {
                    actualParamTypeStrs.add("def");
                    continue;
                }
                actualParamTypeStrs.add(type);
            }
        } else {
            interfaceMethod = locals.getPainlessLookup().lookupFunctionalInterfacePainlessMethod(this.expected);
            if (interfaceMethod == null) {
                throw this.createError(new IllegalArgumentException("Cannot pass lambda to [" + PainlessLookupUtility.typeToCanonicalTypeName(this.expected) + "], not a functional interface"));
            }
            if (interfaceMethod.typeParameters.size() != this.paramTypeStrs.size()) {
                throw new IllegalArgumentException("Incorrect number of parameters for [" + interfaceMethod.javaMethod.getName() + "] in [" + PainlessLookupUtility.typeToCanonicalTypeName(this.expected) + "]");
            }
            returnType = interfaceMethod.returnType == Void.TYPE ? def.class : interfaceMethod.returnType;
            actualParamTypeStrs = new ArrayList(this.paramTypeStrs.size());
            for (int i = 0; i < this.paramTypeStrs.size(); ++i) {
                String paramType = this.paramTypeStrs.get(i);
                if (paramType == null) {
                    actualParamTypeStrs.add(PainlessLookupUtility.typeToCanonicalTypeName(interfaceMethod.typeParameters.get(i)));
                    continue;
                }
                actualParamTypeStrs.add(paramType);
            }
        }
        this.captures = new ArrayList<Locals.Variable>();
        for (String variable : this.extractedVariables) {
            if (!locals.hasVariable(variable)) continue;
            this.captures.add(locals.getVariable(this.location, variable));
        }
        ArrayList<String> paramTypes = new ArrayList<String>(this.captures.size() + actualParamTypeStrs.size());
        ArrayList<String> paramNames = new ArrayList<String>(this.captures.size() + this.paramNameStrs.size());
        for (Locals.Variable var : this.captures) {
            paramTypes.add(PainlessLookupUtility.typeToCanonicalTypeName(var.clazz));
            paramNames.add(var.name);
        }
        paramTypes.addAll(actualParamTypeStrs);
        paramNames.addAll(this.paramNameStrs);
        String name = locals.getNextSyntheticName();
        this.desugared = new SFunction(this.location, PainlessLookupUtility.typeToCanonicalTypeName(returnType), name, paramTypes, paramNames, this.statements, true);
        this.desugared.storeSettings(this.settings);
        this.desugared.generateSignature(locals.getPainlessLookup());
        this.desugared.analyze(Locals.newLambdaScope(locals.getProgramScope(), this.desugared.name, returnType, this.desugared.parameters, this.captures.size(), this.settings.getMaxLoopCounter()));
        if (this.expected == null) {
            this.ref = null;
            this.actual = String.class;
            this.defPointer = "Sthis." + name + "," + this.captures.size();
        } else {
            this.defPointer = null;
            this.ref = FunctionRef.create(locals.getPainlessLookup(), locals.getMethods(), this.location, this.expected, "this", this.desugared.name, this.captures.size());
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        writer.writeDebugInfo(this.location);
        if (this.ref != null) {
            writer.writeDebugInfo(this.location);
            for (Locals.Variable capture : this.captures) {
                writer.visitVarInsn(MethodWriter.getType(capture.clazz).getOpcode(21), capture.getSlot());
            }
            writer.invokeLambdaCall(this.ref);
        } else {
            writer.push(null);
            for (Locals.Variable capture : this.captures) {
                writer.visitVarInsn(MethodWriter.getType(capture.clazz).getOpcode(21), capture.getSlot());
            }
        }
        globals.addSyntheticMethod(this.desugared);
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        Type[] types = new Type[this.captures.size()];
        for (int i = 0; i < types.length; ++i) {
            types[i] = MethodWriter.getType(this.captures.get((int)i).clazz);
        }
        return types;
    }

    @Override
    public String toString() {
        return this.multilineToString(this.pairwiseToString(this.paramTypeStrs, this.paramNameStrs), this.statements);
    }
}

