/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.server.ai.goal;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.util.StringUtils;
import net.sf.freecol.server.ai.AIObject;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.ai.AIUnit;
import net.sf.freecol.server.ai.goal.GoalConstants;

public abstract class Goal
extends AIObject
implements GoalConstants {
    private static final Logger logger = Logger.getLogger(Goal.class.getName());
    private float relativeWeight;
    protected boolean needsPlanning;
    protected boolean isFinished;
    protected final List<AIUnit> availableUnitsList;
    protected final AIPlayer player;
    private final Goal parentGoal;

    public Goal(AIPlayer p, Goal g, float w) {
        super(p.getAIMain());
        this.player = p;
        this.parentGoal = g;
        this.relativeWeight = w;
        this.getGame().getTurn().getNumber();
        this.needsPlanning = true;
        this.isFinished = false;
        this.availableUnitsList = new ArrayList<AIUnit>();
    }

    public Goal(AIPlayer p, Goal g, float w, AIUnit u) {
        this(p, g, w);
        this.addUnit(u);
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    public List<AIUnit> cancelGoal() {
        logger.finest("Entering method cancelGoal() for " + this.getDebugDescription());
        ArrayList<AIUnit> cancelledUnitsList = new ArrayList<AIUnit>();
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            List<AIUnit> ulist = g.cancelGoal();
            cancelledUnitsList.addAll(ulist);
        }
        Iterator<AIUnit> uit = this.getOwnedAIUnitsIterator();
        while (uit.hasNext()) {
            AIUnit u = uit.next();
            cancelledUnitsList.add(u);
        }
        logger.info("Got " + cancelledUnitsList.size() + " units from cancelled subgoals");
        return cancelledUnitsList;
    }

    public void doPlanning() {
        logger.finest("Entering method doPlanning() for " + this.getDebugDescription());
        boolean subgoalsPlanned = false;
        this.normalizeSubGoalWeights();
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            if (!g.needsPlanning()) continue;
            g.doPlanning();
            subgoalsPlanned = true;
        }
        if (this.needsPlanning || subgoalsPlanned) {
            this.plan();
            this.needsPlanning = false;
        }
    }

    public boolean needsPlanning() {
        logger.finest("Entering method needsPlanning() for " + this.getDebugDescription());
        if (this.needsPlanning) {
            return true;
        }
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            if (!g.needsPlanning()) continue;
            return true;
        }
        return false;
    }

    public void setNeedsPlanningRecursive(boolean p) {
        logger.finest("Entering method setNeedsPlanningRecursive() for " + this.getDebugDescription());
        this.needsPlanning = p;
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            g.setNeedsPlanningRecursive(p);
        }
    }

    public float getWeight() {
        return this.relativeWeight;
    }

    public float getParentWeight() {
        if (this.parentGoal == null) {
            return 1.0f;
        }
        return this.parentGoal.getAbsoluteWeight();
    }

    public float getAbsoluteWeight() {
        return this.getParentWeight() * this.relativeWeight;
    }

    public void setWeight(float w) {
        this.relativeWeight = w;
    }

    public void normalizeSubGoalWeights() {
        Goal g;
        float sumWeights = 0.0f;
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            g = git.next();
            sumWeights += g.getWeight();
        }
        if (sumWeights > 0.0f && (sumWeights < 0.95f || sumWeights > 1.05f)) {
            git = this.getSubGoalIterator();
            while (git != null && git.hasNext()) {
                g = git.next();
                g.setWeight(g.getWeight() / sumWeights);
            }
        }
    }

    protected void requestWorker(GoodsType gt, int minProduction) {
    }

    public final void addUnit(AIUnit u) {
        logger.finest("Entering method addUnit() for " + this.getDebugDescription() + " with unit: " + u.getId());
        this.getGame().getTurn().getNumber();
        this.availableUnitsList.add(u);
        u.setGoal(this);
        this.needsPlanning = true;
        this.isFinished = false;
    }

    protected void addUnitToParent(AIUnit u) {
        logger.finest("Entering method addUnitToParent() for " + this.getDebugDescription() + " with unit: " + u.getId());
        if (this.parentGoal != null) {
            this.parentGoal.addUnit(u);
        } else {
            u.setGoal(null);
        }
    }

    public boolean canYieldUnit(UnitType ut, AIObject o) {
        Iterator<AIUnit> uit = this.getOwnedAIUnitsIterator();
        while (uit.hasNext()) {
            AIUnit u = uit.next();
            if (!u.getUnit().getType().equals(ut)) continue;
            return true;
        }
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            if (!g.canYieldUnit(ut, o)) continue;
            return true;
        }
        return false;
    }

    public float getYieldedUnitWeight(UnitType ut, AIObject o) {
        float unitWeight = 99.0f;
        Iterator<AIUnit> uit = this.getOwnedAIUnitsIterator();
        while (uit.hasNext()) {
            AIUnit u = uit.next();
            if (!u.getUnit().getType().equals(ut)) continue;
            unitWeight = this.getAbsoluteWeight();
        }
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            float newWeight = g.getYieldedUnitWeight(ut, o);
            if (!(newWeight < unitWeight)) continue;
            unitWeight = newWeight;
        }
        return unitWeight;
    }

    public AIUnit yieldUnit(UnitType ut, AIObject o) {
        float unitWeight = 99.0f;
        AIUnit yieldedUnit = null;
        boolean isOwnUnit = false;
        Iterator<AIUnit> uit = this.getOwnedAIUnitsIterator();
        while (uit.hasNext()) {
            AIUnit u = uit.next();
            if (!u.getUnit().getType().equals(ut)) continue;
            unitWeight = this.getAbsoluteWeight();
            yieldedUnit = u;
            isOwnUnit = true;
        }
        Iterator<Goal> git = this.getSubGoalIterator();
        while (git != null && git.hasNext()) {
            Goal g = git.next();
            float newWeight = g.getYieldedUnitWeight(ut, o);
            if (!(newWeight < unitWeight)) continue;
            unitWeight = newWeight;
            yieldedUnit = g.yieldUnit(ut, o);
            isOwnUnit = false;
        }
        if (isOwnUnit) {
            this.removeUnit(yieldedUnit);
            this.needsPlanning = true;
        }
        return yieldedUnit;
    }

    protected void validateOwnedUnits() {
        Iterator<AIUnit> uit = this.getOwnedAIUnitsIterator();
        while (uit.hasNext()) {
            AIUnit u = uit.next();
            if (u.getGoal() == this) continue;
            logger.warning("Goal " + this.getGoalDescription() + " owns unit with another goal: " + u.getGoal().getGoalDescription());
            this.removeUnit(u);
        }
    }

    public String getGoalDescription() {
        String goalName = StringUtils.lastPart(this.getClass().getName(), ".");
        return goalName.substring(0, goalName.length() - "goal".length());
    }

    public String getDebugDescription() {
        String descr = "";
        if (this.parentGoal != null) {
            descr = this.parentGoal.getGoalDescription() + ">>";
        }
        return descr + this.getGoalDescription();
    }

    public static String getXMLElementTagName() {
        return "aiGoal";
    }

    protected abstract Iterator<AIUnit> getOwnedAIUnitsIterator();

    protected abstract Iterator<Goal> getSubGoalIterator();

    protected abstract void removeUnit(AIUnit var1);

    protected abstract void plan();
}

