/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.data.gpx;

import com.drew.imaging.jpeg.JpegMetadataReader;
import com.drew.lang.CompoundException;
import com.drew.metadata.Metadata;
import com.drew.metadata.MetadataException;
import com.drew.metadata.exif.ExifIFD0Directory;
import com.drew.metadata.exif.GpsDirectory;
import com.drew.metadata.iptc.IptcDirectory;
import com.drew.metadata.jpeg.JpegDirectory;
import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.openstreetmap.josm.data.coor.CachedLatLon;
import org.openstreetmap.josm.data.coor.LatLon;
import org.openstreetmap.josm.tools.ExifReader;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;

public class GpxImageEntry
implements Comparable<GpxImageEntry> {
    private File file;
    private Integer exifOrientation;
    private LatLon exifCoor;
    private Double exifImgDir;
    private Date exifTime;
    private boolean isNewGpsData;
    private Date exifGpsTime;
    private String iptcCaption;
    private String iptcHeadline;
    private List<String> iptcKeywords;
    private String iptcObjectName;
    private CachedLatLon pos;
    private Double speed;
    private Double elevation;
    private Date gpsTime;
    private int width;
    private int height;
    private GpxImageEntry tmp;

    public GpxImageEntry() {
    }

    public GpxImageEntry(GpxImageEntry other) {
        this.file = other.file;
        this.exifOrientation = other.exifOrientation;
        this.exifCoor = other.exifCoor;
        this.exifImgDir = other.exifImgDir;
        this.exifTime = other.exifTime;
        this.isNewGpsData = other.isNewGpsData;
        this.exifGpsTime = other.exifGpsTime;
        this.pos = other.pos;
        this.speed = other.speed;
        this.elevation = other.elevation;
        this.gpsTime = other.gpsTime;
        this.width = other.width;
        this.height = other.height;
        this.tmp = other.tmp;
    }

    public GpxImageEntry(File file) {
        this.setFile(file);
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public CachedLatLon getPos() {
        if (this.tmp != null) {
            return this.tmp.pos;
        }
        return this.pos;
    }

    public Double getSpeed() {
        if (this.tmp != null) {
            return this.tmp.speed;
        }
        return this.speed;
    }

    public Double getElevation() {
        if (this.tmp != null) {
            return this.tmp.elevation;
        }
        return this.elevation;
    }

    public Date getGpsTime() {
        if (this.tmp != null) {
            return GpxImageEntry.getDefensiveDate(this.tmp.gpsTime);
        }
        return GpxImageEntry.getDefensiveDate(this.gpsTime);
    }

    public boolean hasGpsTime() {
        return this.tmp != null && this.tmp.gpsTime != null || this.gpsTime != null;
    }

    public File getFile() {
        return this.file;
    }

    public Integer getExifOrientation() {
        return this.exifOrientation != null ? this.exifOrientation : 1;
    }

    public Date getExifTime() {
        return GpxImageEntry.getDefensiveDate(this.exifTime);
    }

    public boolean hasExifTime() {
        return this.exifTime != null;
    }

    public Date getExifGpsTime() {
        return GpxImageEntry.getDefensiveDate(this.exifGpsTime);
    }

    public boolean hasExifGpsTime() {
        return this.exifGpsTime != null;
    }

    private static Date getDefensiveDate(Date date) {
        if (date == null) {
            return null;
        }
        return new Date(date.getTime());
    }

    public LatLon getExifCoor() {
        return this.exifCoor;
    }

    public Double getExifImgDir() {
        if (this.tmp != null) {
            return this.tmp.exifImgDir;
        }
        return this.exifImgDir;
    }

    public void setWidth(int width) {
        this.width = width;
    }

    public void setHeight(int height) {
        this.height = height;
    }

    public void setPos(CachedLatLon pos) {
        this.pos = pos;
    }

    public void setPos(LatLon pos) {
        this.setPos(pos != null ? new CachedLatLon(pos) : null);
    }

    public void setSpeed(Double speed) {
        this.speed = speed;
    }

    public void setElevation(Double elevation) {
        this.elevation = elevation;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setExifOrientation(Integer exifOrientation) {
        this.exifOrientation = exifOrientation;
    }

    public void setExifTime(Date exifTime) {
        this.exifTime = GpxImageEntry.getDefensiveDate(exifTime);
    }

    public void setExifGpsTime(Date exifGpsTime) {
        this.exifGpsTime = GpxImageEntry.getDefensiveDate(exifGpsTime);
    }

    public void setGpsTime(Date gpsTime) {
        this.gpsTime = GpxImageEntry.getDefensiveDate(gpsTime);
    }

    public void setExifCoor(LatLon exifCoor) {
        this.exifCoor = exifCoor;
    }

    public void setExifImgDir(Double exifDir) {
        this.exifImgDir = exifDir;
    }

    public void setIptcCaption(String iptcCaption) {
        this.iptcCaption = iptcCaption;
    }

    public void setIptcHeadline(String iptcHeadline) {
        this.iptcHeadline = iptcHeadline;
    }

    public void setIptcKeywords(List<String> iptcKeywords) {
        this.iptcKeywords = iptcKeywords;
    }

    public void setIptcObjectName(String iptcObjectName) {
        this.iptcObjectName = iptcObjectName;
    }

    public String getIptcCaption() {
        return this.iptcCaption;
    }

    public String getIptcHeadline() {
        return this.iptcHeadline;
    }

    public List<String> getIptcKeywords() {
        return this.iptcKeywords;
    }

    public String getIptcObjectName() {
        return this.iptcObjectName;
    }

    @Override
    public int compareTo(GpxImageEntry image) {
        if (this.exifTime != null && image.exifTime != null) {
            return this.exifTime.compareTo(image.exifTime);
        }
        if (this.exifTime == null && image.exifTime == null) {
            return 0;
        }
        if (this.exifTime == null) {
            return -1;
        }
        return 1;
    }

    public int hashCode() {
        return Objects.hash(this.height, this.width, this.isNewGpsData, this.elevation, this.exifCoor, this.exifGpsTime, this.exifImgDir, this.exifOrientation, this.exifTime, this.iptcCaption, this.iptcHeadline, this.iptcKeywords, this.iptcObjectName, this.file, this.gpsTime, this.pos, this.speed, this.tmp);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        GpxImageEntry other = (GpxImageEntry)obj;
        return this.height == other.height && this.width == other.width && this.isNewGpsData == other.isNewGpsData && Objects.equals(this.elevation, other.elevation) && Objects.equals(this.exifCoor, other.exifCoor) && Objects.equals(this.exifGpsTime, other.exifGpsTime) && Objects.equals(this.exifImgDir, other.exifImgDir) && Objects.equals(this.exifOrientation, other.exifOrientation) && Objects.equals(this.exifTime, other.exifTime) && Objects.equals(this.iptcCaption, other.iptcCaption) && Objects.equals(this.iptcHeadline, other.iptcHeadline) && Objects.equals(this.iptcKeywords, other.iptcKeywords) && Objects.equals(this.iptcObjectName, other.iptcObjectName) && Objects.equals(this.file, other.file) && Objects.equals(this.gpsTime, other.gpsTime) && Objects.equals(this.pos, other.pos) && Objects.equals(this.speed, other.speed) && Objects.equals(this.tmp, other.tmp);
    }

    public void createTmp() {
        this.tmp = new GpxImageEntry(this);
        this.tmp.tmp = null;
    }

    public GpxImageEntry getTmp() {
        if (this.tmp == null) {
            this.createTmp();
        }
        return this.tmp;
    }

    public void applyTmp() {
        if (this.tmp != null) {
            this.pos = this.tmp.pos;
            this.speed = this.tmp.speed;
            this.elevation = this.tmp.elevation;
            this.gpsTime = this.tmp.gpsTime;
            this.exifImgDir = this.tmp.exifImgDir;
            this.isNewGpsData = this.tmp.isNewGpsData;
            this.tmp = null;
        }
    }

    public void discardTmp() {
        this.tmp = null;
    }

    public boolean isTagged() {
        return this.pos != null;
    }

    public String toString() {
        return this.file.getName() + ": pos = " + this.pos + " | exifCoor = " + this.exifCoor + " | " + (this.tmp == null ? " tmp==null" : " [tmp] pos = " + this.tmp.pos);
    }

    public void flagNewGpsData() {
        this.isNewGpsData = true;
    }

    public void unflagNewGpsData() {
        this.isNewGpsData = false;
    }

    public boolean hasNewGpsData() {
        if (this.tmp != null) {
            return this.tmp.isNewGpsData;
        }
        return this.isNewGpsData;
    }

    public void extractExif() {
        Metadata metadata;
        if (this.file == null) {
            return;
        }
        try {
            metadata = JpegMetadataReader.readMetadata(this.file);
        }
        catch (CompoundException | IOException ex) {
            Logging.error(ex);
            this.setExifTime(null);
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        try {
            this.setExifTime(ExifReader.readTime(metadata));
        }
        catch (IllegalArgumentException | IllegalStateException | JosmRuntimeException ex) {
            Logging.warn(ex);
            this.setExifTime(null);
        }
        JpegDirectory dir = metadata.getFirstDirectoryOfType(JpegDirectory.class);
        ExifIFD0Directory dirExif = metadata.getFirstDirectoryOfType(ExifIFD0Directory.class);
        GpsDirectory dirGps = metadata.getFirstDirectoryOfType(GpsDirectory.class);
        try {
            if (dirExif != null) {
                this.setExifOrientation(dirExif.getInt(274));
            }
        }
        catch (MetadataException ex) {
            Logging.debug(ex);
        }
        try {
            if (dir != null) {
                this.setWidth(dir.getInt(3));
                this.setHeight(dir.getInt(1));
            }
        }
        catch (MetadataException ex) {
            Logging.debug(ex);
        }
        if (dirGps == null) {
            this.setExifCoor(null);
            this.setPos(null);
            return;
        }
        GpxImageEntry.ifNotNull(ExifReader.readSpeed(dirGps), this::setSpeed);
        GpxImageEntry.ifNotNull(ExifReader.readElevation(dirGps), this::setElevation);
        try {
            this.setExifCoor(ExifReader.readLatLon(dirGps));
            this.setPos(this.getExifCoor());
        }
        catch (MetadataException | IndexOutOfBoundsException ex) {
            Logging.error("Error reading EXIF from file: " + ex);
            this.setExifCoor(null);
            this.setPos(null);
        }
        try {
            GpxImageEntry.ifNotNull(ExifReader.readDirection(dirGps), this::setExifImgDir);
        }
        catch (IndexOutOfBoundsException ex) {
            Logging.debug(ex);
        }
        GpxImageEntry.ifNotNull(dirGps.getGpsDate(), this::setExifGpsTime);
        IptcDirectory dirIptc = metadata.getFirstDirectoryOfType(IptcDirectory.class);
        if (dirIptc != null) {
            GpxImageEntry.ifNotNull(ExifReader.readCaption(dirIptc), this::setIptcCaption);
            GpxImageEntry.ifNotNull(ExifReader.readHeadline(dirIptc), this::setIptcHeadline);
            GpxImageEntry.ifNotNull(ExifReader.readKeywords(dirIptc), this::setIptcKeywords);
            GpxImageEntry.ifNotNull(ExifReader.readObjectName(dirIptc), this::setIptcObjectName);
        }
    }

    private static <T> void ifNotNull(T value, Consumer<T> setter) {
        if (value != null) {
            setter.accept(value);
        }
    }
}

