/*
 * Decompiled with CFR 0.152.
 */
package org.semanticweb.owlapi.rdf.rdfxml.parser;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.semanticweb.owlapi.rdf.rdfxml.parser.AbstractState;
import org.semanticweb.owlapi.rdf.rdfxml.parser.NodeElement;
import org.semanticweb.owlapi.rdf.rdfxml.parser.RDFParser;
import org.semanticweb.owlapi.rdf.rdfxml.parser.State;
import org.semanticweb.owlapi.util.OWLAPIPreconditions;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

class ResourceOrLiteralElement
extends AbstractState
implements State {
    @Nonnull
    protected final NodeElement nodeElement;
    protected String propertyIRI;
    @Nullable
    protected String reificationID;
    protected String datatype;
    protected StringBuilder text;
    protected NodeElement innerNode;

    @Nonnull
    protected String propertyIRI() {
        return OWLAPIPreconditions.verifyNotNull(this.propertyIRI);
    }

    ResourceOrLiteralElement(@Nonnull NodeElement nodeElement, @Nonnull RDFParser parser) {
        super(parser);
        this.nodeElement = nodeElement;
    }

    @Override
    public void startElement(String namespaceIRI, String localName, String qName, @Nonnull Attributes atts) throws SAXException {
        if (this.text == null) {
            this.propertyIRI = this.nodeElement.getPropertyIRI(namespaceIRI + localName);
            this.reificationID = this.nodeElement.getReificationID(atts);
            this.datatype = atts.getValue("http://www.w3.org/1999/02/22-rdf-syntax-ns#", "datatype");
            this.text = new StringBuilder();
        } else {
            this.parser.verify(this.notBlank(OWLAPIPreconditions.verifyNotNull(this.text)), "Text was seen and new node is started.");
            this.parser.verify(this.datatype != null, "rdf:datatype specified on a node with resource value.");
            this.innerNode = new NodeElement(this.parser);
            this.parser.pushState(this.innerNode);
            this.parser.state.startElement(namespaceIRI, localName, qName, atts);
        }
    }

    @Override
    public void endElement(String namespaceIRI, String localName, String qName) {
        if (this.innerNode != null) {
            this.parser.statementWithResourceValue(this.nodeElement.subjectIRI(), this.propertyIRI(), this.innerNode.subjectIRI(), this.reificationID);
        } else {
            this.parser.statementWithLiteralValue(this.nodeElement.subjectIRI(), this.propertyIRI(), OWLAPIPreconditions.verifyNotNull(this.text.toString()), this.datatype, this.reificationID);
        }
        this.parser.popState();
    }

    @Override
    public void characters(char[] data, int start, int length) {
        if (this.innerNode != null) {
            this.parser.verify(this.notBlank(data, start, length), "Cannot answer characters when object properties are expected.");
        } else {
            this.text.append(data, start, length);
        }
    }
}

