/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.core.type;

import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameUtils;
import io.micronaut.core.type.Argument;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

@Internal
public class DefaultArgument<T>
implements Argument<T> {
    private final Class<T> type;
    private final String name;
    private final Map<String, Argument<?>> typeParameters;
    private final Argument[] typeParameterArray;
    private final AnnotationMetadata annotationMetadata;

    public DefaultArgument(Class<T> type, String name, AnnotationMetadata annotationMetadata, Argument ... genericTypes) {
        this.type = type;
        this.name = name;
        this.annotationMetadata = annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA;
        this.typeParameters = this.initializeTypeParameters(genericTypes);
        this.typeParameterArray = genericTypes;
    }

    public DefaultArgument(Class<T> type, String name, AnnotationMetadata annotationMetadata, Map<String, Argument<?>> typeParameters, Argument[] typeParameterArray) {
        this.type = type;
        this.name = name;
        this.annotationMetadata = annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA;
        this.typeParameters = typeParameters;
        this.typeParameterArray = typeParameterArray;
    }

    public DefaultArgument(Type type, String name, AnnotationMetadata annotationMetadata) {
        AnnotationMetadata annotationMetadata2 = this.annotationMetadata = annotationMetadata != null ? annotationMetadata : AnnotationMetadata.EMPTY_METADATA;
        if (type == null) {
            type = this.getClass().getGenericSuperclass();
            if (type instanceof ParameterizedType) {
                type = ((ParameterizedType)type).getActualTypeArguments()[0];
            } else {
                throw new IllegalArgumentException(type + " is not parameterized");
            }
        }
        if (type instanceof Class) {
            this.type = (Class)type;
            this.typeParameterArray = Argument.ZERO_ARGUMENTS;
        } else if (type instanceof ParameterizedType) {
            ParameterizedType parameterizedType = (ParameterizedType)type;
            this.type = (Class)parameterizedType.getRawType();
            TypeVariable<Class<T>>[] params = this.type.getTypeParameters();
            Type[] paramValues = parameterizedType.getActualTypeArguments();
            this.typeParameterArray = new Argument[params.length];
            for (int i = 0; i < params.length; ++i) {
                TypeVariable<Class<T>> param = params[i];
                Type value = paramValues[i];
                this.typeParameterArray[i] = new DefaultArgument<T>(value, param.getName(), AnnotationMetadata.EMPTY_METADATA);
            }
        } else {
            throw new IllegalArgumentException(type.getClass().getSimpleName() + " types are not supported");
        }
        if (name == null) {
            name = NameUtils.decapitalize(this.type.getSimpleName());
        }
        this.name = name;
        this.typeParameters = this.initializeTypeParameters(this.typeParameterArray);
    }

    @Override
    public AnnotationMetadata getAnnotationMetadata() {
        return this.annotationMetadata;
    }

    @Override
    public Optional<Argument<?>> getFirstTypeVariable() {
        if (!this.typeParameters.isEmpty()) {
            return this.typeParameters.values().stream().findFirst();
        }
        return Optional.empty();
    }

    @Override
    public Argument[] getTypeParameters() {
        return this.typeParameterArray;
    }

    @Override
    public Map<String, Argument<?>> getTypeVariables() {
        return this.typeParameters;
    }

    @Override
    public Class<T> getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.type.getSimpleName() + " " + this.name;
    }

    @Override
    public boolean equalsType(Argument<?> o) {
        if (this == o) {
            return true;
        }
        if (o == null) {
            return false;
        }
        return Objects.equals(this.type, o.getType()) && Objects.equals(this.typeParameters, o.getTypeVariables());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultArgument)) {
            return false;
        }
        DefaultArgument that = (DefaultArgument)o;
        return Objects.equals(this.type, that.type) && Objects.equals(this.name, that.name) && Objects.equals(this.typeParameters, that.typeParameters);
    }

    @Override
    public int typeHashCode() {
        return Objects.hash(this.type, this.typeParameters);
    }

    public int hashCode() {
        return Objects.hash(this.type, this.name, this.typeParameters);
    }

    private Map<String, Argument<?>> initializeTypeParameters(Argument[] genericTypes) {
        Map<String, Argument<?>> typeParameters;
        if (genericTypes != null && genericTypes.length > 0) {
            typeParameters = new LinkedHashMap(genericTypes.length);
            for (Argument genericType : genericTypes) {
                typeParameters.put(genericType.getName(), genericType);
            }
        } else {
            typeParameters = Collections.emptyMap();
        }
        return typeParameters;
    }
}

