/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.inject.qualifiers;

import io.micronaut.context.Qualifier;
import io.micronaut.context.annotation.Primary;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.AnnotationValue;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.naming.NameResolver;
import io.micronaut.core.naming.Named;
import io.micronaut.core.util.ArgumentUtils;
import io.micronaut.inject.BeanType;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;

@Internal
class NameQualifier<T>
implements Qualifier<T>,
Named {
    private final String name;

    NameQualifier(String name) {
        this.name = Objects.requireNonNull(name, "Argument [name] cannot be null");
    }

    @Override
    public <BT extends BeanType<T>> Stream<BT> reduce(Class<T> beanType, Stream<BT> candidates) {
        ArgumentUtils.check((String)"beanType", beanType).notNull();
        ArgumentUtils.check((String)"candidates", candidates).notNull();
        return candidates.filter(candidate -> {
            if (!beanType.isAssignableFrom(candidate.getBeanType())) {
                return false;
            }
            AnnotationMetadata annotationMetadata = candidate.getAnnotationMetadata();
            Optional beanQualifier = annotationMetadata.findDeclaredAnnotation(javax.inject.Named.class).flatMap(AnnotationValue::stringValue);
            String typeName = beanQualifier.orElseGet(() -> {
                if (candidate instanceof NameResolver) {
                    Optional resolvedName = ((NameResolver)candidate).resolveName();
                    return resolvedName.orElse(candidate.getBeanType().getSimpleName());
                }
                return candidate.getBeanType().getSimpleName();
            });
            return typeName.equalsIgnoreCase(this.name) || typeName.equalsIgnoreCase(this.name + beanType.getSimpleName());
        });
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !NameQualifier.class.isAssignableFrom(o.getClass())) {
            return false;
        }
        NameQualifier that = (NameQualifier)o;
        return this.name.equals(that.name);
    }

    public String toString() {
        return "@Named('" + this.name + "')";
    }

    public int hashCode() {
        return this.name.hashCode();
    }

    public String getName() {
        return this.name;
    }

    protected <BT extends BeanType<T>> Stream<BT> reduceByAnnotation(Class<T> beanType, Stream<BT> candidates, String annotationName, String qualifiedName) {
        return candidates.filter(candidate -> {
            String candidateName;
            if (candidate.isPrimary() && Primary.class.getSimpleName().equals(annotationName)) {
                return true;
            }
            if (candidate instanceof NameResolver) {
                candidateName = ((NameResolver)candidate).resolveName().orElse(candidate.getBeanType().getSimpleName());
            } else {
                Optional annotation = candidate.getAnnotationMetadata().stringValue(javax.inject.Named.class);
                candidateName = annotation.orElse(candidate.getBeanType().getSimpleName());
            }
            if (candidateName.equalsIgnoreCase(annotationName)) {
                return true;
            }
            String qualified = annotationName + beanType.getSimpleName();
            if (qualified.equals(candidateName)) {
                return true;
            }
            return qualifiedName != null && candidate.getAnnotationMetadata().hasDeclaredAnnotation(qualifiedName);
        });
    }

    protected <BT extends BeanType<T>> Stream<BT> reduceByName(Class<T> beanType, Stream<BT> candidates, String annotationName) {
        return candidates.filter(candidate -> {
            String candidateName;
            if (candidate.isPrimary() && Primary.class.getSimpleName().equals(annotationName)) {
                return true;
            }
            if (candidate instanceof NameResolver) {
                candidateName = ((NameResolver)candidate).resolveName().orElse(candidate.getBeanType().getSimpleName());
            } else {
                Optional annotation = candidate.getAnnotationMetadata().stringValue(javax.inject.Named.class);
                candidateName = annotation.orElse(candidate.getBeanType().getSimpleName());
            }
            if (candidateName.equalsIgnoreCase(annotationName)) {
                return true;
            }
            String qualified = annotationName + beanType.getSimpleName();
            return qualified.equals(candidateName);
        });
    }
}

