/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.nio.file.InvalidPathException;
import java.util.LinkedList;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import org.openstreetmap.josm.actions.DiskAccessAction;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.PreferencesUtils;
import org.openstreetmap.josm.gui.ExtendedDialog;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileExporter;
import org.openstreetmap.josm.gui.layer.Layer;
import org.openstreetmap.josm.gui.layer.OsmDataLayer;
import org.openstreetmap.josm.gui.layer.SaveToFile;
import org.openstreetmap.josm.gui.util.GuiHelper;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Shortcut;
import org.openstreetmap.josm.tools.Utils;

public abstract class SaveActionBase
extends DiskAccessAction {
    public SaveActionBase(String name, String iconName, String tooltip, Shortcut shortcut) {
        super(name, iconName, tooltip, shortcut);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        this.doSave();
    }

    public boolean doSave() {
        Layer layer = this.getLayerManager().getActiveLayer();
        if (layer != null && layer.isSavable()) {
            return this.doSave(layer);
        }
        return false;
    }

    public boolean doSave(Layer layer) {
        if (!layer.checkSaveConditions()) {
            return false;
        }
        boolean requiresSave = layer instanceof SaveToFile && ((SaveToFile)((Object)layer)).requiresSaveToFile();
        boolean result = SaveActionBase.doInternalSave(layer, this.getFile(layer));
        if (!requiresSave) {
            this.updateEnabledState();
        }
        return result;
    }

    public static boolean doSave(Layer layer, File file, boolean checkSaveConditions) {
        if (checkSaveConditions && !layer.checkSaveConditions()) {
            return false;
        }
        return SaveActionBase.doInternalSave(layer, file);
    }

    private static boolean doInternalSave(Layer layer, File file) {
        if (file == null) {
            return false;
        }
        try {
            boolean exported = false;
            boolean canceled = false;
            for (FileExporter exporter : ExtensionFileFilter.getExporters()) {
                if (!exporter.acceptFile(file, layer)) continue;
                exporter.exportData(file, layer);
                exported = true;
                canceled = exporter.isCanceled();
                break;
            }
            if (!exported) {
                GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("No Exporter found! Nothing saved.", new Object[0]), I18n.tr("Warning", new Object[0]), 2));
                return false;
            }
            if (canceled) {
                return false;
            }
            if (!layer.isRenamed()) {
                layer.setName(file.getName());
            }
            layer.setAssociatedFile(file);
            if (layer instanceof OsmDataLayer) {
                ((OsmDataLayer)layer).onPostSaveToFile();
            }
        }
        catch (IOException | InvalidPathException e) {
            SaveActionBase.showAndLogException(e);
            return false;
        }
        SaveActionBase.addToFileOpenHistory(file);
        return true;
    }

    protected abstract File getFile(Layer var1);

    @Override
    protected void updateEnabledState() {
        Layer activeLayer = this.getLayerManager().getActiveLayer();
        this.setEnabled(activeLayer != null && activeLayer.isSavable());
    }

    public static File createAndOpenSaveFileChooser(String title, ExtensionFileFilter filter) {
        AbstractFileChooser fc = SaveActionBase.createAndOpenFileChooser(false, false, title, filter, 0, null);
        return SaveActionBase.checkFileAndConfirmOverWrite(fc, filter.getDefaultExtension());
    }

    public static File createAndOpenSaveFileChooser(String title, String extension) {
        AbstractFileChooser fc = SaveActionBase.createAndOpenFileChooser(false, false, title, extension);
        return SaveActionBase.checkFileAndConfirmOverWrite(fc, extension);
    }

    public static File checkFileAndConfirmOverWrite(AbstractFileChooser fc, String extension) {
        if (fc == null) {
            return null;
        }
        File file = fc.getSelectedFile();
        FileFilter ff = fc.getFileFilter();
        if (!ff.accept(file)) {
            for (FileFilter cff : fc.getChoosableFileFilters()) {
                if (!cff.accept(file)) continue;
                fc.setFileFilter(cff);
                return file;
            }
            String fn = file.getPath();
            if (extension != null && ff.accept(new File(fn + '.' + extension))) {
                fn = fn + '.' + extension;
            } else if (ff instanceof ExtensionFileFilter) {
                fn = fn + '.' + ((ExtensionFileFilter)ff).getDefaultExtension();
            }
            file = new File(fn);
            if (!fc.getSelectedFile().exists() && !SaveActionBase.confirmOverwrite(file)) {
                return null;
            }
        }
        return file;
    }

    public static boolean confirmOverwrite(File file) {
        if (file == null || file.exists()) {
            return new ExtendedDialog((Component)MainApplication.getMainFrame(), I18n.tr("Overwrite", new Object[0]), I18n.tr("Overwrite", new Object[0]), I18n.tr("Cancel", new Object[0])).setContent(I18n.tr("File exists. Overwrite?", new Object[0])).setButtonIcons("save_as", "cancel").showDialog().getValue() == 1;
        }
        return true;
    }

    static void addToFileOpenHistory(File file) {
        String filepath;
        try {
            filepath = file.getCanonicalPath();
        }
        catch (IOException ign) {
            Logging.warn(ign);
            return;
        }
        int maxsize = Math.max(0, Config.getPref().getInt("file-open.history.max-size", 15));
        List<String> oldHistory = Config.getPref().getList("file-open.history");
        LinkedList<String> history = new LinkedList<String>(oldHistory);
        history.remove(filepath);
        history.add(0, filepath);
        PreferencesUtils.putListBounded(Config.getPref(), "file-open.history", maxsize, history);
    }

    static void showAndLogException(Exception e) {
        GuiHelper.runInEDT(() -> JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("<html>An error occurred while saving.<br>Error is:<br>{0}</html>", Utils.escapeReservedCharactersHTML(e.getClass().getSimpleName() + " - " + e.getMessage())), I18n.tr("Error", new Object[0]), 0));
        Logging.error(e);
    }
}

