/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.io.importexport;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.notes.Note;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.FileImporter;
import org.openstreetmap.josm.gui.layer.NoteLayer;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.NoteReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public class NoteImporter
extends FileImporter {
    public static final ExtensionFileFilter FILE_FILTER = ExtensionFileFilter.newFilterWithArchiveExtensions("osn", "osn", I18n.tr("Note Files", new Object[0]), true);

    public NoteImporter() {
        super(FILE_FILTER);
    }

    @Override
    public void importData(File file, ProgressMonitor progressMonitor) throws IOException {
        if (Logging.isDebugEnabled()) {
            Logging.debug("importing notes file {0}", file.getAbsolutePath());
        }
        try (InputStream is = Compression.getUncompressedFileInputStream(file);){
            NoteLayer layer = this.loadLayer(is, file, file.getName(), progressMonitor);
            if (!MainApplication.getLayerManager().containsLayer(layer)) {
                MainApplication.getLayerManager().addLayer(layer);
            }
        }
        catch (SAXException e) {
            Logging.error("error opening up notes file");
            Logging.error(e);
            throw new IOException(e.getMessage(), e);
        }
    }

    public NoteLayer loadLayer(InputStream in, File associatedFile, String layerName, ProgressMonitor progressMonitor) throws SAXException, IOException {
        List<Note> fileNotes = new NoteReader(in).parse();
        NoteLayer layer = MainApplication.getLayerManager().getNoteLayer();
        if (layer != null) {
            layer.getNoteData().addNotes(fileNotes);
        } else {
            layer = new NoteLayer(fileNotes, associatedFile != null ? associatedFile.getName() : I18n.tr("Notes", new Object[0]));
        }
        return layer;
    }
}

