/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.tools;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Scanner;
import java.util.TreeMap;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.GZIPInputStream;
import org.openstreetmap.josm.data.validation.routines.DomainValidator;
import org.openstreetmap.josm.gui.progress.NullProgressMonitor;
import org.openstreetmap.josm.gui.progress.ProgressMonitor;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.NetworkManager;
import org.openstreetmap.josm.io.ProgressInputStream;
import org.openstreetmap.josm.io.UTFInputStreamReader;
import org.openstreetmap.josm.io.auth.DefaultAuthenticator;
import org.openstreetmap.josm.spi.preferences.Config;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.JosmRuntimeException;
import org.openstreetmap.josm.tools.Logging;
import org.openstreetmap.josm.tools.Utils;

public abstract class HttpClient {
    private URL url;
    private final String requestMethod;
    private int connectTimeout = (int)TimeUnit.SECONDS.toMillis(Config.getPref().getInt("socket.timeout.connect", 15));
    private int readTimeout = (int)TimeUnit.SECONDS.toMillis(Config.getPref().getInt("socket.timeout.read", 30));
    private byte[] requestBody;
    private long ifModifiedSince;
    private final Map<String, String> headers = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
    private int maxRedirects = Config.getPref().getInt("socket.maxredirects", 5);
    private boolean useCache;
    private String reasonForRequest;
    private String outputMessage = I18n.tr("Uploading data ...", new Object[0]);
    private Response response;
    private boolean finishOnCloseOutput = true;
    private boolean debug;
    private static final Pattern TOMCAT_ERR_MESSAGE = Pattern.compile(".*<p><b>[^<]+</b>[^<]+</p><p><b>[^<]+</b> (?:<u>)?([^<]*)(?:</u>)?</p><p><b>[^<]+</b> (?:<u>)?[^<]*(?:</u>)?</p>.*", 2);
    private static HttpClientFactory factory;

    public static void setFactory(HttpClientFactory newFactory) {
        factory = Objects.requireNonNull(newFactory);
    }

    protected HttpClient(URL url, String requestMethod) {
        try {
            String host = url.getHost();
            String asciiHost = DomainValidator.unicodeToASCII(host);
            this.url = asciiHost.equals(host) ? url : new URL(url.getProtocol(), asciiHost, url.getPort(), url.getFile());
        }
        catch (MalformedURLException e) {
            throw new JosmRuntimeException(e);
        }
        this.requestMethod = requestMethod;
        this.headers.put("Accept-Encoding", "gzip");
    }

    public final Response connect() throws IOException {
        return this.connect(null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Response connect(ProgressMonitor progressMonitor) throws IOException {
        if (progressMonitor == null) {
            progressMonitor = NullProgressMonitor.INSTANCE;
        }
        this.setupConnection(progressMonitor);
        boolean successfulConnection = false;
        try {
            ConnectionResponse cr;
            try {
                cr = this.performConnection();
                boolean hasReason = this.reasonForRequest != null && !this.reasonForRequest.isEmpty();
                this.logRequest("{0} {1}{2} -> {3} {4}{5}", this.getRequestMethod(), this.getURL(), hasReason ? " (" + this.reasonForRequest + ')' : "", cr.getResponseVersion(), cr.getResponseCode(), cr.getContentLengthLong() > 0L ? " (" + Utils.getSizeString(cr.getContentLengthLong(), Locale.getDefault()) + ')' : "");
                if (Logging.isDebugEnabled()) {
                    try {
                        Logging.debug("RESPONSE: {0}", cr.getHeaderFields());
                    }
                    catch (IllegalArgumentException e) {
                        Logging.warn(e);
                    }
                }
                if (DefaultAuthenticator.getInstance().isEnabled() && cr.getResponseCode() == 401) {
                    DefaultAuthenticator.getInstance().addFailedCredentialHost(this.url.getHost());
                }
            }
            catch (IOException | RuntimeException e) {
                this.logRequest("{0} {1} -> !!!", this.requestMethod, this.url);
                Logging.warn(e);
                NetworkManager.addNetworkError(this.url, Utils.getRootCause(e));
                throw e;
            }
            if (HttpClient.isRedirect(cr.getResponseCode())) {
                String redirectLocation = cr.getHeaderField("Location");
                if (redirectLocation == null) {
                    throw new IOException(I18n.tr("Unexpected response from HTTP server. Got {0} response without ''Location'' header. Can''t redirect. Aborting.", cr.getResponseCode()));
                }
                if (this.maxRedirects > 0) {
                    this.url = new URL(this.url, redirectLocation);
                    --this.maxRedirects;
                    this.logRequest(I18n.tr("Download redirected to ''{0}''", redirectLocation), new Object[0]);
                    this.response = this.connect();
                    successfulConnection = true;
                    Response e = this.response;
                    return e;
                }
                if (this.maxRedirects == 0) {
                    String msg = I18n.tr("Too many redirects to the download URL detected. Aborting.", new Object[0]);
                    throw new IOException(msg);
                }
            }
            this.response = this.buildResponse(progressMonitor);
            successfulConnection = true;
            Response response = this.response;
            return response;
        }
        finally {
            if (!successfulConnection) {
                this.performDisconnection();
            }
        }
    }

    protected abstract void setupConnection(ProgressMonitor var1) throws IOException;

    protected abstract ConnectionResponse performConnection() throws IOException;

    protected abstract void performDisconnection() throws IOException;

    protected abstract Response buildResponse(ProgressMonitor var1) throws IOException;

    protected final void notifyConnect(ProgressMonitor progressMonitor) {
        progressMonitor.beginTask(I18n.tr("Contacting Server...", new Object[0]), 1);
        progressMonitor.indeterminateSubTask(null);
    }

    protected final void logRequest(String pattern, Object ... args) {
        if (this.debug) {
            Logging.debug(pattern, args);
        } else {
            Logging.info(pattern, args);
        }
    }

    protected final void logRequestBody() {
        this.logRequest("{0} {1} ({2}) ...", this.requestMethod, this.url, Utils.getSizeString(this.requestBody.length, Locale.getDefault()));
        if (Logging.isTraceEnabled() && this.hasRequestBody()) {
            Logging.trace("BODY: {0}", new String(this.requestBody, StandardCharsets.UTF_8));
        }
    }

    public final Response getResponse() {
        return this.response;
    }

    public static HttpClient create(URL url) {
        return HttpClient.create(url, "GET");
    }

    public static HttpClient create(URL url, String requestMethod) {
        return factory.create(url, requestMethod);
    }

    public final URL getURL() {
        return this.url;
    }

    public final byte[] getRequestBody() {
        return Utils.copyArray(this.requestBody);
    }

    public final boolean hasRequestBody() {
        return this.requestBody != null && this.requestBody.length > 0;
    }

    public final boolean requiresBody() {
        return "PUT".equals(this.requestMethod) || "POST".equals(this.requestMethod) || "DELETE".equals(this.requestMethod);
    }

    public final String getRequestMethod() {
        return this.requestMethod;
    }

    public final String getRequestHeader(String header) {
        return this.headers.get(header);
    }

    public final int getConnectTimeout() {
        return this.connectTimeout;
    }

    public final int getReadTimeout() {
        return this.readTimeout;
    }

    public final long getIfModifiedSince() {
        return this.ifModifiedSince;
    }

    public final boolean isUseCache() {
        return this.useCache;
    }

    public final Map<String, String> getHeaders() {
        return this.headers;
    }

    public final String getReasonForRequest() {
        return this.reasonForRequest;
    }

    protected final String getOutputMessage() {
        return this.outputMessage;
    }

    protected final boolean isFinishOnCloseOutput() {
        return this.finishOnCloseOutput;
    }

    public final HttpClient useCache(boolean useCache) {
        this.useCache = useCache;
        return this;
    }

    public final HttpClient keepAlive(boolean keepAlive) {
        return this.setHeader("Connection", keepAlive ? null : "close");
    }

    public final HttpClient setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
        return this;
    }

    public final HttpClient setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
        return this;
    }

    public final HttpClient setAccept(String accept) {
        return this.setHeader("Accept", accept);
    }

    public final HttpClient setRequestBody(byte[] requestBody) {
        this.requestBody = Utils.copyArray(requestBody);
        return this;
    }

    public final HttpClient setIfModifiedSince(long ifModifiedSince) {
        this.ifModifiedSince = ifModifiedSince;
        return this;
    }

    public final HttpClient setMaxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public final HttpClient setHeader(String key, String value) {
        this.headers.put(key, value);
        return this;
    }

    public final HttpClient setHeaders(Map<String, String> headers) {
        this.headers.putAll(headers);
        return this;
    }

    public final HttpClient setReasonForRequest(String reasonForRequest) {
        this.reasonForRequest = reasonForRequest;
        return this;
    }

    public final HttpClient setOutputMessage(String outputMessage) {
        this.outputMessage = outputMessage;
        return this;
    }

    public final HttpClient setFinishOnCloseOutput(boolean finishOnCloseOutput) {
        this.finishOnCloseOutput = finishOnCloseOutput;
        return this;
    }

    public final HttpClient setLogAtDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public static boolean isRedirect(int statusCode) {
        switch (statusCode) {
            case 301: 
            case 302: 
            case 303: 
            case 307: 
            case 308: {
                return true;
            }
        }
        return false;
    }

    public abstract void disconnect();

    public static Matcher getTomcatErrorMatcher(String data) {
        return data != null ? TOMCAT_ERR_MESSAGE.matcher(data) : null;
    }

    static {
        try {
            CookieHandler.setDefault(new CookieManager());
        }
        catch (SecurityException e) {
            Logging.log(Logging.LEVEL_ERROR, "Unable to set default cookie handler", e);
        }
    }

    public static abstract class Response {
        private final ProgressMonitor monitor;
        private final int responseCode;
        private final String responseMessage;
        private boolean uncompress;
        private boolean uncompressAccordingToContentDisposition;
        private String responseData;

        protected Response(ProgressMonitor monitor, int responseCode, String responseMessage) {
            this.monitor = Objects.requireNonNull(monitor, "monitor");
            this.responseCode = responseCode;
            this.responseMessage = responseMessage;
        }

        protected final void debugRedirect() throws IOException {
            if (this.responseCode >= 300) {
                String contentType = this.getContentType();
                if (contentType == null || contentType.contains("text") || contentType.contains("html") || contentType.contains("xml")) {
                    String content = this.fetchContent();
                    Logging.debug(content.isEmpty() ? "Server did not return any body" : "Response body: \n" + content);
                } else {
                    Logging.debug("Server returned content: {0} of length: {1}. Not printing.", contentType, this.getContentLength());
                }
            }
        }

        public final Response uncompress(boolean uncompress) {
            this.uncompress = uncompress;
            return this;
        }

        public final Response uncompressAccordingToContentDisposition(boolean uncompressAccordingToContentDisposition) {
            this.uncompressAccordingToContentDisposition = uncompressAccordingToContentDisposition;
            return this;
        }

        public abstract URL getURL();

        public abstract String getRequestMethod();

        public final InputStream getContent() throws IOException {
            InputStream in = this.getInputStream();
            in = new ProgressInputStream(in, this.getContentLength(), this.monitor);
            in = "gzip".equalsIgnoreCase(this.getContentEncoding()) ? new GZIPInputStream(in) : in;
            Compression compression = Compression.NONE;
            if (this.uncompress) {
                String contentType = this.getContentType();
                Logging.debug("Uncompressing input stream according to Content-Type header: {0}", contentType);
                compression = Compression.forContentType(contentType);
            }
            if (this.uncompressAccordingToContentDisposition && Compression.NONE == compression) {
                String contentDisposition = this.getHeaderField("Content-Disposition");
                Matcher matcher = Pattern.compile("filename=\"([^\"]+)\"").matcher(contentDisposition != null ? contentDisposition : "");
                if (matcher.find()) {
                    Logging.debug("Uncompressing input stream according to Content-Disposition header: {0}", contentDisposition);
                    compression = Compression.byExtension(matcher.group(1));
                }
            }
            in = compression.getUncompressedInputStream(in);
            return in;
        }

        protected abstract InputStream getInputStream() throws IOException;

        public final BufferedReader getContentReader() throws IOException {
            return new BufferedReader(UTFInputStreamReader.create(this.getContent()));
        }

        public final synchronized String fetchContent() throws IOException {
            if (this.responseData == null) {
                try (Scanner scanner = new Scanner(this.getContentReader()).useDelimiter("\\A");){
                    this.responseData = scanner.hasNext() ? scanner.next() : "";
                }
            }
            return this.responseData;
        }

        public final int getResponseCode() {
            return this.responseCode;
        }

        public final String getResponseMessage() {
            return this.responseMessage;
        }

        public abstract String getContentEncoding();

        public abstract String getContentType();

        public abstract long getExpiration();

        public abstract long getLastModified();

        public abstract long getContentLength();

        public abstract String getHeaderField(String var1);

        public abstract Map<String, List<String>> getHeaderFields();

        public abstract void disconnect();
    }

    public static interface ConnectionResponse {
        public String getResponseVersion();

        public int getResponseCode() throws IOException;

        public long getContentLengthLong();

        public Map<String, List<String>> getHeaderFields();

        public String getHeaderField(String var1);
    }

    @FunctionalInterface
    public static interface HttpClientFactory {
        public HttpClient create(URL var1, String var2);
    }
}

