/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.buildinit.plugins.internal;

import java.util.Collections;
import java.util.Set;
import org.gradle.api.internal.file.FileResolver;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilder;
import org.gradle.buildinit.plugins.internal.BuildScriptBuilderFactory;
import org.gradle.buildinit.plugins.internal.DefaultTemplateLibraryVersionProvider;
import org.gradle.buildinit.plugins.internal.InitSettings;
import org.gradle.buildinit.plugins.internal.JvmProjectInitDescriptor;
import org.gradle.buildinit.plugins.internal.TemplateOperation;
import org.gradle.buildinit.plugins.internal.TemplateOperationFactory;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitDsl;
import org.gradle.buildinit.plugins.internal.modifiers.BuildInitTestFramework;

public class KotlinApplicationProjectInitDescriptor
extends JvmProjectInitDescriptor {
    public KotlinApplicationProjectInitDescriptor(BuildScriptBuilderFactory scriptBuilderFactory, TemplateOperationFactory templateOperationFactory, FileResolver fileResolver, DefaultTemplateLibraryVersionProvider versionProvider) {
        super("kotlin", scriptBuilderFactory, templateOperationFactory, fileResolver, versionProvider);
    }

    @Override
    public String getId() {
        return "kotlin-application";
    }

    @Override
    public BuildInitDsl getDefaultDsl() {
        return BuildInitDsl.KOTLIN;
    }

    @Override
    public BuildInitTestFramework getDefaultTestFramework() {
        return BuildInitTestFramework.KOTLINTEST;
    }

    @Override
    public Set<BuildInitTestFramework> getTestFrameworks() {
        return Collections.singleton(BuildInitTestFramework.KOTLINTEST);
    }

    @Override
    protected void generate(InitSettings settings, BuildScriptBuilder buildScriptBuilder) {
        super.generate(settings, buildScriptBuilder);
        String kotlinVersion = this.libraryVersionProvider.getVersion("kotlin");
        buildScriptBuilder.fileComment("This generated file contains a sample Kotlin application project to get you started.").plugin("Apply the Kotlin JVM plugin to add support for Kotlin on the JVM.", "org.jetbrains.kotlin.jvm", kotlinVersion).plugin("Apply the application plugin to add support for building a CLI application.", "application").implementationDependency("Use the Kotlin JDK 8 standard library.", "org.jetbrains.kotlin:kotlin-stdlib-jdk8").testImplementationDependency("Use the Kotlin test library.", "org.jetbrains.kotlin:kotlin-test").testImplementationDependency("Use the Kotlin JUnit integration.", "org.jetbrains.kotlin:kotlin-test-junit").conventionPropertyAssignment("Define the main class for the application.", "application", "mainClassName", this.withPackage(settings, "AppKt"));
        TemplateOperation kotlinSourceTemplate = this.fromClazzTemplate("kotlinapp/App.kt.template", settings, "main");
        TemplateOperation kotlinTestTemplate = this.fromClazzTemplate("kotlinapp/AppTest.kt.template", settings, "test");
        this.whenNoSourcesAvailable(kotlinSourceTemplate, kotlinTestTemplate).generate();
    }
}

