/*
 * Decompiled with CFR 0.152.
 */
package org.freehep.graphics2d;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.print.PrinterGraphics;
import java.io.Serializable;
import javax.swing.JPanel;
import org.freehep.graphics2d.VectorGraphics;

public class BufferedPanel
extends JPanel
implements Serializable {
    private VectorGraphics offScreenGraphics;
    private Image offScreenImage;
    private Dimension oldDimension = new Dimension();
    private Dimension dim = new Dimension();
    private boolean printing = false;
    private boolean exporting = false;
    private boolean repaint = false;

    public BufferedPanel() {
        this(true);
    }

    public BufferedPanel(boolean opaque) {
        super(false);
        this.setOpaque(opaque);
    }

    @Override
    public void repaint() {
        super.repaint();
        this.repaint = true;
    }

    @Override
    public void invalidate() {
        super.invalidate();
        this.repaint = true;
    }

    private synchronized boolean shouldRepaint() {
        boolean result = this.repaint;
        this.repaint = false;
        return result;
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (g == null || this.offScreenImage == null) {
            return;
        }
        if (g instanceof PrinterGraphics) {
            this.printing = true;
        }
        if (g instanceof VectorGraphics) {
            this.exporting = true;
        }
        if (!this.isDisplaying()) {
            this.paintComponent(VectorGraphics.create(g));
            return;
        }
        if (this.shouldRepaint()) {
            this.paintComponent(this.offScreenGraphics);
        }
        g.drawImage(this.offScreenImage, 0, 0, this);
    }

    public Graphics getBufferedGraphics() {
        return this.offScreenGraphics;
    }

    public void paintComponent(VectorGraphics vg) {
    }

    @Override
    public void setBounds(int x, int y, int w, int h) {
        super.setBounds(x, y, w, h);
        this.makeImage();
    }

    public boolean isPrinting() {
        return this.printing;
    }

    public boolean isExporting() {
        return this.exporting;
    }

    public boolean isDisplaying() {
        return !this.isExporting() && !this.isPrinting();
    }

    private void makeImage() {
        this.dim = this.getSize(this.dim);
        if (this.dim.width > 0 && this.dim.height > 0) {
            if (!this.oldDimension.equals(this.dim)) {
                this.offScreenImage = this.isOpaque() ? super.createImage(this.dim.width, this.dim.height) : new BufferedImage(this.dim.width, this.dim.height, 2);
                this.offScreenGraphics = VectorGraphics.create(this.offScreenImage.getGraphics());
                this.oldDimension.setSize(this.dim);
            }
        } else {
            this.offScreenImage = null;
            this.offScreenGraphics = null;
        }
    }
}

