﻿/*
* Copyright 2010-2017 Amazon.com, Inc. or its affiliates. All Rights Reserved.
*
* Licensed under the Apache License, Version 2.0 (the "License").
* You may not use this file except in compliance with the License.
* A copy of the License is located at
*
*  http://aws.amazon.com/apache2.0
*
* or in the "license" file accompanying this file. This file is distributed
* on an "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either
* express or implied. See the License for the specific language governing
* permissions and limitations under the License.
*/

#pragma once
#include <aws/lakeformation/LakeFormation_EXPORTS.h>
#include <aws/core/utils/memory/stl/AWSVector.h>
#include <aws/core/utils/memory/stl/AWSString.h>
#include <aws/lakeformation/model/PrincipalResourcePermissions.h>
#include <utility>

namespace Aws
{
template<typename RESULT_TYPE>
class AmazonWebServiceResult;

namespace Utils
{
namespace Json
{
  class JsonValue;
} // namespace Json
} // namespace Utils
namespace LakeFormation
{
namespace Model
{
  class AWS_LAKEFORMATION_API ListPermissionsResult
  {
  public:
    ListPermissionsResult();
    ListPermissionsResult(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);
    ListPermissionsResult& operator=(const Aws::AmazonWebServiceResult<Aws::Utils::Json::JsonValue>& result);


    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline const Aws::Vector<PrincipalResourcePermissions>& GetPrincipalResourcePermissions() const{ return m_principalResourcePermissions; }

    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline void SetPrincipalResourcePermissions(const Aws::Vector<PrincipalResourcePermissions>& value) { m_principalResourcePermissions = value; }

    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline void SetPrincipalResourcePermissions(Aws::Vector<PrincipalResourcePermissions>&& value) { m_principalResourcePermissions = std::move(value); }

    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline ListPermissionsResult& WithPrincipalResourcePermissions(const Aws::Vector<PrincipalResourcePermissions>& value) { SetPrincipalResourcePermissions(value); return *this;}

    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline ListPermissionsResult& WithPrincipalResourcePermissions(Aws::Vector<PrincipalResourcePermissions>&& value) { SetPrincipalResourcePermissions(std::move(value)); return *this;}

    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline ListPermissionsResult& AddPrincipalResourcePermissions(const PrincipalResourcePermissions& value) { m_principalResourcePermissions.push_back(value); return *this; }

    /**
     * <p>A list of principals and their permissions on the resource for the specified
     * principal and resource types.</p>
     */
    inline ListPermissionsResult& AddPrincipalResourcePermissions(PrincipalResourcePermissions&& value) { m_principalResourcePermissions.push_back(std::move(value)); return *this; }


    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline const Aws::String& GetNextToken() const{ return m_nextToken; }

    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline void SetNextToken(const Aws::String& value) { m_nextToken = value; }

    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline void SetNextToken(Aws::String&& value) { m_nextToken = std::move(value); }

    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline void SetNextToken(const char* value) { m_nextToken.assign(value); }

    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline ListPermissionsResult& WithNextToken(const Aws::String& value) { SetNextToken(value); return *this;}

    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline ListPermissionsResult& WithNextToken(Aws::String&& value) { SetNextToken(std::move(value)); return *this;}

    /**
     * <p>A continuation token, if this is not the first call to retrieve this
     * list.</p>
     */
    inline ListPermissionsResult& WithNextToken(const char* value) { SetNextToken(value); return *this;}

  private:

    Aws::Vector<PrincipalResourcePermissions> m_principalResourcePermissions;

    Aws::String m_nextToken;
  };

} // namespace Model
} // namespace LakeFormation
} // namespace Aws
