/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.ion.apps;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import software.amazon.ion.IonCatalog;
import software.amazon.ion.IonException;
import software.amazon.ion.IonReader;
import software.amazon.ion.IonType;
import software.amazon.ion.IonWriter;
import software.amazon.ion.SymbolTable;
import software.amazon.ion.apps.BaseApp;

public class SymtabApp
extends BaseApp {
    private ArrayList<SymbolTable> myImports = new ArrayList();
    private ArrayList<String> mySymbols = new ArrayList();
    private String mySymtabName;
    private int mySymtabVersion;

    public static void main(String[] args) {
        if (args.length < 1) {
            System.err.println("Need one file to build symtab");
            return;
        }
        SymtabApp app = new SymtabApp();
        app.doMain(args);
    }

    protected int processOptions(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if ("--catalog".equals(arg)) {
                String symtabPath = args[++i];
                this.loadCatalog(symtabPath);
                continue;
            }
            if ("--import".equals(arg)) {
                String name2 = args[++i];
                IonCatalog catalog = this.mySystem.getCatalog();
                SymbolTable table = catalog.getTable(name2);
                if (table == null) {
                    String message = "There's no symbol table in the catalog named " + name2;
                    throw new RuntimeException(message);
                }
                this.myImports.add(table);
                this.logDebug("Imported symbol table " + name2 + "@" + table.getVersion());
                continue;
            }
            if ("--name".equals(arg)) {
                if (this.mySymtabName != null) {
                    throw new RuntimeException("Multiple names");
                }
                this.mySymtabName = args[++i];
                if (this.mySymtabName.length() != 0) continue;
                throw new RuntimeException("Name must not be empty");
            }
            if ("--version".equals(arg)) {
                if (this.mySymtabVersion != 0) {
                    throw new RuntimeException("Multiple versions");
                }
                int version = Integer.parseInt(arg);
                if (version < 1) {
                    throw new RuntimeException("Version must be at least 1");
                }
                if (version != 1) {
                    String message = "Symtab extension not implemented";
                    throw new UnsupportedOperationException(message);
                }
                this.mySymtabVersion = version;
                continue;
            }
            return i;
        }
        return args.length;
    }

    protected boolean optionsAreValid(String[] filePaths) {
        if (this.mySymtabName == null) {
            throw new RuntimeException("Must provide --name");
        }
        if (this.mySymtabVersion == 0) {
            this.mySymtabVersion = 1;
        }
        if (filePaths.length == 0) {
            System.err.println("Must provide list of files to provide symbols");
            return false;
        }
        return true;
    }

    public void processFiles(String[] filePaths) {
        super.processFiles(filePaths);
        SymbolTable[] importArray = new SymbolTable[this.myImports.size()];
        this.myImports.toArray(importArray);
        SymbolTable mySymtab = this.mySystem.newSharedSymbolTable(this.mySymtabName, this.mySymtabVersion, this.mySymbols.iterator(), importArray);
        IonWriter w = this.mySystem.newTextWriter(System.out);
        try {
            mySymtab.writeTo(w);
            System.out.println();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
    }

    protected void process(IonReader reader2) throws IonException {
        IonType type2;
        while ((type2 = reader2.next()) != null) {
            String fieldName = reader2.getFieldName();
            this.intern(fieldName);
            this.internAnnotations(reader2);
            switch (type2) {
                case SYMBOL: {
                    String text = reader2.stringValue();
                    this.intern(text);
                    break;
                }
                case LIST: 
                case SEXP: 
                case STRUCT: {
                    reader2.stepIn();
                    break;
                }
            }
            while (reader2.next() != null && reader2.getDepth() > 0) {
                reader2.stepOut();
            }
        }
    }

    private void internAnnotations(IonReader reader2) {
        Iterator<String> i = reader2.iterateTypeAnnotations();
        assert (i != null);
        while (i.hasNext()) {
            String ann = i.next();
            this.intern(ann);
        }
    }

    private void intern(String text) {
        if (text != null) {
            if (text.equals("$ion") || text.startsWith("$ion_")) {
                return;
            }
            this.mySymbols.add(text);
        }
    }
}

