/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.elasticsearch.Version;
import org.elasticsearch.common.Explicit;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.geo.ShapeRelation;
import org.elasticsearch.common.geo.SpatialStrategy;
import org.elasticsearch.common.geo.builders.ShapeBuilder;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.DeprecationHandler;
import org.elasticsearch.common.xcontent.LoggingDeprecationHandler;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.geometry.Geometry;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.GeoPointFieldMapper;
import org.elasticsearch.index.mapper.GeoShapeFieldMapper;
import org.elasticsearch.index.mapper.LegacyGeoShapeFieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.query.QueryShardContext;
import org.elasticsearch.index.query.QueryShardException;

public abstract class AbstractGeometryFieldMapper<Parsed, Processed>
extends FieldMapper {
    protected static final String DEPRECATED_PARAMETERS_KEY = "deprecated_parameters";
    protected Explicit<Boolean> coerce;
    protected Explicit<Boolean> ignoreMalformed;
    protected Explicit<Boolean> ignoreZValue;

    protected AbstractGeometryFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, Explicit<Boolean> ignoreMalformed, Explicit<Boolean> coerce, Explicit<Boolean> ignoreZValue, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        this.coerce = coerce;
        this.ignoreMalformed = ignoreMalformed;
        this.ignoreZValue = ignoreZValue;
    }

    @Override
    protected void doMerge(Mapper mergeWith) {
        super.doMerge(mergeWith);
        AbstractGeometryFieldMapper gsfm = (AbstractGeometryFieldMapper)mergeWith;
        if (gsfm.coerce.explicit()) {
            this.coerce = gsfm.coerce;
        }
        if (gsfm.ignoreMalformed.explicit()) {
            this.ignoreMalformed = gsfm.ignoreMalformed;
        }
        if (gsfm.ignoreZValue.explicit()) {
            this.ignoreZValue = gsfm.ignoreZValue;
        }
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        throw new UnsupportedOperationException("Parsing is implemented in parse(), this method should NEVER be called");
    }

    @Override
    public void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        builder.field("type", this.contentType());
        AbstractGeometryFieldType ft = (AbstractGeometryFieldType)this.fieldType();
        if (includeDefaults || ft.orientation() != Defaults.ORIENTATION.value()) {
            builder.field(Names.ORIENTATION.getPreferredName(), (Object)ft.orientation());
        }
        if (includeDefaults || this.coerce.explicit()) {
            builder.field(Names.COERCE.getPreferredName(), this.coerce.value());
        }
        if (includeDefaults || this.ignoreMalformed.explicit()) {
            builder.field("ignore_malformed", this.ignoreMalformed.value());
        }
        if (includeDefaults || this.ignoreZValue.explicit()) {
            builder.field(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName(), this.ignoreZValue.value());
        }
    }

    public Explicit<Boolean> coerce() {
        return this.coerce;
    }

    public Explicit<Boolean> ignoreMalformed() {
        return this.ignoreMalformed;
    }

    public Explicit<Boolean> ignoreZValue() {
        return this.ignoreZValue;
    }

    public ShapeBuilder.Orientation orientation() {
        return ((AbstractGeometryFieldType)this.fieldType).orientation();
    }

    @Override
    public void parse(ParseContext context) throws IOException {
        AbstractGeometryFieldType fieldType = (AbstractGeometryFieldType)this.fieldType();
        Indexer geometryIndexer = fieldType.geometryIndexer();
        Parser geometryParser = fieldType.geometryParser();
        try {
            Object shape = context.parseExternalValue(geometryIndexer.processedClass());
            if (shape == null) {
                Object geometry = geometryParser.parse(context.parser(), this);
                if (geometry == null) {
                    return;
                }
                shape = geometryIndexer.prepareForIndexing(geometry);
            }
            ArrayList<IndexableField> fields = new ArrayList<IndexableField>();
            fields.addAll(geometryIndexer.indexShape(context, shape));
            this.createFieldNamesField(context, fields);
            for (IndexableField field : fields) {
                context.doc().add(field);
            }
        }
        catch (Exception e) {
            if (!this.ignoreMalformed.value().booleanValue()) {
                throw new MapperParsingException("failed to parse field [{}] of type [{}]", (Throwable)e, this.fieldType().name(), this.fieldType().typeName());
            }
            context.addIgnoredField(this.fieldType().name());
        }
    }

    public static abstract class AbstractGeometryFieldType<Parsed, Processed>
    extends MappedFieldType {
        protected ShapeBuilder.Orientation orientation = Defaults.ORIENTATION.value();
        protected Indexer<Parsed, Processed> geometryIndexer;
        protected Parser<Parsed> geometryParser;
        protected QueryProcessor geometryQueryBuilder;

        protected AbstractGeometryFieldType() {
            this.setIndexOptions(IndexOptions.DOCS);
            this.setTokenized(false);
            this.setStored(false);
            this.setStoreTermVectors(false);
            this.setOmitNorms(true);
        }

        protected AbstractGeometryFieldType(AbstractGeometryFieldType ref) {
            super(ref);
            this.orientation = ref.orientation;
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            AbstractGeometryFieldType that = (AbstractGeometryFieldType)((Object)o);
            return this.orientation == that.orientation;
        }

        @Override
        public int hashCode() {
            return Objects.hash(new Object[]{super.hashCode(), this.orientation});
        }

        public ShapeBuilder.Orientation orientation() {
            return this.orientation;
        }

        public void setOrientation(ShapeBuilder.Orientation orientation) {
            this.checkIfFrozen();
            this.orientation = orientation;
        }

        @Override
        public Query existsQuery(QueryShardContext context) {
            return new TermQuery(new Term("_field_names", this.name()));
        }

        @Override
        public Query termQuery(Object value, QueryShardContext context) {
            throw new QueryShardException(context, "Geometry fields do not support exact searching, use dedicated geometry queries instead", new Object[0]);
        }

        public void setGeometryIndexer(Indexer<Parsed, Processed> geometryIndexer) {
            this.geometryIndexer = geometryIndexer;
        }

        protected Indexer<Parsed, Processed> geometryIndexer() {
            return this.geometryIndexer;
        }

        public void setGeometryParser(Parser<Parsed> geometryParser) {
            this.geometryParser = geometryParser;
        }

        protected Parser<Parsed> geometryParser() {
            return this.geometryParser;
        }

        public void setGeometryQueryBuilder(QueryProcessor geometryQueryBuilder) {
            this.geometryQueryBuilder = geometryQueryBuilder;
        }

        public QueryProcessor geometryQueryBuilder() {
            return this.geometryQueryBuilder;
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        protected boolean parseXContentParameters(String name, Map.Entry<String, Object> entry, Map<String, Object> params) throws MapperParsingException {
            return LegacyGeoShapeFieldMapper.DeprecatedParameters.parse(name, entry.getKey(), entry.getValue(), (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get(AbstractGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY));
        }

        protected Builder newBuilder(String name, Map<String, Object> params) {
            if (params.containsKey(AbstractGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY)) {
                return new LegacyGeoShapeFieldMapper.Builder(name, (LegacyGeoShapeFieldMapper.DeprecatedParameters)params.get(AbstractGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY));
            }
            return new GeoShapeFieldMapper.Builder(name);
        }

        public Mapper.Builder parse(String name, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            HashMap<String, Object> params = new HashMap<String, Object>();
            boolean parsedDeprecatedParameters = false;
            params.put(AbstractGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY, new LegacyGeoShapeFieldMapper.DeprecatedParameters());
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String fieldName = entry.getKey();
                Object fieldNode = entry.getValue();
                if (this.parseXContentParameters(name, entry, params)) {
                    parsedDeprecatedParameters = true;
                    iterator.remove();
                    continue;
                }
                if (Names.ORIENTATION.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.ORIENTATION.getPreferredName(), (Object)ShapeBuilder.Orientation.fromString(fieldNode.toString()));
                    iterator.remove();
                    continue;
                }
                if ("ignore_malformed".equals(fieldName)) {
                    params.put("ignore_malformed", XContentMapValues.nodeBooleanValue(fieldNode, name + ".ignore_malformed"));
                    iterator.remove();
                    continue;
                }
                if (Names.COERCE.match(fieldName, (DeprecationHandler)LoggingDeprecationHandler.INSTANCE)) {
                    params.put(Names.COERCE.getPreferredName(), XContentMapValues.nodeBooleanValue(fieldNode, name + "." + Names.COERCE.getPreferredName()));
                    iterator.remove();
                    continue;
                }
                if (!GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName().equals(fieldName)) continue;
                params.put(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName(), XContentMapValues.nodeBooleanValue(fieldNode, name + "." + GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName()));
                iterator.remove();
            }
            if (parserContext.indexVersionCreated().onOrAfter(Version.V_6_6_0) && !parsedDeprecatedParameters) {
                params.remove(AbstractGeometryFieldMapper.DEPRECATED_PARAMETERS_KEY);
            }
            Builder builder = this.newBuilder(name, params);
            if (params.containsKey(Names.COERCE.getPreferredName())) {
                builder.coerce((Boolean)params.get(Names.COERCE.getPreferredName()));
            }
            if (params.containsKey(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName())) {
                builder.ignoreZValue((Boolean)params.get(GeoPointFieldMapper.Names.IGNORE_Z_VALUE.getPreferredName()));
            }
            if (params.containsKey("ignore_malformed")) {
                builder.ignoreMalformed((Boolean)params.get("ignore_malformed"));
            }
            if (params.containsKey(Names.ORIENTATION.getPreferredName())) {
                builder.orientation((ShapeBuilder.Orientation)((Object)params.get(Names.ORIENTATION.getPreferredName())));
            }
            return builder;
        }
    }

    public static abstract class Builder<T extends Builder, Y extends AbstractGeometryFieldMapper>
    extends FieldMapper.Builder<T, Y> {
        protected Boolean coerce;
        protected Boolean ignoreMalformed;
        protected Boolean ignoreZValue;
        protected ShapeBuilder.Orientation orientation;

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType) {
            super(name, fieldType, defaultFieldType);
        }

        public Builder(String name, MappedFieldType fieldType, MappedFieldType defaultFieldType, boolean coerce, boolean ignoreMalformed, ShapeBuilder.Orientation orientation, boolean ignoreZ) {
            super(name, fieldType, defaultFieldType);
            this.coerce = coerce;
            this.ignoreMalformed = ignoreMalformed;
            this.orientation = orientation;
            this.ignoreZValue = ignoreZ;
        }

        public Builder coerce(boolean coerce) {
            this.coerce = coerce;
            return this;
        }

        protected Explicit<Boolean> coerce(Mapper.BuilderContext context) {
            if (this.coerce != null) {
                return new Explicit<Boolean>(this.coerce, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.COERCE_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.COERCE;
        }

        public Builder orientation(ShapeBuilder.Orientation orientation) {
            this.orientation = orientation;
            return this;
        }

        protected Explicit<ShapeBuilder.Orientation> orientation() {
            if (this.orientation != null) {
                return new Explicit<ShapeBuilder.Orientation>(this.orientation, true);
            }
            return Defaults.ORIENTATION;
        }

        @Override
        protected boolean defaultDocValues(Version indexCreated) {
            return false;
        }

        public Builder ignoreMalformed(boolean ignoreMalformed) {
            this.ignoreMalformed = ignoreMalformed;
            return this;
        }

        protected Explicit<Boolean> ignoreMalformed(Mapper.BuilderContext context) {
            if (this.ignoreMalformed != null) {
                return new Explicit<Boolean>(this.ignoreMalformed, true);
            }
            if (context.indexSettings() != null) {
                return new Explicit<Boolean>(FieldMapper.IGNORE_MALFORMED_SETTING.get(context.indexSettings()), false);
            }
            return Defaults.IGNORE_MALFORMED;
        }

        protected Explicit<Boolean> ignoreZValue() {
            if (this.ignoreZValue != null) {
                return new Explicit<Boolean>(this.ignoreZValue, true);
            }
            return Defaults.IGNORE_Z_VALUE;
        }

        public Builder ignoreZValue(boolean ignoreZValue) {
            this.ignoreZValue = ignoreZValue;
            return this;
        }

        @Override
        protected void setupFieldType(Mapper.BuilderContext context) {
            super.setupFieldType(context);
            if (this.name().isEmpty()) {
                throw new IllegalArgumentException("name cannot be empty string");
            }
            AbstractGeometryFieldType ft = (AbstractGeometryFieldType)this.fieldType();
            ft.setOrientation(this.orientation().value());
        }
    }

    public static interface QueryProcessor {
        public Query process(Geometry var1, String var2, ShapeRelation var3, QueryShardContext var4);

        @Deprecated
        default public Query process(Geometry shape, String fieldName, SpatialStrategy strategy, ShapeRelation relation, QueryShardContext context) {
            return this.process(shape, fieldName, relation, context);
        }
    }

    public static interface Parser<Parsed> {
        public Parsed parse(XContentParser var1, AbstractGeometryFieldMapper var2) throws IOException, ParseException;
    }

    public static interface Indexer<Parsed, Processed> {
        public Processed prepareForIndexing(Parsed var1);

        public Class<Processed> processedClass();

        public List<IndexableField> indexShape(ParseContext var1, Processed var2);
    }

    public static class Defaults {
        public static final Explicit<ShapeBuilder.Orientation> ORIENTATION = new Explicit<ShapeBuilder.Orientation>(ShapeBuilder.Orientation.RIGHT, false);
        public static final Explicit<Boolean> COERCE = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> IGNORE_MALFORMED = new Explicit<Boolean>(false, false);
        public static final Explicit<Boolean> IGNORE_Z_VALUE = new Explicit<Boolean>(true, false);
    }

    public static class Names {
        public static final ParseField ORIENTATION = new ParseField("orientation", new String[0]);
        public static final ParseField COERCE = new ParseField("coerce", new String[0]);
    }
}

