/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.painless.node;

import java.util.Objects;
import java.util.Set;
import org.elasticsearch.painless.CompilerSettings;
import org.elasticsearch.painless.FunctionRef;
import org.elasticsearch.painless.Globals;
import org.elasticsearch.painless.Locals;
import org.elasticsearch.painless.Location;
import org.elasticsearch.painless.MethodWriter;
import org.elasticsearch.painless.node.AExpression;
import org.elasticsearch.painless.node.ILambda;
import org.objectweb.asm.Type;

public final class EFunctionRef
extends AExpression
implements ILambda {
    private final String type;
    private final String call;
    private FunctionRef ref;
    private String defPointer;

    public EFunctionRef(Location location, String type, String call) {
        super(location);
        this.type = Objects.requireNonNull(type);
        this.call = Objects.requireNonNull(call);
    }

    @Override
    void storeSettings(CompilerSettings settings) {
    }

    @Override
    void extractVariables(Set<String> variables) {
    }

    @Override
    void analyze(Locals locals) {
        if (this.expected == null) {
            this.ref = null;
            this.actual = String.class;
            this.defPointer = "S" + this.type + "." + this.call + ",0";
        } else {
            this.defPointer = null;
            this.ref = FunctionRef.create(locals.getPainlessLookup(), locals.getMethods(), this.location, this.expected, this.type, this.call, 0);
            this.actual = this.expected;
        }
    }

    @Override
    void write(MethodWriter writer, Globals globals) {
        if (this.ref != null) {
            writer.writeDebugInfo(this.location);
            writer.invokeLambdaCall(this.ref);
        } else {
            writer.push(null);
        }
    }

    @Override
    public String getPointer() {
        return this.defPointer;
    }

    @Override
    public Type[] getCaptures() {
        return new Type[0];
    }

    @Override
    public String toString() {
        return this.singleLineToString(this.type, this.call);
    }
}

