/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.modelsetbio;

import java.util.Hashtable;
import java.util.Map;
import javajs.util.AU;
import javajs.util.BS;
import javajs.util.Lst;
import javajs.util.P3;
import javajs.util.PT;
import javajs.util.SB;
import org.jmol.api.Interface;
import org.jmol.api.JmolAnnotationParser;
import org.jmol.c.STR;
import org.jmol.modelset.Atom;
import org.jmol.modelset.Bond;
import org.jmol.modelset.Group;
import org.jmol.modelset.Model;
import org.jmol.modelset.ModelSet;
import org.jmol.modelset.Structure;
import org.jmol.modelsetbio.AlphaMonomer;
import org.jmol.modelsetbio.AminoPolymer;
import org.jmol.modelsetbio.BioExt;
import org.jmol.modelsetbio.BioModel;
import org.jmol.modelsetbio.BioPolymer;
import org.jmol.modelsetbio.BioResolver;
import org.jmol.modelsetbio.Monomer;
import org.jmol.modelsetbio.ProteinStructure;
import org.jmol.script.T;
import org.jmol.util.BSUtil;
import org.jmol.util.Escape;
import org.jmol.util.Logger;
import org.jmol.viewer.Viewer;

public class BioModelSet {
    private Viewer vwr;
    private ModelSet ms;
    private BioExt ext;
    private Map<String, BS>[] unitIdSets;

    BioExt getBioExt() {
        BioExt bioExt;
        if (this.ext == null) {
            this.ext = (BioExt)Interface.getInterface("org.jmol.modelsetbio.BioExt", this.vwr, "script");
            bioExt = this.ext.set(this.vwr, this.vwr.ms);
        } else {
            bioExt = this.ext;
        }
        return bioExt;
    }

    public BioModelSet set(Viewer vwr, ModelSet ms) {
        this.vwr = vwr;
        this.ms = ms;
        this.unitIdSets = null;
        if (this.ext != null) {
            this.ext.set(vwr, ms);
        }
        return this;
    }

    public void calcAllRasmolHydrogenBonds(BS bsA, BS bsB, Lst<Bond> vHBonds, boolean nucleicOnly, int nMax, boolean dsspIgnoreHydrogens, BS bsHBonds, int dsspVersion) {
        Model[] am = this.ms.am;
        if (vHBonds == null) {
            BS bsAtoms = bsA;
            if (bsB != null && !bsA.equals(bsB)) {
                bsAtoms = BSUtil.copy(bsA);
                bsAtoms.or(bsB);
            }
            BS bsDelete = new BS();
            BS bsOK = new BS();
            Model[] models = this.ms.am;
            Bond[] bonds = this.ms.bo;
            int i = this.ms.bondCount;
            while (--i >= 0) {
                Bond bond = bonds[i];
                if ((bond.order & 0x7000) == 0) continue;
                if (bsAtoms.get(bond.atom1.i)) {
                    bsDelete.set(i);
                    continue;
                }
                bsOK.set(models[bond.atom1.mi].trajectoryBaseIndex);
            }
            i = this.ms.mc;
            while (--i >= 0) {
                if (!models[i].isBioModel) continue;
                models[i].hasRasmolHBonds = bsOK.get(i);
            }
            if (bsDelete.nextSetBit(0) >= 0) {
                this.ms.deleteBonds(bsDelete, false);
            }
        }
        int i = this.ms.mc;
        while (--i >= 0) {
            if (!am[i].isBioModel || this.ms.isTrajectorySubFrame(i)) continue;
            ((BioModel)am[i]).getRasmolHydrogenBonds(bsA, bsB, vHBonds, nucleicOnly, nMax, dsspIgnoreHydrogens, bsHBonds, dsspVersion);
        }
    }

    public void calcSelectedMonomersCount() {
        BS bsSelected = this.vwr.bsA();
        int i = this.ms.mc;
        while (--i >= 0) {
            if (!this.ms.am[i].isBioModel) continue;
            BioModel m = (BioModel)this.ms.am[i];
            int j = m.bioPolymerCount;
            while (--j >= 0) {
                m.bioPolymers[j].calcSelectedMonomersCount(bsSelected);
            }
        }
    }

    public void calculateAllPolymers(Group[] groups, int groupCount, int baseGroupIndex, BS modelsExcluded) {
        boolean checkConnections;
        boolean bl = checkConnections = !this.vwr.getBoolean(603979896);
        if (groupCount < 0) {
            groupCount = groups.length;
        }
        if (modelsExcluded != null) {
            for (int j = 0; j < groupCount; ++j) {
                Group group = groups[j];
                if (!(group instanceof Monomer) || ((Monomer)group).bioPolymer == null || modelsExcluded.get(group.chain.model.modelIndex)) continue;
                ((Monomer)group).setBioPolymer(null, -1);
            }
        }
        int mc = this.ms.mc;
        for (int i = 0; i < mc; ++i) {
            if (modelsExcluded != null && modelsExcluded.get(i) || !this.ms.am[i].isBioModel) continue;
            int pt = 0;
            int j = baseGroupIndex;
            while (j < groupCount) {
                Group g = groups[j];
                Model model = g.getModel();
                if (model.isBioModel && g instanceof Monomer) {
                    BioPolymer bp;
                    boolean doCheck = checkConnections && !this.ms.isJmolDataFrameForModel(this.ms.at[g.firstAtomIndex].mi);
                    BioPolymer bioPolymer = bp = ((Monomer)g).bioPolymer == null ? BioResolver.allocateBioPolymer(groups, j, doCheck, pt) : null;
                    if (bp != null && bp.monomerCount != 0) {
                        int n = ((BioModel)model).addBioPolymer(bp);
                        j += n - 1;
                        pt += n - 1;
                    }
                }
                ++j;
                ++pt;
            }
        }
    }

    public String calculateAllStructuresExcept(BS alreadyDefined, boolean asDSSP, boolean doReport, boolean dsspIgnoreHydrogen, boolean setStructure, boolean includeAlpha, int version) {
        String ret = "";
        BS bsModels = BSUtil.copyInvert(alreadyDefined, this.ms.mc);
        if (setStructure) {
            this.setAllDefaultStructure(bsModels);
        }
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            if (this.ms.am[i].isBioModel) {
                ret = ret + ((BioModel)this.ms.am[i]).calculateStructures(asDSSP, doReport, dsspIgnoreHydrogen, setStructure, includeAlpha, version);
            }
            i = bsModels.nextSetBit(i + 1);
        }
        if (setStructure) {
            this.ms.setStructureIndexes();
        }
        return ret;
    }

    public String calculateAllStuctures(BS bsAtoms, boolean asDSSP, boolean doReport, boolean dsspIgnoreHydrogen, boolean setStructure, int version) {
        BS bsAllAtoms = new BS();
        BS bsModelsExcluded = BSUtil.copyInvert(this.modelsOf(bsAtoms, bsAllAtoms), this.ms.mc);
        if (!setStructure) {
            return this.ms.calculateStructuresAllExcept(bsModelsExcluded, asDSSP, doReport, dsspIgnoreHydrogen, false, false, version);
        }
        this.ms.recalculatePolymers(bsModelsExcluded);
        String ret = this.ms.calculateStructuresAllExcept(bsModelsExcluded, asDSSP, doReport, dsspIgnoreHydrogen, true, false, version);
        this.vwr.shm.resetBioshapes(bsAllAtoms);
        this.ms.setStructureIndexes();
        return ret;
    }

    public void calculateStraightnessAll() {
        this.getBioExt().calculateStraightnessAll();
    }

    public int calculateStruts(BS bs1, BS bs2) {
        return this.getBioExt().calculateAllstruts(this.vwr, this.ms, bs1, bs2);
    }

    public String getAllDefaultStructures(BS bsAtoms, BS bsModified) {
        BS bsModels = this.modelsOf(bsAtoms, bsModified);
        SB ret = new SB();
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            if (this.ms.am[i].isBioModel && ((BioModel)this.ms.am[i]).defaultStructure != null) {
                ret.append(((BioModel)this.ms.am[i]).defaultStructure);
            }
            i = bsModels.nextSetBit(i + 1);
        }
        return ret.toString();
    }

    public Map<String, String> getAllHeteroList(int modelIndex) {
        Hashtable<String, String> htFull = new Hashtable<String, String>();
        boolean ok = false;
        int i = this.ms.mc;
        while (--i >= 0) {
            Map ht;
            if (modelIndex >= 0 && i != modelIndex || (ht = (Map)this.ms.getInfo(i, "hetNames")) == null) continue;
            ok = true;
            for (Map.Entry entry : ht.entrySet()) {
                String key = (String)entry.getKey();
                htFull.put(key, (String)entry.getValue());
            }
        }
        return ok ? htFull : null;
    }

    public void getAllPolymerInfo(BS bs, Map<String, Lst<Map<String, Object>>> info) {
        this.getBioExt().getAllPolymerInfo(bs, info);
    }

    public void getAllPolymerPointsAndVectors(BS bs, Lst<P3[]> vList, boolean isTraceAlpha, float sheetSmoothing) {
        for (int i = 0; i < this.ms.mc; ++i) {
            if (!this.ms.am[i].isBioModel) continue;
            BioModel m = (BioModel)this.ms.am[i];
            int last = 0x7FFFFFFE;
            for (int ip = 0; ip < m.bioPolymerCount; ++ip) {
                last = m.bioPolymers[ip].getPolymerPointsAndVectors(last, bs, vList, isTraceAlpha, sheetSmoothing);
            }
        }
    }

    public BS getAllSequenceBits(String specInfo, BS bsAtoms, BS bsResult) {
        if (specInfo.length() > 0) {
            if (bsAtoms == null) {
                bsAtoms = this.vwr.getAllAtoms();
            }
            if (specInfo.indexOf(124) < specInfo.lastIndexOf(124)) {
                return this.getAllUnitIds(specInfo, bsAtoms, bsResult);
            }
            Model[] am = this.ms.am;
            int i = this.ms.mc;
            while (--i >= 0) {
                if (!am[i].isBioModel) continue;
                BioModel m = (BioModel)am[i];
                int lenInfo = specInfo.length();
                block1: for (int ip = 0; ip < m.bioPolymerCount; ++ip) {
                    String sequence = m.bioPolymers[ip].getSequence();
                    int j = -1;
                    while (true) {
                        ++j;
                        if ((j = sequence.indexOf(specInfo, j)) < 0) continue block1;
                        m.bioPolymers[ip].getPolymerSequenceAtoms(j, lenInfo, bsAtoms, bsResult);
                    }
                }
            }
        }
        return bsResult;
    }

    public BS getAtomBitsBS(int tokType, BS bsInfo, BS bs) {
        Atom[] at = this.ms.at;
        int ac = this.ms.ac;
        int i = 0;
        switch (tokType) {
            case 0x200020: 
            case 136314895: {
                Group g;
                STR type = tokType == 136314895 ? STR.HELIX : STR.SHEET;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isWithinStructure(type)) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 0x200024: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isCarbohydrate()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 0x200004: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isDna()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 0x20000E: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isNucleic()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 0x200010: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isProtein()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 0x200012: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isPurine()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 2097172: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isPyrimidine()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
            case 2097174: {
                Group g;
                i = ac;
                while (--i >= 0) {
                    g = at[i].group;
                    if (g.isRna()) {
                        g.setAtomBits(bs);
                    }
                    i = g.firstAtomIndex;
                }
                break;
            }
        }
        if (i < 0) {
            return bs;
        }
        int i0 = bsInfo.nextSetBit(0);
        if (i0 < 0) {
            return bs;
        }
        i = 0;
        switch (tokType) {
            case 1094713362: {
                i = i0;
                while (i >= 0) {
                    int iPolymer = at[i].group.getBioPolymerIndexInModel();
                    if (iPolymer >= 0) {
                        ((Monomer)at[i].group).bioPolymer.setAtomBitsAndClear(bs, bsInfo);
                    }
                    i = bsInfo.nextSetBit(i + 1);
                }
                break;
            }
            case 1639976963: {
                i = i0;
                while (i >= 0) {
                    Structure structure = at[i].group.getStructure();
                    if (structure != null) {
                        structure.setAtomBitsAndClear(bs, bsInfo);
                    }
                    i = bsInfo.nextSetBit(i + 1);
                }
                break;
            }
        }
        if (i == 0) {
            Logger.error("MISSING getAtomBits entry for " + T.nameOf(tokType));
        }
        return bs;
    }

    public BS getAtomBitsStr(int tokType, String specInfo, BS bs) {
        switch (tokType) {
            default: {
                return new BS();
            }
            case 1073741925: {
                return this.getAnnotationBits("domains", 1073741925, specInfo);
            }
            case 1073742189: {
                return this.getAnnotationBits("validation", 1073742189, specInfo);
            }
            case 1073742128: {
                return this.getAnnotationBits("rna3d", 1073742128, specInfo);
            }
            case 1073741863: {
                String s = specInfo;
                bs = new BS();
                return s.length() % 2 != 0 ? bs : this.ms.getAtomBitsMDa(1086324742, this.getAllBasePairBits(s), bs);
            }
            case 1111490587: {
                return this.getAnnotationBits("dssr", 1111490587, specInfo);
            }
            case 1086324744: 
        }
        return this.getAllSequenceBits(specInfo, null, bs);
    }

    public int getBioPolymerCountInModel(int modelIndex) {
        if (modelIndex < 0) {
            int polymerCount = 0;
            int i = this.ms.mc;
            while (--i >= 0) {
                if (this.ms.isTrajectorySubFrame(i) || !this.ms.am[i].isBioModel) continue;
                polymerCount += ((BioModel)this.ms.am[i]).getBioPolymerCount();
            }
            return polymerCount;
        }
        return this.ms.isTrajectorySubFrame(modelIndex) || !this.ms.am[modelIndex].isBioModel ? 0 : ((BioModel)this.ms.am[modelIndex]).getBioPolymerCount();
    }

    public String getFullProteinStructureState(BS bsAtoms, int mode) {
        int at0;
        boolean taintedOnly;
        boolean bl = taintedOnly = mode == 1073742327;
        if (taintedOnly && !this.ms.proteinStructureTainted) {
            return "";
        }
        boolean scriptMode = mode == 1073742158 || mode == 1073742327;
        Atom[] atoms = this.ms.at;
        int n = at0 = bsAtoms == null ? 0 : bsAtoms.nextSetBit(0);
        if (at0 < 0) {
            return "";
        }
        if (bsAtoms != null && mode == 4138) {
            bsAtoms = BSUtil.copy(bsAtoms);
            int i = this.ms.ac;
            while (--i >= 0) {
                if (!Float.isNaN(atoms[i].group.getGroupParameter(1111490569)) && !Float.isNaN(atoms[i].group.getGroupParameter(1111490570))) continue;
                bsAtoms.clear(i);
            }
        }
        int at1 = (bsAtoms == null ? this.ms.ac : bsAtoms.length()) - 1;
        int im0 = atoms[at0].mi;
        short im1 = atoms[at1].mi;
        Lst<ProteinStructure> lstStr = new Lst<ProteinStructure>();
        Hashtable<ProteinStructure, Boolean> map = new Hashtable<ProteinStructure, Boolean>();
        SB cmd = new SB();
        for (int im = im0; im <= im1; ++im) {
            if (!this.ms.am[im].isBioModel) continue;
            BioModel m = (BioModel)this.ms.am[im];
            if (taintedOnly && !m.structureTainted) continue;
            BS bsA = new BS();
            bsA.or(m.bsAtoms);
            bsA.andNot(m.bsAtomsDeleted);
            int i0 = bsA.nextSetBit(0);
            if (i0 < 0) continue;
            if (scriptMode) {
                cmd.append("  structure none ").append(Escape.eBS(this.ms.getModelAtomBitSetIncludingDeleted(im, false))).append("    \t# model=" + this.ms.getModelNumberDotted(im)).append(";\n");
            }
            int i = i0;
            while (i >= 0) {
                ProteinStructure ps;
                Atom a = atoms[i];
                if (a.group instanceof AlphaMonomer && (ps = ((AlphaMonomer)a.group).proteinStructure) != null && !map.containsKey(ps)) {
                    lstStr.addLast(ps);
                    map.put(ps, Boolean.TRUE);
                }
                i = bsA.nextSetBit(i + 1);
            }
        }
        this.getStructureLines(bsAtoms, cmd, lstStr, STR.HELIX, scriptMode, mode);
        this.getStructureLines(bsAtoms, cmd, lstStr, STR.SHEET, scriptMode, mode);
        this.getStructureLines(bsAtoms, cmd, lstStr, STR.TURN, scriptMode, mode);
        return cmd.toString();
    }

    public BS getGroupsWithinAll(int nResidues, BS bs) {
        BS bsResult = new BS();
        BS bsCheck = this.ms.getIterativeModels(false);
        int iModel = this.ms.mc;
        while (--iModel >= 0) {
            if (!bsCheck.get(iModel) || !this.ms.am[iModel].isBioModel) continue;
            BioModel m = (BioModel)this.ms.am[iModel];
            int i = m.bioPolymerCount;
            while (--i >= 0) {
                m.bioPolymers[i].getRangeGroups(nResidues, bs, bsResult);
            }
        }
        return bsResult;
    }

    public BS getIdentifierOrNull(String identifier) {
        int seqcode;
        BS bsInsert;
        int pt;
        int len = identifier.length();
        for (pt = 0; pt < len && PT.isLetter(identifier.charAt(pt)); ++pt) {
        }
        BS bs = this.ms.getSpecNameOrNull(identifier.substring(0, pt), false);
        if (pt == len) {
            return bs;
        }
        if (bs == null) {
            bs = new BS();
        }
        int pt0 = pt;
        while (pt < len && PT.isDigit(identifier.charAt(pt))) {
            ++pt;
        }
        int seqNumber = 0;
        try {
            seqNumber = Integer.parseInt(identifier.substring(pt0, pt));
        }
        catch (NumberFormatException nfe) {
            return null;
        }
        char insertionCode = ' ';
        if (pt < len && identifier.charAt(pt) == '^' && ++pt < len) {
            insertionCode = identifier.charAt(pt);
        }
        if ((bsInsert = this.ms.getSeqcodeBits(seqcode = Group.getSeqcodeFor(seqNumber, insertionCode), false)) == null) {
            if (insertionCode != ' ') {
                bsInsert = this.ms.getSeqcodeBits(Character.toUpperCase(identifier.charAt(pt)), false);
            }
            if (bsInsert == null) {
                return null;
            }
            ++pt;
        }
        bs.and(bsInsert);
        if (pt >= len) {
            return bs;
        }
        if (pt != len - 1) {
            return null;
        }
        bs.and(this.ms.getChainBits(identifier.charAt(pt)));
        return bs;
    }

    public boolean mutate(BS bs, String group, String[] sequence) {
        return this.getBioExt().mutate(this.vwr, bs, group, sequence);
    }

    public void recalculateAllPolymers(BS bsModelsExcluded, Group[] groups) {
        for (int i = 0; i < this.ms.mc; ++i) {
            if (!this.ms.am[i].isBioModel || bsModelsExcluded.get(i)) continue;
            ((BioModel)this.ms.am[i]).clearBioPolymers();
        }
        this.calculateAllPolymers(groups, -1, 0, bsModelsExcluded);
    }

    public void recalculatePoints(int modelIndex) {
        if (modelIndex < 0) {
            int i = this.ms.mc;
            while (--i >= 0) {
                if (this.ms.isTrajectorySubFrame(i) || !this.ms.am[i].isBioModel) continue;
                ((BioModel)this.ms.am[i]).recalculateLeadMidpointsAndWingVectors();
            }
            return;
        }
        if (!this.ms.isTrajectorySubFrame(modelIndex) && this.ms.am[modelIndex].isBioModel) {
            ((BioModel)this.ms.am[modelIndex]).recalculateLeadMidpointsAndWingVectors();
        }
    }

    public void setAllConformation(BS bsAtoms) {
        BS bsModels = this.ms.getModelBS(bsAtoms, false);
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            if (this.ms.am[i].isBioModel) {
                BioModel m = (BioModel)this.ms.am[i];
                if (m.altLocCount > 0) {
                    int j = m.bioPolymerCount;
                    while (--j >= 0) {
                        m.bioPolymers[j].setConformation(bsAtoms);
                    }
                }
            }
            i = bsModels.nextSetBit(i + 1);
        }
    }

    public void setAllProteinType(BS bs, STR type) {
        int i;
        int monomerIndexCurrent = -1;
        int iLast = -1;
        BS bsModels = this.ms.getModelBS(bs, false);
        this.setAllDefaultStructure(bsModels);
        Atom[] at = this.ms.at;
        Model[] am = this.ms.am;
        int i2 = bs.nextSetBit(0);
        while (i2 >= 0) {
            Atom a = at[i2];
            Group g = a.group;
            if (!g.isAdded(i2) && g.getBioPolymerLength() != 0) {
                monomerIndexCurrent = g.setProteinStructureType(type, iLast == i2 - 1 ? monomerIndexCurrent : -1);
                short modelIndex = a.mi;
                am[modelIndex].structureTainted = true;
                this.ms.proteinStructureTainted = true;
                iLast = i2 = g.lastAtomIndex;
            }
            i2 = bs.nextSetBit(i2 + 1);
        }
        int[] lastStrucNo = new int[this.ms.mc];
        for (i = 0; i < this.ms.ac; ++i) {
            short modelIndex = at[i].mi;
            if (!bsModels.get(modelIndex)) {
                i = am[modelIndex].firstAtomIndex + am[modelIndex].act - 1;
                continue;
            }
            Group g = at[i].group;
            if (g.isAdded(i)) continue;
            iLast = g.getStrucNo();
            if (iLast < 1000 && iLast > lastStrucNo[modelIndex]) {
                lastStrucNo[modelIndex] = iLast;
            }
            i = g.lastAtomIndex;
        }
        for (i = 0; i < this.ms.ac; ++i) {
            short modelIndex = at[i].mi;
            if (!bsModels.get(modelIndex)) {
                i = am[modelIndex].firstAtomIndex + am[modelIndex].act - 1;
                continue;
            }
            Group g = at[i].group;
            if (g.isAdded(i)) continue;
            i = g.lastAtomIndex;
            if (g.getStrucNo() <= 1000) continue;
            short s = modelIndex;
            int n = lastStrucNo[s] + 1;
            lastStrucNo[s] = n;
            g.setStrucNo(n);
        }
    }

    public void setAllStructureList(Map<STR, float[]> structureList) {
        int iModel = this.ms.mc;
        while (--iModel >= 0) {
            if (!this.ms.am[iModel].isBioModel) continue;
            BioModel m = (BioModel)this.ms.am[iModel];
            m.bioPolymers = (BioPolymer[])AU.arrayCopyObject(m.bioPolymers, m.bioPolymerCount);
            int i = m.bioPolymerCount;
            while (--i >= 0) {
                BioPolymer bp = m.bioPolymers[i];
                if (!(bp instanceof AminoPolymer)) continue;
                ((AminoPolymer)bp).setStructureList(structureList);
            }
        }
    }

    private BS getAllBasePairBits(String specInfo) {
        BS bsA = null;
        BS bsB = null;
        Lst<Bond> vHBonds = new Lst<Bond>();
        if (specInfo.length() == 0) {
            bsA = bsB = this.vwr.getAllAtoms();
            this.calcAllRasmolHydrogenBonds(bsA, bsB, vHBonds, true, 1, false, null, 0);
        } else {
            int i = 0;
            while (i < specInfo.length()) {
                if ((bsA = this.ms.getSequenceBits(specInfo.substring(i++, i), null, new BS())).nextSetBit(0) < 0 || (bsB = this.ms.getSequenceBits(specInfo.substring(i++, i), null, new BS())).nextSetBit(0) < 0) continue;
                this.calcAllRasmolHydrogenBonds(bsA, bsB, vHBonds, true, 1, false, null, 0);
            }
        }
        BS bsAtoms = new BS();
        int i = vHBonds.size();
        while (--i >= 0) {
            Bond b = (Bond)vHBonds.get(i);
            bsAtoms.set(b.atom1.i);
            bsAtoms.set(b.atom2.i);
        }
        return bsAtoms;
    }

    private BS getAllUnitIds(String specInfo, BS bsSelected, BS bsResult) {
        Map<String, BS>[] maps = this.unitIdSets;
        if (maps == null) {
            int i;
            maps = this.unitIdSets = new Map[7];
            for (i = 0; i < 7; ++i) {
                maps[i] = new Hashtable<String, BS>();
            }
            i = this.ms.mc;
            while (--i >= 0) {
                Model m = this.ms.am[i];
                if (!m.isBioModel) continue;
                if (this.ms.isTrajectory(i)) {
                    i = m.trajectoryBaseIndex;
                    m = this.ms.am[i];
                }
                String num = "|" + this.ms.getInfo(i, "modelNumber");
                this.checkMap(maps[0], this.ms.getInfo(i, "modelName") + num, m.bsAtoms);
                this.checkMap(maps[0], num, m.bsAtoms);
            }
        }
        BS bsModelChain = null;
        String lastModelChain = null;
        BS bsTemp = new BS();
        String[] units = PT.getTokens(PT.replaceAllCharacters(specInfo, ", \t\n[]\"=", " "));
        int[] ptrs = new int[8];
        int i = units.length;
        while (--i >= 0) {
            boolean haveAlt;
            String unit = units[i] + "|";
            if (unit.length() < 5) continue;
            int bsPtr = 0;
            int n = 0;
            int pt = unit.lastIndexOf(124) + 1;
            for (int j = 0; j < pt && n < 8; ++j) {
                if (unit.charAt(j) == '|') {
                    ptrs[n++] = j;
                    continue;
                }
                bsPtr |= 1 << n;
            }
            if ((bsPtr & 0x16) != 22) continue;
            bsTemp.clearAll();
            bsTemp.or(bsSelected);
            String mchain = unit.substring(0, ptrs[2]);
            if (lastModelChain != null && lastModelChain.equals(mchain)) {
                bsTemp.and(bsModelChain);
            } else {
                if (!this.addUnit(1094717454, unit.substring(0, ptrs[1]).toUpperCase(), bsTemp, maps[0]) || !this.addUnit(1073742357, unit.substring(ptrs[1] + 1, ptrs[2]), bsTemp, maps[1])) continue;
                bsModelChain = BSUtil.copy(bsTemp);
                lastModelChain = mchain;
            }
            boolean haveAtom = (bsPtr & 0x20) != 0;
            boolean bl = haveAlt = (bsPtr & 0x40) != 0;
            if (!this.addUnit(1094715412, unit.substring(ptrs[3] + 1, ptrs[4]), bsTemp, maps[2]) || !this.addUnit(5, (bsPtr & 0x80) == 0 ? "\u0000" : unit.substring(ptrs[6] + 1, ptrs[7]), bsTemp, maps[3]) || (haveAtom ? !this.addUnit(1086326786, unit.substring(ptrs[4] + 1, ptrs[5]).toUpperCase(), bsTemp, maps[4]) || !this.addUnit(1073742355, unit.substring(ptrs[5] + 1, ptrs[6]), bsTemp, maps[5]) : haveAlt && !this.addUnit(1094717448, unit.substring(ptrs[5] + 1, ptrs[6]), bsTemp, maps[6]))) continue;
            bsResult.or(bsTemp);
        }
        return bsResult;
    }

    private BS checkMap(Map<String, BS> map, String key, BS bsAtoms) {
        BS bs = BSUtil.copy(bsAtoms);
        BS bs0 = map.get(key);
        if (bs0 == null) {
            bs0 = bs;
            map.put(key, bs0);
        } else {
            bs0.or(bs);
        }
        return bs0;
    }

    private boolean addUnit(int tok, String key, BS bsTemp, Map<String, BS> map) {
        BS bs = map.get(key);
        if (bs == null) {
            Object o;
            switch (tok) {
                default: {
                    return false;
                }
                case 1073742357: {
                    o = this.vwr.getChainID(key, false);
                    break;
                }
                case 1094715412: {
                    o = PT.parseInt(key);
                    break;
                }
                case 5: {
                    o = (int)key.charAt(0);
                    break;
                }
                case 1094717448: {
                    tok = 1073742355;
                    bs = this.ms.getAtomBitsMDa(1073742355, null, new BS());
                }
                case 1086326786: {
                    o = key;
                    break;
                }
                case 1073742355: {
                    o = key.length() == 0 ? null : key;
                }
            }
            bs = this.ms.getAtomBitsMDa(tok, o, bs == null ? new BS() : bs);
            map.put(key, bs);
        }
        bsTemp.and(bs);
        return bsTemp.nextSetBit(0) >= 0;
    }

    private BS getAnnotationBits(String name, int tok, String specInfo) {
        BS bs = new BS();
        JmolAnnotationParser pa = this.vwr.getAnnotationParser(name.equals("dssr"));
        int i = this.ms.mc;
        while (--i >= 0) {
            Object ann = this.ms.getInfo(i, name);
            if (ann == null) continue;
            bs.or(pa.getAtomBits(this.vwr, specInfo, ((BioModel)this.ms.am[i]).getCachedAnnotationMap(name + " V ", ann), this.ms.am[i].dssrCache, tok, i, this.ms.am[i].bsAtoms));
        }
        return bs;
    }

    private int getStructureLines(BS bsAtoms, SB cmd, Lst<ProteinStructure> lstStr, STR type, boolean scriptMode, int mode) {
        boolean showMode = mode == 134222350;
        int nHelix = 0;
        int nSheet = 0;
        int nTurn = 0;
        String sid = null;
        BS bs = new BS();
        int n = 0;
        int ns = lstStr.size();
        block12: for (int i = 0; i < ns; ++i) {
            ProteinStructure ps = (ProteinStructure)lstStr.get(i);
            if (ps.type != type) continue;
            Monomer m1 = ps.findMonomer(bsAtoms, true);
            Monomer m2 = ps.findMonomer(bsAtoms, false);
            if (m1 == null || m2 == null) continue;
            int iModel = ps.apolymer.model.modelIndex;
            String comment = scriptMode ? "    \t# model=" + this.ms.getModelNumberDotted(iModel) : null;
            int res1 = m1.getResno();
            int res2 = m2.getResno();
            STR subtype = ps.subtype;
            switch (type) {
                case HELIX: 
                case SHEET: 
                case TURN: {
                    String str;
                    ++n;
                    if (scriptMode) {
                        bs.clearAll();
                        ps.setAtomBits(bs);
                        String stype = subtype.getBioStructureTypeName(false);
                        cmd.append("  structure ").append(stype).append(" ").append(Escape.eBS(bs)).append(comment).append(" & (" + res1 + " - " + res2 + ")").append(";\n");
                        continue block12;
                    }
                    switch (type) {
                        case HELIX: {
                            int nx = ++nHelix;
                            sid = PT.formatStringI("%3N %3N", "N", nx);
                            str = "HELIX  %ID %3GROUPA %1CA %4RESA  %3GROUPB %1CB %4RESB";
                            String stype = null;
                            switch (subtype) {
                                case HELIX: 
                                case HELIXALPHA: {
                                    stype = "  1";
                                    break;
                                }
                                case HELIX310: {
                                    stype = "  5";
                                    break;
                                }
                                case HELIXPI: {
                                    stype = "  3";
                                }
                            }
                            if (stype == null) break;
                            str = str + stype;
                            break;
                        }
                        case SHEET: {
                            int nx = ++nSheet;
                            sid = PT.formatStringI("%3N %3A 0", "N", nx);
                            sid = PT.formatStringS(sid, "A", "S" + nx);
                            str = "SHEET  %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                            break;
                        }
                        default: {
                            int nx = ++nTurn;
                            sid = PT.formatStringI("%3N %3N", "N", nx);
                            str = "TURN   %ID %3GROUPA %1CA%4RESA  %3GROUPB %1CB%4RESB";
                        }
                    }
                    str = PT.formatStringS(str, "ID", sid);
                    str = PT.formatStringS(str, "GROUPA", m1.getGroup3());
                    str = PT.formatStringS(str, "CA", m1.getLeadAtom().getChainIDStr());
                    str = PT.formatStringI(str, "RESA", res1);
                    str = PT.formatStringS(str, "GROUPB", m2.getGroup3());
                    str = PT.formatStringS(str, "CB", m2.getLeadAtom().getChainIDStr());
                    str = PT.formatStringI(str, "RESB", res2);
                    cmd.append(str);
                    if (showMode) {
                        cmd.append(" strucno= ").appendI(ps.strucNo);
                    }
                    cmd.append("\n");
                }
            }
        }
        if (n > 0) {
            cmd.append("\n");
        }
        return n;
    }

    private BS modelsOf(BS bsAtoms, BS bsAtomsRet) {
        int i0;
        BS bsModels = BS.newN(this.ms.mc);
        boolean isAll = bsAtoms == null;
        int i = i0 = isAll ? this.ms.ac - 1 : bsAtoms.nextSetBit(0);
        while (i >= 0) {
            int modelIndex = this.ms.am[this.ms.at[i].mi].trajectoryBaseIndex;
            if (!this.ms.isJmolDataFrameForModel(modelIndex)) {
                bsModels.set(modelIndex);
                bsAtomsRet.set(i);
            }
            i = isAll ? i - 1 : bsAtoms.nextSetBit(i + 1);
        }
        return bsModels;
    }

    private void setAllDefaultStructure(BS bsModels) {
        int i = bsModels.nextSetBit(0);
        while (i >= 0) {
            if (this.ms.am[i].isBioModel) {
                BioModel m = (BioModel)this.ms.am[i];
                if (m.defaultStructure == null) {
                    m.defaultStructure = this.getFullProteinStructureState(m.bsAtoms, 1073742158);
                }
            }
            i = bsModels.nextSetBit(i + 1);
        }
    }

    public boolean getAminoAcidValenceAndCharge(String s, String atomName, int[] aaRet) {
        return this.getBioExt().getAminoAcidValenceAndCharge(s, atomName, aaRet);
    }
}

