/*
 * Decompiled with CFR 0.152.
 */
package org.jruby;

import org.jcodings.specific.ASCIIEncoding;
import org.jruby.Ruby;
import org.jruby.RubyArray;
import org.jruby.RubyClass;
import org.jruby.RubyFile;
import org.jruby.RubyFixnum;
import org.jruby.RubyFloat;
import org.jruby.RubyInteger;
import org.jruby.RubyMatchData;
import org.jruby.RubyMath;
import org.jruby.RubyModule;
import org.jruby.RubyNumeric;
import org.jruby.RubyRational;
import org.jruby.RubyRegexp;
import org.jruby.RubyString;
import org.jruby.anno.JRubyClass;
import org.jruby.anno.JRubyMethod;
import org.jruby.runtime.Arity;
import org.jruby.runtime.ClassIndex;
import org.jruby.runtime.Helpers;
import org.jruby.runtime.JavaSites;
import org.jruby.runtime.ObjectAllocator;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.Visibility;
import org.jruby.runtime.builtin.IRubyObject;
import org.jruby.runtime.invokedynamic.MethodNames;
import org.jruby.util.ByteList;
import org.jruby.util.Numeric;
import org.jruby.util.RubyStringBuilder;
import org.jruby.util.TypeConverter;

@JRubyClass(name={"Complex"}, parent="Numeric")
public class RubyComplex
extends RubyNumeric {
    private static ObjectAllocator COMPLEX_ALLOCATOR = new ObjectAllocator(){

        @Override
        public IRubyObject allocate(Ruby runtime2, RubyClass klass) {
            RubyFixnum zero = RubyFixnum.zero(runtime2);
            return new RubyComplex(runtime2, klass, zero, zero);
        }
    };
    private IRubyObject real;
    private IRubyObject image;
    private static boolean canonicalization = false;
    private static final ByteList SEP = RubyFile.SLASH;
    private static final ByteList _eE = new ByteList(new byte[]{46, 101, 69}, false);

    public static RubyClass createComplexClass(Ruby runtime2) {
        String[] UNDEFINED = new String[]{"<", "<=", "<=>", ">", ">=", "between?", "divmod", "floor", "ceil", "modulo", "round", "step", "truncate", "positive?", "negative?"};
        RubyClass complexc = runtime2.defineClass("Complex", runtime2.getNumeric(), COMPLEX_ALLOCATOR);
        runtime2.setComplex(complexc);
        complexc.setClassIndex(ClassIndex.COMPLEX);
        complexc.setReifiedClass(RubyComplex.class);
        complexc.kindOf = new RubyModule.JavaClassKindOf(RubyComplex.class);
        complexc.defineAnnotatedMethods(RubyComplex.class);
        complexc.getSingletonClass().undefineMethod("allocate");
        complexc.getSingletonClass().undefineMethod("new");
        for (String undef : UNDEFINED) {
            complexc.undefineMethod(undef);
        }
        complexc.defineConstant("I", RubyComplex.newComplexConvert(runtime2.getCurrentContext(), RubyFixnum.zero(runtime2), RubyFixnum.one(runtime2)));
        return complexc;
    }

    private RubyComplex(Ruby runtime2, RubyClass clazz, IRubyObject real2, IRubyObject image2) {
        super(runtime2, clazz);
        this.real = real2;
        this.image = image2;
        this.flags |= FROZEN_F;
    }

    @Override
    public ClassIndex getNativeClassIndex() {
        return ClassIndex.COMPLEX;
    }

    public static RubyComplex newComplexRaw(Ruby runtime2, IRubyObject x, IRubyObject y) {
        return new RubyComplex(runtime2, runtime2.getComplex(), x, y);
    }

    public static RubyComplex newComplexRaw(Ruby runtime2, IRubyObject x) {
        return new RubyComplex(runtime2, runtime2.getComplex(), x, RubyFixnum.zero(runtime2));
    }

    public static RubyComplex newComplexRawImage(Ruby runtime2, IRubyObject image2) {
        return new RubyComplex(runtime2, runtime2.getComplex(), RubyFixnum.zero(runtime2), image2);
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexCanonicalize(context, x, RubyFixnum.zero(context.runtime));
    }

    public static IRubyObject newComplexCanonicalize(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.canonicalizeInternal(context, context.runtime.getComplex(), x, y);
    }

    static IRubyObject newComplexPolar(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.f_complex_polar(context, context.runtime.getComplex(), x, y);
    }

    static RubyNumeric newComplex(ThreadContext context, RubyClass clazz, IRubyObject x) {
        return RubyComplex.newComplex(context, clazz, x, RubyFixnum.zero(context.runtime));
    }

    static RubyNumeric newComplex(ThreadContext context, RubyClass clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, x, y);
    }

    static RubyComplex newComplexBang(ThreadContext context, RubyClass clazz, RubyNumeric x, RubyNumeric y) {
        return new RubyComplex(context.runtime, clazz, x, y);
    }

    static RubyComplex newComplexBang(ThreadContext context, RubyClass clazz, RubyNumeric x) {
        return RubyComplex.newComplexBang(context, clazz, x, RubyFixnum.zero(context.runtime));
    }

    @Deprecated
    public static RubyComplex newComplexBang(ThreadContext context, RubyClass clazz, IRubyObject x) {
        return RubyComplex.newComplexBang(context, clazz, (RubyNumeric)x);
    }

    IRubyObject getImage() {
        return this.image;
    }

    IRubyObject getReal() {
        return this.real;
    }

    private static IRubyObject m_cos(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x)) {
            return RubyMath.cos(context, x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.runtime.getComplex(), Numeric.f_mul(context, RubyMath.cos(context, x, complex.real), RubyMath.cosh(context, x, complex.image)), Numeric.f_mul(context, Numeric.f_negate(context, RubyMath.sin(context, x, complex.real)), RubyMath.sinh(context, x, complex.image)));
    }

    private static IRubyObject m_sin(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x)) {
            return RubyMath.sin(context, x, x);
        }
        RubyComplex complex = (RubyComplex)x;
        return RubyComplex.newComplex(context, context.runtime.getComplex(), Numeric.f_mul(context, RubyMath.sin(context, x, complex.real), RubyMath.cosh(context, x, complex.image)), Numeric.f_mul(context, RubyMath.cos(context, x, complex.real), RubyMath.sinh(context, x, complex.image)));
    }

    private static IRubyObject m_sqrt(ThreadContext context, IRubyObject x) {
        if (Numeric.f_real_p(context, x)) {
            if (!Numeric.f_negative_p(context, x)) {
                return RubyMath.sqrt(context, x, x);
            }
            return RubyComplex.newComplex(context, context.runtime.getComplex(), RubyFixnum.zero(context.runtime), RubyMath.sqrt(context, x, Numeric.f_negate(context, x)));
        }
        RubyComplex complex = (RubyComplex)x;
        if (Numeric.f_negative_p(context, complex.image)) {
            return Numeric.f_conjugate(context, RubyComplex.m_sqrt(context, Numeric.f_conjugate(context, x)));
        }
        IRubyObject a = Numeric.f_abs(context, x);
        RubyFixnum two = RubyFixnum.two(context.runtime);
        return RubyComplex.newComplex(context, context.runtime.getComplex(), RubyMath.sqrt(context, x, Numeric.f_div(context, Numeric.f_add(context, a, complex.real), two)), RubyMath.sqrt(context, x, Numeric.f_div(context, Numeric.f_sub(context, a, complex.real), two)));
    }

    @Deprecated
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.newInstanceBang(context, recv2, args2[0]);
            }
            case 2: {
                return RubyComplex.newInstanceBang(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        if (!(real2 instanceof RubyNumeric)) {
            real2 = Numeric.f_to_i(context, real2);
        }
        return new RubyComplex(context.runtime, (RubyClass)recv2, real2, RubyFixnum.zero(context.runtime));
    }

    @JRubyMethod(name={"new!"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject newInstanceBang(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        if (!(real2 instanceof RubyNumeric)) {
            real2 = Numeric.f_to_i(context, real2);
        }
        if (!(image2 instanceof RubyNumeric)) {
            image2 = Numeric.f_to_i(context, image2);
        }
        return new RubyComplex(context.runtime, (RubyClass)recv2, real2, image2);
    }

    public static void setCanonicalization(boolean canonical) {
        canonicalization = canonical;
    }

    private static void realCheck(ThreadContext context, IRubyObject num) {
        switch (num.getMetaClass().getClassIndex()) {
            case INTEGER: 
            case FLOAT: 
            case RATIONAL: {
                break;
            }
            default: {
                if (num instanceof RubyNumeric && Numeric.f_real_p(context, num)) break;
                throw context.runtime.newTypeError("not a real");
            }
        }
    }

    private static RubyNumeric canonicalizeInternal(ThreadContext context, RubyClass clazz, IRubyObject real2, IRubyObject image2) {
        if (Numeric.f_zero_p(context, image2) && Numeric.k_exact_p(image2) && canonicalization) {
            return (RubyNumeric)real2;
        }
        boolean realReal = Numeric.f_real_p(context, real2);
        boolean imagReal = Numeric.f_real_p(context, image2);
        if (realReal && imagReal) {
            return new RubyComplex(context.runtime, clazz, real2, image2);
        }
        if (realReal) {
            RubyComplex complex = (RubyComplex)image2;
            return new RubyComplex(context.runtime, clazz, Numeric.f_sub(context, real2, complex.image), Numeric.f_add(context, (IRubyObject)RubyFixnum.zero(context.runtime), complex.real));
        }
        if (imagReal) {
            RubyComplex complex = (RubyComplex)real2;
            return new RubyComplex(context.runtime, clazz, complex.real, Numeric.f_add(context, complex.image, image2));
        }
        RubyComplex complex1 = (RubyComplex)real2;
        RubyComplex complex2 = (RubyComplex)image2;
        return new RubyComplex(context.runtime, clazz, Numeric.f_sub(context, complex1.real, complex2.image), Numeric.f_add(context, complex1.image, complex2.real));
    }

    @Deprecated
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.newInstance(context, recv2, args2[0]);
            }
            case 2: {
                return RubyComplex.newInstance(context, recv2, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2.length, 1, 2);
        return null;
    }

    @Deprecated
    public static IRubyObject newInstanceNew(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        return RubyComplex.newInstance(context, recv2, real2);
    }

    @JRubyMethod(name={"rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2) {
        RubyComplex.realCheck(context, real2);
        return RubyComplex.canonicalizeInternal(context, (RubyClass)recv2, real2, RubyFixnum.zero(context.runtime));
    }

    @Deprecated
    public static IRubyObject newInstanceNew(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        return RubyComplex.newInstance(context, recv2, real2, image2);
    }

    @JRubyMethod(name={"rect", "rectangular"}, meta=true)
    public static IRubyObject newInstance(ThreadContext context, IRubyObject recv2, IRubyObject real2, IRubyObject image2) {
        RubyComplex.realCheck(context, real2);
        RubyComplex.realCheck(context, image2);
        return RubyComplex.canonicalizeInternal(context, (RubyClass)recv2, real2, image2);
    }

    private static IRubyObject f_complex_polar(ThreadContext context, RubyClass clazz, IRubyObject x, IRubyObject y) {
        assert (!(x instanceof RubyComplex) && !(y instanceof RubyComplex));
        return RubyComplex.canonicalizeInternal(context, clazz, Numeric.f_mul(context, x, RubyComplex.m_cos(context, y)), Numeric.f_mul(context, x, RubyComplex.m_sin(context, y)));
    }

    @JRubyMethod(name={"polar"}, meta=true, required=1, optional=1)
    public static IRubyObject polar(ThreadContext context, IRubyObject clazz, IRubyObject ... args2) {
        IRubyObject abs3 = args2[0];
        IRubyObject arg2 = args2.length < 2 ? RubyFixnum.zero(context.runtime) : args2[1];
        RubyComplex.realCheck(context, abs3);
        RubyComplex.realCheck(context, arg2);
        return RubyComplex.f_complex_polar(context, (RubyClass)clazz, abs3, arg2);
    }

    @Deprecated
    public static IRubyObject polar19(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        return RubyComplex.polar(context, clazz, args2);
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x) {
        return RubyComplex.newComplexConvert(context, x, RubyFixnum.zero(context.runtime));
    }

    public static IRubyObject newComplexConvert(ThreadContext context, IRubyObject x, IRubyObject y) {
        return RubyComplex.convert(context, context.runtime.getComplex(), x, y);
    }

    @Deprecated
    public static IRubyObject convert(ThreadContext context, IRubyObject clazz, IRubyObject[] args2) {
        switch (args2.length) {
            case 1: {
                return RubyComplex.convert(context, clazz, args2[0]);
            }
            case 2: {
                return RubyComplex.convert(context, clazz, args2[0], args2[1]);
            }
        }
        Arity.raiseArgumentError(context.runtime, args2.length, 1, 2);
        return null;
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject arg2) {
        return RubyComplex.convertCommon(context, recv2, arg2, null);
    }

    @JRubyMethod(name={"convert"}, meta=true, visibility=Visibility.PRIVATE)
    public static IRubyObject convert(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        return RubyComplex.convertCommon(context, recv2, a1, a2);
    }

    private static IRubyObject convertCommon(ThreadContext context, IRubyObject recv2, IRubyObject a1, IRubyObject a2) {
        boolean singleArg;
        boolean bl = singleArg = a2 == null;
        if (a1 == context.nil || a2 == context.nil) {
            throw context.runtime.newTypeError("can't convert nil into Complex");
        }
        if (a1 instanceof RubyString) {
            a1 = RubyComplex.str_to_c_strict(context, (RubyString)a1);
        }
        if (a2 instanceof RubyString) {
            a2 = RubyComplex.str_to_c_strict(context, (RubyString)a2);
        }
        if (a1 instanceof RubyComplex) {
            RubyComplex a1c = (RubyComplex)a1;
            if (Numeric.k_exact_p(a1c.image) && Numeric.f_zero_p(context, a1c.image)) {
                a1 = a1c.real;
            }
        }
        if (a2 instanceof RubyComplex) {
            RubyComplex a2c = (RubyComplex)a2;
            if (Numeric.k_exact_p(a2c.image) && Numeric.f_zero_p(context, a2c.image)) {
                a2 = a2c.real;
            }
        }
        if (a1 instanceof RubyComplex && (singleArg || Numeric.k_exact_p(a2) && Numeric.f_zero_p(context, a2))) {
            return a1;
        }
        if (singleArg) {
            if (a1 instanceof RubyNumeric) {
                if (!Numeric.f_real_p(context, a1)) {
                    return a1;
                }
            } else {
                return TypeConverter.convertToType(context, a1, context.runtime.getComplex(), RubyComplex.sites((ThreadContext)context).to_c_checked);
            }
            return RubyComplex.newInstance(context, recv2, a1);
        }
        if (a1 instanceof RubyNumeric && a2 instanceof RubyNumeric && (!Numeric.f_real_p(context, a1) || !Numeric.f_real_p(context, a2))) {
            Ruby runtime2 = context.runtime;
            return Numeric.f_add(context, a1, Numeric.f_mul(context, a2, RubyComplex.newComplexBang(context, runtime2.getComplex(), RubyFixnum.zero(runtime2), RubyFixnum.one(runtime2))));
        }
        return RubyComplex.newInstance(context, recv2, a1, a2);
    }

    @JRubyMethod(name={"real"})
    public IRubyObject real() {
        return this.real;
    }

    @JRubyMethod(name={"imaginary", "imag"})
    public IRubyObject image() {
        return this.image;
    }

    @JRubyMethod(name={"-@"})
    public IRubyObject negate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_negate(context, this.real), Numeric.f_negate(context, this.image));
    }

    @JRubyMethod(name={"+"})
    public IRubyObject op_add(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, otherComplex.real), Numeric.f_add(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_add(context, this.real, other), this.image);
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_plus, other);
    }

    @JRubyMethod(name={"-"})
    public IRubyObject op_sub(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, otherComplex.real), Numeric.f_sub(context, this.image, otherComplex.image));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, this.real, other), this.image);
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_minus, other);
    }

    @JRubyMethod(name={"*"})
    public IRubyObject op_mul(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            boolean arzero = Numeric.f_zero_p(context, this.real);
            boolean aizero = Numeric.f_zero_p(context, this.image);
            boolean brzero = Numeric.f_zero_p(context, otherComplex.real);
            boolean bizero = Numeric.f_zero_p(context, otherComplex.image);
            IRubyObject realp = Numeric.f_sub(context, Numeric.safe_mul(context, this.real, otherComplex.real, arzero, brzero), Numeric.safe_mul(context, this.image, otherComplex.image, aizero, bizero));
            IRubyObject imagep = Numeric.f_add(context, Numeric.safe_mul(context, this.real, otherComplex.image, arzero, bizero), Numeric.safe_mul(context, this.image, otherComplex.real, aizero, brzero));
            return RubyComplex.newComplex(context, this.getMetaClass(), realp, imagep);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, this.real, other), Numeric.f_mul(context, this.image, other));
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_times, other);
    }

    @JRubyMethod(name={"/", "quo"})
    public IRubyObject op_div(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (this.real instanceof RubyFloat || this.image instanceof RubyFloat || otherComplex.real instanceof RubyFloat || otherComplex.image instanceof RubyFloat) {
                RubyFloat magn = RubyMath.hypot(context, this, otherComplex.real, otherComplex.image);
                RubyComplex tmp = RubyComplex.newComplexBang(context, this.getMetaClass(), (RubyNumeric)Numeric.f_quo(context, otherComplex.real, (IRubyObject)magn), (RubyNumeric)Numeric.f_quo(context, otherComplex.image, (IRubyObject)magn));
                return Numeric.f_quo(context, Numeric.f_mul(context, this, Numeric.f_conjugate(context, tmp)), (IRubyObject)magn);
            }
            return Numeric.f_quo(context, Numeric.f_mul(context, this, Numeric.f_conjugate(context, other)), Numeric.f_abs2(context, other));
        }
        if (other instanceof RubyNumeric) {
            if (Numeric.f_real_p(context, (RubyNumeric)other)) {
                return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_quo(context, this.real, other), Numeric.f_quo(context, this.image, other));
            }
            RubyArray coercedOther = this.doCoerce(context, other, true);
            return RubyRational.newInstance(context, context.runtime.getRational(), coercedOther.eltInternal(0), coercedOther.eltInternal(1));
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_quo, other);
    }

    @Override
    @JRubyMethod(name={"fdiv"})
    public IRubyObject fdiv(ThreadContext context, IRubyObject other) {
        RubyNumeric complex = RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_to_f(context, this.real), Numeric.f_to_f(context, this.image));
        return Numeric.f_div(context, complex, other);
    }

    @JRubyMethod(name={"**"})
    public IRubyObject op_expt(ThreadContext context, IRubyObject other) {
        if (Numeric.k_exact_p(other) && Numeric.f_zero_p(context, other)) {
            return RubyComplex.newComplexBang(context, this.getMetaClass(), RubyFixnum.one(context.runtime));
        }
        if (other instanceof RubyRational && Numeric.f_one_p(context, Numeric.f_denominator(context, other))) {
            other = Numeric.f_numerator(context, other);
        }
        if (other instanceof RubyComplex) {
            RubyArray a = Numeric.f_polar(context, this).convertToArray();
            Object r = a.eltInternal(0);
            Object theta = a.eltInternal(1);
            RubyComplex otherComplex = (RubyComplex)other;
            RubyFloat nr = RubyMath.exp(context, this, Numeric.f_sub(context, Numeric.f_mul(context, otherComplex.real, RubyMath.log(context, (IRubyObject)this, r)), Numeric.f_mul(context, otherComplex.image, theta)));
            IRubyObject ntheta = Numeric.f_add(context, Numeric.f_mul(context, theta, otherComplex.real), Numeric.f_mul(context, otherComplex.image, RubyMath.log(context, (IRubyObject)this, r)));
            return RubyComplex.f_complex_polar(context, this.getMetaClass(), nr, ntheta);
        }
        if (other instanceof RubyInteger) {
            RubyFixnum one = RubyFixnum.one(context.runtime);
            if (Numeric.f_gt_p(context, (RubyInteger)other, RubyFixnum.zero(context.runtime))) {
                RubyNumeric x;
                IRubyObject z = x = this;
                RubyInteger n = Numeric.f_sub(context, (RubyInteger)other, one);
                RubyFixnum two = RubyFixnum.two(context.runtime);
                while (!Numeric.f_zero_p(context, n)) {
                    RubyArray a = Numeric.f_divmod(context, n, (IRubyObject)two).convertToArray();
                    while (Numeric.f_zero_p(context, a.eltInternal(1))) {
                        RubyComplex xComplex = x;
                        x = RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_sub(context, Numeric.f_mul(context, xComplex.real, xComplex.real), Numeric.f_mul(context, xComplex.image, xComplex.image)), Numeric.f_mul(context, Numeric.f_mul(context, (IRubyObject)two, xComplex.real), xComplex.image));
                        n = (RubyInteger)a.eltInternal(0);
                        a = Numeric.f_divmod(context, n, (IRubyObject)two).convertToArray();
                    }
                    z = Numeric.f_mul(context, z, x);
                    n = Numeric.f_sub(context, n, one);
                }
                return z;
            }
            return Numeric.f_expt(context, Numeric.f_div(context, Numeric.f_to_r(context, one), this), (IRubyObject)Numeric.f_negate(context, (RubyInteger)other));
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            RubyArray a = Numeric.f_polar(context, this).convertToArray();
            Object r = a.eltInternal(0);
            Object theta = a.eltInternal(1);
            return RubyComplex.f_complex_polar(context, this.getMetaClass(), Numeric.f_expt(context, r, other), Numeric.f_mul(context, theta, other));
        }
        return this.coerceBin(context, RubyComplex.sites((ThreadContext)context).op_exp, other);
    }

    @Override
    @JRubyMethod(name={"=="})
    public IRubyObject op_equal(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            boolean test2 = Numeric.f_equal(context, this.real, otherComplex.real).isTrue() && Numeric.f_equal(context, this.image, otherComplex.image).isTrue();
            return context.runtime.newBoolean(test2);
        }
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, (RubyNumeric)other)) {
            boolean test3 = Numeric.f_equal(context, this.real, other).isTrue() && Numeric.f_zero_p(context, this.image);
            return context.runtime.newBoolean(test3);
        }
        return Numeric.f_equal(context, other, this);
    }

    @JRubyMethod(name={"coerce"})
    public IRubyObject coerce(ThreadContext context, IRubyObject other) {
        if (other instanceof RubyNumeric && Numeric.f_real_p(context, other)) {
            return context.runtime.newArray((IRubyObject)RubyComplex.newComplexBang(context, this.getMetaClass(), (RubyNumeric)other), (IRubyObject)this);
        }
        if (other instanceof RubyComplex) {
            return context.runtime.newArray(other, (IRubyObject)this);
        }
        Ruby runtime2 = context.runtime;
        throw runtime2.newTypeError(RubyStringBuilder.str(runtime2, RubyStringBuilder.types(runtime2, other.getMetaClass()), " can't be coerced into ", RubyStringBuilder.types(runtime2, this.getMetaClass())));
    }

    @Override
    @JRubyMethod(name={"abs", "magnitude"})
    public IRubyObject abs(ThreadContext context) {
        return RubyMath.hypot(context, this, this.real, this.image);
    }

    @Override
    @JRubyMethod(name={"abs2"})
    public IRubyObject abs2(ThreadContext context) {
        return Numeric.f_add(context, Numeric.f_mul(context, this.real, this.real), Numeric.f_mul(context, this.image, this.image));
    }

    @Override
    @JRubyMethod(name={"arg", "angle", "phase"})
    public IRubyObject arg(ThreadContext context) {
        return RubyMath.atan2(context, this, this.image, this.real);
    }

    @Override
    @JRubyMethod(name={"rectangular", "rect"})
    public IRubyObject rect(ThreadContext context) {
        return context.runtime.newArray(this.real, this.image);
    }

    @Override
    @JRubyMethod(name={"polar"})
    public IRubyObject polar(ThreadContext context) {
        return context.runtime.newArray(Numeric.f_abs(context, this), Numeric.f_arg(context, this));
    }

    @Override
    @JRubyMethod(name={"conjugate", "conj", "~"})
    public IRubyObject conjugate(ThreadContext context) {
        return RubyComplex.newComplex(context, this.getMetaClass(), this.real, Numeric.f_negate(context, this.image));
    }

    @Override
    @JRubyMethod(name={"real?"})
    public IRubyObject real_p(ThreadContext context) {
        return context.fals;
    }

    @Override
    public boolean isReal() {
        return false;
    }

    public IRubyObject complex_p(ThreadContext context) {
        return context.tru;
    }

    public IRubyObject exact_p(ThreadContext context) {
        return Numeric.f_exact_p(context, this.real) && Numeric.f_exact_p(context, this.image) ? context.tru : context.fals;
    }

    public IRubyObject inexact_p(ThreadContext context) {
        return this.exact_p(context) == context.tru ? context.fals : context.tru;
    }

    @JRubyMethod(name={"denominator"})
    public IRubyObject demoninator(ThreadContext context) {
        return Numeric.f_lcm(context, Numeric.f_denominator(context, this.real), Numeric.f_denominator(context, this.image));
    }

    @Override
    @JRubyMethod(name={"numerator"})
    public IRubyObject numerator(ThreadContext context) {
        IRubyObject cd = this.callMethod(context, "denominator");
        return RubyComplex.newComplex(context, this.getMetaClass(), Numeric.f_mul(context, Numeric.f_numerator(context, this.real), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.real))), Numeric.f_mul(context, Numeric.f_numerator(context, this.image), Numeric.f_div(context, cd, Numeric.f_denominator(context, this.image))));
    }

    @JRubyMethod(name={"hash"})
    public IRubyObject hash(ThreadContext context) {
        return Numeric.f_xor(context, Helpers.invokedynamic(context, this.real, MethodNames.HASH), Helpers.invokedynamic(context, this.image, MethodNames.HASH));
    }

    @Override
    public int hashCode() {
        IRubyObject hash2 = this.hash(this.getRuntime().getCurrentContext());
        if (hash2 instanceof RubyFixnum) {
            return (int)RubyNumeric.fix2long(hash2);
        }
        return RubyComplex.nonFixnumHashCode(hash2);
    }

    @Override
    @JRubyMethod(name={"eql?"})
    public IRubyObject eql_p(ThreadContext context, IRubyObject other) {
        return context.runtime.newBoolean(this.equals(context, other));
    }

    private boolean equals(ThreadContext context, Object other) {
        if (other instanceof RubyComplex) {
            RubyComplex otherComplex = (RubyComplex)other;
            if (this.real.getMetaClass() == otherComplex.real.getMetaClass() && this.image.getMetaClass() == otherComplex.image.getMetaClass() && Numeric.f_equal(context, this, otherComplex).isTrue()) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean equals(Object other) {
        return this.equals(this.getRuntime().getCurrentContext(), other);
    }

    private static boolean signbit(ThreadContext context, IRubyObject x) {
        if (x instanceof RubyFloat) {
            double value2 = ((RubyFloat)x).value;
            return !Double.isNaN(value2) && Double.doubleToLongBits(value2) < 0L;
        }
        return Numeric.f_negative_p(context, x);
    }

    private static boolean tpositive_p(ThreadContext context, IRubyObject x) {
        return !RubyComplex.signbit(context, x);
    }

    @JRubyMethod(name={"to_s"})
    public IRubyObject to_s(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = Numeric.f_to_s(context, this.real).convertToString();
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_to_s(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        if (!RubyComplex.lastCharDigit(str)) {
            str.cat((byte)42);
        }
        str.cat((byte)105);
        return str;
    }

    @JRubyMethod(name={"inspect"})
    public IRubyObject inspect(ThreadContext context) {
        boolean impos = RubyComplex.tpositive_p(context, this.image);
        RubyString str = context.runtime.newString();
        str.cat((byte)40);
        str.cat(Numeric.f_inspect(context, this.real).convertToString().getByteList());
        str.cat(impos ? (byte)43 : 45);
        str.cat(Numeric.f_inspect(context, Numeric.f_abs(context, this.image)).convertToString().getByteList());
        if (!RubyComplex.lastCharDigit(str)) {
            str.cat((byte)42);
        }
        str.cat((byte)105);
        str.cat((byte)41);
        return str;
    }

    private static boolean lastCharDigit(RubyString str) {
        ByteList bytes2 = str.getByteList();
        return ASCIIEncoding.INSTANCE.isDigit(bytes2.getUnsafeBytes()[bytes2.getBegin() + bytes2.getRealSize() - 1]);
    }

    @JRubyMethod(name={"marshal_dump"})
    public IRubyObject marshal_dump(ThreadContext context) {
        RubyArray dump2 = context.runtime.newArray(this.real, this.image);
        if (this.hasVariables()) {
            dump2.syncVariables(this);
        }
        return dump2;
    }

    @JRubyMethod(name={"marshal_load"})
    public IRubyObject marshal_load(ThreadContext context, IRubyObject arg2) {
        RubyArray load2 = arg2.convertToArray();
        this.real = load2.size() > 0 ? load2.eltInternal(0) : context.nil;
        IRubyObject iRubyObject = this.image = load2.size() > 1 ? load2.eltInternal(1) : context.nil;
        if (load2.hasVariables()) {
            this.syncVariables(load2);
        }
        return this;
    }

    @Override
    @JRubyMethod(name={"to_c"})
    public IRubyObject to_c(ThreadContext context) {
        return this;
    }

    @JRubyMethod(name={"to_i"})
    public IRubyObject to_i(ThreadContext context) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.runtime.newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Integer");
        }
        return Numeric.f_to_i(context, this.real);
    }

    @JRubyMethod(name={"to_f"})
    public IRubyObject to_f(ThreadContext context) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.runtime.newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Float");
        }
        return Numeric.f_to_f(context, this.real);
    }

    @JRubyMethod(name={"to_r"})
    public IRubyObject to_r(ThreadContext context) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.runtime.newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Rational");
        }
        return Numeric.f_to_r(context, this.real);
    }

    @JRubyMethod(name={"rationalize"}, optional=1)
    public IRubyObject rationalize(ThreadContext context, IRubyObject[] args2) {
        if (Numeric.k_inexact_p(this.image) || !Numeric.f_zero_p(context, this.image)) {
            throw context.runtime.newRangeError("can't convert " + Numeric.f_to_s(context, this).convertToString() + " into Rational");
        }
        return this.real.callMethod(context, "rationalize", args2);
    }

    @Override
    @JRubyMethod(name={"finite?"})
    public IRubyObject finite_p(ThreadContext context) {
        if (this.checkFinite(context, this.real) && this.checkFinite(context, this.image)) {
            return context.tru;
        }
        return context.fals;
    }

    public boolean checkFinite(ThreadContext context, IRubyObject value2) {
        if (value2 instanceof RubyInteger || value2 instanceof RubyRational) {
            return true;
        }
        if (value2 instanceof RubyFloat) {
            return ((RubyFloat)value2).finite_p().isTrue();
        }
        if (value2 instanceof RubyRational) {
            return true;
        }
        return RubyComplex.sites((ThreadContext)context).finite.call(context, value2, value2).isTrue();
    }

    @Override
    @JRubyMethod(name={"infinite?"})
    public IRubyObject infinite_p(ThreadContext context) {
        if (this.checkInfinite(context, this.real).isNil() && this.checkInfinite(context, this.image).isNil()) {
            return context.nil;
        }
        return RubyFixnum.newFixnum(this.getRuntime(), 1L);
    }

    public IRubyObject checkInfinite(ThreadContext context, IRubyObject value2) {
        if (value2 instanceof RubyInteger || value2 instanceof RubyRational) {
            return context.nil;
        }
        if (value2 instanceof RubyFloat) {
            return ((RubyFloat)value2).infinite_p();
        }
        return RubyComplex.sites((ThreadContext)context).infinite.call(context, value2, value2);
    }

    static IRubyObject[] str_to_c_internal(ThreadContext context, RubyString str) {
        IRubyObject t;
        RubyMatchData match2;
        IRubyObject re;
        Ruby runtime2 = context.runtime;
        IRubyObject nil = context.nil;
        ByteList bytes2 = str.getByteList();
        if (bytes2.getRealSize() == 0) {
            return new IRubyObject[]{context.nil, str};
        }
        IRubyObject si = re = nil;
        IRubyObject sr = re;
        boolean po = false;
        IRubyObject m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat0).match_m(context, (IRubyObject)str, false);
        if (m != nil) {
            match2 = (RubyMatchData)m;
            sr = match2.at(1);
            si = match2.at(2);
            re = match2.post_match(context);
            po = true;
        }
        if (m == nil && (m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat1).match_m(context, (IRubyObject)str, false)) != nil) {
            match2 = (RubyMatchData)m;
            sr = nil;
            si = match2.at(1);
            if (si == nil) {
                si = runtime2.newString();
            }
            if ((t = match2.at(2)) == nil) {
                t = runtime2.newString(RubyInteger.singleCharByteList((byte)49));
            }
            si = si.convertToString();
            ((RubyString)si).cat(t.convertToString());
            re = match2.post_match(context);
            po = false;
        }
        if (m == nil) {
            m = RubyRegexp.newDummyRegexp(runtime2, Numeric.ComplexPatterns.comp_pat2).match_m(context, (IRubyObject)str, false);
            if (m == nil) {
                return new IRubyObject[]{context.nil, str};
            }
            match2 = (RubyMatchData)m;
            sr = match2.at(1);
            if (match2.at(2) == nil) {
                si = context.nil;
            } else {
                si = match2.at(3);
                t = match2.at(4);
                if (t == nil) {
                    t = runtime2.newString(RubyInteger.singleCharByteList((byte)49));
                }
                si = si.convertToString();
                ((RubyString)si).cat(t.convertToString());
            }
            re = match2.post_match(context);
            po = false;
        }
        RubyFixnum zero = RubyFixnum.zero(runtime2);
        RubyNumeric r = RubyComplex.convertString(context, sr, zero);
        RubyNumeric i2 = RubyComplex.convertString(context, si, zero);
        return new IRubyObject[]{po ? RubyComplex.newComplexPolar(context, r, i2) : RubyComplex.newComplexCanonicalize(context, r, i2), re};
    }

    private static RubyNumeric convertString(ThreadContext context, IRubyObject s2, RubyFixnum zero) {
        if (s2 == context.nil) {
            return zero;
        }
        Ruby runtime2 = context.runtime;
        if (s2.callMethod(context, "include?", RubyString.newStringShared(runtime2, SEP)).isTrue()) {
            return (RubyNumeric)Numeric.f_to_r(context, s2);
        }
        if (Numeric.f_gt_p(context, s2.callMethod(context, "count", RubyString.newStringShared(runtime2, _eE)), (IRubyObject)zero)) {
            return (RubyNumeric)Numeric.f_to_f(context, s2);
        }
        return (RubyNumeric)Numeric.f_to_i(context, s2);
    }

    private static RubyNumeric str_to_c_strict(ThreadContext context, RubyString str) {
        IRubyObject[] ary = RubyComplex.str_to_c_internal(context, str);
        if (ary[0] == context.nil || ary[1].convertToString().getByteList().length() > 0) {
            throw context.runtime.newArgumentError(RubyStringBuilder.str(context.runtime, "invalid value for convert(): ", str.callMethod(context, "inspect")));
        }
        return (RubyNumeric)ary[0];
    }

    private static JavaSites.ComplexSites sites(ThreadContext context) {
        return context.sites.Complex;
    }
}

