/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Attachment;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.PsiClassReferenceType;
import com.intellij.psi.impl.source.PsiImmediateClassType;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final Logger LOG = Logger.getInstance(JavaResolveCache.class);
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final AtomicReference<ConcurrentMap<PsiExpression, PsiType>> myCalculatedTypes = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical = new AtomicReference();
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical = new AtomicReference();
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public JavaResolveCache(@Nullable(value="can be null in com.intellij.core.JavaCoreApplicationEnvironment.JavaCoreApplicationEnvironment") MessageBus messageBus) {
        if (messageBus != null) {
            messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener.Adapter(){

                @Override
                public void beforePsiChanged(boolean isPhysical) {
                    JavaResolveCache.this.clearCaches(isPhysical);
                }
            });
        }
    }

    private void clearCaches(boolean isPhysical) {
        this.myCalculatedTypes.set(null);
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<? super T, ? extends PsiType> f) {
        PsiType type2;
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(0);
        }
        if (f == null) {
            JavaResolveCache.$$$reportNull$$$0(1);
        }
        boolean isOverloadCheck = MethodCandidateInfo.isOverloadCheck();
        boolean polyExpression = PsiPolyExpressionUtil.isPolyExpression(expr);
        ConcurrentMap<PsiExpression, PsiType> map2 = this.myCalculatedTypes.get();
        if (map2 == null) {
            map2 = ConcurrencyUtil.cacheOrGet(this.myCalculatedTypes, ContainerUtil.createConcurrentWeakKeySoftValueMap());
        }
        PsiType psiType2 = type2 = isOverloadCheck && polyExpression ? null : (PsiType)map2.get(expr);
        if (type2 == null) {
            PsiType alreadyCached;
            RecursionGuard.StackStamp dStackStamp = RecursionManager.markStack();
            type2 = f.fun(expr);
            if (!dStackStamp.mayCacheNow()) {
                return type2;
            }
            if (isOverloadCheck && polyExpression) {
                return type2;
            }
            if (type2 == null) {
                type2 = TypeConversionUtil.NULL_TYPE;
            }
            if ((alreadyCached = map2.put(expr, type2)) != null && !type2.equals(alreadyCached)) {
                JavaResolveCache.reportUnstableType(expr, type2, alreadyCached);
            }
            if (type2 instanceof PsiClassReferenceType) {
                PsiClassType.ClassResolveResult result2 = ((PsiClassReferenceType)type2).resolveGenerics();
                PsiClass psiClass = result2.getElement();
                type2 = psiClass == null ? type2 : new PsiImmediateClassType(psiClass, result2.getSubstitutor(), ((PsiClassReferenceType)type2).getLanguageLevel(), type2.getAnnotationProvider());
            }
        }
        return type2 == TypeConversionUtil.NULL_TYPE ? null : type2;
    }

    private static <T extends PsiExpression> void reportUnstableType(@NotNull PsiExpression expr, @NotNull PsiType type2, @NotNull PsiType alreadyCached) {
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(2);
        }
        if (type2 == null) {
            JavaResolveCache.$$$reportNull$$$0(3);
        }
        if (alreadyCached == null) {
            JavaResolveCache.$$$reportNull$$$0(4);
        }
        PsiFile file2 = expr.getContainingFile();
        LOG.error("Different types returned for the same PSI " + expr.getTextRange() + " on different threads: " + type2 + " != " + alreadyCached, new Attachment(file2.getName(), file2.getText()));
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable2, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached2;
        boolean physical;
        AtomicReference<Map<PsiVariable, Object>> ref;
        Map map2;
        if (variable2 == null) {
            JavaResolveCache.$$$reportNull$$$0(5);
        }
        if (computer == null) {
            JavaResolveCache.$$$reportNull$$$0(6);
        }
        if ((map2 = (ref = (physical = variable2.isPhysical()) ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical).get()) == null) {
            map2 = ConcurrencyUtil.cacheOrGet(ref, ContainerUtil.createConcurrentWeakMap());
        }
        if ((cached2 = map2.get(variable2)) == NULL) {
            return null;
        }
        if (cached2 != null) {
            return cached2;
        }
        Object result2 = computer.execute(variable2, visitedVars);
        map2.put(variable2, result2 == null ? NULL : result2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "alreadyCached";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/JavaResolveCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "reportUnstableType";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConstantValueWithCaching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

