/*
 * Decompiled with CFR 0.152.
 */
package gnu.inet.ftp;

import gnu.inet.ftp.FTPConnection;
import gnu.inet.util.GetLocalHostAction;
import gnu.inet.util.GetSystemPropertyAction;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;

public class FTPURLConnection
extends URLConnection {
    protected FTPConnection connection;
    protected boolean passive = true;
    protected int representationType = 3;
    protected int fileStructure = -1;
    protected int transferMode = -1;

    public FTPURLConnection(URL uRL) {
        super(uRL);
    }

    @Override
    public void connect() throws IOException {
        if (this.connected) {
            return;
        }
        String string = this.url.getHost();
        int n = this.url.getPort();
        String string2 = this.url.getUserInfo();
        String string3 = null;
        if (string2 != null) {
            int n2 = string2.indexOf(58);
            if (n2 != -1) {
                string3 = string2.substring(n2 + 1);
                string2 = string2.substring(0, n2);
            }
        } else {
            string2 = "anonymous";
            PrivilegedAction privilegedAction = new GetSystemPropertyAction("user.name");
            String string4 = (String)AccessController.doPrivileged(privilegedAction);
            privilegedAction = new GetLocalHostAction();
            InetAddress inetAddress = (InetAddress)AccessController.doPrivileged(privilegedAction);
            string3 = string4 + "@" + (inetAddress == null ? "localhost" : inetAddress.getHostName());
        }
        this.connection = new FTPConnection(string, n);
        if (!this.connection.authenticate(string2, string3)) {
            throw new SecurityException("Authentication failed");
        }
        this.connection.setPassive(this.passive);
        if (this.representationType != -1) {
            this.connection.setRepresentationType(this.representationType);
        }
        if (this.fileStructure != -1) {
            this.connection.setFileStructure(this.fileStructure);
        }
        if (this.transferMode != -1) {
            this.connection.setTransferMode(this.transferMode);
        }
    }

    @Override
    public void setDoInput(boolean bl) {
        this.doInput = bl;
    }

    @Override
    public void setDoOutput(boolean bl) {
        this.doOutput = bl;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        String string;
        if (!this.connected) {
            this.connect();
        }
        if ((string = this.url.getPath()).startsWith("/")) {
            string = string.substring(1);
        }
        if (this.connection.changeWorkingDirectory(string)) {
            return new ClosingInputStream(this.connection.list(null));
        }
        return new ClosingInputStream(this.connection.retrieve(string));
    }

    @Override
    public OutputStream getOutputStream() throws IOException {
        if (!this.connected) {
            this.connect();
        }
        String string = this.url.getPath();
        return new ClosingOutputStream(this.connection.store(string));
    }

    @Override
    public String getRequestProperty(String string) {
        if ("passive".equals(string)) {
            return Boolean.toString(this.passive);
        }
        if ("representationType".equals(string)) {
            switch (this.representationType) {
                case 1: {
                    return "ASCII";
                }
                case 2: {
                    return "EBCDIC";
                }
                case 3: {
                    return "BINARY";
                }
            }
        } else if ("fileStructure".equals(string)) {
            switch (this.fileStructure) {
                case 1: {
                    return "FILE";
                }
                case 2: {
                    return "RECORD";
                }
                case 3: {
                    return "PAGE";
                }
            }
        } else if ("transferMode".equals(string)) {
            switch (this.transferMode) {
                case 1: {
                    return "STREAM";
                }
                case 2: {
                    return "BLOCK";
                }
                case 3: {
                    return "COMPRESSED";
                }
            }
        }
        return null;
    }

    public Map getRequestProperties() {
        HashMap hashMap = new HashMap();
        this.addRequestPropertyValue(hashMap, "passive");
        this.addRequestPropertyValue(hashMap, "representationType");
        this.addRequestPropertyValue(hashMap, "fileStructure");
        this.addRequestPropertyValue(hashMap, "transferMode");
        return hashMap;
    }

    private void addRequestPropertyValue(Map map, String string) {
        String string2 = this.getRequestProperty(string);
        map.put(string, string2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void setRequestProperty(String string, String string2) {
        if (this.connected) {
            throw new IllegalStateException();
        }
        if ("passive".equals(string)) {
            this.passive = Boolean.valueOf(string2);
            return;
        } else if ("representationType".equals(string)) {
            if ("A".equalsIgnoreCase(string2) || "ASCII".equalsIgnoreCase(string2)) {
                this.representationType = 1;
                return;
            } else if ("E".equalsIgnoreCase(string2) || "EBCDIC".equalsIgnoreCase(string2)) {
                this.representationType = 2;
                return;
            } else {
                if (!"I".equalsIgnoreCase(string2) && !"BINARY".equalsIgnoreCase(string2)) throw new IllegalArgumentException(string2);
                this.representationType = 3;
            }
            return;
        } else if ("fileStructure".equals(string)) {
            if ("F".equalsIgnoreCase(string2) || "FILE".equalsIgnoreCase(string2)) {
                this.fileStructure = 1;
                return;
            } else if ("R".equalsIgnoreCase(string2) || "RECORD".equalsIgnoreCase(string2)) {
                this.fileStructure = 2;
                return;
            } else {
                if (!"P".equalsIgnoreCase(string2) && !"PAGE".equalsIgnoreCase(string2)) throw new IllegalArgumentException(string2);
                this.fileStructure = 3;
            }
            return;
        } else {
            if (!"transferMode".equals(string)) return;
            if ("S".equalsIgnoreCase(string2) || "STREAM".equalsIgnoreCase(string2)) {
                this.transferMode = 1;
                return;
            } else if ("B".equalsIgnoreCase(string2) || "BLOCK".equalsIgnoreCase(string2)) {
                this.transferMode = 2;
                return;
            } else {
                if (!"C".equalsIgnoreCase(string2) && !"COMPRESSED".equalsIgnoreCase(string2)) throw new IllegalArgumentException(string2);
                this.transferMode = 3;
            }
        }
    }

    @Override
    public void addRequestProperty(String string, String string2) {
        this.setRequestProperty(string, string2);
    }

    class ClosingOutputStream
    extends FilterOutputStream {
        ClosingOutputStream(OutputStream outputStream) {
            super(outputStream);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FTPURLConnection.this.connection.logout();
        }
    }

    class ClosingInputStream
    extends FilterInputStream {
        ClosingInputStream(InputStream inputStream) {
            super(inputStream);
        }

        @Override
        public void close() throws IOException {
            super.close();
            FTPURLConnection.this.connection.logout();
        }
    }
}

