/*
 * Decompiled with CFR 0.152.
 */
package gnu.mail.util;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class QPOutputStream
extends FilterOutputStream {
    private static final char[] hex = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};
    private int count;
    private int bytesPerLine;
    private boolean gotSpace;
    private boolean gotCR;

    public QPOutputStream(OutputStream stream, int length) {
        super(stream);
        this.bytesPerLine = length;
        this.count = 0;
        this.gotSpace = false;
        this.gotCR = false;
    }

    public QPOutputStream(OutputStream stream) {
        this(stream, 76);
    }

    @Override
    public void flush() throws IOException {
        if (this.gotSpace) {
            this.output(32, false);
            this.gotSpace = false;
        }
        this.out.flush();
    }

    @Override
    public void write(byte[] bytes, int offset, int length) throws IOException {
        for (int index = offset; index < length; ++index) {
            this.write(bytes[index]);
        }
    }

    @Override
    public void write(byte[] bytes) throws IOException {
        this.write(bytes, 0, bytes.length);
    }

    @Override
    public void write(int b) throws IOException {
        b &= 0xFF;
        if (this.gotSpace) {
            if (b == 10 || b == 13) {
                this.output(32, true);
            } else {
                this.output(32, false);
            }
            this.gotSpace = false;
        }
        if (b == 32) {
            this.gotSpace = true;
        } else if (b == 13) {
            this.gotCR = true;
            this.outputCRLF();
        } else if (b == 10) {
            if (this.gotCR) {
                this.gotCR = false;
            } else {
                this.outputCRLF();
            }
        } else if (b < 32 || b >= 127 || b == 61) {
            this.output(b, true);
        } else {
            this.output(b, false);
        }
    }

    @Override
    public void close() throws IOException {
        this.out.close();
    }

    protected void output(int b, boolean value) throws IOException {
        if (value) {
            if ((this.count += 3) > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 3;
            }
            this.out.write(61);
            this.out.write(hex[b >> 4]);
            this.out.write(hex[b & 0xF]);
        } else {
            if (++this.count > this.bytesPerLine) {
                this.out.write(61);
                this.out.write(13);
                this.out.write(10);
                this.count = 1;
            }
            this.out.write(b);
        }
    }

    private void outputCRLF() throws IOException {
        this.out.write(13);
        this.out.write(10);
        this.count = 0;
    }
}

