/*
 * Decompiled with CFR 0.152.
 */
package sun.tools.jconsole.inspector;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.management.InstanceNotFoundException;
import javax.management.IntrospectionException;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanInfo;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.ReflectionException;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingWorker;
import javax.swing.border.LineBorder;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import sun.tools.jconsole.JConsole;
import sun.tools.jconsole.MBeansTab;
import sun.tools.jconsole.Messages;
import sun.tools.jconsole.Resources;
import sun.tools.jconsole.inspector.ThreadDialog;
import sun.tools.jconsole.inspector.Utils;
import sun.tools.jconsole.inspector.XDataViewer;
import sun.tools.jconsole.inspector.XMBean;
import sun.tools.jconsole.inspector.XMBeanAttributes;
import sun.tools.jconsole.inspector.XMBeanInfo;
import sun.tools.jconsole.inspector.XMBeanNotifications;
import sun.tools.jconsole.inspector.XMBeanOperations;
import sun.tools.jconsole.inspector.XNodeInfo;
import sun.tools.jconsole.inspector.XTree;

public class XSheet
extends JPanel
implements ActionListener,
NotificationListener {
    private JPanel mainPanel;
    private JPanel southPanel;
    private volatile DefaultMutableTreeNode currentNode;
    private volatile XMBean mbean;
    private XMBeanAttributes mbeanAttributes;
    private XMBeanOperations mbeanOperations;
    private XMBeanNotifications mbeanNotifications;
    private XMBeanInfo mbeanInfo;
    private JButton refreshButton;
    private JButton clearButton;
    private JButton subscribeButton;
    private JButton unsubscribeButton;
    private MBeansTab mbeansTab;

    public XSheet(MBeansTab mbeansTab) {
        this.mbeansTab = mbeansTab;
        this.setupScreen();
    }

    public void dispose() {
        this.clear();
        XDataViewer.dispose(this.mbeansTab);
        this.mbeanNotifications.dispose();
    }

    private void setupScreen() {
        this.setLayout(new BorderLayout());
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        this.mainPanel = new JPanel();
        this.mainPanel.setLayout(new BorderLayout());
        this.add((Component)this.mainPanel, "Center");
        this.southPanel = new JPanel();
        this.add((Component)this.southPanel, "South");
        this.refreshButton = new JButton(Messages.MBEANS_TAB_REFRESH_ATTRIBUTES_BUTTON);
        this.refreshButton.setMnemonic(Resources.getMnemonicInt(Messages.MBEANS_TAB_REFRESH_ATTRIBUTES_BUTTON));
        this.refreshButton.setToolTipText(Messages.MBEANS_TAB_REFRESH_ATTRIBUTES_BUTTON_TOOLTIP);
        this.refreshButton.addActionListener(this);
        this.clearButton = new JButton(Messages.MBEANS_TAB_CLEAR_NOTIFICATIONS_BUTTON);
        this.clearButton.setMnemonic(Resources.getMnemonicInt(Messages.MBEANS_TAB_CLEAR_NOTIFICATIONS_BUTTON));
        this.clearButton.setToolTipText(Messages.MBEANS_TAB_CLEAR_NOTIFICATIONS_BUTTON_TOOLTIP);
        this.clearButton.addActionListener(this);
        this.subscribeButton = new JButton(Messages.MBEANS_TAB_SUBSCRIBE_NOTIFICATIONS_BUTTON);
        this.subscribeButton.setMnemonic(Resources.getMnemonicInt(Messages.MBEANS_TAB_SUBSCRIBE_NOTIFICATIONS_BUTTON));
        this.subscribeButton.setToolTipText(Messages.MBEANS_TAB_SUBSCRIBE_NOTIFICATIONS_BUTTON_TOOLTIP);
        this.subscribeButton.addActionListener(this);
        this.unsubscribeButton = new JButton(Messages.MBEANS_TAB_UNSUBSCRIBE_NOTIFICATIONS_BUTTON);
        this.unsubscribeButton.setMnemonic(Resources.getMnemonicInt(Messages.MBEANS_TAB_UNSUBSCRIBE_NOTIFICATIONS_BUTTON));
        this.unsubscribeButton.setToolTipText(Messages.MBEANS_TAB_UNSUBSCRIBE_NOTIFICATIONS_BUTTON_TOOLTIP);
        this.unsubscribeButton.addActionListener(this);
        this.mbeanAttributes = new XMBeanAttributes(this.mbeansTab);
        this.mbeanOperations = new XMBeanOperations(this.mbeansTab);
        this.mbeanOperations.addOperationsListener(this);
        this.mbeanNotifications = new XMBeanNotifications();
        this.mbeanNotifications.addNotificationsListener(this);
        this.mbeanInfo = new XMBeanInfo();
    }

    private boolean isSelectedNode(DefaultMutableTreeNode n, DefaultMutableTreeNode cn) {
        return cn == n;
    }

    private void showErrorDialog(Object message, String title) {
        new ThreadDialog(this, message, title, 0).run();
    }

    public boolean isMBeanNode(DefaultMutableTreeNode node) {
        Object userObject = node.getUserObject();
        if (userObject instanceof XNodeInfo) {
            XNodeInfo uo = (XNodeInfo)userObject;
            return uo.getType().equals((Object)XNodeInfo.Type.MBEAN);
        }
        return false;
    }

    public synchronized void displayNode(DefaultMutableTreeNode node) {
        this.clear();
        this.displayEmptyNode();
        if (node == null) {
            return;
        }
        this.currentNode = node;
        Object userObject = node.getUserObject();
        if (userObject instanceof XNodeInfo) {
            XNodeInfo uo = (XNodeInfo)userObject;
            switch (uo.getType()) {
                case MBEAN: {
                    this.displayMBeanNode(node);
                    break;
                }
                case NONMBEAN: {
                    this.displayEmptyNode();
                    break;
                }
                case ATTRIBUTES: {
                    this.displayMBeanAttributesNode(node);
                    break;
                }
                case OPERATIONS: {
                    this.displayMBeanOperationsNode(node);
                    break;
                }
                case NOTIFICATIONS: {
                    this.displayMBeanNotificationsNode(node);
                    break;
                }
                case ATTRIBUTE: 
                case OPERATION: 
                case NOTIFICATION: {
                    this.displayMetadataNode(node);
                    break;
                }
                default: {
                    this.displayEmptyNode();
                    break;
                }
            }
        } else {
            this.displayEmptyNode();
        }
    }

    private void displayMBeanNode(final DefaultMutableTreeNode node) {
        XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.MBEAN)) {
            return;
        }
        this.mbean = (XMBean)uo.getData();
        SwingWorker<MBeanInfo, Void> sw = new SwingWorker<MBeanInfo, Void>(){

            @Override
            public MBeanInfo doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                return XSheet.this.mbean.getMBeanInfo();
            }

            @Override
            protected void done() {
                try {
                    MBeanInfo mbi = (MBeanInfo)this.get();
                    if (mbi != null) {
                        if (!XSheet.this.isSelectedNode(node, XSheet.this.currentNode)) {
                            return;
                        }
                        XSheet.this.mbeanInfo.addMBeanInfo(XSheet.this.mbean, mbi);
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        XSheet.this.mainPanel.add((Component)XSheet.this.mbeanInfo, "Center");
                        XSheet.this.southPanel.setVisible(false);
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                }
                catch (Exception e) {
                    Throwable t = Utils.getActualException(e);
                    if (JConsole.isDebug()) {
                        System.err.println("Couldn't get MBeanInfo for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                        t.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(t.toString(), Messages.PROBLEM_DISPLAYING_MBEAN);
                }
            }
        };
        sw.execute();
    }

    private void displayMetadataNode(final DefaultMutableTreeNode node) {
        final XNodeInfo uo = (XNodeInfo)node.getUserObject();
        final XMBeanInfo mbi = this.mbeanInfo;
        switch (uo.getType()) {
            case ATTRIBUTE: {
                SwingWorker<MBeanAttributeInfo, Void> sw = new SwingWorker<MBeanAttributeInfo, Void>(){

                    @Override
                    public MBeanAttributeInfo doInBackground() {
                        Object attrData = uo.getData();
                        XSheet.this.mbean = (XMBean)((Object[])attrData)[0];
                        MBeanAttributeInfo mbai = (MBeanAttributeInfo)((Object[])attrData)[1];
                        XSheet.this.mbeanAttributes.loadAttributes(XSheet.this.mbean, new MBeanInfo(null, null, new MBeanAttributeInfo[]{mbai}, null, null, null));
                        return mbai;
                    }

                    @Override
                    protected void done() {
                        try {
                            MBeanAttributeInfo mbai = (MBeanAttributeInfo)this.get();
                            if (!XSheet.this.isSelectedNode(node, XSheet.this.currentNode)) {
                                return;
                            }
                            XSheet.this.invalidate();
                            XSheet.this.mainPanel.removeAll();
                            JPanel attributePanel = new JPanel(new BorderLayout());
                            JPanel attributeBorderPanel = new JPanel(new BorderLayout());
                            attributeBorderPanel.setBorder(BorderFactory.createTitledBorder(Messages.ATTRIBUTE_VALUE));
                            JPanel attributeValuePanel = new JPanel(new BorderLayout());
                            attributeValuePanel.setBorder(LineBorder.createGrayLineBorder());
                            attributeValuePanel.add((Component)XSheet.this.mbeanAttributes.getTableHeader(), "First");
                            attributeValuePanel.add((Component)XSheet.this.mbeanAttributes, "Center");
                            attributeBorderPanel.add((Component)attributeValuePanel, "Center");
                            JPanel refreshButtonPanel = new JPanel();
                            refreshButtonPanel.add(XSheet.this.refreshButton);
                            attributeBorderPanel.add((Component)refreshButtonPanel, "South");
                            XSheet.this.refreshButton.setEnabled(true);
                            attributePanel.add((Component)attributeBorderPanel, "North");
                            mbi.addMBeanAttributeInfo(mbai);
                            attributePanel.add((Component)mbi, "Center");
                            XSheet.this.mainPanel.add((Component)attributePanel, "Center");
                            XSheet.this.southPanel.setVisible(false);
                            XSheet.this.southPanel.removeAll();
                            XSheet.this.validate();
                            XSheet.this.repaint();
                        }
                        catch (Exception e) {
                            Throwable t = Utils.getActualException(e);
                            if (JConsole.isDebug()) {
                                System.err.println("Problem displaying MBean attribute for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                                t.printStackTrace();
                            }
                            XSheet.this.showErrorDialog(t.toString(), Messages.PROBLEM_DISPLAYING_MBEAN);
                        }
                    }
                };
                sw.execute();
                break;
            }
            case OPERATION: {
                Object operData = uo.getData();
                this.mbean = (XMBean)((Object[])operData)[0];
                MBeanOperationInfo mboi = (MBeanOperationInfo)((Object[])operData)[1];
                this.mbeanOperations.loadOperations(this.mbean, new MBeanInfo(null, null, null, null, new MBeanOperationInfo[]{mboi}, null));
                this.invalidate();
                this.mainPanel.removeAll();
                JPanel operationPanel = new JPanel(new BorderLayout());
                JPanel operationBorderPanel = new JPanel(new BorderLayout());
                operationBorderPanel.setBorder(BorderFactory.createTitledBorder(Messages.OPERATION_INVOCATION));
                operationBorderPanel.add(new JScrollPane(this.mbeanOperations));
                operationPanel.add((Component)operationBorderPanel, "North");
                mbi.addMBeanOperationInfo(mboi);
                operationPanel.add((Component)mbi, "Center");
                this.mainPanel.add((Component)operationPanel, "Center");
                this.southPanel.setVisible(false);
                this.southPanel.removeAll();
                this.validate();
                this.repaint();
                break;
            }
            case NOTIFICATION: {
                Object notifData = uo.getData();
                this.invalidate();
                this.mainPanel.removeAll();
                mbi.addMBeanNotificationInfo((MBeanNotificationInfo)notifData);
                this.mainPanel.add((Component)mbi, "Center");
                this.southPanel.setVisible(false);
                this.southPanel.removeAll();
                this.validate();
                this.repaint();
            }
        }
    }

    private void displayMBeanAttributesNode(final DefaultMutableTreeNode node) {
        XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.ATTRIBUTES)) {
            return;
        }
        final XMBean xmb = this.mbean = (XMBean)uo.getData();
        SwingWorker<MBeanInfo, Void> sw = new SwingWorker<MBeanInfo, Void>(){

            @Override
            public MBeanInfo doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                MBeanInfo mbi = xmb.getMBeanInfo();
                return mbi;
            }

            @Override
            protected void done() {
                try {
                    MBeanInfo mbi = (MBeanInfo)this.get();
                    if (mbi != null && mbi.getAttributes() != null && mbi.getAttributes().length > 0) {
                        XSheet.this.mbeanAttributes.loadAttributes(xmb, mbi);
                        if (!XSheet.this.isSelectedNode(node, XSheet.this.currentNode)) {
                            return;
                        }
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel borderPanel = new JPanel(new BorderLayout());
                        borderPanel.setBorder(BorderFactory.createTitledBorder(Messages.ATTRIBUTE_VALUES));
                        borderPanel.add(new JScrollPane(XSheet.this.mbeanAttributes));
                        XSheet.this.mainPanel.add((Component)borderPanel, "Center");
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.southPanel.add((Component)XSheet.this.refreshButton, "South");
                        XSheet.this.southPanel.setVisible(true);
                        XSheet.this.refreshButton.setEnabled(true);
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                }
                catch (Exception e) {
                    Throwable t = Utils.getActualException(e);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem displaying MBean attributes for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                        t.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(t.toString(), Messages.PROBLEM_DISPLAYING_MBEAN);
                }
            }
        };
        sw.execute();
    }

    private void displayMBeanOperationsNode(final DefaultMutableTreeNode node) {
        XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.OPERATIONS)) {
            return;
        }
        this.mbean = (XMBean)uo.getData();
        SwingWorker<MBeanInfo, Void> sw = new SwingWorker<MBeanInfo, Void>(){

            @Override
            public MBeanInfo doInBackground() throws InstanceNotFoundException, IntrospectionException, ReflectionException, IOException {
                return XSheet.this.mbean.getMBeanInfo();
            }

            @Override
            protected void done() {
                try {
                    MBeanInfo mbi = (MBeanInfo)this.get();
                    if (mbi != null) {
                        if (!XSheet.this.isSelectedNode(node, XSheet.this.currentNode)) {
                            return;
                        }
                        XSheet.this.mbeanOperations.loadOperations(XSheet.this.mbean, mbi);
                        XSheet.this.invalidate();
                        XSheet.this.mainPanel.removeAll();
                        JPanel borderPanel = new JPanel(new BorderLayout());
                        borderPanel.setBorder(BorderFactory.createTitledBorder(Messages.OPERATION_INVOCATION));
                        borderPanel.add(new JScrollPane(XSheet.this.mbeanOperations));
                        XSheet.this.mainPanel.add((Component)borderPanel, "Center");
                        XSheet.this.southPanel.setVisible(false);
                        XSheet.this.southPanel.removeAll();
                        XSheet.this.validate();
                        XSheet.this.repaint();
                    }
                }
                catch (Exception e) {
                    Throwable t = Utils.getActualException(e);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem displaying MBean operations for MBean [" + XSheet.this.mbean.getObjectName() + "]");
                        t.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(t.toString(), Messages.PROBLEM_DISPLAYING_MBEAN);
                }
            }
        };
        sw.execute();
    }

    private void displayMBeanNotificationsNode(DefaultMutableTreeNode node) {
        XNodeInfo uo = (XNodeInfo)node.getUserObject();
        if (!uo.getType().equals((Object)XNodeInfo.Type.NOTIFICATIONS)) {
            return;
        }
        this.mbean = (XMBean)uo.getData();
        this.mbeanNotifications.loadNotifications(this.mbean);
        this.updateNotifications();
        this.invalidate();
        this.mainPanel.removeAll();
        JPanel borderPanel = new JPanel(new BorderLayout());
        borderPanel.setBorder(BorderFactory.createTitledBorder(Messages.NOTIFICATION_BUFFER));
        borderPanel.add(new JScrollPane(this.mbeanNotifications));
        this.mainPanel.add((Component)borderPanel, "Center");
        this.southPanel.removeAll();
        this.southPanel.add((Component)this.subscribeButton, "West");
        this.southPanel.add((Component)this.unsubscribeButton, "Center");
        this.southPanel.add((Component)this.clearButton, "East");
        this.southPanel.setVisible(true);
        this.subscribeButton.setEnabled(true);
        this.unsubscribeButton.setEnabled(true);
        this.clearButton.setEnabled(true);
        this.validate();
        this.repaint();
    }

    private void displayEmptyNode() {
        this.invalidate();
        this.mainPanel.removeAll();
        this.southPanel.removeAll();
        this.validate();
        this.repaint();
    }

    private void registerListener() {
        new SwingWorker<Void, Void>(){

            @Override
            public Void doInBackground() throws InstanceNotFoundException, IOException {
                XSheet.this.mbeanNotifications.registerListener(XSheet.this.currentNode);
                return null;
            }

            @Override
            protected void done() {
                try {
                    this.get();
                    XSheet.this.updateNotifications();
                    XSheet.this.validate();
                }
                catch (Exception e) {
                    Throwable t = Utils.getActualException(e);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem adding listener");
                        t.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(t.getMessage(), Messages.PROBLEM_ADDING_LISTENER);
                }
            }
        }.execute();
    }

    private void unregisterListener() {
        new SwingWorker<Boolean, Void>(){

            @Override
            public Boolean doInBackground() {
                return XSheet.this.mbeanNotifications.unregisterListener(XSheet.this.currentNode);
            }

            @Override
            protected void done() {
                try {
                    if (((Boolean)this.get()).booleanValue()) {
                        XSheet.this.updateNotifications();
                        XSheet.this.validate();
                    }
                }
                catch (Exception e) {
                    Throwable t = Utils.getActualException(e);
                    if (JConsole.isDebug()) {
                        System.err.println("Problem removing listener");
                        t.printStackTrace();
                    }
                    XSheet.this.showErrorDialog(t.getMessage(), Messages.PROBLEM_REMOVING_LISTENER);
                }
            }
        }.execute();
    }

    private void refreshAttributes() {
        this.mbeanAttributes.refreshAttributes();
    }

    private void updateNotifications() {
        if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
            long received = this.mbeanNotifications.getReceivedNotifications(this.mbean);
            this.updateReceivedNotifications(this.currentNode, received, false);
        } else {
            this.clearNotifications();
        }
    }

    private void updateReceivedNotifications(DefaultMutableTreeNode emitter, long received, boolean bold) {
        String text = Messages.NOTIFICATIONS + "[" + received + "]";
        DefaultMutableTreeNode selectedNode = (DefaultMutableTreeNode)this.mbeansTab.getTree().getLastSelectedPathComponent();
        if (bold && emitter != selectedNode) {
            text = "<html><b>" + text + "</b></html>";
        }
        this.updateNotificationsNodeLabel(emitter, text);
    }

    private void clearNotifications() {
        this.updateNotificationsNodeLabel(this.currentNode, Messages.NOTIFICATIONS);
    }

    private void clearNotifications0() {
        this.updateNotificationsNodeLabel(this.currentNode, Messages.NOTIFICATIONS + "[0]");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNotificationsNodeLabel(DefaultMutableTreeNode node, String label) {
        XTree xTree = this.mbeansTab.getTree();
        synchronized (xTree) {
            this.invalidate();
            XNodeInfo oldUserObject = (XNodeInfo)node.getUserObject();
            XNodeInfo newUserObject = new XNodeInfo(oldUserObject.getType(), oldUserObject.getData(), label, oldUserObject.getToolTipText());
            node.setUserObject(newUserObject);
            DefaultTreeModel model = (DefaultTreeModel)this.mbeansTab.getTree().getModel();
            model.nodeChanged(node);
            this.validate();
            this.repaint();
        }
    }

    private void clearCurrentNotifications() {
        this.mbeanNotifications.clearCurrentNotifications();
        if (this.mbeanNotifications.isListenerRegistered(this.mbean)) {
            this.clearNotifications0();
        } else {
            this.clearNotifications();
        }
    }

    private void clear() {
        this.mbeanAttributes.stopCellEditing();
        this.mbeanAttributes.emptyTable();
        this.mbeanAttributes.removeAttributes();
        this.mbeanOperations.removeOperations();
        this.mbeanNotifications.stopCellEditing();
        this.mbeanNotifications.emptyTable();
        this.mbeanNotifications.disableNotifications();
        this.mbean = null;
        this.currentNode = null;
    }

    @Override
    public void handleNotification(Notification e, Object handback) {
        if (e.getType().equals("jam.xoperations.invoke.result")) {
            Component message;
            if (handback == null) {
                JTextArea textArea = new JTextArea("null");
                textArea.setEditable(false);
                textArea.setEnabled(true);
                textArea.setRows(textArea.getLineCount());
                message = textArea;
            } else {
                Component comp = this.mbeansTab.getDataViewer().createOperationViewer(handback, this.mbean);
                if (comp == null) {
                    JTextArea textArea = new JTextArea(handback.toString());
                    textArea.setEditable(false);
                    textArea.setEnabled(true);
                    textArea.setRows(textArea.getLineCount());
                    JScrollPane scrollPane = new JScrollPane(textArea);
                    Dimension d = scrollPane.getPreferredSize();
                    if (d.getWidth() > 400.0 || d.getHeight() > 250.0) {
                        scrollPane.setPreferredSize(new Dimension(400, 250));
                    }
                    message = scrollPane;
                } else {
                    Dimension d;
                    if (!(comp instanceof JScrollPane)) {
                        comp = new JScrollPane(comp);
                    }
                    if ((d = comp.getPreferredSize()).getWidth() > 400.0 || d.getHeight() > 250.0) {
                        comp.setPreferredSize(new Dimension(400, 250));
                    }
                    message = comp;
                }
            }
            new ThreadDialog((Component)e.getSource(), message, Messages.OPERATION_RETURN_VALUE, 1).run();
        } else if (e.getType().equals("jconsole.xnotification.received")) {
            DefaultMutableTreeNode emitter = (DefaultMutableTreeNode)handback;
            Long received = (Long)e.getUserData();
            this.updateReceivedNotifications(emitter, received, true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() instanceof JButton) {
            JButton button = (JButton)e.getSource();
            if (button == this.refreshButton) {
                this.refreshAttributes();
                return;
            }
            if (button == this.clearButton) {
                this.clearCurrentNotifications();
                return;
            }
            if (button == this.subscribeButton) {
                this.registerListener();
                return;
            }
            if (button == this.unsubscribeButton) {
                this.unregisterListener();
                return;
            }
        }
    }
}

