/*
 * Decompiled with CFR 0.152.
 */
package sun.nio.cs.ext;

import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import sun.nio.cs.HistoricallyNamedCharset;
import sun.nio.cs.ext.EUC_TW;
import sun.nio.cs.ext.ExtendedCharsets;
import sun.nio.cs.ext.ISO2022;
import sun.nio.cs.ext.ISO2022_CN;

public class ISO2022_CN_CNS
extends ISO2022
implements HistoricallyNamedCharset {
    public ISO2022_CN_CNS() {
        super("x-ISO-2022-CN-CNS", ExtendedCharsets.aliasesFor("x-ISO-2022-CN-CNS"));
    }

    @Override
    public boolean contains(Charset cs) {
        return cs instanceof EUC_TW || cs.name().equals("US-ASCII") || cs instanceof ISO2022_CN_CNS;
    }

    @Override
    public String historicalName() {
        return "ISO2022CN_CNS";
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new ISO2022_CN.Decoder(this);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new Encoder(this);
    }

    private static class Encoder
    extends ISO2022.Encoder {
        private byte[] bb = new byte[4];

        public Encoder(Charset cs) {
            super(cs);
            this.SODesig = "$)G";
            this.SS2Desig = "$*H";
            this.SS3Desig = "$+I";
            try {
                Charset cset = Charset.forName("EUC_TW");
                this.ISOEncoder = cset.newEncoder();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public boolean canEncode(char c) {
            int n = 0;
            return c <= '\u007f' || (n = ((EUC_TW.Encoder)this.ISOEncoder).toEUC(c, this.bb)) == 2 || n == 4 && this.bb[0] == -114 && (this.bb[1] == -94 || this.bb[1] == -93);
        }

        @Override
        public boolean isLegalReplacement(byte[] repl) {
            return repl.length == 1 && repl[0] == 63;
        }
    }
}

