/*
 * Copyright (c) 2012, 2019, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (C) 1991-2016 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in 
 * http://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that
 * (a) this copyright and permission notice appear with all copies 
 * of the Data Files or Software,
 * (b) this copyright and permission notice appear in associated 
 * documentation, and
 * (c) there is clear notice in each modified Data File or in the Software
 * as well as in the documentation associated with the Data File(s) or
 * Software that the data or software has been modified.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class CurrencyNames_mn extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final Object[][] data = new Object[][] {
            { "AED", "AED" },
            { "AFN", "AFN" },
            { "ALL", "ALL" },
            { "AMD", "AMD" },
            { "ANG", "ANG" },
            { "AOA", "AOA" },
            { "ARS", "ARS" },
            { "AWG", "AWG" },
            { "AZN", "AZN" },
            { "BAM", "BAM" },
            { "BBD", "BBD" },
            { "BDT", "BDT" },
            { "BGN", "BGN" },
            { "BHD", "BHD" },
            { "BIF", "BIF" },
            { "BMD", "BMD" },
            { "BND", "BND" },
            { "BOB", "BOB" },
            { "BSD", "BSD" },
            { "BTN", "BTN" },
            { "BWP", "BWP" },
            { "BYN", "BYN" },
            { "BYR", "BYR" },
            { "BZD", "BZD" },
            { "CDF", "CDF" },
            { "CHF", "CHF" },
            { "CLP", "CLP" },
            { "CNH", "CNH" },
            { "COP", "COP" },
            { "CRC", "CRC" },
            { "CUC", "CUC" },
            { "CUP", "CUP" },
            { "CVE", "CVE" },
            { "CZK", "CZK" },
            { "DJF", "DJF" },
            { "DKK", "DKK" },
            { "DOP", "DOP" },
            { "DZD", "DZD" },
            { "EGP", "EGP" },
            { "ERN", "ERN" },
            { "ETB", "ETB" },
            { "FJD", "FJD" },
            { "FKP", "FKP" },
            { "GEL", "GEL" },
            { "GHS", "GHS" },
            { "GIP", "GIP" },
            { "GMD", "GMD" },
            { "GNF", "GNF" },
            { "GTQ", "GTQ" },
            { "GYD", "GYD" },
            { "HNL", "HNL" },
            { "HRK", "HRK" },
            { "HTG", "HTG" },
            { "HUF", "HUF" },
            { "IDR", "IDR" },
            { "IQD", "IQD" },
            { "IRR", "IRR" },
            { "ISK", "ISK" },
            { "JMD", "JMD" },
            { "JOD", "JOD" },
            { "KES", "KES" },
            { "KGS", "KGS" },
            { "KHR", "KHR" },
            { "KMF", "KMF" },
            { "KPW", "KPW" },
            { "KWD", "KWD" },
            { "KYD", "KYD" },
            { "KZT", "KZT" },
            { "LAK", "LAK" },
            { "LBP", "LBP" },
            { "LKR", "LKR" },
            { "LRD", "LRD" },
            { "LTL", "LTL" },
            { "LVL", "LVL" },
            { "LYD", "LYD" },
            { "MAD", "MAD" },
            { "MDL", "MDL" },
            { "MGA", "MGA" },
            { "MKD", "MKD" },
            { "MMK", "MMK" },
            { "MNT", "\u20ae" },
            { "MOP", "MOP" },
            { "MRO", "MRO" },
            { "MUR", "MUR" },
            { "MVR", "MVR" },
            { "MWK", "MWK" },
            { "MYR", "MYR" },
            { "MZN", "MZN" },
            { "NAD", "NAD" },
            { "NGN", "NGN" },
            { "NIO", "NIO" },
            { "NOK", "NOK" },
            { "NPR", "NPR" },
            { "OMR", "OMR" },
            { "PAB", "PAB" },
            { "PEN", "PEN" },
            { "PGK", "PGK" },
            { "PHP", "PHP" },
            { "PKR", "PKR" },
            { "PLN", "PLN" },
            { "PYG", "PYG" },
            { "QAR", "QAR" },
            { "RON", "RON" },
            { "RSD", "RSD" },
            { "RUB", "RUB" },
            { "RWF", "RWF" },
            { "SAR", "SAR" },
            { "SBD", "SBD" },
            { "SCR", "SCR" },
            { "SDG", "SDG" },
            { "SEK", "SEK" },
            { "SGD", "SGD" },
            { "SHP", "SHP" },
            { "SLL", "SLL" },
            { "SOS", "SOS" },
            { "SRD", "SRD" },
            { "SSP", "SSP" },
            { "STD", "STD" },
            { "SYP", "SYP" },
            { "SZL", "SZL" },
            { "THB", "\u0e3f" },
            { "TJS", "TJS" },
            { "TMT", "TMT" },
            { "TND", "TND" },
            { "TOP", "TOP" },
            { "TRY", "TRY" },
            { "TTD", "TTD" },
            { "TZS", "TZS" },
            { "UAH", "UAH" },
            { "UGX", "UGX" },
            { "USD", "$" },
            { "UYU", "UYU" },
            { "UZS", "UZS" },
            { "VEF", "VEF" },
            { "VUV", "VUV" },
            { "WST", "WST" },
            { "YER", "YER" },
            { "ZAR", "ZAR" },
            { "ZMW", "ZMW" },
            { "aed", "\u0430\u0440\u0430\u0431\u044b\u043d \u043d\u044d\u0433\u0434\u0441\u044d\u043d \u044d\u043c\u0438\u0440\u0430\u0442\u044b\u043d \u0434\u0438\u0440\u0445\u0430\u043c" },
            { "afn", "\u0430\u0444\u0433\u0430\u043d\u0438\u0441\u0442\u0430\u043d \u0430\u0444\u0433\u0430\u043d\u0438" },
            { "all", "\u0430\u043b\u0431\u0430\u043d\u0438\u0439\u043d \u043b\u0435\u043a" },
            { "amd", "\u0430\u0440\u043c\u0435\u043d\u0438\u0439\u043d \u0434\u0440\u0430\u043c" },
            { "ang", "\u043d\u0438\u0434\u0435\u0440\u043b\u0430\u043d\u0434\u044b\u043d \u0430\u043d\u0442\u0438\u043b\u043b\u044a\u044f \u0433\u0443\u043b\u0434\u0435\u0440" },
            { "aoa", "\u0430\u043d\u0433\u043e\u043b \u043a\u0432\u0430\u043d\u0437\u0430" },
            { "ars", "\u0430\u0440\u0433\u0435\u043d\u0442\u0438\u043d \u043f\u0435\u0441\u043e" },
            { "aud", "\u0430\u0432\u0441\u0442\u0440\u0430\u043b\u0438 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "awg", "\u0430\u0440\u0443\u0431\u044b\u043d \u0444\u043b\u043e\u0440\u0438\u043d" },
            { "azn", "\u0430\u0437\u0435\u0440\u0431\u0430\u0439\u0436\u0430\u043d\u044b \u043c\u0430\u043d\u0430\u0442" },
            { "bam", "\u0431\u043e\u0441\u043d\u0438-\u0433\u0435\u0440\u0446\u0435\u0433\u043e\u0432\u0438\u043d \u0445\u04e9\u0440\u0432\u04e9\u0433\u0447 \u043c\u0430\u0440\u043a" },
            { "bbd", "\u0431\u0430\u0440\u0431\u0430\u0434\u043e\u0441 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "bdt", "\u0431\u0430\u043d\u0433\u043b\u0430\u0434\u0435\u0448 \u0442\u0430\u043a\u0430" },
            { "bgn", "\u0431\u043e\u043b\u0433\u0430\u0440\u044b\u043d \u043b\u0435\u0432" },
            { "bhd", "\u0431\u0430\u0445\u0440\u0435\u0439\u043d \u0434\u0438\u043d\u0430\u0440" },
            { "bif", "\u0431\u0443\u0440\u0443\u043d\u0434 \u0444\u0440\u0430\u043d\u043a" },
            { "bmd", "\u0431\u0435\u0440\u043c\u0443\u0434 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "bnd", "\u0431\u0440\u0443\u043d\u0435\u0439 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "bob", "\u0431\u043e\u043b\u0438\u0432\u0438 \u0431\u043e\u043b\u0438\u0432\u0438\u0430\u043d\u043e" },
            { "brl", "\u0431\u0440\u0430\u0437\u0438\u043b\u0438\u0439\u043d \u0440\u0438\u043b" },
            { "bsd", "\u0431\u0430\u0433\u0430\u043c \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "btn", "\u0431\u0443\u0442\u0430\u043d\u044b \u043d\u0433\u0443\u043b\u0442\u0440\u0443\u043c" },
            { "bwp", "\u0431\u043e\u0442\u0441\u0432\u0430\u043d\u0438 \u043f\u0443\u043b\u0430" },
            { "byn", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c \u0440\u0443\u0431\u043b\u044c" },
            { "byr", "\u0431\u0435\u043b\u0430\u0440\u0443\u0441\u044c \u0440\u0443\u0431\u043b\u044c (2000\u20132016)" },
            { "bzd", "\u0431\u0435\u043b\u0438\u0437 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "cad", "\u043a\u0430\u043d\u0430\u0434 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "cdf", "\u043a\u043e\u043d\u0433\u043e \u0444\u0440\u0430\u043d\u043a" },
            { "chf", "\u0448\u0432\u0435\u0439\u0446\u0430\u0440\u044c \u0444\u0440\u0430\u043d\u043a" },
            { "clp", "\u0447\u0438\u043b\u0438\u0439\u043d \u043f\u0435\u0441\u043e" },
            { "cnh", "\u0425\u044f\u0442\u0430\u0434\u044b\u043d \u044e\u0430\u043d\u044c" },
            { "cny", "\u0445\u044f\u0442\u0430\u0434 \u044e\u0430\u043d\u044c" },
            { "cop", "\u043a\u043e\u043b\u0443\u043c\u0431\u044b\u043d \u043f\u0435\u0441\u043e" },
            { "crc", "\u043a\u043e\u0441\u0442\u0430 \u0440\u0438\u043a\u0430\u0433\u0438\u0439\u043d \u043a\u043e\u043b\u043e\u043d" },
            { "cuc", "\u043a\u0443\u0431\u044b\u043d \u0445\u04e9\u0440\u0432\u04e9\u0433\u0447 \u043f\u0435\u0441\u043e" },
            { "cup", "\u043a\u0443\u0431\u044b\u043d \u043f\u0435\u0441\u043e" },
            { "cve", "\u043a\u0430\u0431\u043e-\u0432\u0435\u0440\u0434\u0435 \u044d\u0441\u043a\u0443\u0434\u043e" },
            { "czk", "\u0427\u0435\u0445 \u043a\u0440\u043e\u043d" },
            { "djf", "\u0436\u0438\u0431\u043e\u0443\u0442\u0438 \u0444\u0440\u0430\u043d\u043a" },
            { "dkk", "\u0434\u0430\u043d\u0438\u0439\u043d \u043a\u0440\u043e\u043d" },
            { "dop", "\u0434\u043e\u043c\u0438\u043d\u0438\u043a\u0430\u043d\u044b \u043f\u0435\u0441\u043e" },
            { "dzd", "\u0430\u043b\u0436\u0438\u0440 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "egp", "\u0435\u0433\u0438\u043f\u0435\u0442 \u043f\u0430\u0443\u043d\u0434" },
            { "ern", "\u044d\u0440\u0438\u0442\u0440\u0435\u0439 \u043d\u0430\u043a\u0444\u0430" },
            { "etb", "\u044d\u0442\u0438\u043e\u043f \u0431\u0438\u0440\u0440" },
            { "eur", "\u0435\u0432\u0440\u043e" },
            { "fjd", "\u0444\u0438\u0436\u0438 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "fkp", "\u0444\u043e\u043b\u043a\u043b\u044d\u043d\u0434 \u0430\u0440\u043b\u044b\u043d \u043f\u0430\u0443\u043d\u0434" },
            { "gbp", "\u0431\u0440\u0438\u0442\u0430\u043d\u0438\u0439\u043d \u0444\u0443\u043d\u0442" },
            { "gel", "\u0433\u04af\u0440\u0436\u0438\u0439\u043d \u043b\u0430\u0440\u0438" },
            { "ghs", "\u0433\u0430\u043d\u0430 \u0441\u0435\u0434\u0438" },
            { "gip", "\u0433\u0438\u0431\u0440\u0430\u043b\u0442\u0430\u0440 \u043f\u0430\u0443\u043d\u0434" },
            { "gmd", "\u0433\u0430\u043c\u0431\u0438 \u0434\u0430\u043b\u0430\u0441\u0438" },
            { "gnf", "\u0433\u0432\u0438\u043d\u0435\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "gtq", "\u0433\u0432\u0430\u0442\u0435\u043c\u0430\u043b\u044b\u043d \u043a\u0435\u0446\u0430\u043b" },
            { "gyd", "\u0433\u0430\u0439\u0430\u043d\u0430 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "hkd", "\u0445\u043e\u043d\u0433\u043a\u043e\u043d\u0433 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "hnl", "\u0433\u043e\u043d\u0434\u0443\u0440\u0430\u0441\u044b\u043d \u043b\u0435\u043c\u043f\u0438\u0440\u0430" },
            { "hrk", "\u0445\u043e\u0440\u0432\u0430\u0442\u044b\u043d \u043a\u0443\u043d\u0430" },
            { "htg", "\u0433\u0430\u0438\u0442\u0438\u0439\u043d \u0433\u043e\u0443\u0440\u0434" },
            { "huf", "\u0443\u043d\u0433\u0430\u0440\u044b\u043d \u0444\u043e\u0440\u0438\u043d\u0442" },
            { "idr", "\u0438\u043d\u0434\u043e\u043d\u0435\u0437\u0438 \u0440\u0443\u043f\u0438" },
            { "ils", "\u0438\u0437\u0440\u0430\u0438\u043b\u0438\u0439\u043d \u0448\u0438\u043d\u044d \u0448\u0435\u043a\u0435\u043b" },
            { "inr", "\u044d\u043d\u044d\u0442\u0445\u044d\u0433 \u0440\u0443\u043f\u0438" },
            { "iqd", "\u0438\u0440\u0430\u043a \u0434\u0438\u043d\u0430\u0440" },
            { "irr", "\u0438\u0440\u0430\u043d \u0440\u0438\u0430\u043b" },
            { "isk", "\u0438\u0441\u043b\u0430\u043d\u0434\u044b\u043d \u043a\u0440\u043e\u043d" },
            { "jmd", "\u044f\u043c\u0430\u0439\u043a \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "jod", "\u0439\u043e\u0440\u0434\u0430\u043d \u0434\u0438\u043d\u0430\u0440" },
            { "jpy", "\u044f\u043f\u043e\u043d \u0438\u0435\u043d" },
            { "kes", "\u043a\u0435\u043d\u0438 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "kgs", "\u043a\u044b\u0440\u0433\u044b\u0437 \u0441\u043e\u043c" },
            { "khr", "\u043a\u0430\u043c\u0431\u043e\u0436 \u0440\u0438\u0435\u043b" },
            { "kmf", "\u043a\u043e\u043c\u043e\u0440 \u0444\u0440\u0430\u043d\u043a" },
            { "kpw", "\u0445\u043e\u0439\u0434 \u0441\u043e\u043b\u043e\u043d\u0433\u043e\u0441 \u0432\u043e\u043d" },
            { "krw", "\u04e9\u043c\u043d\u04e9\u0434 \u0441\u043e\u043b\u043e\u043d\u0433\u043e\u0441 \u0432\u043e\u043d" },
            { "kwd", "\u043a\u0443\u0432\u0435\u0439\u0442 \u0434\u0438\u043d\u0430\u0440" },
            { "kyd", "\u043a\u0430\u0439\u043c\u0430\u043d \u0430\u0440\u043b\u044b\u043d \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "kzt", "\u043a\u0430\u0437\u0430\u0445\u044b\u043d \u0442\u044d\u043d\u0433\u044d" },
            { "lak", "\u043b\u0430\u043e\u0441\u044b\u043d \u043a\u0438\u043f" },
            { "lbp", "\u043b\u0438\u0432\u0430\u043d \u043f\u0430\u0443\u043d\u0434" },
            { "lkr", "\u0448\u0440\u0438-\u043b\u0430\u043d\u043a \u0440\u0443\u043f\u0438" },
            { "lrd", "\u043b\u0438\u0431\u0435\u0440\u0438 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "ltl", "\u043b\u0438\u0442\u0432\u0438\u0439\u043d \u043b\u0438\u0442\u0430\u0441" },
            { "lvl", "\u043b\u0430\u0442\u0432\u0438\u0439\u043d \u043b\u0430\u0446" },
            { "lyd", "\u043b\u0438\u0432\u0438 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "mad", "\u043c\u0430\u0440\u043e\u043a\u043a\u043e\u0433\u0438\u0439\u043d \u0434\u0438\u0440\u0445\u0430\u043c" },
            { "mdl", "\u043c\u043e\u043b\u0434\u0430\u0432\u044b\u043d \u043b\u0435\u0443" },
            { "mga", "\u043c\u0430\u043b\u0430\u0439\u043d \u0430\u0440\u0438\u0430\u0440\u0438" },
            { "mkd", "\u043c\u0430\u043a\u0435\u0434\u043e\u043d\u0438 \u0434\u0438\u043d\u0430\u0440" },
            { "mmk", "\u043c\u044c\u044f\u043d\u043c\u0430\u0440\u044b\u043d \u043a\u0438\u0430\u0442" },
            { "mnt", "\u0442\u04e9\u0433\u0440\u04e9\u0433" },
            { "mop", "\u043c\u0430\u043a\u0430\u043e\u0433\u0438\u0439\u043d \u043f\u0430\u0442\u0430\u043a\u0430" },
            { "mro", "\u043c\u0430\u0432\u0440\u0438\u0442\u0430\u043d \u0443\u0433\u0438\u044f (1973\u20132017)" },
            { "mru", "\u043c\u0430\u0432\u0440\u0438\u0442\u0430\u043d \u0443\u0433\u0438\u044f" },
            { "mur", "\u043c\u0430\u0432\u0440\u0438\u0442\u044b\u043d \u0440\u0443\u043f\u0438" },
            { "mvr", "\u043c\u0430\u043b\u044c\u0434\u0438\u0432 \u0440\u0443\u0444\u0438\u044f" },
            { "mwk", "\u043c\u0430\u043b\u0430\u0432\u0438 \u043a\u0432\u0430\u0447\u0430" },
            { "mxn", "\u043c\u0435\u043a\u0441\u0438\u043a\u0438\u0439\u043d \u043f\u0435\u0441\u043e" },
            { "myr", "\u043c\u0430\u043b\u0430\u0439\u0437\u044b\u043d \u0440\u0438\u043d\u0433\u0438\u0442" },
            { "mzn", "\u043c\u043e\u0437\u0430\u043c\u0431\u0438\u043a \u043c\u0435\u0442\u0438\u043a\u0430\u043b" },
            { "nad", "\u043d\u0430\u043c\u0438\u0431\u0438 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "ngn", "\u043d\u0438\u0433\u0435\u0440\u0438 \u043d\u0430\u0439\u0440\u0430" },
            { "nio", "\u043d\u0438\u043a\u0430\u0440\u0430\u0433\u0443\u0430\u0433\u0438\u0439\u043d \u043a\u043e\u0440\u0434\u043e\u0431\u0430" },
            { "nok", "\u043d\u043e\u0440\u0432\u0435\u0433\u0438\u0439\u043d \u043a\u0440\u043e\u043d" },
            { "npr", "\u0431\u0430\u043b\u0431\u0430 \u0440\u0443\u043f\u0438" },
            { "nzd", "\u0448\u0438\u043d\u044d \u0437\u0435\u043b\u0430\u043d\u0434 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "omr", "\u043e\u043c\u0430\u043d\u0438 \u0440\u0438\u0430\u043b" },
            { "pab", "\u043f\u0430\u043d\u0430\u043c\u044b\u043d \u0431\u0430\u043b\u044c\u0431\u043e\u0430" },
            { "pen", "\u043f\u0435\u0440\u0443\u0433\u0438\u0439\u043d \u0441\u043e\u043b\u044c" },
            { "pgk", "\u043f\u0430\u043f\u0443\u0430-\u0448\u0438\u043d\u044d \u0433\u0432\u0438\u043d\u0435\u0439\u043d \u043a\u0438\u043d\u0430" },
            { "php", "\u0444\u0438\u043b\u0438\u043f\u043f\u0438\u043d \u043f\u0435\u0441\u043e" },
            { "pkr", "\u043f\u0430\u043a\u0438\u0441\u0442\u0430\u043d \u0440\u0443\u043f\u0438" },
            { "pln", "\u043f\u043e\u043b\u044c\u0448\u0438\u0439\u043d \u0437\u043b\u043e\u0442" },
            { "pyg", "\u043f\u0430\u0440\u0430\u0433\u0432\u0430\u0439\u043d \u0433\u0443\u0430\u0440\u0430\u043d\u0438" },
            { "qar", "\u043a\u0430\u0442\u0430\u0440 \u0440\u0438\u0430\u043b" },
            { "ron", "\u0440\u0443\u043c\u044b\u043d\u044b \u043b\u0435\u0443" },
            { "rsd", "\u0441\u0435\u0440\u0431 \u0434\u0438\u043d\u0430\u0440" },
            { "rub", "\u043e\u0440\u043e\u0441 \u0440\u0443\u0431\u043b\u044c" },
            { "rwf", "\u0440\u0443\u0430\u043d\u0434 \u0444\u0440\u0430\u043d\u043a" },
            { "sar", "\u0441\u0430\u0443\u0434\u0438 \u0440\u0438\u0430\u043b" },
            { "sbd", "\u0441\u043e\u043b\u043e\u043c\u043e\u043d \u0430\u0440\u043b\u044b\u043d \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "scr", "\u0441\u0435\u0439\u0448\u0435\u043b \u0440\u0443\u043f\u0438" },
            { "sdg", "\u0441\u0443\u0434\u0430\u043d \u043f\u0430\u0443\u043d\u0434" },
            { "sek", "\u0448\u0432\u0435\u0434\u0438\u0439\u043d \u043a\u0440\u043e\u043d" },
            { "sgd", "\u0441\u0438\u043d\u0433\u0430\u043f\u0443\u0440 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "shp", "\u0441\u0435\u043d\u0442 \u0445\u0435\u043b\u0435\u043d\u0430 \u0444\u0443\u043d\u0442" },
            { "sll", "\u0441\u044c\u0435\u0440\u0440\u0430 \u043b\u0435\u043e\u043d\u044b \u043b\u0435\u043e\u043d" },
            { "sos", "\u0441\u043e\u043c\u0430\u043b\u0438 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "srd", "\u0441\u0443\u0440\u0438\u043d\u0430\u043c \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "ssp", "\u04e9\u043c\u043d\u04e9\u0434 \u0441\u0443\u0434\u0430\u043d \u043f\u0430\u0443\u043d\u0434" },
            { "std", "\u0441\u0430\u043d-\u0442\u043e\u043c\u0435 \u0431\u0430 \u043f\u0440\u0438\u043d\u0441\u0438\u043f\u0438 \u0434\u043e\u0431\u0440\u0430 (1977\u20132017)" },
            { "stn", "\u0441\u0430\u043d-\u0442\u043e\u043c\u0435 \u0431\u0430 \u043f\u0440\u0438\u043d\u0441\u0438\u043f\u0438 \u0434\u043e\u0431\u0440\u0430" },
            { "syp", "\u0441\u0438\u0440\u0438 \u043f\u0430\u0443\u043d\u0434" },
            { "szl", "\u0441\u0432\u0430\u0437\u0438\u043b\u0430\u043d\u0434 \u043b\u0438\u043b\u0430\u043d\u0433\u0435\u043d\u0438" },
            { "thb", "\u0442\u0430\u0439\u043b\u0430\u043d\u0434\u044b\u043d \u0431\u0430\u0442" },
            { "tjs", "\u0442\u0430\u0436\u0438\u043a\u0438\u0439\u043d \u0441\u043e\u043c\u043e\u043d" },
            { "tmt", "\u0442\u0443\u0440\u043a\u043c\u0435\u043d \u043c\u0430\u043d\u0430\u0442" },
            { "tnd", "\u0442\u0443\u043d\u0438\u0441 \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "top", "\u0442\u043e\u043d\u0433\u0430\u0433\u0438\u0439\u043d \u043f\u0430\u043d\u0433\u0430" },
            { "try", "\u0442\u0443\u0440\u043a\u0438\u0439\u043d \u043b\u0438\u0440\u0430" },
            { "ttd", "\u0442\u0440\u0438\u043d\u0438\u0434\u0430\u0434 \u0431\u0430 \u0442\u043e\u0431\u0430\u0433\u043e \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "twd", "\u0448\u0438\u043d\u044d \u0442\u0430\u0439\u0432\u0430\u043d\u044c \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "tzs", "\u0442\u0430\u043d\u0437\u0430\u043d\u0438 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "uah", "\u0443\u043a\u0440\u0430\u0438\u043d\u044b \u0433\u0440\u0438\u0432\u043d\u044f" },
            { "ugx", "\u0443\u0433\u0430\u043d\u0434 \u0448\u0438\u043b\u043b\u0438\u043d\u0433" },
            { "usd", "\u0430\u043c\u0435\u0440\u0438\u043a \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "uyu", "\u0443\u0440\u0443\u0433\u0432\u0430\u0439\u043d \u043f\u0435\u0441\u043e" },
            { "uzs", "\u0443\u0437\u0431\u0435\u043a\u0438\u0439\u043d \u0441\u043e\u043c" },
            { "vef", "\u0432\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0438\u0439\u043d \u0431\u043e\u043b\u0438\u0432\u0430\u0440 (2008\u20132018)" },
            { "ves", "\u0432\u0435\u043d\u0435\u0441\u0443\u044d\u043b\u0438\u0439\u043d \u0431\u043e\u043b\u0438\u0432\u0430\u0440" },
            { "vnd", "\u0432\u044c\u0435\u0442\u043d\u0430\u043c\u044b\u043d \u0434\u043e\u043d\u0433" },
            { "vuv", "\u0432\u0430\u043d\u0443\u0430\u0442\u0443\u0433\u0438\u0439\u043d \u0432\u0430\u0442\u0443" },
            { "wst", "\u0441\u0430\u043c\u043e\u0430\u0433\u0438\u0439\u043d \u0442\u0430\u043b\u0430" },
            { "xaf", "\u0442\u04e9\u0432 \u0430\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0444\u0440\u0430\u043d\u043a" },
            { "xcd", "\u0437\u04af\u04af\u043d \u043a\u0430\u0440\u0438\u0431\u0438\u0439\u043d \u0434\u043e\u043b\u043b\u0430\u0440" },
            { "xof", "\u0431\u0430\u0440\u0443\u0443\u043d \u0430\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0444\u0440\u0430\u043d\u043a" },
            { "xpf", "\u0444\u0440\u0430\u043d\u0446\u044b\u043d \u043a\u043e\u043b\u043e\u043d\u0438\u0439 \u0444\u0440\u0430\u043d\u043a" },
            { "xxx", "\u0442\u043e\u0434\u043e\u0440\u0445\u043e\u0439\u0433\u04af\u0439 \u043c\u04e9\u043d\u0433\u04e9\u043d \u0442\u044d\u043c\u0434\u044d\u0433\u0442" },
            { "yer", "\u0439\u0435\u043c\u0435\u043d \u0440\u0438\u0430\u043b" },
            { "zar", "\u04e9\u043c\u043d\u04e9\u0434 \u0430\u0444\u0440\u0438\u043a\u0438\u0439\u043d \u0440\u0430\u043d\u0434" },
            { "zmk", "\u0417\u0430\u043c\u0431\u0438 \u043a\u0432\u0430\u0447\u0430 (1968\u20132012)" },
            { "zmw", "\u0437\u0430\u043c\u0431\u0438 \u043a\u0432\u0430\u0447\u0430" },
        };
        return data;
    }
}
