/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.plugins;

import java.io.File;
import java.util.concurrent.Callable;
import org.gradle.api.Action;
import org.gradle.api.GradleException;
import org.gradle.api.Plugin;
import org.gradle.api.Project;
import org.gradle.api.Task;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.distribution.Distribution;
import org.gradle.api.distribution.DistributionContainer;
import org.gradle.api.distribution.plugins.DistributionPlugin;
import org.gradle.api.file.CopySpec;
import org.gradle.api.file.FileCollection;
import org.gradle.api.internal.IConventionAware;
import org.gradle.api.plugins.ApplicationPluginConvention;
import org.gradle.api.plugins.JavaApplication;
import org.gradle.api.plugins.JavaPlugin;
import org.gradle.api.plugins.JavaPluginConvention;
import org.gradle.api.plugins.internal.DefaultApplicationPluginConvention;
import org.gradle.api.plugins.internal.DefaultJavaApplication;
import org.gradle.api.tasks.JavaExec;
import org.gradle.api.tasks.SourceSet;
import org.gradle.api.tasks.Sync;
import org.gradle.api.tasks.TaskProvider;
import org.gradle.api.tasks.application.CreateStartScripts;

public class ApplicationPlugin
implements Plugin<Project> {
    public static final String APPLICATION_PLUGIN_NAME = "application";
    public static final String APPLICATION_GROUP = "application";
    public static final String TASK_RUN_NAME = "run";
    public static final String TASK_START_SCRIPTS_NAME = "startScripts";
    public static final String TASK_DIST_ZIP_NAME = "distZip";
    public static final String TASK_DIST_TAR_NAME = "distTar";
    private Project project;
    private ApplicationPluginConvention pluginConvention;

    public void apply(Project project) {
        this.project = project;
        project.getPluginManager().apply(JavaPlugin.class);
        project.getPluginManager().apply(DistributionPlugin.class);
        this.addExtensions();
        this.addRunTask();
        this.addCreateScriptsTask();
        Distribution distribution = (Distribution)((DistributionContainer)project.getExtensions().getByName("distributions")).getByName("main");
        ((IConventionAware)distribution).getConventionMapping().map("baseName", (Callable)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ApplicationPlugin.this.pluginConvention.getApplicationName();
            }
        });
        this.configureDistSpec(distribution.getContents());
        this.configureInstallTask((TaskProvider<Task>)project.getTasks().named("installDist"));
    }

    private void configureInstallTask(TaskProvider<Task> installTask) {
        installTask.configure((Action)new Action<Task>(){

            public void execute(Task task) {
                task.doFirst((Action)new Action<Task>(){

                    public void execute(Task task) {
                        Sync sync = (Sync)task;
                        File destinationDir = sync.getDestinationDir();
                        if (destinationDir.isDirectory()) {
                            String[] children = destinationDir.list();
                            if (children == null) {
                                throw new UncheckedIOException("Could not list directory " + destinationDir);
                            }
                            if (!(children.length <= 0 || new File(destinationDir, "lib").isDirectory() && new File(destinationDir, ApplicationPlugin.this.pluginConvention.getExecutableDir()).isDirectory())) {
                                throw new GradleException("The specified installation directory '" + destinationDir + "' is neither empty nor does it contain an installation for '" + ApplicationPlugin.this.pluginConvention.getApplicationName() + "'.\nIf you really want to install to this directory, delete it and run the install task again.\nAlternatively, choose a different installation directory.");
                            }
                        }
                    }
                });
            }
        });
    }

    private void addExtensions() {
        this.pluginConvention = new DefaultApplicationPluginConvention(this.project);
        this.pluginConvention.setApplicationName(this.project.getName());
        this.project.getConvention().getPlugins().put("application", this.pluginConvention);
        this.project.getExtensions().create(JavaApplication.class, "application", DefaultJavaApplication.class, new Object[]{this.pluginConvention});
    }

    private void addRunTask() {
        this.project.getTasks().register(TASK_RUN_NAME, JavaExec.class, (Action)new Action<JavaExec>(){

            public void execute(JavaExec run) {
                run.setDescription("Runs this project as a JVM application");
                run.setGroup("application");
                JavaPluginConvention javaPluginConvention = (JavaPluginConvention)ApplicationPlugin.this.project.getConvention().getPlugin(JavaPluginConvention.class);
                run.setClasspath(((SourceSet)javaPluginConvention.getSourceSets().getByName("main")).getRuntimeClasspath());
                run.getConventionMapping().map("main", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ApplicationPlugin.this.pluginConvention.getMainClassName();
                    }
                });
                run.getConventionMapping().map("jvmArgs", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ApplicationPlugin.this.pluginConvention.getApplicationDefaultJvmArgs();
                    }
                });
            }
        });
    }

    private void addCreateScriptsTask() {
        this.project.getTasks().register(TASK_START_SCRIPTS_NAME, CreateStartScripts.class, (Action)new Action<CreateStartScripts>(){

            public void execute(CreateStartScripts startScripts) {
                startScripts.setDescription("Creates OS specific scripts to run the project as a JVM application.");
                startScripts.setClasspath(ApplicationPlugin.this.project.getTasks().getAt("jar").getOutputs().getFiles().plus((FileCollection)ApplicationPlugin.this.project.getConfigurations().getByName("runtimeClasspath")));
                startScripts.getConventionMapping().map("mainClassName", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ApplicationPlugin.this.pluginConvention.getMainClassName();
                    }
                });
                startScripts.getConventionMapping().map("applicationName", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ApplicationPlugin.this.pluginConvention.getApplicationName();
                    }
                });
                startScripts.getConventionMapping().map("outputDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return new File(ApplicationPlugin.this.project.getBuildDir(), "scripts");
                    }
                });
                startScripts.getConventionMapping().map("executableDir", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ApplicationPlugin.this.pluginConvention.getExecutableDir();
                    }
                });
                startScripts.getConventionMapping().map("defaultJvmOpts", (Callable)new Callable<Object>(){

                    @Override
                    public Object call() throws Exception {
                        return ApplicationPlugin.this.pluginConvention.getApplicationDefaultJvmArgs();
                    }
                });
            }
        });
    }

    private CopySpec configureDistSpec(CopySpec distSpec) {
        TaskProvider jar = this.project.getTasks().named("jar");
        TaskProvider startScripts = this.project.getTasks().named(TASK_START_SCRIPTS_NAME);
        CopySpec libChildSpec = this.project.copySpec();
        libChildSpec.into((Object)"lib");
        libChildSpec.from(new Object[]{jar});
        libChildSpec.from(new Object[]{this.project.getConfigurations().named("runtimeClasspath")});
        CopySpec binChildSpec = this.project.copySpec();
        binChildSpec.into((Object)new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                return ApplicationPlugin.this.pluginConvention.getExecutableDir();
            }
        });
        binChildSpec.from(new Object[]{startScripts});
        binChildSpec.setFileMode(Integer.valueOf(493));
        CopySpec childSpec = this.project.copySpec();
        childSpec.from(new Object[]{this.project.file((Object)"src/dist")});
        childSpec.with(new CopySpec[]{libChildSpec});
        childSpec.with(new CopySpec[]{binChildSpec});
        distSpec.with(new CopySpec[]{childSpec});
        distSpec.with(new CopySpec[]{this.pluginConvention.getApplicationDistribution()});
        return distSpec;
    }
}

