/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.remote.internal.hub.queue;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import org.gradle.internal.dispatch.Dispatch;
import org.gradle.internal.remote.internal.hub.protocol.EndOfStream;
import org.gradle.internal.remote.internal.hub.protocol.InterHubMessage;
import org.gradle.internal.remote.internal.hub.queue.EndPointQueue;
import org.gradle.internal.remote.internal.hub.queue.QueueInitializer;

public class MultiEndPointQueue
implements Dispatch<InterHubMessage> {
    private final Set<EndPointQueue> endpoints = new HashSet<EndPointQueue>();
    private final List<InterHubMessage> queue = new ArrayList<InterHubMessage>();
    private final List<EndPointQueue> waiting = new ArrayList<EndPointQueue>();
    private final Lock lock;
    private final QueueInitializer initializer = new QueueInitializer();

    public MultiEndPointQueue(Lock lock) {
        this.lock = lock;
    }

    @Override
    public void dispatch(InterHubMessage message) {
        this.queue.add(message);
        this.flush();
    }

    void empty(EndPointQueue endPointQueue) {
        this.waiting.add(endPointQueue);
        this.flush();
    }

    void stopped(EndPointQueue queue) {
        this.waiting.remove(queue);
        this.endpoints.remove(queue);
        queue.dispatch(new EndOfStream());
    }

    public void drain(Collection<InterHubMessage> drainTo) {
        drainTo.addAll(this.queue);
        this.queue.clear();
    }

    private void flush() {
        EndPointQueue selected;
        EndPointQueue endPointQueue = selected = this.waiting.isEmpty() ? null : this.waiting.get(0);
        block4: while (!this.queue.isEmpty()) {
            InterHubMessage message = this.queue.get(0);
            switch (message.getDelivery()) {
                case Stateful: 
                case AllHandlers: {
                    if (this.endpoints.isEmpty()) {
                        return;
                    }
                    if (message.getDelivery() == InterHubMessage.Delivery.Stateful) {
                        this.initializer.onStatefulMessage(message);
                    }
                    for (EndPointQueue endpoint : this.endpoints) {
                        endpoint.dispatch(message);
                    }
                    this.queue.remove(0);
                    this.waiting.clear();
                    continue block4;
                }
                case SingleHandler: {
                    if (selected == null) {
                        return;
                    }
                    this.queue.remove(0);
                    this.waiting.remove(selected);
                    selected.dispatch(message);
                    continue block4;
                }
            }
            throw new IllegalArgumentException("Unknown delivery type: " + (Object)((Object)message.getDelivery()));
        }
    }

    public EndPointQueue newEndpoint() {
        EndPointQueue endPointQueue = new EndPointQueue(this, this.lock.newCondition());
        this.endpoints.add(endPointQueue);
        this.initializer.onQueueAdded(endPointQueue);
        return endPointQueue;
    }
}

