/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.psi.controlFlow;

import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.util.ArrayUtil;

class InstructionKey
implements Comparable<InstructionKey> {
    private final int myOffset;
    private final int[] myCallStack;

    private InstructionKey(int offset2, @NotNull int[] callStack) {
        if (callStack == null) {
            InstructionKey.$$$reportNull$$$0(0);
        }
        this.myOffset = offset2;
        this.myCallStack = callStack;
    }

    @NotNull
    static InstructionKey create(int offset2) {
        InstructionKey instructionKey = new InstructionKey(offset2, ArrayUtil.EMPTY_INT_ARRAY);
        if (instructionKey == null) {
            InstructionKey.$$$reportNull$$$0(1);
        }
        return instructionKey;
    }

    @NotNull
    InstructionKey next(int nextOffset) {
        InstructionKey instructionKey = new InstructionKey(nextOffset, this.myCallStack);
        if (instructionKey == null) {
            InstructionKey.$$$reportNull$$$0(2);
        }
        return instructionKey;
    }

    @NotNull
    InstructionKey push(int nextOffset, int returnOffset) {
        if (this.myCallStack.length > 100) {
            throw new OverflowException(this.myOffset);
        }
        int[] nextStack = ArrayUtil.append(this.myCallStack, returnOffset);
        InstructionKey instructionKey = new InstructionKey(nextOffset, nextStack);
        if (instructionKey == null) {
            InstructionKey.$$$reportNull$$$0(3);
        }
        return instructionKey;
    }

    @NotNull
    InstructionKey pop(int overriddenOffset) {
        int returnOffset = this.myCallStack[this.myCallStack.length - 1];
        int[] nextStack = ArrayUtil.realloc(this.myCallStack, this.myCallStack.length - 1);
        int nextOffset = overriddenOffset != 0 ? overriddenOffset : returnOffset;
        InstructionKey instructionKey = new InstructionKey(nextOffset, nextStack);
        if (instructionKey == null) {
            InstructionKey.$$$reportNull$$$0(4);
        }
        return instructionKey;
    }

    int getOffset() {
        return this.myOffset;
    }

    @NotNull
    int[] getCallStack() {
        if (this.myCallStack == null) {
            InstructionKey.$$$reportNull$$$0(5);
        }
        return this.myCallStack;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        InstructionKey key = (InstructionKey)o;
        return this.myOffset == key.myOffset && Arrays.equals(this.myCallStack, key.myCallStack);
    }

    public int hashCode() {
        return 31 * this.myOffset + Arrays.hashCode(this.myCallStack);
    }

    public String toString() {
        if (this.myCallStack.length == 0) {
            return String.valueOf(this.myOffset);
        }
        StringBuilder s = new StringBuilder();
        for (int offset2 : this.myCallStack) {
            if (s.length() != 0) {
                s.append(',');
            }
            s.append(offset2);
        }
        return this.myOffset + "[" + s + "]";
    }

    @Override
    public int compareTo(@NotNull InstructionKey key) {
        int c;
        if (key == null) {
            InstructionKey.$$$reportNull$$$0(6);
        }
        if ((c = this.myOffset - key.myOffset) != 0) {
            return c;
        }
        int len = Math.min(this.myCallStack.length, key.myCallStack.length);
        for (int i = 0; i < len; ++i) {
            c = this.myCallStack[i] - key.myCallStack[i];
            if (c == 0) continue;
            return c;
        }
        c = this.myCallStack.length - key.myCallStack.length;
        return c;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "callStack";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/InstructionKey";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/psi/controlFlow/InstructionKey";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "create";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "next";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "push";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "pop";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getCallStack";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "compareTo";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static class OverflowException
    extends RuntimeException {
        OverflowException(int offset2) {
            super("Instruction key overflow at offset " + offset2);
        }
    }
}

