/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util.lang;

import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.openapi.util.io.FileUtil;
import org.jetbrains.kotlin.com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.kotlin.com.intellij.util.SmartList;
import org.jetbrains.kotlin.com.intellij.util.lang.ClassPath;
import org.jetbrains.kotlin.com.intellij.util.lang.ClasspathCache;
import org.jetbrains.kotlin.com.intellij.util.lang.Loader;
import org.jetbrains.kotlin.com.intellij.util.lang.Resource;

class FileLoader
extends Loader {
    private final File myRootDir;
    private final String myRootDirAbsolutePath;
    private final ClassPath myConfiguration;
    private final DirEntry root = new DirEntry(0, null);
    private static final AtomicInteger totalLoaders = new AtomicInteger();
    private static final AtomicLong totalScanning = new AtomicLong();
    private static final AtomicLong totalSaving = new AtomicLong();
    private static final AtomicLong totalReading = new AtomicLong();
    private static final Boolean doFsActivityLogging = false;

    FileLoader(URL url, int index2, ClassPath configuration) {
        super(url, index2);
        this.myRootDir = new File(FileUtil.unquote(url.getFile()));
        this.myRootDirAbsolutePath = this.myRootDir.getAbsolutePath();
        this.myConfiguration = configuration;
    }

    private void buildPackageCache(File dir, ClasspathCache.LoaderData loaderData) {
        loaderData.addResourceEntry(this.getRelativeResourcePath(dir));
        File[] files2 = dir.listFiles();
        if (files2 == null) {
            return;
        }
        boolean containsClasses = false;
        for (File file2 : files2) {
            boolean isClass = file2.getPath().endsWith(".class");
            if (isClass) {
                if (!containsClasses) {
                    loaderData.addResourceEntry(this.getRelativeResourcePath(file2));
                    containsClasses = true;
                }
                loaderData.addNameEntry(file2.getName());
                continue;
            }
            loaderData.addNameEntry(file2.getName());
            this.buildPackageCache(file2, loaderData);
        }
    }

    private String getRelativeResourcePath(File file2) {
        return this.getRelativeResourcePath(file2.getAbsolutePath());
    }

    private String getRelativeResourcePath(String absFilePath) {
        String relativePath = absFilePath.substring(this.myRootDirAbsolutePath.length());
        relativePath = relativePath.replace(File.separatorChar, '/');
        relativePath = StringUtil.trimStart(relativePath, "/");
        return relativePath;
    }

    @Override
    @Nullable
    Resource getResource(String name) {
        try {
            URL url;
            if (this.myConfiguration.myLazyClassloadingCaches) {
                DirEntry lastEntry = this.root;
                int prevIndex = 0;
                int nextIndex = name.indexOf(47, prevIndex);
                while (true) {
                    int nameEnd = nextIndex == -1 ? name.length() : nextIndex;
                    int nameHash = StringUtil.stringHashCodeInsensitive(name, prevIndex, nameEnd);
                    int[] childrenNameHashes = lastEntry.childrenNameHashes;
                    if (childrenNameHashes == null) {
                        String[] list2 = (prevIndex != 0 ? new File(this.myRootDir, name.substring(0, prevIndex)) : this.myRootDir).list();
                        if (list2 != null) {
                            childrenNameHashes = new int[list2.length];
                            for (int i = 0; i < list2.length; ++i) {
                                childrenNameHashes[i] = StringUtil.stringHashCodeInsensitive(list2[i]);
                            }
                        } else {
                            childrenNameHashes = DirEntry.empty;
                        }
                        lastEntry.childrenNameHashes = childrenNameHashes;
                    }
                    boolean found = false;
                    for (int childNameHash : childrenNameHashes) {
                        if (childNameHash != nameHash) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        return null;
                    }
                    if (nextIndex == -1 || nextIndex == name.length() - 1) break;
                    DirEntry nextEntry = null;
                    List<DirEntry> directories = lastEntry.childrenDirectories;
                    if (directories != null) {
                        for (DirEntry previouslyScannedDir : directories) {
                            if (previouslyScannedDir.nameHash != nameHash || !previouslyScannedDir.name.regionMatches(0, name, prevIndex, nameEnd - prevIndex)) continue;
                            nextEntry = previouslyScannedDir;
                            break;
                        }
                    }
                    if (nextEntry == null) {
                        nextEntry = new DirEntry(nameHash, name.substring(prevIndex, nameEnd));
                        SmartList<DirEntry> newChildrenDirectories = directories != null ? new SmartList<DirEntry>((Collection<DirEntry>)directories) : new SmartList();
                        newChildrenDirectories.add(nextEntry);
                        lastEntry.childrenDirectories = newChildrenDirectories;
                    }
                    lastEntry = nextEntry;
                    prevIndex = nextIndex + 1;
                    nextIndex = name.indexOf(47, prevIndex);
                }
            }
            if (!(url = new URL(this.getBaseURL(), name)).getFile().startsWith(this.getBaseURL().getFile())) {
                return null;
            }
            File file2 = new File(this.myRootDir, name.replace('/', File.separatorChar));
            if (file2.exists()) {
                return new MyResource(url, file2);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClasspathCache.LoaderData tryReadFromIndex() {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return null;
        }
        long started = System.nanoTime();
        ClasspathCache.LoaderData loaderData = new ClasspathCache.LoaderData();
        File index2 = this.getIndexFileFile();
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(index2));
            FileLoader.readList(reader, loaderData.getResourcePaths());
            FileLoader.readList(reader, loaderData.getNames());
            ClasspathCache.LoaderData loaderData2 = loaderData;
            return loaderData2;
        }
        catch (Exception ex) {
            if (!(ex instanceof FileNotFoundException)) {
                index2.delete();
            }
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
            }
            totalReading.addAndGet(System.nanoTime() - started);
        }
        return null;
    }

    private static void readList(BufferedReader reader, List<? super String> paths) throws IOException {
        String line = reader.readLine();
        int numberOfElements = Integer.parseInt(line);
        for (int i = 0; i < numberOfElements; ++i) {
            paths.add(reader.readLine());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void trySaveToIndex(ClasspathCache.LoaderData data) {
        if (!this.myConfiguration.myCanHavePersistentIndex) {
            return;
        }
        long started = System.nanoTime();
        File index2 = this.getIndexFileFile();
        BufferedWriter writer = null;
        try {
            writer = new BufferedWriter(new FileWriter(index2));
            FileLoader.writeList(writer, data.getResourcePaths());
            FileLoader.writeList(writer, data.getNames());
        }
        catch (IOException ex) {
            index2.delete();
        }
        finally {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (IOException iOException) {}
            }
            totalSaving.addAndGet(System.nanoTime() - started);
        }
    }

    private static void writeList(BufferedWriter writer, List<String> paths) throws IOException {
        writer.append(Integer.toString(paths.size())).append('\n');
        for (String s : paths) {
            writer.append(s).append('\n');
        }
    }

    @NotNull
    private File getIndexFileFile() {
        File file2 = new File(this.myRootDir, "classpath.index");
        if (file2 == null) {
            FileLoader.$$$reportNull$$$0(0);
        }
        return file2;
    }

    @Override
    @NotNull
    public ClasspathCache.LoaderData buildData() throws IOException {
        long currentScanning;
        ClasspathCache.LoaderData fromIndex = this.tryReadFromIndex();
        ClasspathCache.LoaderData loaderData = fromIndex != null ? fromIndex : new ClasspathCache.LoaderData();
        int nsMsFactor = 1000000;
        int currentLoaders = totalLoaders.incrementAndGet();
        if (fromIndex == null) {
            long started = System.nanoTime();
            this.buildPackageCache(this.myRootDir, loaderData);
            long doneNanos = System.nanoTime() - started;
            currentScanning = totalScanning.addAndGet(doneNanos);
            if (doFsActivityLogging.booleanValue()) {
                System.out.println("Scanned: " + this.myRootDirAbsolutePath + " for " + doneNanos / 1000000L + "ms");
            }
            this.trySaveToIndex(loaderData);
        } else {
            currentScanning = totalScanning.get();
        }
        loaderData.addResourceEntry("foo.class");
        loaderData.addResourceEntry("bar.properties");
        if (doFsActivityLogging.booleanValue()) {
            System.out.println("Scanning: " + currentScanning / 1000000L + "ms, saving: " + totalSaving.get() / 1000000L + "ms, loading:" + totalReading.get() / 1000000L + "ms for " + currentLoaders + " loaders");
        }
        ClasspathCache.LoaderData loaderData2 = loaderData;
        if (loaderData2 == null) {
            FileLoader.$$$reportNull$$$0(1);
        }
        return loaderData2;
    }

    public String toString() {
        return "FileLoader [" + this.myRootDir + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/jetbrains/kotlin/com/intellij/util/lang/FileLoader";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getIndexFileFile";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildData";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }

    private static class MyResource
    extends Resource {
        private final URL myUrl;
        private final File myFile;

        MyResource(URL url, File file2) {
            this.myUrl = url;
            this.myFile = file2;
        }

        @Override
        public URL getURL() {
            return this.myUrl;
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new BufferedInputStream(new FileInputStream(this.myFile));
        }

        @Override
        public byte[] getBytes() throws IOException {
            return FileUtil.loadFileBytes(this.myFile);
        }
    }

    private static class DirEntry {
        static final int[] empty = new int[0];
        volatile int[] childrenNameHashes;
        volatile List<DirEntry> childrenDirectories;
        final int nameHash;
        final String name;

        DirEntry(int _nameHash, String _name) {
            this.nameHash = _nameHash;
            this.name = _name;
        }
    }
}

